<?php

/**
 * This is the model class for table "{{mas_bank}}".
 *
 * The followings are the available columns in table '{{mas_bank}}':
 * @property integer $id
 * @property string $bank_name
 * @property string $isActive
 *
 * The followings are the available model relations:
 * @property MasCompany[] $masCompanies
 */
class FinGeneralLedger extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public $account_no;
    public $debit_total;
    public $credit_total;
    public $reference_no;
    public $type;
    public $current_balance;
    public $total_current_balance;
    public $company_id;
    public $chk_description;
    public $chk_no;
    public $ac_no1;
    public $isBank;
    public $realisation_date;
    public $voucherno;
    public $amt;
     public $exchange_rate;
     public $currency;
     public $start_date;
     public $end_date;
     public $fin_account_id;
     public $fin_subledger;
     public $_account;
     public $havesubledger;
     public $credit_amt;
     public $cash_amt;
     //  public $subledger_new;
   //  public $fin_subledger_new;
     //public $fin_account_id_new;
    public $fin_givenname;
    //public $account_amount;
    public function tableName() {
        return '{{fin_general_ledger}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('date,voucher_no,form_ref_no,account_id,amt,chk_no,cheque_date,credit_amt,cash_amt,card_no,auth_code,exchange_rate', 'required'),
            // array('voucher_no', 'unique'),
            array('form_ref_no,voucher_no,reference_no,agent_name,item_no', 'length', 'max' => 255),
            array('item_type,item_id', 'numerical', 'integerOnly' => true),
            array('narration,form_ref_no', 'safe'),
            array('credit,debit', 'length', 'max' => 12),
            array('realisation_date', 'type', 'type' => 'date', 'message' => 'Please enter {attribute} as yyyy-mm-dd format', 'dateFormat' => 'yyyy-MM-dd'),
            //  array('voucher_no', 'unique'),
            //array('account_no,description,adtndedtn', 'required', 'on' => 'adtndedtn'),
             array('exchange_rate', 'numerical'), 
            // array('account_no', 'unique', 'on' => 'adtndedtn'),
            array('isActive', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            // array('id, acid,ref_no,date,account_id,description,type', 'safe', 'on' => 'search'),
            array('id,ref_no,form_ref_no,date,account_id,description,type,credit,debit', 'safe'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'form' => array(self::BELONGS_TO, 'FinForm', 'form_id'),
            'file' => array(self::BELONGS_TO, 'MasterFile', 'file_id'),
            'account' => array(self::BELONGS_TO, 'FinAccounts', 'account_id'),
            'company' => array(self::BELONGS_TO, 'Company', 'subledger'),
            'currencies' => array(self::BELONGS_TO, 'MasCurrency', 'currency'),
            'sub' => array(self::BELONGS_TO, 'Subledger', 'subledger'),
            'parent' => array(self::BELONGS_TO, 'FinGeneralLedgerHead', 'form_ref_no'),
            );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'voucher_no' => 'Voucher No.',
            'isActive' => 'Is Active',
            'adtndedtn' => 'Addition/Deduction',
            'amt' => 'Amount',
            'account_id'=>'Account',
            'chk_no'=>'Cheque No'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    /*   public function search() {
      $criteria = new CDbCriteria;
      $searchterm = trim(Yii::app()->request->getParam('account_no'));
      $criteria->addCondition('logistics_type="O" and isActive =  "Y" AND company_id=' . Yii::app()->user->master_user_company_id, 'AND');
      if (!empty($searchterm))
      $criteria->addCondition('account_no like "%' . $searchterm . '%"', 'AND');
      return new CActiveDataProvider($this, array(
      'pagination' => array(
      'pageSize' => 5,
      ),
      'criteria' => $criteria,
      'sort' => array(
      'defaultOrder' => 't.account_no ASC',
      ),
      ));
      } */

    /* public function searchadtndedtn() {
      $criteria = new CDbCriteria;
      $searchterm = trim(Yii::app()->request->getParam('account_no'));
      $criteria->addCondition(' isActive =  "Y" AND (logistics_type="A" OR logistics_type="D")  AND company_id=' . Yii::app()->user->master_user_company_id, 'AND');
      if (!empty($searchterm))
      $criteria->addCondition('account_no like "%' . $searchterm . '%"', 'AND');
      return new CActiveDataProvider($this, array(
      'pagination' => array(
      'pageSize' => 5,
      ),
      'criteria' => $criteria,
      'sort' => array(
      'defaultOrder' => 't.account_no ASC',
      ),
      ));
      } */

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return MasBank the static model class
     */

    public function search($data)
    {
      $criteria = new CDbCriteria;
      $criteria->group='voucher_no';

      $searchterm = trim(Yii::app()->request->getParam('search'));
      $criteria->addCondition('voucher_no like "' . $data . '%"', 'AND');
      if($searchterm)
      {
      $criteria->addCondition('voucher_no like "' . $searchterm . '%"', 'AND');
      }
      return new CActiveDataProvider($this, array(
//      'pagination' => array(
//      'pageSize' => 20,
//      ),
      'pagination' => false,
      'criteria' => $criteria,
      'sort' => array(
      'defaultOrder' => 't.id ASC',
      ),
      ));
      
    }

    public function searchdata($data)
	{
        $ledge_detail=  array();
                $criteria=new CDbCriteria; 
                $criteria->group='voucher_no';
                $criteria->order='id desc,voucher_no desc';          
                 $searchterm = trim(Yii::app()->request->getParam('search'));
                 $data1 = trim(Yii::app()->request->getParam('voucher_type'));
                 $sort = trim(Yii::app()->request->getParam('sort'));
                 $allocate = trim(Yii::app()->request->getParam('allocate'));
                 
                 $start_date 	= trim(Yii::app()->request->getParam('start_date'));
                 $end_date 		= trim(Yii::app()->request->getParam('end_date'));
                 
                 $current_date = date('Y-m-d');
                 
                 if($allocate=='')
                 {
                     $allocate="N";
                 }
                 if($data1){
                 $criteria->addCondition('form_ref_no like "' . $data1 . '%"', 'AND');    
                 }
                 else {
                 $criteria->addCondition('form_ref_no like "' . $data . '%"', 'AND');
                 }
                 if($searchterm)
			      {
			      $criteria->addCondition('form_ref_no like "' . $searchterm . '%"', 'AND');
			      }
			      if($allocate)
			      {
			      $criteria->addCondition('isAllocated="'.$allocate.'"', 'AND');
			      }
			      
			      
			      if($start_date!="" && $end_date!="")
			      {
			      	
			      	$arr_start_date = explode("/",$start_date);
			      	
			      	$start_date = $arr_start_date[2]."-".$arr_start_date[1]."-".$arr_start_date[0];
			      	
			      	$arr_end_date = explode("/",$end_date);
			      	
			      	$end_date = $arr_end_date[2]."-".$arr_end_date[1]."-".$arr_end_date[0];
			      	
			      	$criteria->addCondition('date>="'.$start_date.'" AND date<="'.$end_date.'"', 'AND');
			      }
			      else 
			      {
			      	$criteria->addCondition('date="'.$current_date.'"', 'AND');
			      	$criteria->limit = 5;
			      }
			      
     
                $ledger_details = FinGeneralLedger::model()->findAll($criteria);           
                 foreach ($ledger_details as $i => $value) {                  
                     $ledger_detail = FinGeneralLedger::model()->findAll(array('condition' => 'voucher_no="' . $value->voucher_no . '"'));
                     foreach ($ledger_detail as $j => $valu) {  
                         if($valu->credit!=0.00){
                             $ledge_detail[$i]['id']=$valu->id;
                             $ledge_detail[$i]['amount']=$valu->credit;
                             $ledge_detail[$i]['narration']=$valu->narration;
                             $ledge_detail[$i]['voucher_no']=$valu->voucher_no;
                             $ledge_detail[$i]['date']=$valu->date;
                             $ledge_detail[$i]['credit_description']=$valu->account->description;
                             $ledge_detail[$i]['isAllocated']=$valu->isAllocated; 
                         }
                         
                         if($valu->debit!=0.00){
                             $ledge_detail[$i]['id']=$valu->id;
                             $ledge_detail[$i]['amount']=$valu->debit;
                             $ledge_detail[$i]['narration']=$valu->narration;
                             $ledge_detail[$i]['voucher_no']=$valu->voucher_no;
                             $ledge_detail[$i]['date']=$valu->date;
                             $ledge_detail[$i]['debit_description']=$valu->account->description;
                             $ledge_detail[$i]['isAllocated']=$valu->isAllocated; 
                         }
                     }
                 }
                 
            return new CArrayDataProvider($ledge_detail, array(
                'id' => 'id',
//                'pagination' => array(
//                    'pageSize' => 20,
//                ),
                'pagination' => false,
            ));
	}
        
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public function getVoucherNo($form_no) {
        $modelVoucherNo = self::model()->findAll(array('condition' => 'form_id=' . $form_no, 'distinct' => true));
        return CHtml::listData($modelVoucherNo, 'voucher_no', 'voucher_no');
    }

    public function getAccountNo($account_id, $company_id) {

        $modelAccount = FinAccounts::model()->findByPk($account_id);
        return $modelAccount->account_no;
    }

    //function Written by Toby
}

