<?php

/**
 * This is the model class for table "{{mas_bank}}".
 *
 * The followings are the available columns in table '{{mas_bank}}':
 * @property integer $id
 * @property string $bank_name
 * @property string $isActive
 *
 * The followings are the available model relations:
 * @property MasCompany[] $masCompanies
 */
class FinCostCenter extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{fin_cost_center}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('name', 'required'),
            ///   array('bank_name', 'length', 'max' => 255),
            array('name', 'unique', 'on' => 'add'),
            array('isActive', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, name,product_class_id', 'safe', 'on' => 'search'),
            array('id, name,product_class_id', 'safe'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
                //   'masCompanies' => array(self::HAS_MANY, 'MasCompany', 'bank'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            // 'bank_name' => 'Bank Name',
            'isActive' => 'Is Active',
            'adtndedtn' => 'Addition/Deduction'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
   
 public function search() {
        $criteria = new CDbCriteria;
        $searchterm = trim(Yii::app()->request->getParam('name'));
        $criteria->addCondition('isActive =  "Y"', 'AND');
        if (!empty($searchterm))
            $criteria->addCondition('name like "%' . $searchterm . '%"', 'AND');
        return new CActiveDataProvider($this, array(
            'pagination' => array(
                'pageSize' => 5,
            ),
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.name ASC',
            ),
        ));
    }
    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return MasBank the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

}

