<?php

/**
 * This is the model class for table "{{entry_invoice_truck_no}}".
 *
 * The followings are the available columns in table '{{entry_invoice_truck_no}}':
 * @property integer $id
 * @property integer $entry_invoice_id
 * @property string $truck_no
 * @property string $driver_name
 * @property string $details
 */
class EntryInvoiceTruckNo extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{entry_invoice_truck_no}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			//array('entry_invoice_id, truck_no, driver_name, details', 'required'),
			array('entry_invoice_id', 'numerical', 'integerOnly'=>true),
			array('truck_no, driver_name, details', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, entry_invoice_id, truck_no, driver_name, details', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'entry_invoice_id' => 'Entry Invoice',
			'truck_no' => 'Truck No',
			'driver_name' => 'Driver Name',
			'details' => 'Driver Contact No',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('entry_invoice_id',$this->entry_invoice_id);
		$criteria->compare('truck_no',$this->truck_no,true);
		$criteria->compare('driver_name',$this->driver_name,true);
		$criteria->compare('details',$this->details,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return EntryInvoiceTruckNo the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
