<?php

/**
 * This is the model class for table "{{entry_invoice}}".
 *
 * The followings are the available columns in table '{{entry_invoice}}':
 * @property integer $id
 * @property integer $file_id
 * @property string $customer_id
 * @property integer $contact_id
 * @property string $billing_address
 * @property string $invoice_date
 * @property string $customer_reference_no
 * @property string $payment_terms
 * @property integer $shipper_id
 * @property string $destination
 * @property integer $consignee_id
 * @property string $bill_of_lading
 * @property string $packages
 * @property string $description_of_goods
 * @property string $shipment_reference
 * @property string $others
 * @property string $grand_total
 * @property string $notes
 * @property string $terms_and_conditions
 * @property string $remarks
 * @property integer $created_by
 * @property integer $created_date
 * @property integer $updated_by
 * @property integer $updated_date
 */
class EntryInvoice extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public $alias;
	public $customer_name;
	public $searchstartdate;
	public $searchenddate;
	public $type_id;
	public $statement_no;
	public $expiry_date;
	
	public function tableName()
	{
		return '{{entry_invoice}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('customer_id,  invoice_date,payment_terms', 'required'),
			array('file_id, contact_id, created_by,  updated_by, status', 'numerical', 'integerOnly'=>true),
			array('shipper_id, consignee_id', 'length', 'max'=>500),
			array(' created_date,updated_date,customer_id', 'length', 'max'=>30),
			array('description_of_goods,billing_address,others', 'length', 'max'=>5000),	
			array('customer_reference_no, payment_terms, destination, bill_of_lading, packages, shipment_reference, others,terms_and_conditions,remarks,notes,additional_notes', 'length', 'max'=>255),
			array('grand_total, salesman', 'length', 'max'=>15),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, file_id, customer_id, contact_id, billing_address, invoice_date, customer_reference_no, payment_terms, shipper_id, destination, consignee_id, bill_of_lading, packages, description_of_goods, shipment_reference, others, grand_total, notes, terms_and_conditions, remarks, created_by, created_date, updated_by, updated_date,status', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
             'customer' => array(self::BELONGS_TO, 'Customer', 'customer_id'),
            'file' => array(self::BELONGS_TO, 'MasterFile', 'file_id'),
            'items' => array(self::HAS_MANY, 'EntryInvoiceItem', 'entry_invoice_id'),
            'paymentTerm' => array(self::BELONGS_TO, 'MasPaymentTerm', 'payment_terms'),
            'product' => array(self::BELONGS_TO, 'Store', 'id', 'order' => 'items.product_id'),
			'truck' => 	array(self::HAS_MANY, 'EntryInvoiceTruckNo', 'entry_invoice_id'),
			'manifest' => 	array(self::HAS_MANY, 'EntryInvoiceManifestNo', 'entry_invoice_id'),
			'receivedAmount' => array(self::STAT, 'ReceivedInvoices', 'invoice_id', 'select' => 'SUM(received_amt)'),
            'returnedAmount' => array(self::STAT, 'Creditnote', 'invoice_id', 'select' => 'SUM(credited_amount)'),
            'charge' => array(self::STAT, 'ReceivedInvoices', 'invoice_id', 'select' => 'SUM(charges)'),
            'returned' => array(self::HAS_ONE, 'Creditnote', 'invoice_id'),
			'manifest_no' => 	array(self::HAS_MANY, 'EntryInvoiceManifestNo', 'entry_invoice_id'),
                                'userdetails' => array(self::BELONGS_TO, 'User', 'created_by'),

        );
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'file_id' => 'File',
			'customer_id' => 'Customer',
			'contact_id' => 'Contact',
			'billing_address' => 'Billing Address',
			'invoice_date' => 'Invoice Date',
			'customer_reference_no' => 'Customer Reference No',
			'payment_terms' => 'Payment Terms',
			'shipper_id' => 'Shipper',
			'destination' => 'Destination2',
			'consignee_id' => 'Consignee',
			'bill_of_lading' => 'Bill Of Lading',
			'packages' => 'Destination1',
			'description_of_goods' => 'Description Of Goods',
			'shipment_reference' => 'Shipment Reference',
			'others' => 'Others',
			'grand_total' => 'Grand Total',
			'notes' => 'Notes',
			'terms_and_conditions' => 'Terms And Conditions',
			'remarks' => 'Remarks',
			'created_by' => 'Created By',
			'created_date' => 'Created Date',
			'updated_by' => 'Updated By',
			'updated_date' => 'Updated Date',
			'status' => 'Status'	
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.
            $search= trim(Yii::app()->request->getParam('inv_search'));
		$criteria=new CDbCriteria;

//		$criteria->compare('t.id',$this->id);
//		$criteria->compare('t.file_id',$this->file_id);
//		$criteria->compare('t.customer_id',$this->customer_id,true);
//		$criteria->compare('t.contact_id',$this->contact_id);
//		$criteria->compare('t.billing_address',$this->billing_address,true);
//		$criteria->compare('t.invoice_date',$this->invoice_date,true);
//		$criteria->compare('t.customer_reference_no',$this->customer_reference_no,true);
//		$criteria->compare('t.payment_terms',$this->payment_terms,true);
//		$criteria->compare('t.shipper_id',$this->shipper_id);
//		$criteria->compare('destination',$this->destination,true);
//		$criteria->compare('consignee_id',$this->consignee_id);
//		$criteria->compare('bill_of_lading',$this->bill_of_lading,true);
//		$criteria->compare('packages',$this->packages,true);
//		$criteria->compare('description_of_goods',$this->description_of_goods,true);
//		$criteria->compare('shipment_reference',$this->shipment_reference,true);
//		$criteria->compare('others',$this->others,true);
//		$criteria->compare('grand_total',$this->grand_total,true);
//		$criteria->compare('notes',$this->notes,true);
//		$criteria->compare('terms_and_conditions',$this->terms_and_conditions,true);
//		$criteria->compare('remarks',$this->remarks,true);
//		$criteria->compare('created_by',$this->created_by);
//		$criteria->compare('created_date',$this->created_date);
//		$criteria->compare('updated_by',$this->updated_by);
//		$criteria->compare('updated_date',$this->updated_date);
                $criteria->with = array('customer');
                if(!empty($search)){
                    $criteria->addCondition('t.manifest like "%'.$search.'%" OR t.trucks like "%'.$search.'%" OR t.id like "%'.$search.'%" OR t.file_id  like "%'.$search.'%" OR customer.customer_name like "%'.$search.'%" ','AND');
                }
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
				'sort' => array(
        				'defaultOrder' => 't.id DESC',
				),
				'pagination'=>array(
        				'pageSize'=>20,
        		         ),
		));
	}
	
	public function searchEntryInvoice() {
		$criteria = new CDbCriteria;
		$criteria->with = "file";
		$customer_id = isset($_GET['customer_id']) ? $_GET['customer_id'] : 0;
		
		if($customer_id > 0)
		{
			$criteria->condition = "file.company_id=" . $customer_id;
		}
		//  $criteria->order = "paid DESC";
		$criteria->order = "t.id DESC";
		return new CActiveDataProvider($this, array(
				'criteria' => $criteria,
				'pagination' => false
		));
	}
	
	public function report($start_date="",$end_date="",$customer_id="",$type_id="")
	{
		$condition_entry="WHERE 1=1";
		$condition_exit="WHERE 1=1";
		
		
		
		if($start_date!="" && $end_date!="")
		{
			$condition_entry.=" AND entry.invoice_date>='".$start_date."' AND entry.invoice_date<='".$end_date."'";
			$condition_exit.=" AND exitinv.invoice_date>='".$start_date."' AND exitinv.invoice_date<='".$end_date."'";
		}
		
		if($customer_id!="")
		{
			$condition_entry.=" AND entry.customer_id=".$customer_id;
			$condition_exit.=" AND exitinv.customer_id=".$customer_id;
		}
		
		$SQL_ENTRY = "SELECT  entry.id AS invoice_id,'Entry' AS type,invoice_date,total_vat_amount,customer_name,customer_id,grand_total,shipment_reference,
            				(SELECT GROUP_CONCAT( manifest.manifest_no ) FROM crm_entry_invoice_manifest_no AS manifest WHERE entry.id=entry_invoice_id) AS manifest_no,
            				(SELECT GROUP_CONCAT( truck.truck_no ) FROM crm_entry_invoice_truck_no AS truck WHERE entry.id=entry_invoice_id) AS truck_no
							FROM `crm_entry_invoice` AS entry 
            				INNER JOIN crm_customer AS customer ON entry.customer_id=customer.id ".$condition_entry." GROUP BY entry.id ";
		
		$SQL_EXIT=" SELECT  exitinv.id AS invoice_id,'Exit' AS type,invoice_date,total_vat_amount,customer_name,customer_id,grand_total,shipment_reference,
							(SELECT GROUP_CONCAT( manifest.manifest_no ) FROM crm_exit_invoice_manifest_no AS manifest WHERE exitinv.id=exit_invoice_id) AS manifest_no,
							(SELECT GROUP_CONCAT( truck.truck_no ) FROM crm_exit_invoice_truck_no AS truck   WHERE exitinv.id=exit_invoice_id) AS truck_no
							FROM `crm_exit_invoice` AS exitinv 
							INNER JOIN crm_customer AS customer ON exitinv.customer_id=customer.id ".$condition_exit." GROUP BY exitinv.id ";
		
		
		if($type_id!="")
		{
			
			if($type_id == 1)
			{
				$SQL=$SQL_ENTRY;
			}
			else if($type_id == 2)
			{
				$SQL=$SQL_EXIT;
			}
			
		}
		else 
		{
			$SQL=$SQL_ENTRY." UNION ALL".$SQL_EXIT;
		}
		
		
		 $arr_invoice_details = Yii::app()->db->createCommand($SQL)->queryAll();
		
		$count = count($arr_invoice_details);
		
		
		return new CSqlDataProvider($SQL, array(
				'totalItemCount'=>$count,
				/*'sort'=>array(
						 'attributes'=>array(
								'id', 'username$SQL', 'email',
						), 
				),*/
			 	'pagination'=> false
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return EntryInvoice the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	public function getEntryManisfestNo($id) {
		$model = EntryInvoiceManifestNo ::model()->findAllByAttributes(array(
                    'entry_invoice_id' => $id,
		));
		$manisfestno = "";
		if(count($model)>0){
                    foreach($model as $row){
                        $manisfestno.= $row['manifest_no'].",";
                    } 
		}
		return rtrim($manisfestno,',');
	}
	
	public function getInvoiceTotalValue($records)
	{
		$total_value=0;
		foreach($records as $record)
		{
			$total_value+= ($record['grand_total']+$record['total_vat_amount']);
		}
		return $total_value;
	
	}
}