<?php

/**
 * This is the model class for table "crm_emaillog".
 *
 * The followings are the available columns in table 'crm_emaillog':
 * @property integer $id
 * @property integer $company_id
 * @property string $cover_letter
 * @property string $email_id
 * @property integer $file_id
 * @property string $from_name
 * @property integer $from_id
 * @property string $isActive
 */
class Emaillog extends CActiveRecord
{
    public $cover1;
    public $sender_id;
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'crm_emaillog';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('company_id, sender_id, subject, email_id, file_id, from_name, from_id,', 'required'),
			array('company_id, sender_id, file_id, from_id', 'numerical', 'integerOnly'=>true),
			array('from_name', 'length', 'max'=>2),
			array('isActive', 'length', 'max'=>1),
                        array('date','default',
                            'value'=>new CDbExpression('NOW()'),
                            'setOnEmpty'=>false,'on'=>'insert'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('company_id, sender_id, subject, cover_letter, email_id, file_id, from_name, from_id, isActive, date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                   'sender' => array(self::BELONGS_TO, 'User', 'sender_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'company_id' => 'Company',
                        'sender_id'=>'Sender',
                        'subject'=>'Subject',
			'cover_letter' => 'Message To customer',
			'email_id' => 'To',
			'file_id' => 'File',
			'from_name'=> 'From Name',
			'from_id' => 'From',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('company_id',$this->company_id);
                $criteria->compare('subject',$this->subject,true);
		$criteria->compare('cover_letter',$this->cover_letter,true);
		$criteria->compare('email_id',$this->email_id,true);
		$criteria->compare('file_id',$this->file_id);
		$criteria->compare('from_name',$this->from_name,true);
		$criteria->compare('from_id',$this->from_id);
		$criteria->compare('isActive',$this->isActive,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Emaillog the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
