<?php

/**
 * This is the model class for table "{{purchase_order_items}}".
 *
 * The followings are the available columns in table '{{purchase_order_items}}':
 * @property integer $id
 * @property integer $purchase_order_id
 * @property integer $product_id
 * @property string $part_number
 * @property string $product_description
 * @property integer $quantity
 * @property string $rate
 * @property string $net_amount
 */
class DirectPurchaseOrderItems extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{direct_purchase_order_items}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('product_id,product_description,part_number, quantity, rate,unit', 'required'),
			array('purchase_order_id, product_id', 'numerical', 'integerOnly'=>true),
			array('part_number', 'length', 'max'=>255),
			array('rate, net_amount,quantity,tax_amount,tax_percentage', 'length', 'max'=>15),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, purchase_order_id, product_id, part_number, product_description, quantity, rate, net_amount', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                      'porder' => array(self::BELONGS_TO, 'DirectPurchaseOrderGeneral', 'purchase_order_id'),
                      'product' => array(self::BELONGS_TO, 'Store', 'product_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'purchase_order_id' => 'Purchase Order',
			'product_id' => 'Product',
			'part_number' => 'Part Number',
			'product_description' => 'Product Description',
			'quantity' => 'Quantiry',
			'rate' => 'Rate',
			'net_amount' => 'Net Amount',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('purchase_order_id',$this->purchase_order_id);
		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('part_number',$this->part_number,true);
		$criteria->compare('product_description',$this->product_description,true);
		$criteria->compare('quantity',$this->quantity);
		$criteria->compare('rate',$this->rate,true);
		$criteria->compare('net_amount',$this->net_amount,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return PurchaseOrderItems the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
