<?php

/**
 * This is the model class for table "{{purchase_order_general}}".
 *
 * The followings are the available columns in table '{{purchase_order_general}}':
 * @property integer $id
 * @property string $vendor_id
 * @property string $vendor_contact_id
 * @property string $purchase_order_date
 * @property integer $currency_id
 * @property string $shipping_address
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class DirectPurchaseOrderGeneral extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
        public $exchange_rate;
        public function tableName()
	{
		return '{{direct_purchase_order_general}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('vendor_id, purchase_order_date,invoice_type', 'required'),
			array('currency_id,file_id, created_by, updated_by,warehouse_id', 'numerical', 'integerOnly'=>true),
			array('vendor_id, vendor_contact_id, shipping_address,total_tax_amount', 'length', 'max'=>255),
				array('reference_no', 'length', 'max'=>15),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('notes,terms_and_conditions,remarks', 'length', 'max' => 5000),
                        array('id, vendor_id, vendor_contact_id,is_posted,purchase_order_date,grand_total,currency_id, shipping_address, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'purchase_currency' => array(self::BELONGS_TO, 'MasCurrency', 'currency_id'),
                    'vendor_details' => array(self::BELONGS_TO, 'Vendor', 'vendor_id'),
                    'netAmount' => array(self::STAT, 'DirectPurchaseOrderItems', 'purchase_order_id', 'select' => 'SUM(net_amount)'),
                    'netVat' => array(self::STAT, 'DirectPurchaseOrderItems', 'purchase_order_id', 'select' => 'SUM(tax_amount)'),
                    'adItems' => array(self::HAS_MANY, 'DirectPurchasingOrderAddition', 'purchasing_order_id'),
                    'dedItems' => array(self::HAS_MANY, 'DirectPurchasingOrderDeduction', 'purchasing_order_id'),
					'invoicetype' => array(self::BELONGS_TO, 'MasInvoiceType', 'invoice_type'),
					'currency_details' => array(self::BELONGS_TO, 'MasCurrency', 'currency_id'),
					'crm_user' => array(self::BELONGS_TO, 'User', 'created_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'vendor_id' => 'Vendor',
			'vendor_contact_id' => 'Vendor Contact Name',
			'purchase_order_date' => 'Purchase Order Date',
			'currency_id' => 'Currency',
			'shipping_address' => 'Shipping Address',
			'total_tax_amount' => 'Tax Amount',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('vendor_id',$this->vendor_id,true);
		$criteria->compare('vendor_contact_id',$this->vendor_contact_id,true);
		$criteria->compare('purchase_order_date',$this->purchase_order_date,true);
		$criteria->compare('currency_id',$this->currency_id);
		$criteria->compare('shipping_address',$this->shipping_address,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return PurchaseOrderGeneral the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
