<?php

/**
 * This is the model class for table "{{delivery_notes}}".
 *
 * The followings are the available columns in table '{{delivery_notes}}':
 * @property integer $id
 * @property integer $file_id
 * @property integer $crm_user_id
 * @property string $company_id
 * @property integer $order_id
 * @property integer $contact_id
 * @property string $delivery_date
 * @property string $shipped_by
 * @property string $sales_group
 * @property string $awb_no
 * @property integer $no_of_boxes
 * @property string $tracking_no
 * @property string $total_weight
 * @property string $packed_by
 * @property string $shipping_conditions
 * @property string $lpo
 * @property string $others
 * @property string $delivery_status
 * @property string $isActive
 *
 * The followings are the available model relations:
 * @property DeliveryItem[] $deliveryItems
 * @property CompanyContact $contact
 * @property Order $order
 * @property User $crmUser
 * @property MasterFile $file
 * @property Company $company
 * @property Invoice[] $invoices
 */
class DeliveryNote extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public $company_name;
    public $shipping_by;
    public $lead_owner_id;
    public $title;
    public $tot_qty;
    public $searchstartdate;
    public $searchenddate;
    public $country;
    public $no_of_delivey_note;
    public $grand_total;
    public $delivered_value;

    public function tableName() {
        return '{{delivery_note}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('crm_user_id, company_id, contact_id, delivery_date,lpo,warehouse', 'required'),
            array('file_id, crm_user_id, order_id, contact_id,warehouse', 'numerical', 'integerOnly' => true),
            //array('total_weight', 'numerical'),
            array('company_id', 'length', 'max' => 20),
            //array('delivery_no', 'unique', 'on' => 'add'),
            array('shipping_address,billing_address, shipped_by, sales_group, awb_no,packed_by,shipping_conditions tracking_no, packed_by, shipping_conditions, lpo, others,total_weight,file_title', 'length', 'max' => 255),
            array('total_weight', 'length', 'max' => 10),
            array('delivery_status', 'length', 'max' => 8),
            array('isActive', 'length', 'max' => 1),
            array('notes,terms_and_conditions,remarks', 'length', 'max' => 5000),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, file_id, crm_user_id, company_id, order_id, contact_id, delivery_date, 
                shipped_by, sales_group, awb_no, no_of_boxes, tracking_no, total_weight, 
                packed_by, shipping_conditions, lpo, others, delivery_status, isActive', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'items' => array(self::HAS_MANY, 'DeliveryNoteItem', 'delivery_note_id', 'order' => 'items.id asc'),
            'valueOfitemsDelivered' => array(self::STAT, 'DeliveryNoteItem', 'delivery_note_id',
                'join' => 'INNER JOIN {{store}} `tc` ON `tc`.`id` = `t`.`product_id`', 'select' => 'SUM(t.quantity*tc.rate)'),
            'contact' => array(self::BELONGS_TO, 'CompanyContact', 'contact_id'),
            'order' => array(self::BELONGS_TO, 'Order', 'order_id'),
            'crmUser' => array(self::BELONGS_TO, 'User', 'crm_user_id'),
            'file' => array(self::BELONGS_TO, 'MasterFile', 'file_id'),
            'company' => array(self::BELONGS_TO, 'Company', 'company_id'),
            'customer' => array(self::BELONGS_TO, 'Customer', 'company_id'),
            'invoices' => array(self::HAS_MANY, 'Invoice', 'delivery_id'),
            'shippedby' => array(self::BELONGS_TO, 'MasShipping', 'shipped_by'),
            'salesgroup' => array(self::BELONGS_TO, 'MasSalesGroup', 'sales_group'),
            'netVal' => array(self::STAT, 'DeliveryNoteItem', 'delivery_note_id',
                'join' => 'INNER JOIN {{store}} `tc` ON `tc`.`id` = `t`.`product_id`', 'select' => 'SUM(t.picked_qty*tc.rate)'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'file_id' => 'File',
            'crm_user_id' => 'Crm User',
            'company_id' => 'Company',
            'order_id' => 'Order',
            'contact_id' => 'Contact',
            'delivery_date' => 'Delivery Date',
            'shipped_by' => 'Shipped By',
            'sales_group' => 'Sales Group',
            'awb_no' => 'AWB No',
            'no_of_boxes' => 'No of Boxes',
            'tracking_no' => 'Tracking No',
            'total_weight' => 'Total Weight',
            'packed_by' => 'Packed By',
            'shipping_conditions' => 'Shipping Conditions',
            'lpo' => ' PO Ref :',
            'others' => 'Others',
            'delivery_status' => 'Delivery Status',
            'isActive' => 'Is Active',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function reportDeliverynoteTobeInvoiced() {
        $criteria = new CDbCriteria;
        $criteria->with = array('file', 'file.company');
        if (!empty($this->company_id))
            $condition[] = 't.company_id="' . $this->company_id . '"';
        if (!empty($this->country))
            $condition[] = 'company.billing_country="' . $this->country . '"';
        if (!empty($this->shipped_by))
            $condition[] = 'shipped_by="' . $this->shipped_by . '"';
        if (is_array($condition))
            $criteria->condition = implode(' AND ', $condition);
        if (!empty($this->searchstartdate) && !empty($this->searchenddate)) {
            $criteria->addBetweenCondition('delivery_date', $this->searchstartdate, $this->searchenddate);
        }
        /*$criteria->addCondition('       file.own_company_id=' . Yii::app()->user->master_user_company_id . ' AND 
                                        file.own_branch_id=' . Yii::app()->user->master_user_branch_id . ' AND t.invoiced="N"', 'AND');*/
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.delivery_date DESC,t.id DESC, t.file_id DESC,t.company_id DESC',
            ),
            'pagination' => false
        ));
    }

    public function report() {
        $criteria = new CDbCriteria;
        $criteria->with = array('file', 'file.company');
        if (!empty($this->company_id))
            $condition[] = 't.company_id="' . $this->company_id . '"';
        if (!empty($this->country))
            $condition[] = 'company.billing_country="' . $this->country . '"';
        if (!empty($this->shipped_by))
            $condition[] = 'shipped_by="' . $this->shipped_by . '"';
        if (is_array($condition))
            $criteria->condition = implode(' AND ', $condition);
        if (!empty($this->searchstartdate) && !empty($this->searchenddate)) {
            $criteria->addBetweenCondition('delivery_date', $this->searchstartdate, $this->searchenddate);
        }
        /*$criteria->addCondition('       file.own_company_id=' . Yii::app()->user->master_user_company_id . ' AND 
                                        file.own_branch_id=' . Yii::app()->user->master_user_branch_id, 'AND');*/
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.delivery_date DESC,t.id DESC, t.file_id DESC,t.company_id DESC',
            ),
            'pagination' => false
        ));
    }

    public function search($searchterm = null) {
        $criteria = new CDbCriteria;
        $searchterm = empty($searchterm) ? trim(Yii::app()->request->getParam('dn_search')) : $searchterm;
        $criteria->with = array('file', 'file.company', 'file.leadowner',);
        /*$criteria->addCondition('       file.own_company_id=' . Yii::app()->user->master_user_company_id . ' AND 
                                        file.own_branch_id=' . Yii::app()->user->master_user_branch_id, 'AND');*/
        $userModel = User::model()->findByPK(Yii::app()->user->id);
        //$criteria->addCondition('file.lead_owner_id in (' . implode(',', $userModel->subordinates) . ')', 'AND');
        (int) Yii::app()->session['company_id'] > 0 ? $criteria->addCondition('t.company_id=' . Yii::app()->session['company_id'], 'AND') : '';
        
        $user = User::model()->findByPK(Yii::app()->user->id);
/*         if((int) Yii::app()->user->havePermissionOn['sop_delivery_viewall']==1 || Yii::app()->user->authorised_user == 1)
        {
            
        }
        else {
        $criteria->addCondition('t.crm_user_id=' . Yii::app()->user->id.' OR file.lead_owner_id='. Yii::app()->user->id, 'AND');
        } */
        
        if(!isset(Yii::app()->user->havePermissionOn['sop_delivery_viewall']) &&  Yii::app()->user->authorised_user != 1)
        {
        	$criteria->addCondition('file.crm_user_id=' . Yii::app()->user->id.' OR file.lead_owner_id='. Yii::app()->user->id, 'AND');
        }
        
        if (!empty($searchterm)) {
            $criteria->addCondition('   t.id like "%' . $searchterm . '%" OR 
                                        t.file_id like "%' . $searchterm . '%" OR 
                                        company.company_name like "%' . $searchterm . '%" OR 
                                        file.file_title like "%' . $searchterm . '%" OR
                                        leadowner.first_name like "%' . $searchterm . '%" OR
                                        leadowner.last_name like "%' . $searchterm . '%"
                                            ', 'AND');
        }
        if (empty($searchterm))
            $criteria->addCondition('t.invoiced="N"', 'AND');
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.id DESC, t.file_id DESC, t.delivery_date ,t.company_id',
            ),
            'pagination' => (Yii::app()->controller->id != "export") ? array('pageSize' => 15) : false,
        ));
    }

    public function forInvoiceSearch() {
        $file = (int) Yii::app()->request->getParam('file_id');
        $criteria = new CDbCriteria;
        //if (isset(Yii::app()->session['file_id']))
        $criteria->condition = 'file_id='.(int)$file;
        // else
        //$criteria->condition = 'file_id=0';
        $criteria->condition.=' AND invoiced<>"Y"';
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.file_id ,t.delivery_date DESC',
            ),
            'pagination' => array('pageSize' => 5)
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return DeliveryNote the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public function reportsBasedOnDelivery() {
        $rp_company = Yii::app()->session['rp_company'];
        $rp_to_date = Yii::app()->session['rp_to_date'];
        $rp_from_date = Yii::app()->session['rp_from_date'];
        $criteria = new CDbCriteria;
        if ($rp_company == "" && $rp_to_date == "" && $rp_from_date == "") {
            $criteria->condition = "isActive   =   'N'";
        }
        $criteria->condition = "isActive   =   'Y'";
        if ($rp_from_date != "" && $rp_to_date != "")
            $criteria->condition .= ' AND delivery_date BETWEEN "' . $rp_from_date . '" AND "' . $rp_to_date . '"';
        if ($rp_company != "")
            $criteria->condition .= ' AND company_id in ( ' . $rp_company . ')';
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.company_id,t.delivery_date,delivery_status,file_id',
            ),
            'pagination' => array('pageSize' => 500)
        ));
    }

    public function getStatus() {
        return $this->invoiced == "Y" ? "Invoiced" : "Delivered";
    }

    public function deliveryFiles($lead_owner_id) {
        $model = MasterFile::model()->findAll(array('condition' => 'lead_owner_id=' . $lead_owner_id));
        $criteria = new CDbCriteria;
        $criteria->with = array('file');
        foreach ($model as $eachItem) {
            $criteria->addCondition('t.file_id=' . $eachItem->id, 'OR');
        }
        //$criteria->addCondition('status="Y" ');
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.delivery_date ASC',
            ),
            'pagination' => (Yii::app()->controller->id != "export") ? array('pageSize' => 20) : false,
        ));
    }

}
