<?php

/**
 * This is the model class for table "{{customer}}".
 *
 * The followings are the available columns in table '{{customer}}':
 * @property integer $id
 * @property string $customer_name
 * @property string $alias_name
 * @property string $phone
 * @property string $fax
 * @property string $email
 * @property string $location
 * @property string $customs_code
 * @property string $address
 * @property string $po_box
 * @property string $city
 * @property string $state
 * @property integer $country
 * @property integer $last_registered_on
 * @property string $last_registration_no
 * @property integer $credit_limit
 * @property integer $payment_terms
 * @property integer $entry_refund_type
 * @property string $entry_refund_value
 * @property string $entry_clearing_charges
 * @property integer $exit_refund_type
 * @property string $exit_refund_value
 * @property string $exit_clearing_charges
 * @property string $other_notes
 * @property string $status
 * @property integer $created_by
 * @property string $created_date
 * @property integer $updated_by
 * @property string $updated_date
 */
class Customer extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public $customer_type;
	
	public function tableName()
	{
		return '{{customer}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('customer_name, location', 'required'),
			// array('email','email'),
			// array('customs_code', 'unique', 'criteria'=>array('condition'=>'status=1')),
			array('country, credit_limit, payment_terms, entry_refund_type, exit_refund_type, status, created_by,  updated_by,customer_type', 'numerical', 'integerOnly'=>true),
			array('customer_name, alias_name, location, address, po_box,trn_no', 'length', 'max'=>255),
			array('phone, fax', 'length', 'max'=>50),
			array('email, customs_code, city, state, last_registration_no', 'length', 'max'=>100),
			array('entry_refund_value, entry_clearing_charges, exit_refund_value, exit_clearing_charges, salesman', 'length', 'max'=>15),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, customer_name, alias_name, phone, fax, email, location, customs_code, address, po_box, city, state, country, last_registered_on, last_registration_no, credit_limit, payment_terms, entry_refund_type, entry_refund_value, entry_clearing_charges, exit_refund_type, exit_refund_value, exit_clearing_charges, other_notes, status, created_by, created_date, updated_by, updated_date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'country' => array(self::BELONGS_TO, 'MasCountry','country'),
                    'country_details' => array(self::BELONGS_TO, 'MasCountry','country'),
                    'PaymentTerm' => array(self::BELONGS_TO, 'MasPaymentTerm', 'genral_payment_term'),
                    'CustomerTypeRelation' => array(self::HAS_MANY, 'CustomerTypeRelation', 'customer_id'),
                    'documents' => array(self::HAS_MANY, 'Documents', 'company_id'),
                    'invoices' => array(self::HAS_MANY, 'Invoice', 'company_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'customer_name' => 'Customer Name',
			'alias_name' => 'Alias Name',
			'phone' => 'Phone',
			'fax' => 'Fax',
			'email' => 'Email',
			'location' => 'Location',
			'customs_code' => 'Customs Code',
			'address' => 'Address',
			'po_box' => 'Po Box',
			'city' => 'City',
			'state' => 'State',
			'country' => 'Country',
			'last_registered_on' => 'Last Registered On',
			'last_registration_no' => 'Last Registration No',
			'credit_limit' => 'Credit Limit',
			'payment_terms' => 'Payment Terms',
			'entry_refund_type' => 'Entry Refund Type',
			'entry_refund_value' => 'Entry Refund Value',
			'entry_clearing_charges' => 'Entry Clearing Charges',
			'exit_refund_type' => 'Exit Refund Value',
			'exit_refund_value' => 'Exit Refund Value',
			'exit_clearing_charges' => 'Exit Clearing Charges',
			'other_notes' => 'Other Notes',
			'status' => 'Status',
			'created_by' => 'Created By',
			'created_date' => 'Created Date',
			'updated_by' => 'Updated By',
			'updated_date' => 'Updated Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$searchterm = trim(Yii::app()->request->getParam('customs_code'));
		$country= trim(Yii::app()->request->getParam('country'));

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('customer_name',$this->customer_name,true);
		$criteria->compare('alias_name',$this->alias_name,true);
		$criteria->compare('phone',$this->phone,true);
		$criteria->compare('fax',$this->fax,true);
		$criteria->compare('email',$this->email,true);
		$criteria->compare('location',$this->location,true);
		$criteria->compare('customs_code',$this->customs_code,true);
		$criteria->compare('address',$this->address,true);
		$criteria->compare('po_box',$this->po_box,true);
		$criteria->compare('city',$this->city,true);
		$criteria->compare('state',$this->state,true);
		$criteria->compare('country',$this->country);
		$criteria->compare('last_registered_on',$this->last_registered_on);
		$criteria->compare('last_registration_no',$this->last_registration_no,true);
		$criteria->compare('credit_limit',$this->credit_limit);
		$criteria->compare('payment_terms',$this->payment_terms);
		$criteria->compare('entry_refund_type',$this->entry_refund_type);
		$criteria->compare('entry_refund_value',$this->entry_refund_value,true);
		$criteria->compare('entry_clearing_charges',$this->entry_clearing_charges,true);
		$criteria->compare('exit_refund_type',$this->exit_refund_type);
		$criteria->compare('exit_refund_value',$this->exit_refund_value,true);
		$criteria->compare('exit_clearing_charges',$this->exit_clearing_charges,true);
		$criteria->compare('other_notes',$this->other_notes,true);
		$criteria->compare('status',$this->status);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date',$this->created_date);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date',$this->updated_date);
		if(!empty($searchterm)){
                    $criteria->addCondition('   t.customer_name like "%' . $searchterm . '%" OR 
                                        t.alias_name like "%' . $searchterm . '%" OR 
                                        t.customs_code like "%' . $searchterm . '%" OR 
                                        t.location like "%' . $searchterm . '%" OR
                                        t.po_box like "%' . $searchterm . '%" OR  
                                        t.last_registration_no like "%' . $searchterm . '%"', 'AND');
                }

		if(!empty($country)){
                    $criteria->addCondition('t.country ='.$country,'AND');
                }
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Customer the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	
	public function getCustomersByType($type=0) {
		
		$condition = 't.status =  1 and t.customer_type='.$type;
		$model = Customer::model()->findAll(array('condition' => $condition, 'order' => 'customer_name ASC'));
		return CHtml::listData($model, 'id', 'customer_name');
	}
	public function getCustomersAliasName() {
	
		$condition = 'customer.status =  1 and t.type_id=1';//customer
		$model = CustomerTypeRelation::model()->with(array('customer'))
		->findAll(array('condition' => $condition, 'order' => 'customer.alias_name ASC'));
		return CHtml::listData($model, 'customer.id', 'customer.alias_name');
	}
	
	public function getCustomersName($id) {
	
		$model = Customer::model()->findAllByPk($id,array('select'=>'customer_name'));
		return $model[0]['customer_name'];
	}
	public function getAllCustomers() {	
		$model = Customer::model()->findAll(array('order'=>customer_name));
		return CHtml::listData($model, 'id', 'customer_name');
	}
}