<?php

/**
 * This is the model class for table "{{company_shipping_details}}".
 *
 * The followings are the available columns in table '{{company_shipping_details}}':
 * @property integer $id
 * @property integer $company_id
 * @property string $state
 * @property string $city
 * @property string $street_address
 * @property string $po_box
 * @property string $postal_code
 */
class CompanyShippingDetails extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{company_shipping_details}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			//array('street_address,', 'required'),
			array('company_id', 'numerical', 'integerOnly'=>true),
			array('street_address,state, city, po_box, postal_code', 'length', 'max'=>200),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, company_id, state, city, street_address, postal_code', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'country' => array(self::BELONGS_TO, 'MasCountry','country_id'),
                    'cus_details' => array(self::BELONGS_TO, 'Customer','company_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'company_id' => 'Company',
			'state' => 'Shipping State/Province',
			'city' => 'Shipping City',
			'street_address' => 'Shipping Street Address',
			'po_box' => 'Shipping Po Box',
			'postal_code' => 'ShippingPostal Code',
            'country_id' => 'Shipping Country',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('company_id',$this->company_id);
		$criteria->compare('state',$this->state);
		$criteria->compare('city',$this->city);
		$criteria->compare('street_address',$this->street_address,true);
		$criteria->compare('po_box',$this->po_box);
		$criteria->compare('postal_code',$this->postal_code);
		$criteria->compare('country_id',$this->country_id);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return CompanyShippingDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
         public function getshipping()
        {
            return ($this->country->country_name . '/' . $this->city);
        }
        public static function getShippingLocation($company_id) {
       
            $condition = 'company_id =  '.$company_id.'';
            $model = self::model()->with('country')->findAll(array('condition' => $condition,'order'=>'country.id,city'));
            return CHtml::listData($model, 'id', 'shipping');
        }
}
