<?php

/**
 * This is the model class for table "crm_pdc".
 *
 * The followings are the available columns in table 'crm_pdc':
 * @property integer $id
 * @property string $voucher_date
 * @property string $apply_date
 * @property integer $customer_id
 * @property string $bank_date
 * @property string $voucher_no
 * @property integer $voucher_sub_id
 * @property string $narration
 * @property string $amount
 * @property string $posted
 */
class BankReconciliation extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Pdc the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{bank_reconciliation}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('voucher_date, apply_date, customer_id,voucher_no, voucher_sub_id, narration, amount,type', 'required'),
			array('customer_id,voucher_sub_id', 'numerical', 'integerOnly'=>true),
			array('voucher_no', 'length', 'max'=>30),
			array('narration,bank_id', 'length', 'max'=>250),
			array('amount', 'length', 'max'=>15),
			array('posted', 'length', 'max'=>1),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, voucher_date, apply_date, customer_id, bank_date, voucher_no, voucher_sub_id, narration, amount, posted', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'sub' => array(self::BELONGS_TO, 'Subledger', 'customer_id'),
                    'acc' => array(self::BELONGS_TO, 'FinAccounts', 'bank_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'voucher_date' => 'Voucher Date',
			'apply_date' => 'Apply Date',
			'customer_id' => 'Customer',
			'bank_date' => 'Realisation Date',
			'voucher_no' => 'Voucher No',
			'voucher_sub_id' => 'Voucher Sub',
			'narration' => 'Narration',
			'amount' => 'Amount',
			'posted' => 'Posted',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('voucher_date',$this->voucher_date,true);
		$criteria->compare('apply_date',$this->apply_date,true);
		$criteria->compare('customer_id',$this->customer_id);
		$criteria->compare('bank_date',$this->bank_date,true);
		$criteria->compare('voucher_no',$this->voucher_no,true);
		$criteria->compare('voucher_sub_id',$this->voucher_sub_id);
		$criteria->compare('narration',$this->narration,true);
		$criteria->compare('amount',$this->amount,true);
		$criteria->compare('posted',$this->posted,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}