<?php

/**
 * This is the model class for table "crm_advance_payment".
 *
 * The followings are the available columns in table 'crm_advance_payment':
 * @property integer $id
 * @property string $received_date
 * @property integer $file_id
 * @property string $notes
 * @property string $amount
 */
class AdvancePayment extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return AdvancePayment the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{advance_payment}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('received_date, file_id,amount,realisation_date,ref_number,mode_of_payment', 'required'),
			array('file_id', 'numerical', 'integerOnly'=>true),
			array('notes', 'length', 'max'=>255),
			array('amount', 'length', 'max'=>15),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, received_date, file_id, notes, amount', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'received_date' => 'Received Date',
			'file_id' => 'File',
			'notes' => 'Notes',
			'amount' => 'Amount',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('received_date',$this->received_date,true);
		$criteria->compare('file_id',$this->file_id);
		$criteria->compare('notes',$this->notes,true);
		$criteria->compare('amount',$this->amount,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}