<?php

/**
 * This is the model class for table "{{activity}}".
 *
 * The followings are the available columns in table '{{activity}}':
 * @property integer $id
 * @property string $company_id
 * @property integer $contact_id
 * @property string $notes
 * @property string $date_to_do
 * @property string $typ_of_activity
 * @property string $isActive
 *
 * The followings are the available model relations:
 * @property CompanyContact $contact
 * @property Company $company
 */
class Activity extends CActiveRecord {

    public $company_name;
    public $company_id;
    public $searchstartdate;
    public $searchenddate;

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{activity}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
// NOTE: you should only define rules for those attributes that
// will receive user inputs.
        return array(
            array('crm_user_id, notes, typ_of_activity', 'required'),
            //array('contact_id', 'numerical', 'min' => 1, 'message' => 'There is an error in selecting the contact,Please select the contact again.'),
            array('date_to_do', 'required', 'on' => 'task'),
            array('date_to_do', 'length', 'max' => 255),
            //array('date_to_do', 'date', 'format' => 'yyyy-MM-dd hh:mm:ss', 'message' => '{attribute} have wrong format'),
            array('company_id,contact_id', 'length', 'max' => 20),
            array('typ_of_activity, isActive, isComplete', 'length', 'max' => 1),
            // The following rule is used by search().
// @todo Please remove those attributes that should not be searched.
            array('id, company_id, contact_id, date_to_do, typ_of_activity, isActive,created_by,updated_by,created_datetime,updated_datetime', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
// NOTE: you may need to adjust the relation name and the related
// class name for the relations automatically generated below.
        return array(
            'user' => array(self::BELONGS_TO, 'User', 'crm_user_id'),
            'contact' => array(self::BELONGS_TO, 'CompanyContact', 'contact_id'),
            'company' => array(self::BELONGS_TO, 'Company', 'company_id'),
            'meeting' => array(self::HAS_ONE, 'Meeting', 'activity_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'company_id' => 'Company',
            'contact_id' => 'Contact Person',
            'notes' => 'Notes / Details / Agenda',
            'date_to_do' => 'Date To Do',
            'typ_of_activity' => 'Typ Of Activity',
            'isActive' => 'Is Active',
            'isComplete' => 'Mark as complete ?'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
// @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;
        $contact_id = (int) Yii::app()->request->getParam('contact_id');
        if (!empty($contact_id))
            $criteria->addCondition('contact_id=' . $contact_id);
        else if (!empty($this->contact_id))
            $criteria->addCondition('contact_id=' . $this->contact_id);
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.contact_id',
            ),
            'pagination' => array('pageSize' => 5)
        ));
    }

    public function report() {
         if (!empty($this->company_id))
        {
        $id=$this->company_id;
        $contact=CompanyContact::model()->findAll(array("condition"=>"company_id =  $id"));
        $cont=  array();
        foreach ($contact as $i => $row)
        {
        $cont[$i]= $row->id;    
        }
        }
        $criteria = new CDbCriteria;
        $criteria->with = array('user');
        if (!empty($this->company_id))
            $criteria->addInCondition('t.contact_id',$cont);
           // $criteria->addCondition('t.company_id="' . $this->company_id . '"', ' AND ');
        if (!empty($this->crm_user_id))
            $criteria->addCondition('crm_user_id="' . $this->crm_user_id . '"', ' AND ');
        if (!empty($this->typ_of_activity))
            $criteria->addCondition('t.typ_of_activity = "' . $this->typ_of_activity . '"', ' AND ');
        if (!empty($this->searchstartdate) && !empty($this->searchenddate)) {
            $criteria->addBetweenCondition('date(date_to_do)', $this->searchstartdate, $this->searchenddate);
        }

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 'user.first_name,t.typ_of_activity,t.isComplete DESC, t.id DESC,t.date_to_do DESC',
            ),
            'pagination' => false
        ));
    }

    public function followups() {
        $criteria = new CDbCriteria;
        $criteria->condition = 'crm_user_id=' . Yii::app()->user->id . ' AND DATE(date_to_do)="' . date('Y-m-d') . '"';

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.date_to_do DESC', //,t.company_id',
            ),
            'pagination' => array('pageSize' => 5)
        ));
    }

    public function todaysActivity() {
        $criteria = new CDbCriteria;
        $criteria->condition = 'crm_user_id=' . Yii::app()->user->id . ' AND DATE(date_of_activity)="' . date('Y-m-d') . '"';

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.date_of_activity DESC', //, t.company_id',
            ),
            'pagination' => array('pageSize' => 5)
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return Activity the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public function getActivity() {
        switch ($this->typ_of_activity) {
            case 'C':
                return 'Call';
                break;
            case 'T':
                return 'Task';
                break;
            case 'M':
                return 'Meeting';
                break;
            case 'V':
                return 'Visit';
                break;
        }
    }

    public function getTiming() {
        if ($this->typ_of_activity == "M")
            return date('Y-m-d h:i A', strtotime($this->meeting->start_date)) . " To " . date('Y-m-d h:i A', strtotime($this->meeting->end_date));
        else if ($this->typ_of_activity == "V")
            return date('Y-m-d h:i A', strtotime($this->date_to_do));
        else
            return date('Y-m-d', strtotime($this->date_to_do));
    }

    public function getStatus() {
        if ($this->isComplete == "Y")
            return "F";
        else
            return "-";
    }

}
