<?php
class SiteController extends Controller {
    /**
     * Declares class-based actions.
     */
    public function actions() {
        return array(
			// captcha action renders the CAPTCHA image displayed on the contact page
            'captcha' => array(
                'class' => 'CCaptchaAction',
                'backColor' => 0xFFFFFF,
            ),
            // page action renders "static" pages stored under 'protected/views/site/pages'
			// They can be accessed via: index.php?r=site/page&view=FileName
            'page' => array(
                'class' => 'CViewAction',
            ),
        );
    }
        public function accessRules() {

        return array(

                array('allow', // allow all users to perform 'index' and 'view' actions

                  'actions' => array('login', 'error', 'logout'),

                  'users' => array('*'),

                  ),

                array('allow', // allow authenticated user to perform 'create' and 'update' actions

                  'actions' => array('Index','ChangePassword','UpdatePassword','GetAllDetailsForProduct','GetDBBackup'),

                  'expression' => '$user->isMember()',

                  ),

                array('deny', // deny all users

                  'users' => array('*'),

                  ),

                );

    }


    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     */
    public function actionIndex() {

        $this->layout = (Yii::app()->user->master_user) ? 'master' : 'layout';     
        $this->render('index');
    }
    public function actionChangePassword() {
        $this->render('changepassword');
    }
    public function actionUpdatePassword() {
        $curr_pwd      = $_POST['user_current_password'];
        $new_pwd       = $_POST['user_new_password'];
        $rep_pwd       = $_POST['user_reenter_password'];
        $login_user_id = Yii::app()->user->id;
        $arr_user_details= User::model()->findByPk($login_user_id);
        $salt       = '$2a$10$1qAz2wSx3eDc4rFv5tGb5t';
        $password   = crypt($_POST['user_current_password'], $salt);
        if($arr_user_details->password == $password){
            $new_password   = crypt($_POST['user_new_password'], $salt);
            $arr_user_details->password=$new_password;
            $arr_user_details->save(false);
            $json['status'] = "success";
        }
        else
        {  
            $json['status'] = "fail";
        }
        echo CJSON::encode($json);
    }
    
    public function actionGetAllDetailsForProduct(){
        $product_id     = $_POST['product_id'];
        $customer_id    = $_POST['customer_id'];
        $modelCustomer = new Customer();
        $arr_customer_details = $modelCustomer->findByPk($customer_id);
        
        
        $sales_pricing_group_id = $arr_customer_details->sales_pricing_group;
        
        
        $model = new SalesPriceGroup();
        $arr_price_details = $model->find(array('condition'=>'product_id='.$product_id));
       
        $price = $arr_price_details->sales_price1;
        
        
        $jsonData['price'] = number_format(floatval($price), 2, '.', '');
        echo CJSON::encode($jsonData);
        Yii::app()->end();
        
    }
    
    public function actionGetDBBackup(){
$host = "localhost";
// online - sila
$user="blskymine_logistics";
    	$pass="F=hAppiW!7Ck";

$db = Yii::app()->user->company_db_name;
$db_main = Yii::app()->user->main_db_name;

$tables = '*';

$file_name = "dbbackup/dbbackup.sql";
$file_name_path = Yii::getPathOfAlias('webroot') . "/" . $file_name;

// Establish the connection
$link = mysqli_connect($host, $user, $pass);

// Check connection
if (!$link) {
    die("Connection failed: " . mysqli_connect_error());
}

// Select the database
mysqli_select_db($link, $db);

// Get all of the tables
if ($tables == '*') {
    $tables = array();
    $result = mysqli_query($link, 'SHOW TABLES');

    while ($row = mysqli_fetch_row($result)) {
        $tables[] = $row[0];
    }
} else {
    $tables = is_array($tables) ? $tables : explode(',', $tables);
}

// Open the file for writing
$handle = fopen($file_name_path, 'w');
if (!$handle) {
    die("Unable to open file!");
}

// Cycle through each table
foreach ($tables as $table) {
    $return = "";
    $result = mysqli_query($link, 'SELECT * FROM ' . $table);
    $num_fields = mysqli_num_fields($result);

    // Add DROP statement for the table
    $return .= 'DROP TABLE ' . $table . ';';
    $row2 = mysqli_fetch_row(mysqli_query($link, 'SHOW CREATE TABLE ' . $table));
    $return .= "\n\n" . $row2[1] . ";\n\n";

    // Loop through each row and prepare the INSERT statements
    while ($row = mysqli_fetch_row($result)) {
        $return .= 'INSERT INTO ' . $table . ' VALUES(';
        for ($j = 0; $j < $num_fields; $j++) {
            $row[$j] = addslashes($row[$j]);
            $row[$j] = preg_replace("/(\n){2,}/", "\\n", $row[$j]);

            if (isset($row[$j])) {
                $return .= '"' . $row[$j] . '"';
            } else {
                $return .= '""';
            }

            if ($j < ($num_fields - 1)) {
                $return .= ',';
            }
        }
        $return .= ");\n";
    }
    $return .= "\n\n\n";

    // Write to file
    file_put_contents($file_name_path, $return, FILE_APPEND | LOCK_EX);
    fwrite($handle, $return);
}

// Close the file handle
fclose($handle);

echo "DB Backup Process Completed";

    }
    
    public function actionGetDBBackupold()
    {
    	$host="localhost";
    	
    	//online -sila
    	
    	$user="blskymine_logistics";
    	$pass="F=hAppiW!7Ck";
    	
    	$db=Yii::app()->user->company_db_name; 
    	$db_main=Yii::app()->user->main_db_name; 
    	
    	
    	    	
    	$tables = '*';

    	$file_name		= "dbbackup/dbbackup.sql";
    	$file_name_path = Yii::getPathOfAlias('webroot')."/".$file_name;
    
    	$link = mysqli_connect($host,$user,$pass);
    	
    	
    	
    	mysqli_select_db($db,$link);
    	//get all of the tables
    	if($tables == '*')
    	{
    		$tables = array();
    		$result = mysqli_query('SHOW TABLES');
    		 
    		while($row = mysqli_fetch_row($result))
    		{
    			$tables[] = $row[0];
    
    		}
    	}
    	else
    	{
    		$tables = is_array($tables) ? $tables : explode(',',$tables);
    	}
    	//cycle through
    	foreach($tables as $table)
    	{
    		$return="";
    		$result = mysqli_query('SELECT * FROM '.$table);
    		$num_fields = mysqli_num_fields($result);
    		//print_r($num_fields);exit;
    		$return.= 'DROP TABLE '.$table.';';
    		$row2 = mysqli_fetch_row(mysqli_query('SHOW CREATE TABLE '.$table));
    		$return.= "\n\n".$row2[1].";\n\n";
    		 
    		for ($i = 0; $i < $num_fields; $i++)
    		{
    		while($row = mysqli_fetch_row($result))
    		{
    		$return.= 'INSERT INTO '.$table.' VALUES(';
    				for($j=0; $j<$num_fields; $j++)
    		{
    		$row[$j] = addslashes($row[$j]);
    		// $row[$j] = preg_replace("\n","\\n",$row[$j]);
    
    		$row[$j] = preg_replace("/(\n){2,}/", "\\n", $row[$j]);
    
    		if (isset($row[$j])) { $return.= '"'.$row[$j].'"' ; } else { $return.= '""'; }
    		if ($j<($num_fields-1)) { $return.= ','; }
    		}
    		$return.= ");\n";
    		}
    		}
    		$return.="\n\n\n";
    		 
    		file_put_contents($file_name_path, $return, FILE_APPEND | LOCK_EX);
    		fwrite($handle,$return);
    }
    
    
    
    
            /*$link = mysqli_connect($host,$user,$pass);
            mysqli_select_db($db_main,$link);
            
            $tables_main = array();
            $result = mysqli_query('SHOW TABLES');
             
            while($row = mysqli_fetch_row($result))
    {
    	$tables_main[] = $row[0];
    
    }
     
    foreach($tables_main as $table_main)
    {
    	$return="";
    	$result = mysqli_query('SELECT * FROM '.$table_main);
    	$num_fields = mysqli_num_fields($result);
    	//print_r($num_fields);exit;
    	$return.= 'DROP TABLE '.$table_main.';';
    	$row2 = mysqli_fetch_row(mysqli_query('SHOW CREATE TABLE '.$table_main));
    	$return.= "\n\n".$row2[1].";\n\n";
    	 
    	for ($i = 0; $i < $num_fields; $i++)
    	{
    	while($row = mysqli_fetch_row($result))
    	{
    	$return.= 'INSERT INTO '.$table_main.' VALUES(';
    	for($j=0; $j<$num_fields; $j++)
    	{
    	$row[$j] = addslashes($row[$j]);
    		// $row[$j] = preg_replace("\n","\\n",$row[$j]);
    
    		$row[$j] = preg_replace("/(\n){2,}/", "\\n", $row[$j]);
    
    		if (isset($row[$j])) { $return.= '"'.$row[$j].'"' ; } else { $return.= '""'; }
    		if ($j<($num_fields-1)) { $return.= ','; }
    		}
    				$return.= ");\n";
    	}
    	}
    	$return.="\n\n\n";
    	 
    	file_put_contents($file_name_path, $return, FILE_APPEND | LOCK_EX);
    	fwrite($handle,$return);
    }
    */
    $zip = new ZipArchive();
    
    $zip_file_path = Yii::getPathOfAlias('webroot')."/dbbackup/dbbackup_".date('d-m-Y').".zip";
    		 
    if($zip->open($zip_file_path,1?ZIPARCHIVE::OVERWRITE:ZIPARCHIVE::CREATE)===TRUE)
    	{
    			// Add the files to the .zip file
        		$zip->addFile($file_name);
        		// Closing the zip file
        		$zip->close();
        		//remove file from path
        		@unlink($file_name_path);
        }
        		 
        header("Content-type:application/zip"); //for pdf file
        //if you want to read text file using text/plain header
    	header('Content-Disposition: attachment; filename="'.basename($zip_file_path).'"');
    	header('Content-Length: ' . filesize($zip_file_path));
    	readfile($zip_file_path);
    	
    	@unlink($zip_file_path);
    	Yii::app()->end();
    }

}
