<?php

class LocationController extends Controller
{
        public function accessRules() {
            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                  'actions' => array('login', 'error', 'logout'),
                  'users' => array('*'),
                  ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                  'actions' => array('Index','Create','GetList','Save','Delete'),
                  'expression' => '$user->isMember()',
                  ),
                array('deny', // deny all users
                  'users' => array('*'),
                  ),
                );
        }
	public function actionIndex()
	{
		$this->render('index');
	}

	
	
	public function filters()
        {
            return array(
                'accessControl', // perform access control for CRUD operations
                );
        }
        public function actionGetList()
        {
                $model=new MasLocation();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 =>'id',
                   1 =>'location',
                   2 =>'isActive',
                   
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = 't.isActive="Y"';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition.=" and (location LIKE '%".$searchString."%')";
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m = 1;
                
                foreach ($model as $row)
                {
                    $div = '';
                    if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["location_edit"])){
                        $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'location/create&id='.$row['id'].'\',\'Edit Location\',\'lg\')"><i class="fa fa-pencil"></i></button>';
                    }
                   // if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_inv_rack_delete"])){
                   //     $div .=  '<a href ="#" class="btn btn-danger btn-xs" onclick="deleteTax('.$row['id'].')"><i class="fa fa-trash-o "></i></a>';
                 //   }
                       $rowData[]=array($m,$row['location'],'<div class="btn-wrap text-center">'.$div.'</div>');
                
                    $m++;
                    
                }
                
                
                
//                foreach ($model as $row)
//                {
//                    $rowData[]=array($m,$row['name'],'<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'rack/create&id='.$row['id'].'\',\'Edit Rack\',\'lg\')"><i class="fa fa-pencil"></i></button> '
//             .'<a href ="#" class="btn btn-danger btn-xs" onclick="deleteRack('.$row['id'].')"><i class="fa fa-trash-o "></i></a></div>');
//                    $m++;
//                }
                $data['data'] = $rowData;
                echo json_encode($data);
        }
         public function actionCreate()
        {
            $model=new MasLocation();
            $id = (int) Yii::app()->request->getParam('id');
            if($id>0){
                $model=$model->findByPk($id);
            }
                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('location_form', array('model' => $model), false, false);
        }
  
  
        public function actionSave()
        {
            $model = new MasLocation();
            if (isset($_POST['MasLocation'])){
                $model->created_by = Yii::app()->user->id;
                $model->created_datetime =date('Y-m-d h:i:s');
                if ((int) @$_POST['MasLocation']['id'] > 0){   
                    $model->updated_by = Yii::app()->user->id;
                    $model->updated_datetime =date('Y-m-d h:i:s');
                    $id= (int) @$_POST['MasLocation']['id'];
                    $model=$model->findByPk($id);  
                }
                $model->attributes=$_POST['MasLocation'];
                $model->location=$_POST['MasLocation']['location'];
                $model->isActive="Y";                
                if ($model->save()){
                    $jsonData['status'] = 'success';
                    $jsonData['frm'] = $_POST['rack_form'];
                    $jsonData['id'] = $model->id;
                    echo CJSON::encode($jsonData);
                }
                else{
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }
          
            }
        }
        public function actionDelete(){
            $id = $_POST['id'];
            $model=new MasInvTax();
            $model->deleteByPk($id);
            echo "success";
        }
}