<?php

class GenericController extends Controller

{

        public function accessRules() {

            return array(

                array('allow', // allow all users to perform 'index' and 'view' actions

                  'actions' => array('login', 'error', 'logout'),

                  'users' => array('*'),

                  ),

                array('allow', // allow authenticated user to perform 'create' and 'update' actions

                  'actions' => array('Index','Create','GetList','SaveGeneric','DeleteGeneric','DirectAdd'),

                  'expression' => '$user->isMember()',

                  ),

                array('deny', // deny all users

                  'users' => array('*'),

                  ),

                );

        }

	public function actionIndex()
	{

		$this->render('index');

	}


	public function filters()

        {

            return array(

                'accessControl', // perform access control for CRUD operations

                );

        }

        public function actionGetList()
        {

                $model = new MasGeneric();

                $draw     = $_POST['draw'];

                $offset = $_POST['start'];

                $limit  = $_POST['length'];

                $columns = array(

                // datatable column index  => database column name

                   0 =>'id',

                   1 => 'generic_name',

                   2 => 'generic_description',                  

                   

                   );

                $filterColumn = $columns[$_POST['order'][0]['column']];

                $filterOrder  = $_POST['order'][0]['dir'];

                $orderBy   = $filterColumn." ".$filterOrder;

                $condition = '1=1';

                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")

                {

                  $searchString = $_POST['search']['value'];

                  $condition.=" and generic_name LIKE '%".$searchString."%' OR generic_description LIKE '%".$searchString."%'";

                }

                $count = $model->count(array('condition'=>$condition));

                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));

                $recordsTotal = $count;

                $recordsFiltered = $count;

                $data['draw'] = $draw;

                $data['recordsTotal'] = $recordsTotal;

                $data['recordsFiltered'] = $recordsFiltered;

                $rowData=array();

                $m = 1;

                 
                foreach ($model as $row)
                {
                    $div = '';
                    if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["inventory_generic_name_edit"])){
                        $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'generic/create&id='.$row['id'].'\',\'Generic - '.$row['generic_name'].' \',\'lg\')"><i class="fa fa-pencil"></i></button>';
                    }
                    if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["inventory_generic_name_delete"])){
                     //   $div .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="deleteGeneric('.$row['id'].')"><i class="fa fa-trash-o "></i></a>';
                    }
                        $rowData[]=array($m,$row['generic_name'],$row['generic_description'],'<div class="btn-wrap text-center">'.$div.'</div>');
                
                    $m++;
                    
                       }

//                foreach ($model as $row)
//
//                {
//
//                    $rowData[]=array($m,$row['generic_name'],$row['generic_description'],'<div class="btn-wrap text-center">'
//
//                        . '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'generic/create&id='.$row['id'].'\',\'Generic\',\'lg\')"><i class="fa fa-pencil"></i></button> '
//
//                        .'<a href ="#" class="btn btn-danger btn-xs" onclick="deleteGeneric('.$row['id'].')"><i class="fa fa-trash-o "></i></a></div>');
//
//                    $m++;
//
////                }

                $data['data'] = $rowData;

                echo json_encode($data);

        }

         public function actionCreate()

        {

            $model=new MasGeneric();

            $model_clevel1=array(new MasCategoryFirstLevel());

            $model_clevel2=array(new MasCategorySecondLevel());
            
             $from = Yii::app()->request->getParam('from');

            $id = (int) Yii::app()->request->getParam('id');

            if($id>0){

                $model=$model->findByPk($id);

                $model_clevel1 = MasCategoryFirstLevel::model()->findAll(array('condition'=>'generic_name_id="'.$id.'"'));  

                $model_clevel2 = MasCategorySecondLevel::model()->findAll(array('condition'=>'generic_name_id="'.$id.'"'));  

                if(empty($model_clevel1)){

                      $model_clevel1=array(new MasCategoryFirstLevel());  

                }

                 if(empty($model_clevel2)){

                      $model_clevel2=array(new MasCategorySecondLevel());  



                }

            }

                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

            $this->render('generic_form', array('model' => $model,'model_clevel1'=>$model_clevel1,'model_clevel2'=>$model_clevel2,'from' => $from));

        }

        public function actionSaveGeneric()
        {

           // print_r($_POST); die();
            $model=new MasGeneric();

    	/************ START Code for Save ***************/

    	if (isset($_POST['MasGeneric'])) {

    		if ((int) @$_POST['MasGeneric']['id'] > 0) {               

                        $id= (int) @$_POST['MasGeneric']['id'];
                        $model=$model->findByPk($id);
    			$model->updated_by = Yii::app()->user->id;
    			$model->updated_date_time = date('y-m-d');
                }else{
                        $model->created_by = Yii::app()->user->id;
    			$model->created_date_time = date('y-m-d');
                     }

            $model->attributes=$_POST['MasGeneric']; 
            $model->generic_description=$_POST['MasGeneric']['generic_description'];
           // $model_user= User::model()->findByPK(Yii::app()->user->user_id);  

           // $model->company_id=$model_user->company_id; 
                                 

            if ($model->validate())
	    {            
                $model->save();     

                    if (isset($_POST['MasCategoryFirstLevel'])) {

                     foreach ($_POST['MasCategoryFirstLevel'] as $i => $items) {                          

                        if($items['id']>0){
                            $model_clevel1[$i] = MasCategoryFirstLevel::model()->findByPK($items['id']);  
                            $model_clevel1[$i]->updated_by = Yii::app()->user->id;
    			    $model_clevel1[$i]->updated_date_time = date('y-m-d');

                         }else{
                            $model_clevel1[$i] = new MasCategoryFirstLevel();   
                            $model_clevel1[$i]->created_by = Yii::app()->user->id;
    			    $model_clevel1[$i]->created_date_time = date('y-m-d');
                         }     

                        $model_clevel1[$i]->generic_name_id = $model->id;
                        $model_clevel1[$i]->category_name = $items['category_name'];
                        $model_clevel1[$i]->category_description = $items['category_description'];
                        $valid = $model_clevel1[$i]->validate();                                           

                    }  

                     if($valid){
                        foreach ($model_clevel1 as $eachModel) { 
                            $eachModel->save();
                        }
                    }                        
                } 
                
                  if (isset($_POST['MasCategorySecondLevel'])) {

                     foreach ($_POST['MasCategorySecondLevel'] as $i => $items) {                          

                        if($items['id']>0){
                            $model_clevel2[$i] = MasCategorySecondLevel::model()->findByPK($items['id']);          
                            $model_clevel2[$i]->updated_by = Yii::app()->user->id;
    			    $model_clevel2[$i]->updated_date_time = date('y-m-d');
                         }else{
                            $model_clevel2[$i] = new MasCategorySecondLevel(); 
                            $model_clevel2[$i]->created_by = Yii::app()->user->id;
    			    $model_clevel2[$i]->created_date_time = date('y-m-d');

                         }     

                        $model_clevel2[$i]->generic_name_id = $model->id;
                        $model_clevel2[$i]->category_name = $items['category_name'];
                        $model_clevel2[$i]->category_description = $items['category_description'];
                        $valid = $model_clevel2[$i]->validate();                                           

                    }  

                     if($valid){
                        foreach ($model_clevel2 as $eachModel) { 
                            $eachModel->save();
                        }
                    }                        
                } 
                        $jsonData['id'] = $model->id;
                         $jsonData['from'] = $_POST['from'];

                        $jsonData['status'] = 'success';

	                echo CJSON::encode($jsonData);
                
            }
	    else
	    {
                        $error = CActiveForm::validate($model, '', false);

                        if ($error != '[]')

		               echo $error;

            }
        }   
        }

        public function actionDeleteGeneric(){

		 $id = $_POST['id'];  
                
                $store = Yii::app()->db->createCommand('SELECT COUNT(*) FROM crm_store WHERE generic_name = '.$id.' ')->queryScalar();
                
                if($store > 0){
                    echo "fail";
                }else{
                    
                    $model=new MasGeneric();
                    $model->deleteByPk($id);
                    echo "success";
                }


    }
    public function actionDirectAdd(){
           $from = $_POST['from'];
           $name = $_POST['name'];
           $des  = $_POST['des'];
           $status =  array();
           if($name != ''){
               $modelGeneric = new MasGeneric;
               $modelGeneric->created_by = Yii::app()->user->id;
               $modelGeneric->created_date_time =date('Y-m-d h:i:s');   
               $modelGeneric->generic_description = $des;
               $modelGeneric->generic_name = $name;
               if($modelGeneric->save()){
                    $data  =  MasGeneric::getGenericNames();
                    if($from == 'inventory'){
                         $model = new Store;
                         $field_name = 'generic_name';
                    }
                    $model->$field_name = $modelGeneric->id;
                    $drop=CHtml::activedropDownList($model,$field_name, $data,  array('class' => 'tooltipster','data-label'=>'Generic'));  
                    $status=array("status" =>"success","drop" => $drop);    
                    echo CJSON::encode($status);
               }else{
                    $error = CActiveForm::validate($modelGeneric, '', false);
                        if ($error != '[]')
		               echo $error;
               }
               
           }
           
          
            
         }

}