<?php

class GeneralalertController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout', 'Forgotpassword', 'Recover'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('viewAlert','Create','SendEntryEmailToCustomer','SendExitEmailToCustomer','SaveAlert'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array('accessControl'); // perform access control for CRUD operations
    }

    public function actionViewAlert() {
        $id=  Yii::app()->request->getParam('id');
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('//general/alert_form', array('id' => $id), false, true);
        
    } 

    public function actionCreate(){
        $model=new MasAlert();
        
        $model = $model->find();
        
        $id = 0;
        if(!empty($model))
        {
        	$id = (int) $model->id;
        }
        else{
            $model=new MasAlert();
        }
        
       
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('alert', array('model' => $model), false, false);
    }

    public function actionSaveAlert()
    {
        
        if( isset($_POST['MasAlert'])){
        	$model = new MasAlert();
            $model->attributes=$_POST['MasAlert'];  
            if($model->validate()){
            	
            	//if($_POST['MasAlert']['id'] >0)
            	if((int) $_POST['MasAlert']['id'] > 0)
            	{
            		$model->updateByPk($_POST['MasAlert']['id'], array('alert' => $_POST['MasAlert']['alert']));
            	}
            	else 
            	{
            		 $model->save();
            	}
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);    	
            }else{
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionSendEntryEmailToCustomer($id=0) {

    	$arr_entry_invoice_details = EntryInvoice::model()->with('truck','customer')->findAll(array('condition'=>"t.id=".$id));
    	
    	
    	$SQL=" SELECT  entryinv.id AS invoice_id,invoice_date,customer_name,email,destination,
							(SELECT GROUP_CONCAT( truck.truck_no ) FROM crm_entry_invoice_truck_no AS truck) AS truck_no 
							FROM `crm_entry_invoice` AS entryinv
							INNER JOIN crm_customer AS customer ON entryinv.customer_id=customer.id WHERE entryinv.id=".$id." GROUP BY entryinv.id ";
    	
    	$arr_entry_invoice_details = Yii::app()->db->createCommand($SQL)->queryAll();
    	
    	
    	$customer_name	= $arr_entry_invoice_details[0]['customer_name'];
    	$invoice_date	= $arr_entry_invoice_details[0]['invoice_date'];
    	$destination	= $arr_entry_invoice_details[0]['destination'];
    	$truck			= $arr_entry_invoice_details[0]['truck'];
    	$customer_email = $arr_entry_invoice_details[0]['email'];
    	
    	/* $mailContent['body'] = "Hi,<br><br>";
    	
        $mailContent['body'].= "An Invoice has been raised  against Truck No ".$truck." Destination is :".$destination." Customer : ".$customer_name." Invoice Date :".$invoice_date."<br>";
    	
        $mailContent['body'].= "Thank You,<br>";
        $mailContent['body'].= "Transworld"; */
    	
    	$mailContent = "Hi,<br><br>";
    	 
    	$mailContent= "An Invoice has been raised  against Truck No ".$truck." Destination is :".$destination." Customer : ".$customer_name." Invoice Date :".$invoice_date."<br>";
    	 
    	$mailContent= "Thank You,<br>";
    	$mailContent= "Transworld";
        
        
        if($customer_email!="")
    	{
	    	$message = new YiiMailMessage;
	    	//$message->view = 'emailTemp';
	    	$message->setBody($mailContent, 'text/html');
	    	$message->subject = 'TransWorld';
	    	$message->from = "sonauae.bluesky@gmail.com";
	    	$message->addTo($customer_email);
	    	Yii::app()->mail->send($message);
	    	echo CJSON::encode(array(
	    			'status' => 'success'
	    	));
    	}
    	else
    	{
    		echo CJSON::encode(array(
    				'status' => 'failed'
    		));
    	}
        Yii::app()->end();
    		
    	              

    }
    
    public function actionSendExitEmailToCustomer($id=0) {
    
    	$arr_exit_invoice_details = ExitInvoice::model()->with('truck','customer')->findAll(array('condition'=>"t.id=".$id));
    	 
    	 
    	$SQL=" SELECT  exitinv.id AS invoice_id,invoice_date,customer_name,email,destination,
							(SELECT GROUP_CONCAT( truck.truck_no ) FROM crm_exit_invoice_truck_no AS truck) AS truck_no
							FROM `crm_exit_invoice` AS exitinv
							INNER JOIN crm_customer AS customer ON exitinv.customer_id=customer.id WHERE exitinv.id=".$id." GROUP BY exitinv.id ";
    	 
    	$arr_exit_invoice_details = Yii::app()->db->createCommand($SQL)->queryAll();
    	 
    	 
    	$customer_name	= $arr_exit_invoice_details[0]['customer_name'];
    	$invoice_date	= $arr_exit_invoice_details[0]['invoice_date'];
    	$destination	= $arr_exit_invoice_details[0]['destination'];
    	$truck			= $arr_exit_invoice_details[0]['truck'];
    	$customer_email = $arr_exit_invoice_details[0]['email'];
    	 
    	/* $mailContent['body'] = "Hi,<br><br>";
    	  
    	$mailContent['body'].= "An Invoice has been raised  against Truck No ".$truck." Destination is :".$destination." Customer : ".$customer_name." Invoice Date :".$invoice_date."<br>";
    	 
    	$mailContent['body'].= "Thank You,<br>";
    	$mailContent['body'].= "Transworld"; */
    	 
    	$mailContent = "Hi,<br><br>";
    
    	$mailContent= "An Invoice has been raised  against Truck No ".$truck." Destination is :".$destination." Customer : ".$customer_name." Invoice Date :".$invoice_date."<br>";
    
    	$mailContent= "Thank You,<br>";
    	$mailContent= "Transworld";
    
    
    	if($customer_email!="")
    	{
	    	$message = new YiiMailMessage;
	    	//$message->view = 'emailTemp';
	    	$message->setBody($mailContent, 'text/html');
	    	$message->subject = 'TransWorld';
	    	$message->from = "sonauae.bluesky@gmail.com";
	    	$message->addTo($customer_email);
	    	Yii::app()->mail->send($message);
	    	echo CJSON::encode(array(
	    			'status' => 'success'
	    	));
    	}
    	else 
    	{
    		echo CJSON::encode(array(
    				'status' => 'failed'
    		));
    	}
    
    	Yii::app()->end();
    
    }
    public function actionSaveUrl() {
        if (isset($_POST['MasUrl'])) {
            $id = $_POST['MasUrl']['id'];
            if($id >0) {
    	    	$model = MasUrl::model()->findByPk($id);
            }else{
    	    	$model = new MasUrl;
            }
            $model->attributes = $_POST['MasUrl'];
            if ($model->validate()) {
                  $model->save();
                  $jsonData['status'] = 'success';
                    echo CJSON::encode($jsonData);
            } else {
                    $error = CActiveForm::validate($model, '', false);
                    if ($error != '[]')
                        echo $error;
                }
         }     
          Yii::app()->end();
    }
    public function actionSaveFile() {
        if (isset($_POST['MasFile'])) {
            $id = $_POST['MasFile']['id'];
            if($id >0) {
    	    	$model = MasFile::model()->findByPk($id);
            }else{
    	    	$model = new MasFile;
            }
            $model->attributes = $_POST['MasFile'];
            $model->remarks= $_POST['MasFile']['remarks'];
            if ($model->validate()) {
                  $model->save();
                  $jsonData['status'] = 'success';
                    echo CJSON::encode($jsonData);
            } else {
                    $error = CActiveForm::validate($model, '', false);
                    if ($error != '[]')
                        echo $error;
                }
         }     
          Yii::app()->end();
    }
    public function actionSaveAdvance() {
        if (isset($_POST['Advance'])) {
            $id = $_POST['Advance']['id'];
            if($id >0) {
    	    	$model = Advance::model()->findByPk($id);
            }else{
    	    	$model = new Advance;
            }
            $model->attributes = $_POST['Advance'];
            $model->remarks= $_POST['Advance']['remarks'];
            if ($model->validate()) {
                  $model->save();
                  $jsonData['status'] = 'success';
                    echo CJSON::encode($jsonData);
            } else {
                    $error = CActiveForm::validate($model, '', false);
                    if ($error != '[]')
                        echo $error;
                }
         }     
          Yii::app()->end();
    }

}