<?php
class FinanceController extends Controller {
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','LoadReceiptAll','Menu' ,'Create','Getallreceipt','Receipt','SearchPaymntAccount','GetDescriptionAcc',
                    'Fetchcurrencydetails','SearchSubLedger','getDescriptionAcc1','LoadPaymentAll','Getallpayment','Payment',
                    'LedgerJournalPrint','JournalView','PaymentEdit','LoadJournalAll','Getalljournal','SimpleJournal','PostJournalSimple',
                    'SaveJournalSimple','JournalEdit','LoadDebitnoteAll','LoadCreditnoteAll','DebitnoteEdit','CreditnoteEdit','SimpleDebitnote','SimpleCreditnote','SaveDebitnoteSimple',
                    'SaveCreditnoteSimple','PostDebitnoteSimple','PostCreditnoteSimple','Getalldebitnote','Getallcreditnote','DeleteVoucher','PostVoucher','UnpostVoucher',
                    'Getallpostedvoucher','LoadPostedVoucherAll','Subledger','Subledgertype','Getsubledgertypelist','Createsubledgertype',
                    'Savesubledgertype','Savesubledger','Getsubledgerlist','PushAll','Createsubledger','Deletesubledger','Deletesubledgertype','Finsettings','Getsettings','Addaccount',
                    'Savefinsettings','PushAll','Createsubledgertype','Accounts','GetAccountList','Createaccount','SaveAccounts','SaveReceipt','SavePayment','Allocation','GetAllocationlist',
                    'AllocateVouchers','SavePaymentAllocation','GetPaymentAllocation1','GetPaymentAllocation','AllocationPrint','UnallocTransaction',
                    'Bankreconciliation','Searchreconciliation','Updatereconciliation','Bankreconciliationhistory','Searchreconciliationhistory','Fetchparentfeatures','PreYearClosing',
                    'SavePreAuditClose','FinalYearClosing','Getallclosedyears','Finalauditclose','DeleteYear','SaveFinalYearClosing','TrialBalSort','FetChchild','EditSortOrder','SaveSortOrder',
                    'Outstandinginvoices','Getoutstandinginvoicelist','Addoutstandinginvoice','Getallcustomersandvendors','Saveoutstandingreceipt','Syncinvoices','Accountswithsub'
                    ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }
    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
    public function actionIndex() {
        $customer_id = $_GET['customer_id'];
        $this->render('index', array('customer_id' => $customer_id));
    }
        public function actionLoadReceiptAll()
        {
        $this->render('receipt_list');
        }
        public function actionLoadPaymentAll()
        {
        $this->render('payment_list');
        }
         public function actionFinsettings()
        {
        $this->render('fin_settings');
        }
        public function actionLoadDebitnoteAll()
        {
        $this->render('debitnote_list');
        }
                public function actionLoadCreditnoteAll()
        {
        $this->render('creditnote_list');
        }
                public function actionLoadJournalAll()
        {
        $this->render('journal_list');
        }
        public function actionAllocation()
        {
        $this->render('allocation_list');
        }
        public function actionAllocateVouchers() {
            $vid=Yii::app()->request->getparam('v_no');
            $type=Yii::app()->request->getparam('type');
            Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
            $this->renderPartial('allocate_vouchers', array('v_no' => $vid,'type' =>  $type), false, true);
        }
        public function actionLoadPostedVoucherAll()
        {
        $this->render('posted_voucher_list');
        }
         public function actionMenu()
        {
        $this->render('menu');
        }
         public function actionAddaccount()
        {
            $model=new FinSettings();
            $id = (int) Yii::app()->request->getParam('id');
            if($id>0){
                $model=$model->findByPk($id);
            }
                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('fin_settings_form', array('model' => $model), false, false);
        }
    public function actionCreate() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('create');
    }
    public function actionGetallreceipt()
    {
                $model=new FinGeneralLedgerHead();
        $draw   = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
                // datatable column index  => database column name
                0=>'t.voucher_type',
                1 =>'t.voucher_date',
                2=> 't.narration',
                3=> 't.posted',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy      = $filterColumn." ".$filterOrder;
        $condition = 'voucher_type="R1"';
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
            $searchString = $_POST['search']['value'];
             $condition.=" AND (voucher_no LIKE '%".$searchString."%' OR comment like '%".$searchString."%' )";
        }
        $count = $model->count(array('condition'=>$condition));
        $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'t.id desc'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
                
        foreach ($model as $i=>$row)
        {
        $modelItem=FinGeneralLedger::model()->find(array('condition'=>'form_ref_no='.$row->id.' AND credit>0','order'=>'credit DESC'));                 
         $div = '';
//                            if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["quotes_view"])){ 
        if($row['posted']=='N')
        {   
            if(isset(Yii::app()->user->havePermissionOn['fin_receipt_edit']) ||  Yii::app()->user->authorised_user == 1)
            {
                $div .= ' <button class="btn btn-primary btn-xs" title = "Edit voucher" onclick="loadPopupModal(\'finance/Receipt&id='.$row['id'].'\',\''.$row['voucher_type']."/".$row['voucher_no'].'\',\'lg\')"><i class="fa fa-edit"></i></button>';
            }            
        }
        if(isset(Yii::app()->user->havePermissionOn['fin_receipt_view']) ||  Yii::app()->user->authorised_user == 1)
        {
            $div .= ' <button class="btn btn-primary btn-xs" title = "View voucher" onclick="loadPopupModal(\'finance/JournalView&id='.$row['id'].'\',\''.$row['voucher_type']."/".$row['voucher_no'].'\',\'lg\')"><i class="fa fa-eye"></i></button>';
        }

        if($row['posted']=='N')
         {
            if(isset(Yii::app()->user->havePermissionOn['fin_receipt_delete']) ||  Yii::app()->user->authorised_user == 1)
            {
                $div .= ' <button class="btn btn-danger btn-xs" title = "Delete Voucher" onclick="deletefinvoucher('.$row['id'].',\'LoadReceiptAll\')"><i class="fa fa-trash"></i></button>';
            }            
         } 
         if($row['posted']=='N')
         {
            if(isset(Yii::app()->user->havePermissionOn['fin_receipt_post']) ||  Yii::app()->user->authorised_user == 1)
            {
                $div .= ' <button class="btn btn-primary btn-xs" title ="Post Voucher" onclick="postfinvoucher('.$row['id'].',\'LoadReceiptAll\')"><i class="fa fa-send"></i></button>';
            }            
         } 
         if($row['posted']=='Y')
         {
            if(isset(Yii::app()->user->havePermissionOn['fin_receipt_unpost']) ||  Yii::app()->user->authorised_user == 1)
            {
                $div .= ' <button class="btn btn-primary btn-xs" title = "Unpost voucher"  onclick="unpostfinvoucher('.$row['id'].',\'LoadReceiptAll\')"><i class="fa fa-remove"></i></button>';
            }         
         }
            if(isset(Yii::app()->user->havePermissionOn['fin_receipt_print']) ||  Yii::app()->user->authorised_user == 1)
            {
                $div .= ' <a class="btn btn-primary btn-xs" title="Print Voucher" target="_blank" href="index.php?r=finance/LedgerJournalPrint&id=' . $row['id'] .' "><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';
            }

        $rowData[]=array(($i+1),$row['voucher_type'].'/'.$row['voucher_no'],date("d/m/Y",strtotime($row['voucher_date'])),$modelItem->account->description,$modelItem->sub->description,$row['comment'],$row['value'],$row['posted'],'<div class="btn-wrap text-center">'.$div.'</div>');

                      }
        $data['data'] = $rowData;
        echo json_encode($data);
        }
        public function actionGetalljournal()
    {
        $model=new FinGeneralLedgerHead();
        $draw   = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
                // datatable column index  => database column name
                0=>'t.voucher_type',
                1 =>'t.voucher_date',
                2=> 't.narration',
                3=> 't.posted',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy      = $filterColumn." ".$filterOrder;
        $condition = 'voucher_type="J1"';
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
            $searchString = $_POST['search']['value'];
            $condition.=" AND (voucher_no LIKE '%".$searchString."%' OR comment like '%".$searchString."%' )";
        }
        $count = $model->count(array('condition'=>$condition));
        $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'t.id desc'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
                
        foreach ($model as $i=>$row)
        {                 
            
                            $accounts = '';
                            $ledgerAccounts = FinGeneralLedger::model()->findAll(array('condition' => 'form_ref_no = '.$row->id.' '));
                            $data = array_map(function($obj) {return $obj->account->description; },$ledgerAccounts);
                            $accounts = implode(',', $data);
                            $div = '';
                            if($row['posted']=='N')
                            {
                                if(isset(Yii::app()->user->havePermissionOn['fin_journal_edit']) ||  Yii::app()->user->authorised_user == 1)
                                {       
                                    $div .= ' <button class="btn btn-primary btn-xs" title="Edit Journal" onclick="loadPopupModal(\'finance/JournalEdit&id='.$row['id'].'\',\''.$row['voucher_type']."/".$row['voucher_no'].'\',\'xl\')"><i class="fa fa-edit"></i></button>';
                                }                                
                            }
                            if(isset(Yii::app()->user->havePermissionOn['fin_journal_view']) ||  Yii::app()->user->authorised_user == 1)
                            {       
                                $div .= ' <button class="btn btn-primary btn-xs" title="View Journal"  onclick="loadPopupModal(\'finance/JournalView&id='.$row['id'].'\',\''.$row['voucher_type']."/".$row['voucher_no'].'\',\'lg\')"><i class="fa fa-eye"></i></button>';
                            }
                            if($row['posted']=='N')
                            {
                                if(isset(Yii::app()->user->havePermissionOn['fin_journal_delete']) ||  Yii::app()->user->authorised_user == 1)
                                {       
                                    $div .= ' <button class="btn btn-danger btn-xs" title="Delete Journal"  onclick="deletefinvoucher('.$row['id'].',\'LoadJournalAll\')"><i class="fa fa-trash"></i></button>';
                                }
                            } 
                            if($row['posted']=='N')
                            {
                                if(isset(Yii::app()->user->havePermissionOn['fin_journal_post']) ||  Yii::app()->user->authorised_user == 1)
                                {       
                                    $div .= ' <button class="btn btn-primary btn-xs" title="Post Journal" onclick="postfinvoucher('.$row['id'].',\'LoadJournalAll\')"><i class="fa fa-send"></i></button>';
                            
                                }
                            }
                            if($row['posted']=='Y')
                            {
                                if(isset(Yii::app()->user->havePermissionOn['fin_journal_unpost']) ||  Yii::app()->user->authorised_user == 1)
                                {       
                                   $div .= ' <button class="btn btn-primary btn-xs" title="Unpost Journal" onclick="unpostfinvoucher('.$row['id'].',\'LoadJournalAll\')"><i class="fa fa-remove"></i></button>';
                                }
                            }
                            if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["fin_journal_print"])){ 
                                $div .= ' <a class="btn btn-primary btn-xs" title="Print Voucher" target="_blank" href="index.php?r=finance/LedgerJournalPrint&id=' . $row['id'] .' "><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';
                            }
                            
                            $rowData[]=array(($i+1),$row['voucher_type'].'/'.$row['voucher_no'],date("d/m/Y",strtotime($row['voucher_date'])),$row['comment'],$accounts,$row['value'],$row['posted'],'<div class="btn-wrap text-center">'.$div.'</div>');
                        
                      }
        $data['data'] = $rowData;
        echo json_encode($data);
        }
                public function actionGetalldebitnote()
    {
                $model=new FinGeneralLedgerHead();
        $draw   = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
                // datatable column index  => database column name
                0=>'t.voucher_type',
                1 =>'t.voucher_date',
                2=> 't.narration',
                3=> 't.posted',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy      = $filterColumn." ".$filterOrder;
        $condition = 'voucher_type="DB"';
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
            $searchString = $_POST['search']['value'];
             $condition.=" AND (voucher_no LIKE '%".$searchString."%' OR comment like '%".$searchString."%' )";
        }
        $count = $model->count(array('condition'=>$condition));
        $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'t.id desc'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
                
        foreach ($model as $i=>$row)
        {                 
                             $div = ''; 
                             if($row['posted']=='N')
                             {
                                if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["fin_debitvoucher_edit"])){ 
                                    $div .= '<button class="btn btn-primary btn-xs" title="Edit DebitNote" onclick="loadPopupModal(\'finance/DebitnoteEdit&id='.$row['id'].'\',\''.$row['voucher_type']."/".$row['voucher_no'].'\',\'xl\')"><i class="fa fa-edit"></i></button>';
                                }                                
                             }   
                                if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["fin_debitvoucher_view"])){ 
                                    $div .= ' <button class="btn btn-primary btn-xs" title="View DebitNote" onclick="loadPopupModal(\'finance/JournalView&id='.$row['id'].'\',\''.$row['voucher_type']."/".$row['voucher_no'].'\',\'lg\')"><i class="fa fa-eye"></i></button>';
                                }
                             if($row['posted']=='N')
                             {
                                if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["fin_debitvoucher_delete"])){ 
                                    $div .= ' <button class="btn btn-danger btn-xs" title="Delete DebitNote" onclick="deletefinvoucher('.$row['id'].',\'LoadDebitnoteAll\')"><i class="fa fa-trash"></i></button>';
                                }                                
                             } 
                             if($row['posted']=='N')
                             {
                                if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["fin_debitvoucher_post"])){ 
                                    $div .= ' <button class="btn btn-primary btn-xs" title="Post DebitNote" onclick="postfinvoucher('.$row['id'].',\'LoadDebitnoteAll\')"><i class="fa fa-send"></i></button>';
                                }                                
                             }
                             if($row['posted']=='Y')
                             {
                                if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["fin_debitvoucher_unpost"])){ 
                                    $div .= ' <button class="btn btn-primary btn-xs" title="Unpost DebitNote" onclick="unpostfinvoucher('.$row['id'].',\'LoadDebitnoteAll\')"><i class="fa fa-remove"></i></button>';
                                }                                
                             }
                                if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["fin_debitvoucher_print"])){ 
                                    $div .= ' <a class="btn btn-primary btn-xs" title="Print DebitNote" target="_blank" href="index.php?r=finance/LedgerJournalPrint&id=' . $row['id'] .' "><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';
                                }
                            
                            $rowData[]=array(($i+1),$row['voucher_type'].'/'.$row['voucher_no'],date("d/m/Y",strtotime($row['voucher_date'])),$row['comment'],$row['amount'],$row['posted'],'<div class="btn-wrap text-center">'.$div.'</div>');
                        
                      }
        $data['data'] = $rowData;
        echo json_encode($data);
        }
                public function actionGetallcreditnote()
    {
                $model=new FinGeneralLedgerHead();
        $draw   = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
                // datatable column index  => database column name
                0=>'t.voucher_type',
                1 =>'t.voucher_date',
                2=> 't.narration',
                3=> 't.posted',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy      = $filterColumn." ".$filterOrder;
        $condition = 'voucher_type="CR"';
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
            $searchString = $_POST['search']['value'];
             $condition.=" AND (voucher_no LIKE '%".$searchString."%' OR comment like '%".$searchString."%' )";
        }
        $count = $model->count(array('condition'=>$condition));
        $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'t.id desc'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
                
        foreach ($model as $i=>$row)
        {                 
                             $div = '';
//                            if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["quotes_view"])){ 
                             if($row['posted']=='N')
                             {
                                if(isset(Yii::app()->user->havePermissionOn['fin_creditvoucher_edit']) ||  Yii::app()->user->authorised_user == 1)
                                {
                                    $div .= ' <button class="btn btn-primary btn-xs" title="Edit CrediNote" onclick="loadPopupModal(\'finance/CreditnoteEdit&id='.$row['id'].'\',\''.$row['voucher_type']."/".$row['voucher_no'].'\',\'xl\')"><i class="fa fa-edit"></i></button>';
                                }                                    
                             } 
                                if(isset(Yii::app()->user->havePermissionOn['fin_creditvoucher_view']) ||  Yii::app()->user->authorised_user == 1)
                                {
                                    $div .= ' <button class="btn btn-primary btn-xs" title="View CrediNote" onclick="loadPopupModal(\'finance/JournalView&id='.$row['id'].'\',\''.$row['voucher_type']."/".$row['voucher_no'].'\',\'lg\')"><i class="fa fa-eye"></i></button>';
                                }
//                            if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["quotes_pdf"])){ 
                               if($row['posted']=='N')
                             {
                                if(isset(Yii::app()->user->havePermissionOn['fin_creditvoucher_delete']) ||  Yii::app()->user->authorised_user == 1)
                                {
                                    $div .= ' <button class="btn btn-danger btn-xs" title="Delete CrediNote" onclick="deletefinvoucher('.$row['id'].',\'LoadCreditnoteAll\')"><i class="fa fa-trash"></i></button>';
                                }                                
                             } 
                             if($row['posted']=='N')
                             {
                                if(isset(Yii::app()->user->havePermissionOn['fin_creditvoucher_post']) ||  Yii::app()->user->authorised_user == 1)
                                {
                                    $div .= ' <button class="btn btn-primary btn-xs" title="Post CrediNote" onclick="postfinvoucher('.$row['id'].',\'LoadCreditnoteAll\')"><i class="fa fa-send"></i></button>';
                                }                                
                             }
                             if($row['posted']=='Y')
                             {
                                if(isset(Yii::app()->user->havePermissionOn['fin_creditvoucher_unpost']) ||  Yii::app()->user->authorised_user == 1)
                                {
                                    $div .= ' <button class="btn btn-primary btn-xs" title="Unpost CrediNote" onclick="unpostfinvoucher('.$row['id'].',\'LoadCreditnoteAll\')"><i class="fa fa-remove"></i></button>';
                                }                                
                             }
                                if(isset(Yii::app()->user->havePermissionOn['fin_creditvoucher_print']) ||  Yii::app()->user->authorised_user == 1)
                                {
                                    $div .= ' <a class="btn btn-primary btn-xs" title="Print Creditnote" target="_blank" href="index.php?r=finance/LedgerJournalPrint&id=' . $row['id'] .' "><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';
                                }
                            
                            $rowData[]=array(($i+1),$row['voucher_type'].'/'.$row['voucher_no'],date("d/m/Y",strtotime($row['voucher_date'])),$row['comment'],$row['amount'],$row['posted'],'<div class="btn-wrap text-center">'.$div.'</div>');
                        
                      }
        $data['data'] = $rowData;
        echo json_encode($data);
        }
        public function actionGetallpayment()    
        {
        $model=new FinGeneralLedgerHead();
        $draw   = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
                // datatable column index  => database column name
                0=>'t.voucher_type',
                1 =>'t.voucher_date',
                2=> 't.narration',
                3=> 't.posted',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy      = $filterColumn." ".$filterOrder;
        $condition = 'voucher_type="P1"';
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
            $searchString = $_POST['search']['value'];
            $condition.=" AND (voucher_no LIKE '%".$searchString."%' OR comment like '%".$searchString."%' )";
        }
        $count = $model->count(array('condition'=>$condition));
        $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'t.id desc'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
              
        foreach ($model as $i=>$row)
        {
            $modelItem=FinGeneralLedger::model()->find(array('condition'=>'form_ref_no='.$row->id.' AND debit>0','order'=>'debit DESC'));                 
            $div = '';
   //                            if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["quotes_view"])){ 
            if($row['posted']=='N')
            {
                if(isset(Yii::app()->user->havePermissionOn['fin_payment_edit']) ||  Yii::app()->user->authorised_user == 1)
                {
                   $div .= '<button class="btn btn-primary btn-xs" title="Edit Voucher" onclick="loadPopupModal(\'finance/Payment&id='.$row['id'].'\',\''.$row['voucher_type']."/".$row['voucher_no'].'\',\'lg\')"><i class="fa fa-edit"></i></button>';
                }
            }   
            if(isset(Yii::app()->user->havePermissionOn['fin_payment_view']) ||  Yii::app()->user->authorised_user == 1)
            {
               $div .= ' <button class="btn btn-primary btn-xs"  title="View Voucher"  onclick="loadPopupModal(\'finance/JournalView&id='.$row['id'].'\',\''.$row['voucher_type']."/".$row['voucher_no'].'\',\'lg\')"><i class="fa fa-eye"></i></button>';
            } 
        if($row['posted']=='N')
        {
            if(isset(Yii::app()->user->havePermissionOn['fin_payment_delete']) ||  Yii::app()->user->authorised_user == 1)
            {
               $div .= ' <button class="btn btn-danger btn-xs"  title="Delete Voucher"  onclick="deletefinvoucher('.$row['id'].',\'LoadPaymentAll\')"><i class="fa fa-trash"></i></button>';
        
            }   
        } 
        if($row['posted']=='N')
        {
            if(isset(Yii::app()->user->havePermissionOn['fin_payment_post']) ||  Yii::app()->user->authorised_user == 1)
            {
               $div .= ' <button class="btn btn-primary btn-xs"  title="Post Voucher"  onclick="postfinvoucher('.$row['id'].',\'LoadPaymentAll\')"><i class="fa fa-send"></i></button>';
            }            
        }
        if($row['posted']=='Y')
        {
            if(isset(Yii::app()->user->havePermissionOn['fin_payment_unpost']) ||  Yii::app()->user->authorised_user == 1)
            {
               $div .= ' <button class="btn btn-primary btn-xs"  title="Unpost Voucher"  onclick="unpostfinvoucher('.$row['id'].',\'LoadPaymentAll\')"><i class="fa fa-remove"></i></button>';
            }           
        }  
        if(isset(Yii::app()->user->havePermissionOn['fin_payment_print']) ||  Yii::app()->user->authorised_user == 1)
        {
           $div .= ' <a class="btn btn-primary btn-xs" title="Print Voucher" target="_blank" href="index.php?r=finance/LedgerJournalPrint&id=' . $row['id'] .' "><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';
        }

                            $rowData[]=array(($i+1),$row['voucher_type'].'/'.$row['voucher_no'],date("d/m/Y",strtotime($row['voucher_date'])),$modelItem->account->description,$modelItem->sub->description,$row['comment'],$row['value'],$row['posted'],'<div class="btn-wrap text-center">'.$div.'</div>');
                        
                      }
        $data['data'] = $rowData;
        echo json_encode($data);
        }
       
        public function actionJournalEdit() {
        $id=Yii::app()->request->getParam('id');
        $model = FinGeneralLedgerHead::model()->findByPk($id);
        $modelFinGeneralLedger=FinGeneralLedger::model()->findAll(array('condition'=>'form_ref_no='.$id));
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('_edit_journal', array('model' => $model,'modelFinGeneralLedger'=>$modelFinGeneralLedger), false, true);
        }
        public function actionDebitnoteEdit() {
        $id=Yii::app()->request->getParam('id');
        $model = FinGeneralLedgerHead::model()->findByPk($id);
        $modelFinGeneralLedger=FinGeneralLedger::model()->findAll(array('condition'=>'form_ref_no='.$id));
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('_edit_debitnote', array('model' => $model,'modelFinGeneralLedger'=>$modelFinGeneralLedger), false, true);
        }
        public function actionCreditnoteEdit() {
        $id=Yii::app()->request->getParam('id');
        $model = FinGeneralLedgerHead::model()->findByPk($id);
        $modelFinGeneralLedger=FinGeneralLedger::model()->findAll(array('condition'=>'form_ref_no='.$id));
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('_edit_creditnote', array('model' => $model,'modelFinGeneralLedger'=>$modelFinGeneralLedger), false, true);
        }
            public function actionPaymentEdit() {
        $id=Yii::app()->request->getParam('id');
        $model = FinGeneralLedgerHead::model()->findByPk($id);

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('_edit_payments', array('model' => $model), false, true);
        }
        public function actionReceipt(){
            /**
             * Author Jo~
             * Receipt Create Function
             */
            
            $id = (int) Yii::app()->request->getparam("id");  
            $type = Yii::app()->request->getparam("type");  
            $invoice = (int) Yii::app()->request->getparam("invoice");  

            $modelCredit = new FinGeneralLedger;
            $modelDebit =  new FinGeneralLedger;
            $modelBank =  new FinGeneralLedger;
            $modelDiscount =  new FinGeneralLedger;
            $modelVat = new FinGeneralLedger;
            if( $invoice > 0 ){

                $invoiceModel = ( $type == 'EN' ) ? new EntryInvoice  : new ExitInvoice ;
                $invoiceModel =  $invoiceModel::model()->findBypk( $invoice );
                $subledgerModel = Subledger::model()->find( array( 'condition' => 'respect_id='.$invoiceModel->customer_id ) );
                $modelCredit->subledger = $subledgerModel->id;
                $subledgerName = $subledgerModel->description;
                $modelCredit->account_id = FinSettings::getAccount(99998);
                $modelCredit->credit = $invoiceModel->grand_total;
                $invoiceVat = $invoiceModel->total_vat_amount;
            }
            if($id > 0){
                $modelCredit = FinGeneralLedger::model()->find(array('condition' => 'form_ref_no='.$id.' AND credit > 0','order' => 'id ASC'));
                $modelDebit = FinGeneralLedger::model()->find(array('condition' => 'form_ref_no='.$id.' AND debit > 0','order' => 'id DESC'));
                $modelBank =  FinGeneralLedger::model()->find(array('condition' => 'form_ref_no='.$id.' AND description = "BT"'));
                $modelDiscount =  FinGeneralLedger::model()->find(array('condition' => 'form_ref_no='.$id.' AND description = "DS"'));
                $modelVat =  FinGeneralLedger::model()->find(array('condition' => 'form_ref_no='.$id.' AND description = "VAT"'));
            }
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
            $this->render('create_receipt', array('modelCredit' => $modelCredit,'modelDebit' => $modelDebit,'modelBank' => $modelBank , 'modelDiscount' => $modelDiscount, 'modelVat' => $modelVat , 'id' => $id, 'subledgerName' => $subledgerName, 'invoice' => $invoice, 'type' => $type, 'invoiceVat' => $invoiceVat ), false, true);
    
        }
    public function actionPayment(){
        /**
        * Author Jo~
        * Payment Create Function
        */

        $id=Yii::app()->request->getparam("id");  
        $modelCredit = new FinGeneralLedger;
        $modelDebit =  new FinGeneralLedger;
        $modelBank =  new FinGeneralLedger;
        $modelDiscount =  new FinGeneralLedger;
        $modelVat =  new FinGeneralLedger;
        if($id > 0){
            $modelCredit = FinGeneralLedger::model()->find(array('condition' => 'form_ref_no='.$id.' AND credit > 0','order' => 'id DESC'));
            $modelDebit = FinGeneralLedger::model()->find(array('condition' => 'form_ref_no='.$id.' AND debit > 0','order' => 'id ASC'));
            $modelBank =  FinGeneralLedger::model()->find(array('condition' => 'form_ref_no='.$id.' AND description = "BT"'));
            $modelDiscount = FinGeneralLedger::model()->find(array('condition' => 'form_ref_no='.$id.' AND description = "DS"'));  
            $modelVat =  FinGeneralLedger::model()->find(array('condition' => 'form_ref_no='.$id.' AND description = "VAT"'));
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('create_payment', array('modelCredit' => $modelCredit,'modelDebit' => $modelDebit,'modelBank' => $modelBank , 'modelDiscount' => $modelDiscount, 'modelVat' => $modelVat,'id' => $id), false, true);
    
    }
    public function actionSearchPaymntAccount()
    {
    	$selectedType = $_GET['type'];
    	$searchTerm = $_GET['term'];
        $condition="";
        $order ="description";
        $condition= 'isParent="N" AND (description LIKE "%' . $searchTerm . '%" OR account_no LIKE "%' . $searchTerm . '%")';
        $model = new FinAccounts();
    	$model = $model->findAll(array('select'=>'id,account_no,description','condition' => $condition, 'order' => $order));
    	$i = 0;
    	foreach ($model as $eachModel) {
    		$data[$i]['value'] = $eachModel->id;

    		$data[$i]['label'] = $eachModel->account_no." : ".$eachModel->description;
    		$i++;
    	}
    	echo CJSON::encode($data);
    	Yii::app()->end();
    }
    public function actionAccountswithsub()
    {
    	$selectedType = $_GET['type'];
    	$searchTerm = $_GET['term'];
        $condition="";
        $order ="description";
        $condition= 'has_subledger="Y" AND (description LIKE "%' . $searchTerm . '%" OR account_no LIKE "%' . $searchTerm . '%")';
        $model = new FinAccounts();
    	$model = $model->findAll(array('select'=>'id,account_no,description','condition' => $condition, 'order' => $order));
    	$i = 0;
    	foreach ($model as $eachModel) {
    		$data[$i]['value'] = $eachModel->id;

    		$data[$i]['label'] = $eachModel->account_no." : ".$eachModel->description;
    		$i++;
    	}
    	echo CJSON::encode($data);
    	Yii::app()->end();
    }
            public function actionGetDescriptionAcc() {

        $account_id = Yii::app()->request->getParam('id');
         $i = Yii::app()->request->getParam('i');
        $modelFinAccounts = FinAccounts::model()->findByPK($account_id);
        if ($modelFinAccounts->cash_bank_type== 1){
                $jsonData['bank'] = "Y";
        } else{
                $jsonData['bank'] = "N";
        }
          $jsonData['account'] = FinAccounts::model()->findByPK($account_id);
        $model = new FinGeneralLedger;
        if($modelFinAccounts->has_subledger=="N")
        {
         $sub=CHtml::activeTextField($model,"[" . $i . "]subledger", array(
                         'disabled' => true,
                        'placeholder' => 'No Subledger',
                        'class' => 'tooltipster subledger'
                    ));
       $sub.=CHtml::activeHiddenField($model, "[$i]havesubledger",array("value"=>0));
        $jsonData['subledger']=$sub;

        }
        else {
         $sub= CHtml::activetextField($model, "[" . $i . "]subledger", array(
                            		'placeholder' => 'Type & Select', 'class' => 'tooltipster subledger','onKeyup' => 'js:autoCompleteSubLedger(this.id,"journal",1);', 'title' => 'Select Subledger',

                            ));
        $sub.=CHtml::activeHiddenField($model, "[$i]havesubledger",array("value"=>1));
        $jsonData['subledger']=$sub;
        }

        echo (CJSON::encode($jsonData));
        Yii::app()->end();
    }
    
    public function actionSearchSubLedger()
    {
    	//$from = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $acc_id = $_GET['ac_id'];
        $condition = '';
        // if($acc_id > 0)
        //     $condition .= 'stype.account_id ='.$acc_id.' AND ';
        $condition .= '(t.description LIKE "%' . $searchTerm . '%" OR t.account_no LIKE "%' . $searchTerm . '%")';
       

    	$model = new Subledger();
    	$model = $model->with('stype')->findAll(array('select'=>'t.id,t.description,t.account_no','condition' => $condition, 'order' => 't.description', 'limit' => 200));

    	$i = 0;
    	$data = array();
    	foreach ($model as $eachModel) {
    		$data[$i]['value'] = $eachModel->id;
                $data[$i]['label'] = $eachModel->account_no." : ".$eachModel->description;
    		$i++;
    	}
    	echo CJSON::encode($data);
    	Yii::app()->end();
    }
              public function actiongetDescriptionAcc1() {

        $account_id = Yii::app()->request->getParam('id');
         $i = Yii::app()->request->getParam('i');
        $modelFinAccounts = FinAccounts::model()->findByPK($account_id);
        if ($modelFinAccounts->cash_bank_type== 1){
                $jsonData['bank'] = "Y";
        } else{
                $jsonData['bank'] = "N";
        }
          $jsonData['account'] = FinAccounts::model()->findByPK($account_id);
         $modelFinGeneralLedger = FinGeneralLedger::model()->findAll(array('condition' => 'account_id=' . $account_id));
        foreach ($modelFinGeneralLedger as $eachItem) {
            $creditTotal = $creditTotal + $eachItem->credit;
            $debitTotal = $debitTotal + $eachItem->debit;
        }
        if ($modelFinAccounts->credit_type == 1) {
            $creditBalanceTotal = $creditTotal - $debitTotal;
        } else if ($modelFinAccounts->credit_type == 2) {
            $debitBalanceTotal = $debitTotal - $creditTotal;
        }
        if (strpos($creditBalanceTotal, '.') === false) {
            $creditBalanceTotal = $creditBalanceTotal . ".00";
        }
        if (strpos($debitBalanceTotal, '.') === false) {
            $debitBalanceTotal = $debitBalanceTotal . ".00";
        }
        $jsonData['creditTotal'] = $creditBalanceTotal;
        $jsonData['debitTotal'] = $debitBalanceTotal;
        $model = new FinGeneralLedger;
        if($modelFinAccounts->has_subledger=="N")
        {
          $jsonData['subledger']=  CHtml::textField("subledger_new", "", array(
                                            'disabled' => true,
                                            'placeholder' => 'No Subledger',
                                            'class' => 'tooltipster subledger_new'

                            ));
        }
        else {
         $jsonData['subledger']=  CHtml::textField("subledger_new", "", array(
                            		'placeholder' => 'Type & Select', 'class' => 'tooltipster subledger_new','onKeyup' => 'js:autoCompleteSubLedger(this.id,"payment",2);', 'title' => 'Select Account',

                            ));

        }

        echo (CJSON::encode($jsonData));
        Yii::app()->end();
    }
 
        public function actionLedgerJournalPrint() {
        $id=Yii::app()->request->getparam('id');
        $model=FinGeneralLedgerHead::model()->findByPk($id);
        $modelVouchers=FinGeneralLedger::model()->findAll(array('condition'=>'form_ref_no="'.$model->id.'"','order'=>'debit DESC'));
        switch($model->voucher_type)
        {
            case 'EN':
                 $title="EN Voucher";
                $view='journal';
                break;
            case 'EX':
                 $title="EX Voucher";
                $view='journal';
                break;
                case 'SI':
                $title="SI Voucher";
               $view='journal';
               break;
           case 'DI':
                $title="DI Voucher";
               $view='journal';
               break;
           case 'CN':
                $title="CN Voucher";
               $view='journal';
               break;
           case 'PI':
                $title="PI Voucher";
               $view='journal';
               break;
           case 'DN':
                $title="DN Voucher";
               $view='journal';
               break;
           case 'CR':
                $title="Credit Note";
               $view='journal';
               break;
           case 'C':
               $title="Contra Voucher";
               $view='journal';
               break;
           case 'R1':
               $title="Receipt Voucher";
               $view='receipt';
               break;
           case 'J1':
               $title="Journal Voucher";
               $view='journal';
               break;
           case 'P1':
               $title="Payment Voucher";
               $view='payment';
               break;
            case 'DB':
               $title="Debit Note";
               $view='debit';
               break;
        }

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        //$mPDF1->SetWatermarkImage(Yii::app()->baseUrl . '/images/logo/200150_' . MasCompany::model()->findbyPK(Yii::app()->user->master_user_company_id)->company_logo);
        //$mPDF1->showWatermarkImage = true;
       // $mPDF1->watermarkImageAlpha = 0.09;
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_for_list.css');
        $mPDF1->WriteHTML($stylesheet, 1);

        $mPDF1->WriteHTML($this->renderPartial("application.views.front.pdf.$view", array('form_ref_no' => $id, 'title' => $title,'model'=>$model,'modelVouchers'=>$modelVouchers), true));
        $mPDF1->Output('Voucher.pdf', 'I');
    }
    public function actionJournalView()
    {
    $id=Yii::app()->request->getParam('id');
     Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
     $this->renderPartial('//finance/_view_journal', array('id'=>$id), false, true);
    }
    public function actionSimpleJournal() {
        $modelFinForm = FinForm::model()->findByPk(3);
        $jrefno = $modelFinForm->form_no + 1;
        $jvoucherno = "J1/" . $jrefno;
        $model1 = new FinGeneralLedger;
        $model = array(new FinGeneralLedger);
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('//finance/_journal', array('modelFinGeneralLedger' => $model, 'model1' => $model1, 'jrefno' => $jrefno, 'jvoucherno' => $jvoucherno), false, true);
    }
    public function actionSimpleDebitnote() {
        $modelFinForm = FinForm::model()->findByPk(12);
        $jrefno = $modelFinForm->form_no + 1;
        $jvoucherno = "DB/" . $jrefno;
        $model1 = new FinGeneralLedger;
        $model = array(new FinGeneralLedger);
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('//finance/_debitnote', array('modelFinGeneralLedger' => $model, 'model1' => $model1, 'jrefno' => $jrefno, 'jvoucherno' => $jvoucherno), false, true);
    }
    public function actionSimpleCreditnote() {
        $modelFinForm = FinForm::model()->findByPk(9);
        $jrefno = $modelFinForm->form_no + 1;
        $jvoucherno = "CN/" . $jrefno;
        $model1 = new FinGeneralLedger;
        $model = array(new FinGeneralLedger);
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('//finance/_creditnote', array('modelFinGeneralLedger' => $model, 'model1' => $model1, 'jrefno' => $jrefno, 'jvoucherno' => $jvoucherno), false, true);
    }
           public function actionSaveJournalSimple()
    {
             $model=new FinGeneralLedger;
                    $date = str_replace('/', '-', $_POST['voucher_date']);
                    $exchange_rate = $_POST['exchange_rate'];
                    $currency = $_POST['currency'];
                    $exact_total = 0;
                    $model->date = date("Y-m-d", strtotime($date));
                    if($model->date=='1970-01-01')
                    {
                    $model->date='';
                    }
                    if($_POST['voucher_no']=='')
                    {
                    $form=FinForm::model()->findByPk(3);
                    $no=$form->form_no+1;
                    $model->voucher_no='J1/'.$no;
                    }
                    else {
                    $model->voucher_no=$_POST['voucher_no'];
                    $no=str_replace("J1/","",$_POST['voucher_no']);    
                    }
                    $tot=0;
                    $tot1=0;
                    $valid='1=1';
                    foreach ($_POST['FinGeneralLedger'] as $i => $item) {
                    $modelFinGeneralLedger[$i] = new FinGeneralLedger;
//                    $modelFinGeneralLedger[$i]->attributes = $_POST['FinGeneralLedger'][$i];
                    $modelFinGeneralLedger[$i]->date = $model->date;
                    $modelFinGeneralLedger[$i]->voucher_no = $model->voucher_no;
                    if(isset($_POST['fin_givenname']))
                    {
                    	$modelFinGeneralLedger[$i]->given_name = $_POST['fin_givenname'];
                    }
                    $modelFinGeneralLedger[$i]->amt = 1;
                    $modelFinGeneralLedger[$i]->subledger = $_POST['FinGeneralLedger'][$i]['fin_subledger'];
                    $modelFinGeneralLedger[$i]->item_description = $_POST['FinGeneralLedger'][$i]['item_description'];
                    $modelFinGeneralLedger[$i]->narration = $_POST['narration'];
                    $modelFinGeneralLedger[$i]->credit = $_POST['FinGeneralLedger'][$i]['credit']  * $exchange_rate;
                    $modelFinGeneralLedger[$i]->cr_entered = $_POST['FinGeneralLedger'][$i]['credit'];
                    $modelFinGeneralLedger[$i]->debit = $_POST['FinGeneralLedger'][$i]['debit']  * $exchange_rate;
                    $modelFinGeneralLedger[$i]->db_entered = $_POST['FinGeneralLedger'][$i]['debit'];
                    $modelFinGeneralLedger[$i]->account_id = $_POST['FinGeneralLedger'][$i]['fin_account_id'];
                    $modelFinGeneralLedger[$i]->form_ref_no =  str_replace("/","",$model->voucher_no);
                    $modelFinGeneralLedger[$i]->item_no =  $_POST['FinGeneralLedger'][$i]['item_no'];
                    $modelFinGeneralLedger[$i]->item_type = $_POST['FinGeneralLedger'][$i]['item_type'];
                    $modelFinGeneralLedger[$i]->item_id = $_POST['FinGeneralLedger'][$i]['item_id'];
                    $modelFinGeneralLedger[$i]->cheque_date = '1111-11-11';
                    $modelFinGeneralLedger[$i]->chk_description = 'XXX';
                    $modelFinGeneralLedger[$i]->chk_no = 'XXX';
                    $modelFinGeneralLedger[$i]->currency =$currency;
                    $modelFinGeneralLedger[$i]->exchange_rate =$exchange_rate;
                    $modelFinGeneralLedger[$i]->form_id=3;
                    $modelFinGeneralLedger[$i]->credit_amt=1;
                    $modelFinGeneralLedger[$i]->cash_amt=1;
                    $modelFinGeneralLedger[$i]->card_no='XXX';
                    $modelFinGeneralLedger[$i]->auth_code='XXX';
                    $additions=$_POST['FinGeneralLedger'][$i]['credit']+$_POST['FinGeneralLedger'][$i]['debit'];
                    $deductions=$_POST['FinGeneralLedger'][$i]['credit']-$_POST['FinGeneralLedger'][$i]['debit'];
                    $total_add_ded=$additions-abs($deductions);
                    if($total_add_ded!=0)
                    {
                    $total_validate=1;
                    }
                    $tot+=$_POST['FinGeneralLedger'][$i]['credit'];
                    $tot1+=$_POST['FinGeneralLedger'][$i]['debit'];
                    $exact_total += $item['debit'];
                    $valid = $modelFinGeneralLedger[$i]->validate() && $valid;
        }
         $tot=Yii::app()->numberFormatter->formatCurrency($tot,'');
         $tot1=Yii::app()->numberFormatter->formatCurrency($tot1,'');
         
        
         if($model->date!='')
         {
         $year=date('Y', strtotime($model->date));
         $finyear=FinanceYearClose::model()->find(array('condition'=>'year='.$year));
         }
//         echo $finyear->year,$year;
         if(empty($finyear))
         {
                    if($tot == $tot1)
                    {
                    if($total_validate!=1)
                    {
                    if ($valid) {
                   
                 if($_POST['id']!='')
                    {
                    $head=FinGeneralLedgerHead::model()->findByPk($_POST['id']);
                    }
                    else {
                    $head=new FinGeneralLedgerHead;
                    }
                $head->voucher_no=$no;
                $head->voucher_date = $model->date;
                $head->comment = $_POST['narration'];
                $head->voucher_type='J1';
                $head->value = $exact_total;
                $head->user_id=Yii::app()->user->id;
                $head->save();
                FinGeneralLedger::model()->deleteAll(array('condition'=>'voucher_no="'.$head->voucher_type.'/'.$head->voucher_no.'"'));
                foreach ($modelFinGeneralLedger as $eachModel) {
                    $eachModel->form_ref_no=$head->id;
                    $eachModel->save(false);
                }
                $form=FinForm::model()->findByPk(3);
           $form->form_no=$form->form_no+1;
           $form->save();
                $jsonData['id']=$head->id;
           $jsonData['form_no']=$form->form_no;
           $jsonData['date']=date("d/m/Y");
           $jsonData['status'] = 'success';
           echo CJSON::encode($jsonData);
                    }
        else {
                $error = json_decode(CActiveForm::validateTabular($modelFinGeneralLedger, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error));
                if ($error != '[]')
                    echo $error;
            }
                    }
                    else {
                     $jsonData['status'] = 'Error in Entry';
                     echo CJSON::encode($jsonData);
                    }
                    }
                    else {
                       
                     $jsonData['status'] = 'Totals are not equal';
                     echo CJSON::encode($jsonData);
                    }
         }
         else {
         $jsonData['status'] = 'Year Closed';
                     echo CJSON::encode($jsonData);    
         }
    }
               public function actionSaveDebitnoteSimple()
    {
             $model=new FinGeneralLedger;
                    $date = str_replace('/', '-', $_POST['voucher_date']);
                    $exchange_rate = $_POST['exchange_rate'];
                    $currency = $_POST['currency'];
                    $model->date = date("Y-m-d", strtotime($date));
                    if($model->date=='1970-01-01')
                    {
                    $model->date='';
                    }
                    if($_POST['voucher_no']=='')
                    {
                    $form=FinForm::model()->findByPk(12);
                    $no=$form->form_no+1;
                    $model->voucher_no='DB/'.$no;
                    }
                    else {
                    $model->voucher_no=$_POST['voucher_no'];
                    $no=str_replace("DB/","",$_POST['voucher_no']);    
                    }
                    $tot=0;
                    $tot1=0;
                    $valid='1=1';
                    foreach ($_POST['FinGeneralLedger'] as $i => $item) {
                    $modelFinGeneralLedger[$i] = new FinGeneralLedger;
//                    $modelFinGeneralLedger[$i]->attributes = $_POST['FinGeneralLedger'][$i];
                    $modelFinGeneralLedger[$i]->date = $model->date;
                    $modelFinGeneralLedger[$i]->voucher_no = $model->voucher_no;
                    if(isset($_POST['fin_givenname']))
                    {
                    	$modelFinGeneralLedger[$i]->given_name = $_POST['fin_givenname'];
                    }
                    $modelFinGeneralLedger[$i]->amt = 1;
                    $modelFinGeneralLedger[$i]->subledger = $_POST['FinGeneralLedger'][$i]['fin_subledger'];
                    $modelFinGeneralLedger[$i]->item_description = $_POST['FinGeneralLedger'][$i]['item_description'];
                    $modelFinGeneralLedger[$i]->narration = $_POST['narration'];
                    $modelFinGeneralLedger[$i]->credit = $_POST['FinGeneralLedger'][$i]['credit']  * $exchange_rate;
                    $modelFinGeneralLedger[$i]->cr_entered = $_POST['FinGeneralLedger'][$i]['credit'];
                    $modelFinGeneralLedger[$i]->debit = $_POST['FinGeneralLedger'][$i]['debit']  * $exchange_rate;
                    $modelFinGeneralLedger[$i]->db_entered = $_POST['FinGeneralLedger'][$i]['debit'];
                    $modelFinGeneralLedger[$i]->account_id = $_POST['FinGeneralLedger'][$i]['fin_account_id'];
                    $modelFinGeneralLedger[$i]->form_ref_no =  str_replace("/","",$model->voucher_no);
                    $modelFinGeneralLedger[$i]->item_no =  $_POST['FinGeneralLedger'][$i]['item_no'];
                    $modelFinGeneralLedger[$i]->item_type = $_POST['FinGeneralLedger'][$i]['item_type'];
                    $modelFinGeneralLedger[$i]->item_id =  $_POST['FinGeneralLedger'][$i]['item_id'];
                    $modelFinGeneralLedger[$i]->cheque_date = '1111-11-11';
                    $modelFinGeneralLedger[$i]->chk_description = 'XXX';
                    $modelFinGeneralLedger[$i]->chk_no = 'XXX';
                    $modelFinGeneralLedger[$i]->currency =$currency;
                    $modelFinGeneralLedger[$i]->exchange_rate =$exchange_rate;
                    $modelFinGeneralLedger[$i]->form_id=12;
                    $modelFinGeneralLedger[$i]->credit_amt=1;
                    $modelFinGeneralLedger[$i]->cash_amt=1;
                    $modelFinGeneralLedger[$i]->card_no='XXX';
                    $modelFinGeneralLedger[$i]->auth_code='XXX';
                    $additions=$_POST['FinGeneralLedger'][$i]['credit']+$_POST['FinGeneralLedger'][$i]['debit'];
                    $deductions=$_POST['FinGeneralLedger'][$i]['credit']-$_POST['FinGeneralLedger'][$i]['debit'];
                    $total_add_ded=$additions-abs($deductions);
                    if($total_add_ded!=0)
                    {
                    $total_validate=1;
                    }
                    $tot+=$_POST['FinGeneralLedger'][$i]['credit'];
                    $tot1+=$_POST['FinGeneralLedger'][$i]['debit'];
                    $valid = $modelFinGeneralLedger[$i]->validate() && $valid;
        }
         $tot=Yii::app()->numberFormatter->formatCurrency($tot,'');
         $tot1=Yii::app()->numberFormatter->formatCurrency($tot1,'');
         
        
         if($model->date!='')
         {
         $year=date('Y', strtotime($model->date));
         $finyear=FinanceYearClose::model()->find(array('condition'=>'year='.$year));
         }
//         echo $finyear->year,$year;
         if(empty($finyear))
         {
                    if($tot == $tot1)
                    {
                    if($total_validate!=1)
                    {
                    if ($valid) {
                   
                 if($_POST['id']!='')
                    {
                    $head=FinGeneralLedgerHead::model()->findByPk($_POST['id']);
                    }
                    else {
                    $head=new FinGeneralLedgerHead;
                    }
                $head->voucher_no=$no;
                $head->voucher_date = $model->date;
                $head->comment = $_POST['narration'];
                $head->voucher_type='DB';
                $head->user_id=Yii::app()->user->id;
                $head->save();
                FinGeneralLedger::model()->deleteAll(array('condition'=>'voucher_no="'.$head->voucher_type.'/'.$head->voucher_no.'"'));
                foreach ($modelFinGeneralLedger as $eachModel) {
                    $eachModel->form_ref_no=$head->id;
                    $eachModel->save(false);
                }
                $form=FinForm::model()->findByPk(12);
           $form->form_no=$form->form_no+1;
           $form->save();
                $jsonData['id']=$head->id;
           $jsonData['form_no']=$form->form_no;
           $jsonData['date']=date("d/m/Y");
           $jsonData['status'] = 'success';
           echo CJSON::encode($jsonData);
                    }
        else {
                $error = json_decode(CActiveForm::validateTabular($modelFinGeneralLedger, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error));
                if ($error != '[]')
                    echo $error;
            }
                    }
                    else {
                     $jsonData['status'] = 'Error in Entry';
                     echo CJSON::encode($jsonData);
                    }
                    }
                    else {
                       
                     $jsonData['status'] = 'Totals are not equal';
                     echo CJSON::encode($jsonData);
                    }
         }
         else {
         $jsonData['status'] = 'Year Closed';
                     echo CJSON::encode($jsonData);    
         }
    }
               public function actionSaveCreditnoteSimple()
    {
             $model=new FinGeneralLedger;
                    $date = str_replace('/', '-', $_POST['voucher_date']);
                    $exchange_rate = $_POST['exchange_rate'];
                    $currency = $_POST['currency'];
                    $model->date = date("Y-m-d", strtotime($date));
                    if($model->date=='1970-01-01')
                    {
                    $model->date='';
                    }
                    if($_POST['voucher_no']=='')
                    {
                    $form=FinForm::model()->findByPk(9);
                    $no=$form->form_no+1;
                    $model->voucher_no='CR/'.$no;
                    }
                    else {
                    $model->voucher_no=$_POST['voucher_no'];
                    $no=str_replace("CR/","",$_POST['voucher_no']);    
                    }
                    $tot=0;
                    $tot1=0;
                    $valid='1=1';
                    foreach ($_POST['FinGeneralLedger'] as $i => $item) {
                    $modelFinGeneralLedger[$i] = new FinGeneralLedger;
//                    $modelFinGeneralLedger[$i]->attributes = $_POST['FinGeneralLedger'][$i];
                    $modelFinGeneralLedger[$i]->date = $model->date;
                    $modelFinGeneralLedger[$i]->voucher_no = $model->voucher_no;
                    if(isset($_POST['fin_givenname']))
                    {
                    	$modelFinGeneralLedger[$i]->given_name = $_POST['fin_givenname'];
                    }
                    $modelFinGeneralLedger[$i]->amt = 1;
                    $modelFinGeneralLedger[$i]->subledger = $_POST['FinGeneralLedger'][$i]['fin_subledger'];
                    $modelFinGeneralLedger[$i]->item_description = $_POST['FinGeneralLedger'][$i]['item_description'];
                    $modelFinGeneralLedger[$i]->narration = $_POST['narration'];
                    $modelFinGeneralLedger[$i]->credit = $_POST['FinGeneralLedger'][$i]['credit']  * $exchange_rate;
                    $modelFinGeneralLedger[$i]->cr_entered = $_POST['FinGeneralLedger'][$i]['credit'];
                    $modelFinGeneralLedger[$i]->debit = $_POST['FinGeneralLedger'][$i]['debit']  * $exchange_rate;
                    $modelFinGeneralLedger[$i]->db_entered = $_POST['FinGeneralLedger'][$i]['debit'];
                    $modelFinGeneralLedger[$i]->account_id = $_POST['FinGeneralLedger'][$i]['fin_account_id'];
                    $modelFinGeneralLedger[$i]->form_ref_no =  str_replace("/","",$model->voucher_no);
                    $modelFinGeneralLedger[$i]->item_no =  $_POST['FinGeneralLedger'][$i]['item_no'];
                    $modelFinGeneralLedger[$i]->item_type = $_POST['FinGeneralLedger'][$i]['item_type'];
                    $modelFinGeneralLedger[$i]->item_id = $_POST['FinGeneralLedger'][$i]['item_id'];
                    $modelFinGeneralLedger[$i]->cheque_date = '1111-11-11';
                    $modelFinGeneralLedger[$i]->chk_description = 'XXX';
                    $modelFinGeneralLedger[$i]->chk_no = 'XXX';
                    $modelFinGeneralLedger[$i]->currency =$currency;
                    $modelFinGeneralLedger[$i]->exchange_rate =$exchange_rate;
                    $modelFinGeneralLedger[$i]->form_id=9;
                    $modelFinGeneralLedger[$i]->credit_amt=1;
                    $modelFinGeneralLedger[$i]->cash_amt=1;
                    $modelFinGeneralLedger[$i]->card_no='XXX';
                    $modelFinGeneralLedger[$i]->auth_code='XXX';
                    $additions=$_POST['FinGeneralLedger'][$i]['credit']+$_POST['FinGeneralLedger'][$i]['debit'];
                    $deductions=$_POST['FinGeneralLedger'][$i]['credit']-$_POST['FinGeneralLedger'][$i]['debit'];
                    $total_add_ded=$additions-abs($deductions);
                    if($total_add_ded!=0)
                    {
                    $total_validate=1;
                    }
                    $tot+=$_POST['FinGeneralLedger'][$i]['credit'];
                    $tot1+=$_POST['FinGeneralLedger'][$i]['debit'];
                    $valid = $modelFinGeneralLedger[$i]->validate() && $valid;
        }
         $tot=Yii::app()->numberFormatter->formatCurrency($tot,'');
         $tot1=Yii::app()->numberFormatter->formatCurrency($tot1,'');
         
        
         if($model->date!='')
         {
         $year=date('Y', strtotime($model->date));
         $finyear=FinanceYearClose::model()->find(array('condition'=>'year='.$year));
         }
//         echo $finyear->year,$year;
         if(empty($finyear))
         {
                    if($tot == $tot1)
                    {
                    if($total_validate!=1)
                    {
                    if ($valid) {
                   
                 if($_POST['id']!='')
                    {
                    $head=FinGeneralLedgerHead::model()->findByPk($_POST['id']);
                    }
                    else {
                    $head=new FinGeneralLedgerHead;
                    }
                $head->voucher_no=$no;
                $head->voucher_date = $model->date;
                $head->comment = $_POST['narration'];
                $head->voucher_type='CR';
                $head->user_id=Yii::app()->user->id;
                $head->save();
                FinGeneralLedger::model()->deleteAll(array('condition'=>'voucher_no="'.$head->voucher_type.'/'.$head->voucher_no.'"'));
                foreach ($modelFinGeneralLedger as $eachModel) {
                    $eachModel->form_ref_no=$head->id;
                    $eachModel->save(false);
                }
                $form=FinForm::model()->findByPk(9);
           $form->form_no=$form->form_no+1;
           $form->save();
                $jsonData['id']=$head->id;
           $jsonData['form_no']=$form->form_no;
           $jsonData['date']=date("d/m/Y");
           $jsonData['status'] = 'success';
           echo CJSON::encode($jsonData);
                    }
        else {
                $error = json_decode(CActiveForm::validateTabular($modelFinGeneralLedger, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error));
                if ($error != '[]')
                    echo $error;
            }
                    }
                    else {
                     $jsonData['status'] = 'Error in Entry';
                     echo CJSON::encode($jsonData);
                    }
                    }
                    else {
                       
                     $jsonData['status'] = 'Totals are not equal';
                     echo CJSON::encode($jsonData);
                    }
         }
         else {
         $jsonData['status'] = 'Year Closed';
                     echo CJSON::encode($jsonData);    
         }
    }
     public function actionPostJournalSimple()
    {
       $model=new FinGeneralLedger;
                    $date = str_replace('/', '-', $_POST['voucher_date']);
                    $exchange_rate = $_POST['exchange_rate'];
                    $currency = $_POST['currency'];
                    $model->date = date("Y-m-d", strtotime($date));
                    if($model->date=='1970-01-01')
                    {
                    $model->date='';
                    }
                    if($_POST['voucher_no']=='')
                    {
                    $form=FinForm::model()->findByPk(3);
                    $no=$form->form_no+1;
                    $model->voucher_no='J1/'.$no;
                    }
                    else {
                    $model->voucher_no=$_POST['voucher_no'];
                    $no=str_replace("J1/","",$_POST['voucher_no']);    
                    }
                    $tot=0;
                    $tot1=0;
                    $valid='1=1';
                    foreach ($_POST['FinGeneralLedger'] as $i => $item) {
                    $modelFinGeneralLedger[$i] = new FinGeneralLedger;
//                    $modelFinGeneralLedger[$i]->attributes = $_POST['FinGeneralLedger'][$i];
                    $modelFinGeneralLedger[$i]->date = $model->date;
                    $modelFinGeneralLedger[$i]->voucher_no = $model->voucher_no;
                    if(isset($_POST['fin_givenname']))
                    {
                    	$modelFinGeneralLedger[$i]->given_name = $_POST['fin_givenname'];
                    }
                    $modelFinGeneralLedger[$i]->amt = 1;
                    $modelFinGeneralLedger[$i]->subledger = $_POST['FinGeneralLedger'][$i]['fin_subledger'];
                    $modelFinGeneralLedger[$i]->item_description = $_POST['FinGeneralLedger'][$i]['item_description'];
                    $modelFinGeneralLedger[$i]->narration = $_POST['narration'];
                    $modelFinGeneralLedger[$i]->credit = $_POST['FinGeneralLedger'][$i]['credit']  * $exchange_rate;
                    $modelFinGeneralLedger[$i]->cr_entered = $_POST['FinGeneralLedger'][$i]['credit'];
                    $modelFinGeneralLedger[$i]->debit = $_POST['FinGeneralLedger'][$i]['debit']  * $exchange_rate;
                    $modelFinGeneralLedger[$i]->db_entered = $_POST['FinGeneralLedger'][$i]['debit'];
                    $modelFinGeneralLedger[$i]->account_id = $_POST['FinGeneralLedger'][$i]['fin_account_id'];
                    $modelFinGeneralLedger[$i]->form_ref_no =  str_replace("/","",$model->voucher_no);
                    $modelFinGeneralLedger[$i]->item_no =  $_POST['FinGeneralLedger'][$i]['item_no'];
                    $modelFinGeneralLedger[$i]->item_type = $_POST['FinGeneralLedger'][$i]['item_type'];
                    $modelFinGeneralLedger[$i]->item_id = $_POST['FinGeneralLedger'][$i]['item_id'];
                    $modelFinGeneralLedger[$i]->cheque_date = '1111-11-11';
                    $modelFinGeneralLedger[$i]->chk_description = 'XXX';
                    $modelFinGeneralLedger[$i]->chk_no = 'XXX';
                    $modelFinGeneralLedger[$i]->currency =$currency;
                    $modelFinGeneralLedger[$i]->exchange_rate =$exchange_rate;
                    $modelFinGeneralLedger[$i]->form_id=3;
                    $modelFinGeneralLedger[$i]->credit_amt=1;
                    $modelFinGeneralLedger[$i]->cash_amt=1;
                    $modelFinGeneralLedger[$i]->card_no='XXX';
                    $modelFinGeneralLedger[$i]->auth_code='XXX';
                    $modelFinGeneralLedger[$i]->isAllocated="Y";
                    $additions=$_POST['FinGeneralLedger'][$i]['credit']+$_POST['FinGeneralLedger'][$i]['debit'];
                    $deductions=$_POST['FinGeneralLedger'][$i]['credit']-$_POST['FinGeneralLedger'][$i]['debit'];
                    $total_add_ded=$additions-abs($deductions);
                    if($total_add_ded!=0)
                    {
                    $total_validate=1;
                    }
                    else
                    {
                    $total_validate =0;
                    }
                    $tot+=$_POST['FinGeneralLedger'][$i]['credit'];
                    $tot1+=$_POST['FinGeneralLedger'][$i]['debit'];
                    $exact_total += $item['debit']; 
                     $valid = $modelFinGeneralLedger[$i]->validate() && $valid;
        }
         $tot=Yii::app()->numberFormatter->formatCurrency($tot,'');
         $tot1=Yii::app()->numberFormatter->formatCurrency($tot1,'');
         
         if($model->date!='')
         {
         $year=date('Y', strtotime($model->date));
         $finyear=FinanceYearClose::model()->find(array('condition'=>'year='.$year));
         }
//         echo $finyear->year,$year;
         if(empty($finyear))
         {
                    if($tot==$tot1)
                    {
                    if($total_validate!=1)
                    {
                    if ($valid) {
                   
                 if($_POST['id']!='')
                    {
                    $head=FinGeneralLedgerHead::model()->findByPk($_POST['id']);
                    }
                    else {
                    $head=new FinGeneralLedgerHead;
                    }
                $head->posted='Y';
                $head->voucher_no=$no;
                $head->voucher_date = $model->date;
                $head->comment = $_POST['narration'];
                $head->voucher_type='J1';
                $head->value = $exact_total;
                $head->user_id=Yii::app()->user->id;
                $head->id_user_posted=Yii::app()->user->id;
                $head->dt_posted=date('Y-m-d');
                $head->save();
                FinGeneralLedger::model()->deleteAll(array('condition'=>'voucher_no="'.$head->voucher_type.'/'.$head->voucher_no.'"'));
                foreach ($modelFinGeneralLedger as $eachModel) {
                    $eachModel->form_ref_no=$head->id;
                    $eachModel->posted_user_id=Yii::app()->user->id;
                    $eachModel->save();
                }
                $form=FinForm::model()->findByPk(3);
           $form->form_no=$form->form_no+1;
           $form->save();
                $jsonData['id']=$head->id;
           $jsonData['form_no']=$form->form_no;
           $jsonData['date']=date("d/m/Y");
           $jsonData['status'] = 'success';
           echo CJSON::encode($jsonData);
                    }
        else {
                $error = json_decode(CActiveForm::validateTabular($modelFinGeneralLedger, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error));
                if ($error != '[]')
                    echo $error;
            }
                    }
                    else {
                     $jsonData['status'] = 'Error in Entry';
                     echo CJSON::encode($jsonData);
                    }
                    }
                    else {
                     $jsonData['status'] = 'Totals are not equal';
                     echo CJSON::encode($jsonData);
                    }
                    
}
else {
         $jsonData['status'] = 'Year Closed';
                     echo CJSON::encode($jsonData);    
         }
    }
    public function actionPostDebitnoteSimple()
    {
       $model=new FinGeneralLedger;
                    $date = str_replace('/', '-', $_POST['voucher_date']);
                    $exchange_rate = $_POST['exchange_rate'];
                    $currency = $_POST['currency'];
                    $model->date = date("Y-m-d", strtotime($date));
                    if($model->date=='1970-01-01')
                    {
                    $model->date='';
                    }
                    if($_POST['voucher_no']=='')
                    {
                    $form=FinForm::model()->findByPk(12);
                    $no=$form->form_no+1;
                    $model->voucher_no='DB/'.$no;
                    }
                    else {
                    $model->voucher_no=$_POST['voucher_no'];
                    $no=str_replace("DB/","",$_POST['voucher_no']);    
                    }
                    $tot=0;
                    $tot1=0;
                    $valid='1=1';
                    foreach ($_POST['FinGeneralLedger'] as $i => $item) {
                    $modelFinGeneralLedger[$i] = new FinGeneralLedger;
//                    $modelFinGeneralLedger[$i]->attributes = $_POST['FinGeneralLedger'][$i];
                    $modelFinGeneralLedger[$i]->date = $model->date;
                    $modelFinGeneralLedger[$i]->voucher_no = $model->voucher_no;
                    if(isset($_POST['fin_givenname']))
                    {
                    	$modelFinGeneralLedger[$i]->given_name = $_POST['fin_givenname'];
                    }
                    $modelFinGeneralLedger[$i]->amt = 1;
                    $modelFinGeneralLedger[$i]->subledger = $_POST['FinGeneralLedger'][$i]['fin_subledger'];
                    $modelFinGeneralLedger[$i]->item_description = $_POST['FinGeneralLedger'][$i]['item_description'];
                    $modelFinGeneralLedger[$i]->narration = $_POST['narration'];
                    $modelFinGeneralLedger[$i]->credit = $_POST['FinGeneralLedger'][$i]['credit']  * $exchange_rate;
                    $modelFinGeneralLedger[$i]->cr_entered = $_POST['FinGeneralLedger'][$i]['credit'];
                    $modelFinGeneralLedger[$i]->debit = $_POST['FinGeneralLedger'][$i]['debit']  * $exchange_rate;
                    $modelFinGeneralLedger[$i]->db_entered = $_POST['FinGeneralLedger'][$i]['debit'];
                    $modelFinGeneralLedger[$i]->account_id = $_POST['FinGeneralLedger'][$i]['fin_account_id'];
                    $modelFinGeneralLedger[$i]->form_ref_no =  str_replace("/","",$model->voucher_no);
                    $modelFinGeneralLedger[$i]->item_no =  $_POST['FinGeneralLedger'][$i]['item_no'];
                    $modelFinGeneralLedger[$i]->item_type = $_POST['FinGeneralLedger'][$i]['item_type'];
                    $modelFinGeneralLedger[$i]->item_id = $_POST['FinGeneralLedger'][$i]['item_id'];
                    $modelFinGeneralLedger[$i]->cheque_date = '1111-11-11';
                    $modelFinGeneralLedger[$i]->chk_description = 'XXX';
                    $modelFinGeneralLedger[$i]->chk_no = 'XXX';
                    $modelFinGeneralLedger[$i]->currency =$currency;
                    $modelFinGeneralLedger[$i]->exchange_rate =$exchange_rate;
                    $modelFinGeneralLedger[$i]->form_id=12;
                    $modelFinGeneralLedger[$i]->credit_amt=1;
                    $modelFinGeneralLedger[$i]->cash_amt=1;
                    $modelFinGeneralLedger[$i]->card_no='XXX';
                    $modelFinGeneralLedger[$i]->auth_code='XXX';
                    $modelFinGeneralLedger[$i]->isAllocated="Y";
                    $additions=$_POST['FinGeneralLedger'][$i]['credit']+$_POST['FinGeneralLedger'][$i]['debit'];
                    $deductions=$_POST['FinGeneralLedger'][$i]['credit']-$_POST['FinGeneralLedger'][$i]['debit'];
                    $total_add_ded=$additions-abs($deductions);
                    if($total_add_ded!=0)
                    {
                    $total_validate=1;
                    }
                    else
                    {
                    $total_validate =0;
                    }
                    $tot+=$_POST['FinGeneralLedger'][$i]['credit'];
                    $tot1+=$_POST['FinGeneralLedger'][$i]['debit'];
                     $valid = $modelFinGeneralLedger[$i]->validate() && $valid;
        }
         $tot=Yii::app()->numberFormatter->formatCurrency($tot,'');
         $tot1=Yii::app()->numberFormatter->formatCurrency($tot1,'');
         
         if($model->date!='')
         {
         $year=date('Y', strtotime($model->date));
         $finyear=FinanceYearClose::model()->find(array('condition'=>'year='.$year));
         }
//         echo $finyear->year,$year;
         if(empty($finyear))
         {
                    if($tot==$tot1)
                    {
                    if($total_validate!=1)
                    {
                    if ($valid) {
                   
                 if($_POST['id']!='')
                    {
                    $head=FinGeneralLedgerHead::model()->findByPk($_POST['id']);
                    }
                    else {
                    $head=new FinGeneralLedgerHead;
                    }
                $head->posted='Y';
                $head->voucher_no=$no;
                $head->voucher_date = $model->date;
                $head->comment = $_POST['narration'];
                $head->voucher_type='DB';
                $head->user_id=Yii::app()->user->id;
                $head->id_user_posted=Yii::app()->user->id;
                $head->dt_posted=date('Y-m-d');
                $head->save();
                FinGeneralLedger::model()->deleteAll(array('condition'=>'voucher_no="'.$head->voucher_type.'/'.$head->voucher_no.'"'));
                foreach ($modelFinGeneralLedger as $eachModel) {
                    $eachModel->form_ref_no=$head->id;
                    $eachModel->posted_user_id=Yii::app()->user->id;
                    $eachModel->save();
                }
                $form=FinForm::model()->findByPk(12);
           $form->form_no=$form->form_no+1;
           $form->save();
                $jsonData['id']=$head->id;
           $jsonData['form_no']=$form->form_no;
           $jsonData['date']=date("d/m/Y");
           $jsonData['status'] = 'success';
           echo CJSON::encode($jsonData);
                    }
        else {
                $error = json_decode(CActiveForm::validateTabular($modelFinGeneralLedger, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error));
                if ($error != '[]')
                    echo $error;
            }
                    }
                    else {
                     $jsonData['status'] = 'Error in Entry';
                     echo CJSON::encode($jsonData);
                    }
                    }
                    else {
                     $jsonData['status'] = 'Totals are not equal';
                     echo CJSON::encode($jsonData);
                    }
                    
}
else {
         $jsonData['status'] = 'Year Closed';
                     echo CJSON::encode($jsonData);    
         }
    }
    public function actionPostCreditnoteSimple()
    {
       $model=new FinGeneralLedger;
                    $date = str_replace('/', '-', $_POST['voucher_date']);
                    $exchange_rate = $_POST['exchange_rate'];
                    $currency = $_POST['currency'];
                    $model->date = date("Y-m-d", strtotime($date));
                    if($model->date=='1970-01-01')
                    {
                    $model->date='';
                    }
                    if($_POST['voucher_no']=='')
                    {
                    $form=FinForm::model()->findByPk(9);
                    $no=$form->form_no+1;
                    $model->voucher_no='CR/'.$no;
                    }
                    else {
                    $model->voucher_no=$_POST['voucher_no'];
                    $no=str_replace("CR/","",$_POST['voucher_no']);    
                    }
                    $tot=0;
                    $tot1=0;
                    $valid='1=1';
                    foreach ($_POST['FinGeneralLedger'] as $i => $item) {
                    $modelFinGeneralLedger[$i] = new FinGeneralLedger;
//                    $modelFinGeneralLedger[$i]->attributes = $_POST['FinGeneralLedger'][$i];
                    $modelFinGeneralLedger[$i]->date = $model->date;
                    $modelFinGeneralLedger[$i]->voucher_no = $model->voucher_no;
                    if(isset($_POST['fin_givenname']))
                    {
                    	$modelFinGeneralLedger[$i]->given_name = $_POST['fin_givenname'];
                    }
                    $modelFinGeneralLedger[$i]->amt = 1;
                    $modelFinGeneralLedger[$i]->subledger = $_POST['FinGeneralLedger'][$i]['fin_subledger'];
                    $modelFinGeneralLedger[$i]->item_description = $_POST['FinGeneralLedger'][$i]['item_description'];
                    $modelFinGeneralLedger[$i]->narration = $_POST['narration'];
                    $modelFinGeneralLedger[$i]->credit = $_POST['FinGeneralLedger'][$i]['credit']  * $exchange_rate;
                    $modelFinGeneralLedger[$i]->cr_entered = $_POST['FinGeneralLedger'][$i]['credit'];
                    $modelFinGeneralLedger[$i]->debit = $_POST['FinGeneralLedger'][$i]['debit']  * $exchange_rate;
                    $modelFinGeneralLedger[$i]->db_entered = $_POST['FinGeneralLedger'][$i]['debit'];
                    $modelFinGeneralLedger[$i]->account_id = $_POST['FinGeneralLedger'][$i]['fin_account_id'];
                    $modelFinGeneralLedger[$i]->form_ref_no =  str_replace("/","",$model->voucher_no);
                    $modelFinGeneralLedger[$i]->item_no =  $_POST['FinGeneralLedger'][$i]['item_no'];
                    $modelFinGeneralLedger[$i]->item_type = $_POST['FinGeneralLedger'][$i]['item_type'];
                    $modelFinGeneralLedger[$i]->item_id = $_POST['FinGeneralLedger'][$i]['item_id'];
                    $modelFinGeneralLedger[$i]->cheque_date = '1111-11-11';
                    $modelFinGeneralLedger[$i]->chk_description = 'XXX';
                    $modelFinGeneralLedger[$i]->chk_no = 'XXX';
                    $modelFinGeneralLedger[$i]->currency =$currency;
                    $modelFinGeneralLedger[$i]->exchange_rate =$exchange_rate;
                    $modelFinGeneralLedger[$i]->form_id=9;
                    $modelFinGeneralLedger[$i]->credit_amt=1;
                    $modelFinGeneralLedger[$i]->cash_amt=1;
                    $modelFinGeneralLedger[$i]->card_no='XXX';
                    $modelFinGeneralLedger[$i]->auth_code='XXX';
                    $modelFinGeneralLedger[$i]->isAllocated="Y";
                    $additions=$_POST['FinGeneralLedger'][$i]['credit']+$_POST['FinGeneralLedger'][$i]['debit'];
                    $deductions=$_POST['FinGeneralLedger'][$i]['credit']-$_POST['FinGeneralLedger'][$i]['debit'];
                    $total_add_ded=$additions-abs($deductions);
                    if($total_add_ded!=0)
                    {
                    $total_validate=1;
                    }
                    else
                    {
                    $total_validate =0;
                    }
                    $tot+=$_POST['FinGeneralLedger'][$i]['credit'];
                    $tot1+=$_POST['FinGeneralLedger'][$i]['debit'];
                     $valid = $modelFinGeneralLedger[$i]->validate() && $valid;
        }
         $tot=Yii::app()->numberFormatter->formatCurrency($tot,'');
         $tot1=Yii::app()->numberFormatter->formatCurrency($tot1,'');
         
         if($model->date!='')
         {
         $year=date('Y', strtotime($model->date));
         $finyear=FinanceYearClose::model()->find(array('condition'=>'year='.$year));
         }
//         echo $finyear->year,$year;
         if(empty($finyear))
         {
                    if($tot==$tot1)
                    {
                    if($total_validate!=1)
                    {
                    if ($valid) {
                   
                 if($_POST['id']!='')
                    {
                    $head=FinGeneralLedgerHead::model()->findByPk($_POST['id']);
                    }
                    else {
                    $head=new FinGeneralLedgerHead;
                    }
                $head->posted='Y';
                $head->voucher_no=$no;
                $head->voucher_date = $model->date;
                $head->comment = $_POST['narration'];
                $head->voucher_type='CR';
                $head->user_id=Yii::app()->user->id;
                $head->id_user_posted=Yii::app()->user->id;
                $head->dt_posted=date('Y-m-d');
                $head->save();
                FinGeneralLedger::model()->deleteAll(array('condition'=>'voucher_no="'.$head->voucher_type.'/'.$head->voucher_no.'"'));
                foreach ($modelFinGeneralLedger as $eachModel) {
                    $eachModel->form_ref_no=$head->id;
                    $eachModel->posted_user_id=Yii::app()->user->id;
                    $eachModel->save();
                }
                $form=FinForm::model()->findByPk(9);
           $form->form_no=$form->form_no+1;
           $form->save();
                $jsonData['id']=$head->id;
           $jsonData['form_no']=$form->form_no;
           $jsonData['date']=date("d/m/Y");
           $jsonData['status'] = 'success';
           echo CJSON::encode($jsonData);
                    }
        else {
                $error = json_decode(CActiveForm::validateTabular($modelFinGeneralLedger, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error));
                if ($error != '[]')
                    echo $error;
            }
                    }
                    else {
                     $jsonData['status'] = 'Error in Entry';
                     echo CJSON::encode($jsonData);
                    }
                    }
                    else {
                     $jsonData['status'] = 'Totals are not equal';
                     echo CJSON::encode($jsonData);
                    }
                    
}
else {
         $jsonData['status'] = 'Year Closed';
                     echo CJSON::encode($jsonData);    
         }
    }
    public function actionDeleteVoucher()
{
  $id=Yii::app()->request->getparam('id');
  $head = FinGeneralLedgerHead::model()->findByPk($id);
  $sql="INSERT INTO crm_fin_general_ledger_head_delete(id,voucher_no,voucher_date,comment,voucher_type,user_id,posted,deleted,subledger,due_date,doc_ref,dtDE,comment2,id_user_posted,dt_posted) SELECT id,voucher_no,voucher_date,comment,voucher_type,user_id,posted,deleted,subledger,due_date,doc_ref,dtDE,comment2,id_user_posted,dt_posted FROM crm_fin_general_ledger_head where id=".$id;
     Yii::app()->db->createCommand($sql)->execute();
     $user=Yii::app()->user->id;
     $sql1="UPDATE crm_fin_general_ledger_head_delete set delete_user_id=".$user;
     Yii::app()->db->createCommand($sql1)->execute();
  $model = FinGeneralLedgerHead::model()->deleteByPk($id);
  FinGeneralLedger::model()->deleteAll(array('condition'=>'form_ref_no="'.$id.'"'));
  Pdc::model()->deleteAll(array('condition'=>'voucher_no="'.$head->voucher_type.'/'.$head->voucher_no.'"'));
  BankReconciliation::model()->deleteAll(array('condition'=>'voucher_no="'.$head->voucher_type.'/'.$head->voucher_no.'"'));
  $jsonData['status'] = 'success';
  echo CJSON::encode($jsonData);
}
public function actionPostVoucher()
    {
     $id=Yii::app()->request->getparam('id');
     $model=FinGeneralLedgerHead::model()->findByPk($id);
     $model->posted='Y';
     $model->id_user_posted=Yii::app()->user->id;
     $model->dt_posted=date('Y-m-d');
     $model->save();
     $connection=Yii::app()->db;
     $user=Yii::app()->user->id;
    $sql = "UPDATE crm_fin_general_ledger SET isAllocated = 'Y',posted_user_id=$user WHERE voucher_no = '".$model->voucher_type.'/'.$model->voucher_no."'";
    $command = $connection->createCommand($sql);
    $command->execute();
    $jsonData['status'] = 'success';
    echo CJSON::encode($jsonData);
    }
 public function actionUnpostVoucher()
    {
     $id=Yii::app()->request->getparam('id');
     $model=FinGeneralLedgerHead::model()->findByPk($id);
     $finyear=FinanceYearClose::model()->find(array('order'=>'year DESC'));
     $year=($finyear->year);
     $v_year=date('Y', strtotime($model->voucher_date));
     if($v_year==$year)
     {
      $jsonData['status'] = 'year';
      echo CJSON::encode($jsonData);       
     }
     else {
     $connection=Yii::app()->db;
     $get_item=FinVoucherAllocation::model()->findAll(array('condition'=>'voucher_no="'.$model->voucher_type.'/'.$model->voucher_no.'"'));
     if(empty($get_item)){
     $model->posted='N';
     $model->save();
     $connection=Yii::app()->db;
     $user=Yii::app()->user->id;
     $sql = "UPDATE crm_fin_general_ledger SET isAllocated = 'N',unposted_user_id=$user WHERE voucher_no = '".$model->voucher_type.'/'.$model->voucher_no."'";
    $command = $connection->createCommand($sql);
    $command->execute();
         $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
            Yii::app()->end();
     }
     else {
       $jsonData['status'] = 'fail';
            echo CJSON::encode($jsonData);   
     }
     }
    }
      
    public function actionGetallpostedvoucher()
    {
        $model=new FinGeneralLedgerHead();
        $draw   = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
                // datatable column index  => database column name
                0=>'t.voucher_type',
                1 =>'t.voucher_date',
                2=> 't.narration',
                3=> 't.posted',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy      = $filterColumn." ".$filterOrder;
        $condition = 'voucher_type IN ("EN","EX")';
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
            $searchString = $_POST['search']['value'];
             $condition.=" AND (voucher_no LIKE '%".$searchString."%' OR comment like '%".$searchString."%' )";
        }
        $count = $model->count(array('condition'=>$condition));
        $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'t.id desc'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
                
        foreach ($model as $i=>$row)
        {                 
            $div = '';

            if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["fin_postedvoucher_view"])){ 
                $div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'finance/JournalView&id='.$row['id'].'\',\''.$row['voucher_type']."/".$row['voucher_no'].'\',\'lg\')"><i class="fa fa-eye"></i></button>';
            }
            if($row['posted']=='N')
            {
                if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["fin_postedvoucher_delete"])){ 
                    $div .= ' <button class="btn btn-primary btn-xs" onclick="deletefinvoucher('.$row['id'].',\'LoadJournalAll\')"><i class="fa fa-trash"></i></button>';
                }                                
            } 
            if($row['posted']=='N')
            {
                if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["fin_postedvoucher_post"])){ 
                     $div .= ' <button class="btn btn-primary btn-xs" onclick="postfinvoucher('.$row['id'].',\'LoadJournalAll\')"><i class="fa fa-send"></i></button>';
                }               
            }
            if($row['posted']=='Y')
            {
                if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["fin_postedvoucher_unpost"])){ 
                    $div .= ' <button class="btn btn-primary btn-xs" onclick="unpostfinvoucher('.$row['id'].',\'LoadJournalAll\')"><i class="fa fa-remove"></i></button>';
                }            
            }

            if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["fin_postedvoucher_print"])){ 
                $div .= ' <a class="btn btn-primary btn-xs" title="Print" target="_blank" href="index.php?r=finance/LedgerJournalPrint&id=' . $row['id'] .' "><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';
            }

            $rowData[]=array(($i+1),$row['voucher_type'].'/'.$row['voucher_no'],date("d/m/Y",strtotime($row['voucher_date'])),$row['comment'],'<div class="text-right">'.$row['value'].'</div>',$row['posted'],'<div class="btn-wrap text-center">'.$div.'</div>');
                        
                      }
        $data['data'] = $rowData;
        echo json_encode($data);
        }
        
        public function actionSubledger()
        {
        $this->render('fin_subledger_index');
        }
        public function actionSubledgertype()
        {
        $this->render('fin_subledger_type_index');
        }
         public function actionGetsubledgertypelist()
    {
            
        $model=new SubledgerType();
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
        // datatable column index  => database column name
            0 => 'id',
            1 => 'description',
            2 => 'code',
            3 => 'id',
           
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
        $condition = '1=1';
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
            $searchString = $_POST['search']['value'];
            $condition.=" AND (description LIKE '%".$searchString."%' OR code LIKE '%".$searchString."%')";
        }
        $count = $model->count(array('condition'=>$condition));
        $model = $model->findAll(array('condition'=>$condition ,'order'=>'id' ));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        foreach ($model as $i => $row)
        {
            $div = '';
            $div .= ' <button class="btn btn-primary btn-xs" title ="Edit '.$row['description'].' " onclick="loadPopupModal(\'finance/createsubledgertype&id='.$row['id'].'\',\'Edit '.$row['description'].' \',\'lg\')"><i class="fa fa-pencil"></i></button>';
           //$div .= ' <button class="btn btn-danger btn-xs" onclick="deletesubtype('.$row['id'].')"><i class="fa fa-trash-o "></i></button>';
            $rowData[]=array(($i+1),$row['description'],$row['code'],'<div class="btn-wrap text-center">'.$div.'</div>
            ');
        }
        $data['data'] = $rowData;
        echo json_encode($data);   
    }
    
    public function actionSavesubledgertype(){
        if(isset($_POST['SubledgerType'])){
            $model = new SubledgerType;
            if($_POST['SubledgerType']['id'] > 0){
                $model = $model->findbypk($_POST['SubledgerType']['id']);
            }
            $model->attributes = $_POST['SubledgerType'];
            if($model->save()){
                  $data['status'] = 'success';
                  echo json_encode($data);   
            }else{
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionSavesubledger(){
        if(isset($_POST['Subledger'])){
            $model = new Subledger;
            if($_POST['Subledger']['id'] > 0){
                $model = $model->findbypk($_POST['Subledger']['id']);
            }
            $model->attributes = $_POST['Subledger'];
            $max = Yii::app()->db->createCommand('SELECT MAX(account_no) FROM crm_fin_subledger')->queryScalar();
            $model->account_no = $max+1;
            if($model->save()){
                  $data['status'] = 'success';
                  echo json_encode($data);   
            }else{
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    
    
    public function actionGetsubledgerlist(){
            
        $model=new Subledger;
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
        // datatable column index  => database column name
            0 => 'id',
            1 => 'account_no',
            2 => 'description',
            3 => 'type',
            4 => 'id',
           
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
        $condition = '1=1';
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
            $searchString = $_POST['search']['value'];
            $condition.=" AND (t.description LIKE '%".$searchString."%' OR t.account_no LIKE '%".$searchString."%' OR stype.description LIKE '%".$searchString."%')";
        }
        $count = $model->with('stype')->count(array('condition'=>$condition));
        $model = $model->with('stype')->findAll(array('condition'=>$condition ,'order'=>'t.account_no' ));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        foreach ($model as $i => $row)
        {
            $div = '<button class="btn btn-primary btn-xs" title ="Edit '.$row['description'].' " onclick="loadPopupModal(\'finance/createsubledger&id='.$row['id'].'\',\'Edit '.$row['description'].' \',\'lg\')"><i class="fa fa-pencil"></i></button> ';
            if($row['stype']['code'] != "VE" && $row['stype']['code'] != "CU"){
                //$div .= ' <button class="btn btn-danger btn-xs" onclick="deletesub('.$row['id'].')"><i class="fa fa-trash-o "></i></button>';
            }
            $rowData[]=array(($i+1),$row['account_no'],$row['description'],$row['stype']['description'],'<div class="btn-wrap text-center">'.$div.'</div>');
        }
        $data['data'] = $rowData;
        echo json_encode($data);   
    }
    
   public function actionPushAll(){
        Subledger::model()->deleteAll();
        $customers = Customer::model()->findAll();
        $last = 0;
        foreach($customers as $i => $each){
            $model = new Subledger;
            $model->account_no = $i+10001;
            $model->type = 1;   
            $model->respect_id = $each->id;   
            $model->description = $each['customer_name'];
            $model->created_by = 1;
            $model->updated_by = 1;
            $model->updated_date_time = date('Y-m-d h:i:s');
            $model->created_date_time = date('Y-m-d h:i:s');
            $model->save(false);
            $last =  $model->account_no;
        }
        // $last += 1;
        // $vendor = Vendor::model()->findAll();
        // foreach($vendor as $i => $each){
        //     $model = new Subledger;
        //     $model->account_no = $i+$last;
        //     $model->type = 2;   
        //     $model->respect_id = $each->id;   
        //     $model->description = $each['vendor_name'];
        //     $model->created_by = 1;
        //     $model->updated_by = 1;
        //     $model->updated_date_time = date('Y-m-d h:i:s');
        //     $model->created_date_time = date('Y-m-d h:i:s');
        //     $model->save(false);
            
        // }
   }
   
    
    public function actionDeletesubledger(){
                $id = $_POST['id'];
                $model=new Subledger();
                $model->deleteByPk($id);
                echo "success";
    }
      public function actionDeletesubledgertype(){
                $id = $_POST['id'];
                $exist = Subledger::model()->findAll(array('condition' => 'type='.$id));
                $model = SubledgerType::model()->findByPk($id);
                if(empty($exist)){
                      $model=new SubledgerType();
                      $model->deleteByPk($id);
                      echo "success";
                }else{
                     echo "Subledger exist against ".$model->description." Type , Cannot deleted!";
                }
              
               
    }
    public function actionGetsettings()
        {
                $model=new FinSettings();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 =>'item',
                   
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = '1=1';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  //$condition.=" and (name LIKE '%".$searchString."%')";
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'id'));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m = 1;
                
                foreach ($model as $i => $row)
                {
                    $div = '';
                        $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'finance/addaccount&id='.$row['id'].'\',\'Edit\',\'lg\')"><i class="fa fa-pencil"></i></button>';
                       
                        if($row['operation'] == '1')
                            $op = 'Credit';
                        else
                            $op = 'Debit';
                        if($row['attribute'] == '99999')
                            $arr_attr = 'Sales';
                        else if($row['attribute'] == '99998')
                            $arr_attr = 'Customer';
                        else if($row['attribute'] == '99997')
                            $arr_attr = 'Vendors';
                        else if($row['attribute'] == '66666')
                            $arr_attr = 'Purchase';
                        else if($row['attribute'] == '55555')
                            $arr_attr = 'VAT Inbound';
                        else if($row['attribute'] == '55556')
                            $arr_attr = 'VAT Outbound';
                        else if($row['attribute'] == '88888')
                            $arr_attr = 'Purchase/Receipt Voucher - Bank Charges';
                        else if($row['attribute'] == '88887')
                            $arr_attr = 'Purchase/Receipt Voucher - Cheque';
                        else if($row['attribute'] == '88886')
                            $arr_attr = 'Purchase/Receipt Voucher - Cash';
                        else if($row['attribute'] == '88885')
                            $arr_attr = 'Purchase/Receipt Voucher - Credit Card';
                        else if($row['attribute'] == '44444')
                            $arr_attr = 'Audit Close (Retained Profit Loss)';
                        else if($row['attribute'] == '44445')
                            $arr_attr = 'Audit Close (Current Year Profit or Loss)';
                        else if($row['attribute'] == '21211')
                            $arr_attr = 'Outstanding Invoice - sales';
                        else if($row['attribute'] == '21212')
                            $arr_attr = 'Outstanding Invoice - Purchase';
                        // else
                        //     $arr_attr = $row['attr']['description'];
                        $rowData[]=array(($i+1),$arr_attr,$row['acc']['description'],'<div class="btn-wrap text-center">'.$div.'</div>');
                
                    $m++;
                    
                }
                
                

                $data['data'] = $rowData;
                echo json_encode($data);
        }
        
        public function actionSavefinsettings(){
             $model = new FinSettings();
            if (isset($_POST['FinSettings']))
            {
    		
    		if ($_POST['FinSettings']['id'] > 0)
                {   
                    $model=$model->findByPk($_POST['FinSettings']['id']);  
                }
                $model->attributes=$_POST['FinSettings'];
                if ($model->save())
                {
                        $jsonData['status'] = 'success';
                        echo CJSON::encode($jsonData);
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }
          
            }
        }
         public function actionCreatesubledgertype()
        {
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
            $model = new SubledgerType;
             $id = Yii::app()->request->getParam('id');
            if($id > 0){
                $model = $model->findbypk($id);
            }
             $this->render('subledger_type_create',array('model' => $model));
        }
         public function actionCreatesubledger()
        {
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
            $model = new Subledger;
             $id = Yii::app()->request->getParam('id');
            if($id > 0){
                $model = $model->findbypk($id);
            }
             $this->render('subledger_create',array('model' => $model));
        }
         public function actionAccounts(){
             $this->render('fin_accounts_index');
        }
          public function actionGetAccountList()
    {
            
        $model=new FinAccounts();
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
        // datatable column index  => database column name
            0 => 'id',
            1 => 'account_no',
            2 => 'description',
            3 => 'id',
            4 => 'id',
            5 => 'id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
        $condition = 'isActive="Y"';
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
            $searchString = $_POST['search']['value'];
            $condition.=" AND (account_no LIKE '%".$searchString."%' OR description LIKE '%".$searchString."%')";
        }
        $count = $model->count(array('condition'=>$condition));
        $model = $model->findAll(array('condition'=>$condition ,'order'=>'id','limit'=>$limit,'offset'=>$offset));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        foreach ($model as $row)
        {
            if($row['account_type'] == "A"){
                $acc_type = 'Asset';
            }else if($row['account_type'] == "L"){
                $acc_type = 'Liabiliy';
            }else if($row['account_type'] == "I"){
                $acc_type = 'Income';
            }else{
                $acc_type = 'Expense';
            }
            $roll = 'R';
            if($row['parent_account'] > 0){
                $roll = 'E';
            }
            $rowData[]=array($row['id'],'Level '.$row['level'],$acc_type,$roll,$row['has_subledger'],$row['account_no'],$row['description'],FinAccounts::getparent($row),'<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" title ="Edit '.$row['description'].' " onclick="loadPopupModal(\'finance/createaccount&id='.$row['id'].'\',\'Edit '.$row['description'].' \',\'lg\')"><i class="fa fa-pencil"></i></button></div>
            ');
        }
        $data['data'] = $rowData;
        echo json_encode($data);   
    }
     public function actionCreateaccount()
    {
        $id= Yii::app()->request->getParam('id');
        if($id)
        {
        $model=FinAccounts::model()->findByPk($id);
        }
        else {
        $model= new FinAccounts;
        }
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('account_create', array('model' => $model), false, true);
    }
      public function actionSaveAccounts() {
        $model = new FinAccounts;
        if (isset($_POST['FinAccounts'])) {
            if ((int) @$_POST['FinAccounts']['id'] > 0) {
                $model->id = (int) $_POST['FinAccounts']['id'];
                $model->scenario = 'update';
                $model = $model->findByPK($model->id);
            } else {
                unset($_POST['FinAccounts']['id']);
                $model->scenario = 'add';
            }
            $model->attributes = $_POST['FinAccounts'];
            if ($_POST['FinAccounts']['parent_account'] > 0) {
                $accounts = FinAccounts::model()->findByPk($_POST['FinAccounts']['parent_account']);
                $model->credit_type = $accounts->credit_type;
                $model->level = (int)$accounts->level + 1;
                $lastsort = FinAccounts::model()->find(array('condition' => 'parent_account = '.$_POST['FinAccounts']['parent_account'],'order' => 'id desc'));
                if($lastsort->id > 0){
                    if($model->level == 2)
                        $model->sort_order = (float) $lastsort->sort_order + (float) 0.1000;
                    if($model->level == 3)
                        $model->sort_order = (float) $lastsort->sort_order + (float) 0.0100;
                    if($model->level == 4)
                        $model->sort_order = (float) $lastsort->sort_order + (float) 0.0010;
                    if($model->level == 4)
                        $model->sort_order = (float) $lastsort->sort_order + (float) 0.0001;
                }else{
                    if($model->level == 2)
                        $model->sort_order = (float) $accounts->sort_order + (float) 0.1000;
                    if($model->level == 3)
                        $model->sort_order = (float) $accounts->sort_order + (float) 0.0100;
                    if($model->level == 4)
                        $model->sort_order = (float) $accounts->sort_order + (float) 0.0010;
                    if($model->level == 4)
                        $model->sort_order = (float) $accounts->sort_order + (float) 0.0001;
                }
            }
            else {
              $model->level = 1;  
            }
                $model->created_by = Yii::app()->user->id;
                $model->created_date=date('Y-m-d H:i:s');
                $model->opening_bal=$_POST['FinAccounts']['opening_bal'];
                $model->cash_bank_type=$_POST['FinAccounts']['cash_bank_type'];
                $model->account_type=$_POST['FinAccounts']['account_type'];
                $model->credit_type=$_POST['FinAccounts']['credit_type'];
                $model->routes=$_POST['FinAccounts']['routes'];
                $model->isParent=$_POST['FinAccounts']['isParent'];
                $model->has_subledger=$_POST['FinAccounts']['has_subledger'];
                if($model->opening_bal)
                {
                $model->opening_bal_type=$_POST['FinAccounts']['opening_bal_type'];
                }
                else 
                {
                $model->opening_bal_type=0;    
                }
            if ($model->validate()) {
                $model->save();
                if($model->level == 1)
                    $model->sort_order = $model->id.'0000';
                $model->save(false);
                $model->refresh();
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);

            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    
    public function actionSaveReceipt(){
        
          /**
         * Receipt Save
         * Author Jo~
         * 
         * General Ledger head Save
         */
        $save_type = Yii::app()->request->getParam('type');
        $error1 = array();
        $form=FinForm::model()->findByPk(2);
        $genral_ledger_head = new FinGeneralLedgerHead;
        if($_POST['header_table_id'] > 0){
            $genral_ledger_head = $genral_ledger_head->findbypk($_POST['header_table_id']);
        }else
            $genral_ledger_head->voucher_no = ($form->form_no+1);
        $genral_ledger_head->voucher_date = date('Y-m-d', strtotime(str_replace('/', '-', $_POST['voucher_date'])));
        $genral_ledger_head->voucher_type = 'R1'; 
        $genral_ledger_head->comment = $_POST['narration'];
        $genral_ledger_head->comment2 = $_POST['narration'];
        $genral_ledger_head->user_id = Yii::app()->user->id;
        $genral_ledger_head->subledger = $_POST['subledger_id'];
        $genral_ledger_head->value = $_POST['amount'];
        $genral_ledger_head->invoice_id = $_POST['invoice_id'];
        $genral_ledger_head->type = $_POST['type'];
        $genral_ledger_head->receipt_voucher_no      = $_POST['receipt_voucherno'];
        $exchange_rate = $_POST['exchange_rate'];
        $currency = $_POST['currency'];
        $receipt_type = $_POST['receipt_type'];
        
        if($save_type == 2){
            $genral_ledger_head->posted = "Y";
            $genral_ledger_head->dt_posted = date('Y-m-d');
        }
        $valid = $genral_ledger_head->validate();
        /**
         * Validating the POST values
         */
        if($_POST['account_id'] == 0){
             $valid = false;
             $error1[] = 'Account Cannot Blank';
          
        }
        $sub = 0;
        $receipt_type = 1;
        if($_POST['FinGeneralLedger']['description']['havesubledger'] > 0)
            $sub = 1;
        if($sub == 1 && $_POST['subledger_id'] == ''){
            $valid = false;
            $error1[] = 'Subledger Cannot Blank';
        }
        if($_POST['amount'] == ''){
             $valid = false;
             $error1[] = 'Amount Cannot Blank';
        }
        if($receipt_type == 2 && $_POST['bank_account_id'] == ''){
             $valid = false;
             $error1[] = 'Bank Cannot Blank';
        }
        if($receipt_type == 2 && $_POST['bank_amount'] > $_POST['amount'] ){
             $valid = false;
             $error1[] = 'Bank Charges must be less than Amount';
        }
        if($receipt_type == 1 && $_POST['discount'] > $_POST['amount'] ){
           $valid = false;
           $error1[] = 'Discount must be less than Amount';
        }
        if($_POST['vat_amount'] > $_POST['amount'] ){
            $valid = false;
            $error1[] = 'VAT must be less than Amount';
        }
        if(($receipt_type == 3 || $receipt_type == 4) && $_POST['cheque_no'] == ''){
             $valid = false;
             $error1[] = 'Cheque No Cannot Blank';
        }
        if($receipt_type == 4 && $_POST['cdc_bank_account_id'] == ''){
             $valid = false;
             $error1[] = 'Bank No Cannot Blank';
        }
        if($receipt_type == 5 && $_POST['card_no'] == ''){
             $valid = false;
             $error1[] = 'Card No Cannot Blank';
        } 
        if($valid){
                $genral_ledger_head->save();
                /**
                 * Single Entry
                 * 
                 */
                FinGeneralLedger::model()->deleteAll(array('condition'=>'voucher_no="R1/'.$genral_ledger_head->voucher_no.'"'));     
                $CreditEntry = new FinGeneralLedger;
                $CreditEntry->date = $genral_ledger_head->voucher_date;
                $CreditEntry->voucher_no = 'R1/'.$genral_ledger_head->voucher_no;
                $CreditEntry->form_ref_no = $genral_ledger_head->id;
                $CreditEntry->account_id = $_POST['account_id'];
                $CreditEntry->amt = $_POST['amount'];
                $CreditEntry->exchange_rate = $_POST['exchange_rate'];
                $CreditEntry->currency = $_POST['currency'];
                $CreditEntry->amount_type=$receipt_type;
                $CreditEntry->payment_receipt_type =$receipt_type;
                $CreditEntry->given_name = $_POST['fin_givenname'];
                $CreditEntry->subledger = $_POST['subledger_id'];
                $CreditEntry->item_description = $_POST['narration'];
                $CreditEntry->narration = $_POST['narration'];
                $CreditEntry->bank_name =  $_POST['received_from'];
                $CreditEntry->credit =  $_POST['amount'];
                $CreditEntry->cr_entered =  $_POST['amount'];
                $CreditEntry->cash_amt=1;
                $CreditEntry->form_id = 2;
                $CreditEntry->cheque_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['cheque_date'])));
                $CreditEntry->chk_description = $_POST['amount'];
                $CreditEntry->chk_no = $_POST['cheque_no'];
                if($receipt_type == 2)
                    $CreditEntry->bank_name=$_POST['bank_account_name'];
                if($receipt_type == 4)
                    $CreditEntry->bank_name=$_POST['cdc_bank_account'];
                $CreditEntry->card_no=$_POST['card_no'];
                $CreditEntry->auth_code=$_POST['auth_code'];
                if($save_type == 2){
                    $CreditEntry->isAllocated = "Y";
                }
                $CreditEntry->save(false);
               
                /**
                 * If Bank Transfer adding Bank Charges
                 */
                if(($receipt_type == 2 && $_POST['bank_amount'] > 0) || ($receipt_type == 2 && $_POST['bank_charge_saved_id'] > 0) ){ 
                    $Bankcharges = new FinGeneralLedger;
                    $Bankcharges->date = $genral_ledger_head->voucher_date;
                    $Bankcharges->voucher_no = 'R1/'.$genral_ledger_head->voucher_no;
                    $Bankcharges->form_ref_no = $genral_ledger_head->id;
                    $Bankcharges->form_id = 2;
                    $Bankcharges->exchange_rate = $_POST['exchange_rate'];
                    $Bankcharges->currency = $_POST['currency'];
                    $Bankcharges->item_description = 'Bank Charges';
                    $Bankcharges->narration = 'Bank Charges';
                    $Bankcharges->description = 'BT';
                    $Bankcharges->debit = $_POST['bank_amount'];
                    $Bankcharges->credit = 0;
                    $Bankcharges->bank_name=$_POST['bank_account_name'];
                    $Bankcharges->amount_type=$receipt_type;
                    $Bankcharges->payment_receipt_type =$receipt_type;
                    $Bankcharges->account_id = FinSettings::getAccount(88888);
                    $Bankcharges->db_entered = $_POST['bank_amount'];
                    if($save_type == 2){
                        $Bankcharges->isAllocated = "Y";
                    }
                    $Bankcharges->save(false);
                }

                /**
                 * If Any discount is there
                 */
                if(($receipt_type == 1 && $_POST['discount'] > 0) || ($receipt_type == 1 && $_POST['discount_id'] > 0) ){ 
                    
                    $Discount = new FinGeneralLedger;
                    $Discount->date = $genral_ledger_head->voucher_date;
                    $Discount->voucher_no = 'R1/'.$genral_ledger_head->voucher_no;
                    $Discount->form_ref_no = $genral_ledger_head->id;
                    $Discount->form_id = 1;
                    $Discount->exchange_rate = $_POST['exchange_rate'];
                    $Discount->currency = $_POST['currency'];
                    $Discount->item_description = 'Discount (Receipt)';
                    $Discount->narration = 'Discount (Receipt)';
                    $Discount->description = 'DS';
                    $Discount->debit = $_POST['discount'];
                    $Discount->credit = 0;
                    $Discount->amount_type=$receipt_type;
                    $Discount->payment_receipt_type =$receipt_type;
                    $Discount->account_id = FinSettings::getAccount(88884); //Discount
                    $Discount->db_entered = $_POST['discount'];
                    if($save_type == 2){
                        $Discount->isAllocated = "Y";
                    }
                    $Discount->save(false);
                }

                /**
                 * VAT Amount
                 */
                if( $_POST['vat_amount'] > 0 || $_POST['vat_entry_id'] > 0 ){ 
                    $VAT = new FinGeneralLedger;
                    $VAT->date = $genral_ledger_head->voucher_date;
                    $VAT->voucher_no = 'R1/'.$genral_ledger_head->voucher_no;
                    $VAT->form_ref_no = $genral_ledger_head->id;
                    $VAT->form_id = 1;
                    $VAT->exchange_rate = $_POST['exchange_rate'];
                    $VAT->currency = $_POST['currency'];
                    $VAT->item_description = 'VAT';
                    $VAT->narration = 'VAT';
                    $VAT->description = 'VAT';
                    $VAT->debit = $_POST['vat_amount'];
                    $VAT->credit = 0;
                    $VAT->amount_type=$receipt_type;
                    $VAT->payment_receipt_type =$receipt_type;
                    $VAT->account_id = FinSettings::getAccount(55556); //VAT outbound
                    $VAT->db_entered = $_POST['vat_amount'];
                    if($save_type == 2){
                        $VAT->isAllocated = "Y";
                    }
                    $VAT->save(false);
                }

                /**
                 * PDC, CDC, Bank Reconciliation Management
                 * PDC
                 * 2 - Bank
                 * 3 - PDC
                 * 4 - CDC
                 */
                if($receipt_type == 3 ||  $receipt_type == 4){
                    
                    Pdc::model()->deleteAll(array('condition'=>'voucher_no="R1/'.$genral_ledger_head->voucher_no.'"'));    
                    $pdc= new Pdc;
                    $pdc->type = 1;
                    $pdc->voucher_date= $genral_ledger_head->voucher_date;
                    $pdc->apply_date = $CreditEntry->cheque_date;
                    $pdc->voucher_no = 'R1/'.$genral_ledger_head->voucher_no;
                    $pdc->voucher_sub_id = $CreditEntry->id;
                    $pdc->amount = $_POST['amount'];
                    $pdc->narration = $_POST['narration'];
                    $pdc->customer_id = $CreditEntry->subledger;
                    if($receipt_type == 4){
                        $pdc->bank_id = $_POST['cdc_bank_account_id'];
                        $pdc->realisation_date = $CreditEntry->cheque_date;
                        $pdc->posted = "Y";
                        $pdc->cleared = "Y";
                    }
                    $pdc->save(false);
                   
                }
                /*BR*/
                if($receipt_type == 2 || $receipt_type == 3){
                    
                    BankReconciliation::model()->deleteAll(array('condition'=>'voucher_no="R1/'.$genral_ledger_head->voucher_no.'"'));     
                    $bank_r= new BankReconciliation;
                    $bank_r->type = 1;
                    $bank_r->voucher_date=$genral_ledger_head->voucher_date;
                    $bank_r->apply_date=$genral_ledger_head->voucher_date;
                    $bank_r->narration=$_POST['narration'];
                    $bank_r->amount=$_POST['amount'];
                    $bank_r->bank_id=$_POST['bank_account_id'];
                    $bank_r->voucher_no = 'R1/'.$genral_ledger_head->voucher_no;
                    $bank_r->voucher_sub_id = $CreditEntry->id;
                    $bank_r->mode = $receipt_type;
                    $bank_r->save(false);
                }
                /**
                 * Saving Receipts
                 * Third Entry
                 */
                $DebitEntry = new FinGeneralLedger;
                $DebitEntry->debit = $_POST['amount'];
                $DebitEntry->db_entered = $_POST['amount'];
                /**
                 * Cash
                 */
                if($receipt_type==1){
                    $DebitEntry->debit = $_POST['amount'] -  $_POST['discount'];
                    $DebitEntry->db_entered = $_POST['amount'] -  $_POST['discount'];
                }
                /**
                 * Bank ransfer
                 */
                if($receipt_type==2){
                     $DebitEntry->debit = $_POST['amount'] -  $_POST['bank_amount'];
                     $DebitEntry->db_entered = $_POST['amount'] -  $_POST['bank_amount'];
                }
                 /**
                 * If VAT is entered
                 */
                $DebitEntry->debit -= (float) $_POST['vat_amount'];
                $DebitEntry->db_entered -= (float) $_POST['vat_amount'];

                $DebitEntry->item_description = $_POST['narration'];
                $DebitEntry->narration = $_POST['narration'];
                $DebitEntry->exchange_rate = $_POST['exchange_rate'];
                $DebitEntry->currency = $_POST['currency'];
                /**
                 * Cheque PDC
                 */
                if($receipt_type == 3)
                {
                    $DebitEntry->card_no='XXX';
                    $DebitEntry->auth_code='XXX';
                    $DebitEntry->payment_receipt_type=1;
                    $DebitEntry->amount_type=1;
                    $DebitEntry->credit_amt=1;
                    $DebitEntry->account_id = FinSettings::getAccount(88887); /*Chqeue PDC*/
                    $DebitEntry->cash_amt=1;
                    $DebitEntry->cheque_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['cheque_date'])));
                    $DebitEntry->chk_description = $_POST['amount'];
                    $DebitEntry->chk_no = $_POST['cheque_no'];
                    $DebitEntry->bank_name=$_POST['received_from'];
                    /**
                     * Cash
                     */
                }else if($receipt_type == 1) {
                    $DebitEntry->card_no='XXX';
                    $DebitEntry->auth_code='XXX';
                    $DebitEntry->payment_receipt_type=1;
                    $DebitEntry->amount_type=1;
                    $DebitEntry->credit_amt=1;
                    $DebitEntry->cash_amt=1;
                    $DebitEntry->account_id = $_POST['debit_entry_account']; 
                    $DebitEntry->cheque_date = '1111-11-11';
                    $DebitEntry->chk_description = 'XXX';
                    $DebitEntry->chk_no = 'XXX';

                    /**
                     * Credit debit Card
                     */
                }else if($receipt_type == 5) {
                    $DebitEntry->payment_receipt_type=5;
                    $DebitEntry->amount_type=5;
                    $DebitEntry->card_no=$_POST['card_no'];
                    $DebitEntry->auth_code=$_POST['auth_code'];
                    $DebitEntry->credit_amt=1;
                    $DebitEntry->cash_amt=1;
                    $DebitEntry->account_id = FinSettings::getAccount(88885); 
                    $DebitEntry->cheque_date = '1111-11-11';
                    $DebitEntry->chk_description = 'XXX';
                    $DebitEntry->chk_no = 'XXX';

                    /**
                     * Bank Transfer
                     */
                }else if($receipt_type==2) {
                    $DebitEntry->payment_receipt_type=2;
                    $DebitEntry->amount_type=2;
                    $DebitEntry->credit_amt=1;
                    $DebitEntry->cash_amt=1;
                    $DebitEntry->card_no='XXX';
                    $DebitEntry->auth_code='XXX';
                    $DebitEntry->account_id = $_POST['bank_account_id'];
                    $DebitEntry->cheque_date = '1111-11-11';
                    $DebitEntry->chk_description = 'XXX';
                    $DebitEntry->chk_no = 'XXX';
                    $test_amount=0;
                    $DebitEntry->bank_name=$_POST['bank_account_name'];
                    /**
                    * Cheque CDC
                    */
                }else if($receipt_type == 4){
                    $DebitEntry->card_no='XXX';
                    $DebitEntry->auth_code='XXX';
                    $DebitEntry->payment_receipt_type=4;
                    $DebitEntry->amount_type=4;
                    $DebitEntry->credit_amt=1;
                    $DebitEntry->cash_amt=1;
                    $DebitEntry->account_id = $_POST['cdc_bank_account_id'];
                    $DebitEntry->cheque_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['cheque_date'])));
                    $DebitEntry->chk_description = $_POST['amount'];
                    $DebitEntry->chk_no = $_POST['cheque_no'];
                    $DebitEntry->bank_name=$_POST['cdc_bank_account'];

                }
                $DebitEntry->form_ref_no = $genral_ledger_head->id;
                $DebitEntry->date = $genral_ledger_head->voucher_date;
                $DebitEntry->voucher_no = 'R1/'.$genral_ledger_head->voucher_no;
                $DebitEntry->form_id = 2;
                if($save_type == 2){
                        $DebitEntry->isAllocated = "Y";
                }
                $DebitEntry->save(false);
                if($_POST['header_table_id'] == ''){
                      $form->form_no = $form->form_no+1;
                      $form->save(false);
                }
               
                $jsonData['status'] = 'success';
                $jsonData['form_no'] = $genral_ledger_head->voucher_no;
                $jsonData['id'] = $genral_ledger_head->id;
                echo CJSON::encode($jsonData);
          
        }else{
                 
                    $error2 = json_decode(CActiveForm::validate($genral_ledger_head, '', false), true);
                    $error = CJSON::encode(array_merge_recursive($error1, $error2));

                        if ($error != '[]' )

		               echo $error;
        }
    }
    
     public function actionSavePayment(){
        
          /**
         * Payment Save
         * Author Jo~
         * 
         * General Ledger head Save
         */
        $save_type = Yii::app()->request->getParam('type');
        $error1 = array();
        $form=FinForm::model()->findByPk(4);
        $genral_ledger_head = new FinGeneralLedgerHead;
        if($_POST['header_table_id'] > 0){
            $genral_ledger_head = $genral_ledger_head->findbypk($_POST['header_table_id']);
        }else
            $genral_ledger_head->voucher_no = ($form->form_no+1);
        $genral_ledger_head->voucher_date = date('Y-m-d', strtotime(str_replace('/', '-', $_POST['voucher_date'])));
        $genral_ledger_head->voucher_type = 'P1'; 
        $genral_ledger_head->comment = $_POST['narration'];
        $genral_ledger_head->comment2 = $_POST['narration'];
        $genral_ledger_head->user_id = Yii::app()->user->id;
        $genral_ledger_head->subledger = $_POST['subledger_id'];
        $genral_ledger_head->value = $_POST['amount'];
        
        $genral_ledger_head->receipt_voucher_no      = $_POST['receipt_voucherno'];
        
        $exchange_rate = $_POST['exchange_rate'];
        $currency = $_POST['currency'];
        $receipt_type = $_POST['receipt_type'];
        if($save_type == 2){
            $genral_ledger_head->posted = "Y";
            $genral_ledger_head->dt_posted = date('Y-m-d');
        }
        $valid = $genral_ledger_head->validate();
        /**
         * Validating the POST values
         */
        if($_POST['account_id'] == 0){
             $valid = false;
             $error1[] = 'Account Cannot Blank';
          
        }
        $sub = 0;
        $receipt_type = 1;
        if($_POST['FinGeneralLedger']['description']['havesubledger'] > 0)
            $sub = 1;
        if($sub == 1 && $_POST['subledger_id'] == ''){
            $valid = false;
            $error1[] = 'Subledger Cannot Blank';
        }
        if($_POST['amount'] == ''){
             $valid = false;
             $error1[] = 'Amount Cannot Blank';
        }
        if($receipt_type == 2 && $_POST['bank_account_id'] == ''){
             $valid = false;
             $error1[] = 'Bank Cannot Blank';
        }
         if($receipt_type == 2 && $_POST['bank_amount'] > $_POST['amount'] ){
             $valid = false;
             $error1[] = 'Bank Charges must be less than Amount';
        }
        if($receipt_type == 1 && $_POST['discount'] > $_POST['amount'] ){
             $valid = false;
             $error1[] = 'Discount must be less than Amount';
        }
        if($_POST['vat_amount'] > $_POST['amount'] ){
             $valid = false;
             $error1[] = 'VAT must be less than Amount';
        }
        if( $_POST['discount']+$_POST['vat_amount'] >= $_POST['amount'] ){
             $valid = false;
             $error1[] = 'VAT + Discount must be less than Amount';
        }
        if(($receipt_type == 3 || $receipt_type == 4) && $_POST['cheque_no'] == ''){
             $valid = false;
             $error1[] = 'Cheque No Cannot Blank';
        }
        if($receipt_type == 4 && $_POST['cdc_bank_account_id'] == ''){
             $valid = false;
             $error1[] = 'Bank No Cannot Blank';
        }
        if($receipt_type == 5 && $_POST['card_no'] == ''){
             $valid = false;
             $error1[] = 'Card No Cannot Blank';
        } 
        if($valid){
                $genral_ledger_head->save();
                /**
                 * Single Entry
                 * 
                 */
                FinGeneralLedger::model()->deleteAll(array('condition'=>'voucher_no="P1/'.$genral_ledger_head->voucher_no.'"'));     
                $DebitEntry = new FinGeneralLedger;
                $DebitEntry->date = $genral_ledger_head->voucher_date;
                $DebitEntry->voucher_no = 'P1/'.$genral_ledger_head->voucher_no;
                $DebitEntry->form_ref_no = $genral_ledger_head->id;
                $DebitEntry->account_id = $_POST['account_id'];
                $DebitEntry->amt = $_POST['amount'];
                $DebitEntry->exchange_rate = 1;
                $DebitEntry->amount_type=$receipt_type;
                $DebitEntry->payment_receipt_type =$receipt_type;
                $DebitEntry->given_name = $_POST['fin_givenname'];
                $DebitEntry->subledger = $_POST['subledger_id'];
                $DebitEntry->item_description = $_POST['narration'];
                $DebitEntry->narration = $_POST['narration'];
                $DebitEntry->debit =  $_POST['amount'];
                $DebitEntry->bank_name =  $_POST['received_from'];
                $DebitEntry->db_entered =  $_POST['amount'];
                $DebitEntry->cash_amt=1;
                $DebitEntry->form_id = 4;
                $DebitEntry->cheque_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['cheque_date'])));
                $DebitEntry->chk_description = $_POST['amount'];
                $DebitEntry->chk_no = $_POST['cheque_no'];
                if($receipt_type == 2)
                    $DebitEntry->bank_name=$_POST['bank_account_name'];
                if($receipt_type == 4)
                    $DebitEntry->bank_name=$_POST['cdc_bank_account'];
                $DebitEntry->card_no=$_POST['card_no'];
                $DebitEntry->auth_code=$_POST['auth_code'];
                if($save_type == 2){
                    $DebitEntry->isAllocated = "Y";
                }
                $DebitEntry->save(false);
               
                /**
                 * If Bank Transfer adding Bank Charges
                 */
                if(($receipt_type == 2 && $_POST['bank_amount'] > 0) || ($receipt_type == 2 && $_POST['bank_charge_saved_id'] > 0) ){ 
                    $Bankcharges = new FinGeneralLedger;
                    $Bankcharges->date = $genral_ledger_head->voucher_date;
                    $Bankcharges->voucher_no = 'P1/'.$genral_ledger_head->voucher_no;
                    $Bankcharges->form_ref_no = $genral_ledger_head->id;
                    $Bankcharges->form_id = 2;
                    $Bankcharges->item_description = 'Bank Charges';
                    $Bankcharges->narration = 'Bank Charges';
                    $Bankcharges->description = 'BT';
                    $Bankcharges->credit = $_POST['bank_amount'];
                    $Bankcharges->debit= 0;
                    $Bankcharges->bank_name=$_POST['bank_account_name'];
                    $Bankcharges->amount_type=$receipt_type;
                    $Bankcharges->payment_receipt_type =$receipt_type;
                    $Bankcharges->account_id = FinSettings::getAccount(88888);
                    $Bankcharges->cr_entered = $_POST['bank_amount'];
                    if($save_type == 2){
                        $Bankcharges->isAllocated = "Y";
                    }
                    $Bankcharges->save(false);
                }

                    /**
                     * If Any discount is there
                     */
                    if(($receipt_type == 1 && $_POST['discount'] > 0) || ($receipt_type == 1 && $_POST['discount_id'] > 0) ){ 
                        $Discount = new FinGeneralLedger;
                        $Discount->date = $genral_ledger_head->voucher_date;
                        $Discount->voucher_no = 'P1/'.$genral_ledger_head->voucher_no;
                        $Discount->form_ref_no = $genral_ledger_head->id;
                        $Discount->form_id = 1;
                        $Discount->exchange_rate = $_POST['exchange_rate'];
                        $Discount->currency = $_POST['currency'];
                        $Discount->item_description = 'Discount (Payment)';
                        $Discount->narration = 'Discount (Payment)';
                        $Discount->description = 'DS';
                        $Discount->credit = $_POST['discount'];
                        $Discount->debit = 0;
                        $Discount->amount_type=$receipt_type;
                        $Discount->payment_receipt_type =$receipt_type;
                        $Discount->account_id = FinSettings::getAccount(78884); // discount
                        $Discount->cr_entered = $_POST['discount'];
                        if($save_type == 2){
                            $Discount->isAllocated = "Y";
                        }
                        $Discount->save(false);
                    }

                    /**
                    * VAT Amount
                    */
                    if( $_POST['vat_amount'] > 0 || $_POST['vat_entry_id'] > 0 ){ 
                        $VAT = new FinGeneralLedger;
                        $VAT->date = $genral_ledger_head->voucher_date;
                        $VAT->voucher_no = 'P1/'.$genral_ledger_head->voucher_no;
                        $VAT->form_ref_no = $genral_ledger_head->id;
                        $VAT->form_id = 1;
                        $VAT->exchange_rate = $_POST['exchange_rate'];
                        $VAT->currency = $_POST['currency'];
                        $VAT->item_description = 'VAT';
                        $VAT->narration = 'VAT';
                        $VAT->description = 'VAT';
                        $VAT->credit = $_POST['vat_amount'];
                        $VAT->debit = 0;
                        $VAT->amount_type=$receipt_type;
                        $VAT->payment_receipt_type =$receipt_type;
                        $VAT->account_id = FinSettings::getAccount(55556); //VAT Inbound
                        $VAT->cr_entered = $_POST['vat_amount'];
                        if($save_type == 2){
                            $VAT->isAllocated = "Y";
                        }
                        $VAT->save(false);
                    }

                /**
                 * PDC, CDC, Bank Reconciliation Management
                 * PDC
                 * 2 - Bank
                 * 3 - PDC
                 * 4 - CDC
                 */
                if($receipt_type == 3 ||  $receipt_type == 4){
                    
                    Pdc::model()->deleteAll(array('condition'=>'voucher_no="P1/'.$genral_ledger_head->voucher_no.'"'));    
                    $pdc= new Pdc;
                    $pdc->type = 2;
                    $pdc->voucher_date= $genral_ledger_head->voucher_date;
                    $pdc->apply_date = $DebitEntry->cheque_date;
                    $pdc->voucher_no = 'P1/'.$genral_ledger_head->voucher_no;
                    $pdc->voucher_sub_id = $DebitEntry->id;
                    $pdc->amount = $_POST['amount'];
                    $pdc->narration = $_POST['narration'];
                    $pdc->customer_id = $DebitEntry->subledger;
                    if($receipt_type == 4){
                        $pdc->bank_id = $_POST['cdc_bank_account_id'];
                        $pdc->realisation_date = $DebitEntry->cheque_date;
                        $pdc->posted = "Y";
                        $pdc->cleared = "Y";
                    }
                    $pdc->save(false);
                   
                }
                /*BR*/
                if($receipt_type == 2 || $receipt_type == 3){
                    
                    BankReconciliation::model()->deleteAll(array('condition'=>'voucher_no="P1/'.$genral_ledger_head->voucher_no.'"'));     
                    $bank_r= new BankReconciliation;
                    $bank_r->type = 1;
                    $bank_r->voucher_date=$genral_ledger_head->voucher_date;
                    $bank_r->apply_date=$genral_ledger_head->voucher_date;
                    $bank_r->narration=$_POST['narration'];
                    $bank_r->amount=$_POST['amount'];
                    $bank_r->bank_id=$_POST['bank_account_id'];
                    $bank_r->voucher_no = 'P1/'.$genral_ledger_head->voucher_no;
                    $bank_r->voucher_sub_id = $DebitEntry->id;
                    $bank_r->mode = $receipt_type;
                    $bank_r->save(false);
                }
                /**
                 * Saving Receipts
                 * Third Entry
                 */
                $CreditEntry = new FinGeneralLedger;
                $CreditEntry->credit = $_POST['amount'];
                $CreditEntry->cr_entered = $_POST['amount'];
                /**
                 * Discount
                 */
                if($receipt_type==1){
                    $CreditEntry->credit = $_POST['amount'] -  $_POST['discount'];
                    $CreditEntry->cr_entered = $_POST['amount'] -  $_POST['discount'];
                }
                 /**
                 * Bank Charges
                 */
                if($receipt_type==2){
                    $CreditEntry->credit = $_POST['amount'] -  $_POST['bank_amount'];
                    $CreditEntry->cr_entered = $_POST['amount'] -  $_POST['bank_amount'];
                }

                /**
                * If VAT is entered
                */
                $CreditEntry->credit -= (float) $_POST['vat_amount'];
                $CreditEntry->cr_entered -= (float) $_POST['vat_amount'];

                $CreditEntry->item_description = $_POST['narration'];
                $CreditEntry->narration = $_POST['narration'];
                /**
                 * Cheque PDC
                 */
                if($receipt_type == 3)
                {
                    $CreditEntry->card_no='XXX';
                    $CreditEntry->auth_code='XXX';
                    $CreditEntry->payment_receipt_type=1;
                    $CreditEntry->amount_type=1;
                    $CreditEntry->credit_amt=1;
                    $CreditEntry->account_id = FinSettings::getAccount(88887); /*Chqeue PDC*/
                    $CreditEntry->cash_amt=1;
                    $CreditEntry->cheque_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['cheque_date'])));
                    $CreditEntry->chk_description = $_POST['amount'];
                    $CreditEntry->chk_no = $_POST['cheque_no'];
                    $CreditEntry->bank_name=$_POST['received_from'];
                    /**
                     * Cash
                     */
                }else if($receipt_type == 1) {
                    $CreditEntry->card_no='XXX';
                    $CreditEntry->auth_code='XXX';
                    $CreditEntry->payment_receipt_type=1;
                    $CreditEntry->amount_type=1;
                    $CreditEntry->credit_amt=1;
                    $CreditEntry->cash_amt=1;
                    $CreditEntry->account_id = $_POST['payment_account_id']; 
                    $CreditEntry->cheque_date = '1111-11-11';
                    $CreditEntry->chk_description = 'XXX';
                    $CreditEntry->chk_no = 'XXX';

                    /**
                     * Credit debit Card
                     */
                }else if($receipt_type == 5) {
                    $CreditEntry->payment_receipt_type=5;
                    $CreditEntry->amount_type=5;
                    $CreditEntry->card_no=$_POST['card_no'];
                    $CreditEntry->auth_code=$_POST['auth_code'];
                    $CreditEntry->credit_amt=1;
                    $CreditEntry->cash_amt=1;
                    $CreditEntry->account_id = FinSettings::getAccount(88885); 
                    $CreditEntry->cheque_date = '1111-11-11';
                    $CreditEntry->chk_description = 'XXX';
                    $CreditEntry->chk_no = 'XXX';

                    /**
                     * Bank Transfer
                     */
                }else if($receipt_type==2) {
                    $CreditEntry->payment_receipt_type=2;
                    $CreditEntry->amount_type=2;
                    $CreditEntry->credit_amt=1;
                    $CreditEntry->cash_amt=1;
                    $CreditEntry->card_no='XXX';
                    $CreditEntry->auth_code='XXX';
                    $CreditEntry->account_id = $_POST['bank_account_id'];
                    $CreditEntry->cheque_date = '1111-11-11';
                    $CreditEntry->chk_description = 'XXX';
                    $CreditEntry->chk_no = 'XXX';
                    $CreditEntry->bank_name=$_POST['bank_account_name'];
                    /**
                    * Cheque CDC
                    */
                }else if($receipt_type == 4){
                    $CreditEntry->card_no='XXX';
                    $CreditEntry->auth_code='XXX';
                    $CreditEntry->payment_receipt_type=4;
                    $CreditEntry->amount_type=4;
                    $CreditEntry->credit_amt=1;
                    $CreditEntry->cash_amt=1;
                    $CreditEntry->account_id = $_POST['cdc_bank_account_id'];
                    $CreditEntry->cheque_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['cheque_date'])));
                    $CreditEntry->chk_description = $_POST['amount'];
                    $CreditEntry->chk_no = $_POST['cheque_no'];
                    $CreditEntry->bank_name=$_POST['cdc_bank_account'];

                }
                $CreditEntry->form_ref_no = $genral_ledger_head->id;
                $CreditEntry->date = $genral_ledger_head->voucher_date;
                $CreditEntry->voucher_no = 'P1/'.$genral_ledger_head->voucher_no;
                $CreditEntry->form_id = 4;
                if($save_type == 2){
                        $CreditEntry->isAllocated = "Y";
                }
                $CreditEntry->save(false);
                if($_POST['header_table_id'] == ''){
                      $form->form_no = $form->form_no+1;
                      $form->save(false);
                }
               
                $jsonData['status'] = 'success';
                $jsonData['form_no'] = $genral_ledger_head->voucher_no;
                $jsonData['id'] = $genral_ledger_head->id;
                echo CJSON::encode($jsonData);
          
        }else{
                 
                    $error2 = json_decode(CActiveForm::validate($genral_ledger_head, '', false), true);
                    $error = CJSON::encode(array_merge_recursive($error1, $error2));

                        if ($error != '[]' )

		               echo $error;
        }
    }
    
    public function actionGetAllocationlist(){
            
        $model=new FinVoucherAllocationHead;
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
        // datatable column index  => database column name
            0 => 'id',
            1 => 'alloc_date',
            2 => 'main',
            3 => 'subledger',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
        $condition = 't.isActive="Y"';
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
            $searchString = $_POST['search']['value'];
            $condition.=" AND (t.policy LIKE '%".$searchString."%' OR t.vouchers LIKE '%".$searchString."%' OR t.id LIKE '%".$searchString."%')";
        }
        $count = $model->with('sub','account')->count(array('condition'=>$condition));
        $model = $model->with('sub','account')->findAll(array('condition'=>$condition ,'limit'=>$limit,'offset'=>$offset,'order'=>'t.id DESC'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        foreach ($model as $i => $row)
        {
            if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["fin_alloc_print"])){ 
                $div = '<a class="btn btn-primary btn-xs" title="Print" target="_blank" href="index.php?r=finance/AllocationPrint&id=' . $row['id'] .' "><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';
            }
            if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["fin_alloc_unallocate"])){ 
                $div .= ' <button class="btn btn-danger btn-xs" onclick="unallocate('.$row['id'].')"><i class="fa fa-trash-o "></i></button>';
            }
            $rowData[]=array($row['id'],date("d/m/Y",strtotime($row['alloc_date'])),$row['account']['description'],$row['sub']['description'],'<div class="btn-wrap text-center">'.$div.'</div>');
        }
        $data['data'] = $rowData;
        echo json_encode($data);   
    }
    
     public function actionSavePaymentAllocation()
    {
        $count=$_POST['count'];
        $count1=$_POST['count1'];
        if($_POST['credit_total_amount']!=0 && $_POST['debit_total_amount']!=0){
            if($_POST['credit_total_amount']==$_POST['debit_total_amount']){
                $SQL = "SELECT max(allocation_id) as allocate_id from crm_fin_voucher_allocation";
                $allocate = Yii::app()->db->createCommand($SQL)->queryAll();
                if(empty($allocate))
                {
                    $allocate_id='';
                }else{
                    foreach($allocate as $row_allocate)
                    {
                        $allocate_id=$row_allocate['allocate_id'];
                    }
                }
                $head=new FinVoucherAllocationHead;
                $head->id=$allocate_id+1;
                $head->credit=$_POST['credit_total_amount'];
                $head->debit=$_POST['debit_total_amount'];
                $head->vouchers='';
                $head->policy='';
                $head->subledger=$_POST['credit_subledger_sub_0'];
                $head->main=$_POST['debit_subledger_0'];
                $model=new FinVoucherAllocation;
                $model->allocate_date=date('Y-m-d');
                $model->voucher_type=1;
                $model->allocation_id=$allocate_id+1;
                $model->subledger=$_POST['credit_subledger_sub_0'];
                $model->account_id=$_POST['debit_subledger_0'];
                $model->voucher_no='123';
                if($model->validate())
                {    
                    for($i=0;$i<$count;$i++)
                    {
                        $model_new = new FinVoucherAllocation;
                        $model_new->allocation_id=$allocate_id+1;
                        $model_new->subledger=$_POST['credit_subledger_sub_0'];
                        $model_new->account_id=$_POST['debit_subledger_0'];
                        $model_new->allocate_date=date('Y-m-d');
                        $model_new->voucher_type=1;
                        $model_new->voucher_no=$_POST["allocate_voucher_$i"];
                        $model_new->invoice_id=$_POST["invoice_no_$i"];
                        $model_new->policy_no=$_POST["policy_no_$i"];
                        $model_new->credit_opening_amount=$_POST["credit_$i"];
                        $model_new->credit_allocate_amount=$_POST["credit_allocate_amount_$i"];
                        $model_new->debit_opening_amount=$_POST["debit_$i"];
                        $model_new->debit_allocate_amount=$_POST["debit_allocate_amount_$i"];
                        $model_new->due_date=$_POST["due_date_$i"];
                        if(($model_new->credit_allocate_amount!=0 && $model_new->credit_allocate_amount!='')|| ($model_new->debit_allocate_amount!=0 && $model_new->debit_allocate_amount!=''))
                        {
                            $model_new->save();
                            $finledger=FinGeneralLedger::model()->findByPk($_POST["invoice_no_$i"]);
                            if($model_new->credit_allocate_amount!=0)
                            {
                                $finledger->allocation_amount+=$model_new->credit_allocate_amount;
                            }else{
                                $finledger->allocation_amount+=$model_new->debit_allocate_amount;    
                            }
                            $finledger->save(false);
                        }
                    }
                    for($j=0;$j<$count1;$j++)
                    {
                        $model_new = new FinVoucherAllocation;
                        $model_new->allocation_id=$allocate_id+1;
                        $model_new->subledger=$_POST['credit_subledger_sub_0'];
                        $model_new->account_id=$_POST['debit_subledger_0'];
                        $model_new->allocate_date=date('Y-m-d');
                        $model_new->voucher_type=1;
                        $model_new->voucher_no=$_POST["allocate_voucher_sub_$j"];
                        $model_new->invoice_id=$_POST["invoice_no_sub_$j"];
                        $model_new->policy_no=$_POST["policy_no_sub_$j"];
                        $model_new->credit_opening_amount=$_POST["credit_sub_$j"];
                        $model_new->credit_allocate_amount=$_POST["credit_allocate_amount_sub_$j"];
                        $model_new->debit_opening_amount=$_POST["debit_sub_$j"];
                        $model_new->debit_allocate_amount=$_POST["debit_allocate_amount_sub_$j"];
                        $model_new->due_date=$_POST["due_date_sub_$j"];
                        if(($model_new->credit_allocate_amount!=0 && $model_new->credit_allocate_amount!='')|| ($model_new->debit_allocate_amount!=0 && $model_new->debit_allocate_amount!=''))
                        {
                            $model_new->save();
                            $finledger=FinGeneralLedger::model()->findByPk($_POST["invoice_no_sub_$j"]);
                        if($model_new->credit_allocate_amount!=0)
                        {
                            $finledger->allocation_amount+=$model_new->credit_allocate_amount;
                        }
                        else {
                            $finledger->allocation_amount+=$model_new->debit_allocate_amount;    
                        }
                            $finledger->save(false);
                        }
                    }
                    $head->alloc_date=date('Y-m-d');
                    $head->isActive='Y';
                    $head->save();
                    $user=Yii::app()->user->id;
                    $sql="UPDATE crm_fin_voucher_allocation_head S INNER JOIN (SELECT allocation_id,GROUP_CONCAT(I.policy_no) pno,GROUP_CONCAT(I.voucher_no) vno FROM crm_fin_voucher_allocation I GROUP BY I.allocation_id) AS I ON S.id = I.allocation_id SET S.policy = I.pno,S.vouchers=I.vno,S.user_id=$user where S.id=$head->id";
                    Yii::app()->db->createCommand($sql)->execute();
                    if(!empty($_POST['payment_voucher_number']))
                    {
                        $update_payment=FinGeneralLedgerHead::model()->findByPk($_POST['payment_voucher_number']);    
                        $head_new=FinVoucherAllocationHead::model()->findByPk($head->id);
                        $type=$update_payment->voucher_type;
                        $no=$update_payment->voucher_no;
                        $all_id=$head_new->id;
                        $new_narration='<br>';
                        $all=FinVoucherAllocation::model()->findAll(array('condition'=>'allocation_id='.$all_id.' AND voucher_no!="'.$type.'/'.$no.'"'));
                        foreach($all as $eachItem)
                        {
                            $amt=($eachItem->debit_allocate_amount)+($eachItem->credit_allocate_amount);
                            $new_narration.= $eachItem->voucher_no.' :  AED '.$amt.'<br>';   
                        }
                        $sql1="UPDATE crm_fin_general_ledger set narration='".$new_narration."',item_description='".$update_payment->comment."' where form_ref_no=".$update_payment->id;
                        Yii::app()->db->createCommand($sql1)->execute();
                    }
                    $jsonData['table1']='
                                <div id="account-list-table1">
                                <table class="rt ctr">
                                        <tr>
                                                <th class="cell-ctr">No</th>
                                                <th class="cell-ctr">Voc No</th>
                                                <th class="cell-ctr">Inv/Ref No</th>
                                                <th class="cell-ctr">Open Amt</th>
                                                <th class="cell-ctr">Credit Amt</th>
                                                <th class="cell-ctr">Due Date</th>
                                        </tr>

                                </table>
                                    <ul class="ul-12">
                                        <li class="li-6"><button class="btn-1">Credit Total</button></li>
                                        <li class="li-6"><input type="text" class="from-control"></li>
                                </ul>
                                </div>

                                <div class="clearfix"></div>';

                                 $jsonData['table']='<div id="account-list-table">
                                <table class="rt ctr">
                                        <tr>
                                                <th class="cell-ctr">No</th>
                                                <th class="cell-ctr">Voc No</th>
                                                <th class="cell-ctr">Voc Dt</th>
                                                <th class="cell-ctr">Inv/Ref No</th>
                                                <th class="cell-ctr">Open Amt</th>
                                                <th class="cell-ctr">Debit Amt</th>
                                                <th class="cell-ctr">Due Date</th>
                                        </tr>
                                </table>
                                    <ul class="ul-12">
                                        <li class="li-6"><button class="btn-1">Debit Total</button></li>
                                        <li class="li-6"><input type="text" class="from-control"></li>
                                </ul>
                                </div>
                 <div class="clearfix"></div>';
                $jsonData['status'] = 'success';
                $jsonData['id'] = $model_new->allocation_id;
                echo CJSON::encode($jsonData);
            }else{
                $error = CActiveForm::validate($model, '', false);
                            if ($error != '[]')
                                echo $error;
            }
    }else {
                $jsonData['status'] = 'Totals are not equal';
                        echo CJSON::encode($jsonData);
    }
  }else{
            $jsonData['status'] = 'Please Check the Total Amount';
            echo CJSON::encode($jsonData);
  }
}

  public function actionGetPaymentAllocation()
    {
    $type=Yii::app()->request->getparam('type');
    $account=$_POST['accounts'];
    $subledger=$_POST['subledger1'];
    $date_from=$_POST['from_allocation_date'];
    $date_to=$_POST['to_allocation_date'];
    $debit_inv=$_POST['debit_inv'];
    $debit_voucher=$_POST['debit_voucher'];
    if(isset($_POST['sort']))
    {
    $sort= $_POST['sort'];   
    }
    Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
    $this->renderPartial('/finance/_allocate_display', array('from'=>$date_from,'to'=>$date_to,'account'=>$account,'subledger'=>$subledger,'sort'=>$sort,'debit_inv'=>$debit_inv,'debit_voucher'=>$debit_voucher,'type' => $type), false, true);
    }
    public function actionGetPaymentAllocation1()
    {
    $account=$_POST['accounts1'];
    $subledger=$_POST['subledger'];
    $date_from=$_POST['from_allocation_date1'];
    $date_to=$_POST['to_allocation_date1'];
    $credit_inv=$_POST['credit_inv'];
    $credit_voucher=$_POST['credit_voucher'];
    if(isset($_POST['sort']))
    {
    $sort= $_POST['sort'];   
    }
    Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
    $this->renderPartial('/finance/_allocate_display1', array('from'=>$date_from,'to'=>$date_to,'subledger'=>$subledger,'account'=>$account,'sort'=>$sort,'credit_inv'=>$credit_inv,'credit_voucher'=>$credit_voucher), false, true);
    }
    public function actionAllocationPrint() {
        $allocation_id=Yii::app()->request->getParam('id');
        $allocation = FinVoucherAllocation::model()->find(array('condition'=>'allocation_id='.$allocation_id));
        ini_set("memory_limit", -1);
        ini_set('max_execution_time', 1000);
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $mPDF1->SetWatermarkImage(Yii::app()->baseUrl . '/images/logo/200150_' . MasCompany::model()->findbyPK(Yii::app()->user->master_user_company_id)->company_logo);
        $mPDF1->showWatermarkImage = true;
        $mPDF1->watermarkImageAlpha = 0.09;
//        $mPDF1->AddPage('L');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_for_single.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        if($allocation->voucher_type==1)
        {
        $mPDF1->WriteHTML($this->renderPartial("application.views.front.pdf.allocateprint", array('id'=>$allocation_id), true));
        }
        else {
        $mPDF1->WriteHTML($this->renderPartial("application.views.front.pdf.allocateprint1", array('id'=>$allocation_id), true));    
        }
        $mPDF1->Output('allocation.pdf', 'I');
    }
        public function actionUnallocTransaction()
    {
     $id=Yii::app()->request->getparam('id');
     $allocation=FinVoucherAllocation::model()->findAll(array('condition'=>'allocation_id='.$id));
     $var='';
     foreach ($allocation as $row)
     {
     $voucher=FinGeneralLedger::model()->findByPk($row->invoice_id);   
   
         $bal=$row->debit_allocate_amount+$row->credit_allocate_amount;    
         if($voucher->allocation_amount > 0) 
             {
                $voucher->allocation_amount=$voucher->allocation_amount-$bal;
         }
         else if($voucher->allocation_amount < 0)
         {
                $voucher->allocation_amount=$voucher->allocation_amount+$bal;      
         }
     $voucher->save(false);
     
     }
     $sql="INSERT INTO crm_fin_voucher_allocation_head_delete(id,alloc_date,main,subledger,vouchers,policy,credit,debit,isActive,user_id) SELECT id,alloc_date,main,subledger,vouchers,policy,credit,debit,isActive,user_id FROM crm_fin_voucher_allocation_head where id=".$id;
     Yii::app()->db->createCommand($sql)->execute();
     $user=Yii::app()->user->id;
     $sql1="UPDATE crm_fin_voucher_allocation_head_delete set delete_user_id=".$user;
     Yii::app()->db->createCommand($sql1)->execute();
     FinVoucherAllocation::model()->deleteAll(array('condition'=>'allocation_id='.$id));
     FinVoucherAllocationHead::model()->deleteByPk($id);
//     if($model->save())
//     {
         $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
            Yii::app()->end();
//     }
    }
    public function actionBankreconciliation(){
       
         Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
         $this->renderPartial('bankreconciliation', array(), false, true);
    }
    
    public function actionSearchreconciliation(){
        $date_from  =  date("Y-m-d", strtotime(str_replace('/', '-', $_POST['reconciliation_date_from'])));
        $date_to    =  date("Y-m-d", strtotime(str_replace('/', '-', $_POST['reconciliation_date_to'])));
        $bank    =  $_POST['fin_account_id_new'];
        $type =  $_POST['type'];
        $con = 'apply_date BETWEEN  "'.$date_from.'" AND "'.$date_to.'"';
        if($type > 0)
            $con .= ' AND mode='.$type;  
        $bank_r=BankReconciliation::model()->findAll(array('condition'=>$con));
            $table = '<table class="table table-hover table-bordered personal-task">
     <tr>
        <th>Date</th>
        <th>Voucher No</th>
        <th>Type</th>
        <th>Cheque No./Ref</th>
        <th>Received/Paid From</th>
        <th>Deposit</th>
        <th>Withdrawal</th>
        <th>Reconcile Date</th>
    </tr>';
        $total_deb = $total_cre = 0;
        if(!empty($bank_r)){
                foreach ($bank_r as $i=>$row)
                {
                  
                     if($row['bank_date'] != '0000-00-00'){
                            $date = date('d/m/Y', strtotime($row['bank_date'])); 
                            $class = 'bg-danger';
                     }else{ 
                            $date = date('d/m/Y');
                            $class = '';
                     }
                    $ledger = FinGeneralLedger::model()->find(array('condition' => 'voucher_no="'.$row->voucher_no.'"'));
                    $table .= '<tr class = "'.$class.'" >';
                        $table .= '<td>'.CHtml::hiddenfield('Row['.$i.'][id]',$row->id).date("d/m/Y",strtotime($row->apply_date)).'</td>';
                        $table .= '<td>'.$row->voucher_no.'</td>';
                        if($row->type == 1){
                            $type = 'Receipt';
                            $debit = $row->amount;
                            $credit = 0;
                        }else{
                            $type = 'Payment';
                            $debit = 0;
                            $credit = $row->amount;
                        }
                        $table .= '<td>'.$type.'</td>';
                        $table .= '<td>'.$ledger->chk_no.'</td>';
                        $table .= '<td>'.$ledger->bank_name.'</td>';
                        $table .= '<td>'.number_format($debit, 2, '.', '').'</td>';
                        $table .= '<td>'.number_format($credit, 2, '.', '').'</td>';
                       
                        $table .= '<td>'.CHtml::textfield('Row['.$i.'][date]', $date,array('class' => 'datepicker form-control go')).'</td>';
                    $table .= '</tr>';
                    $total_deb  +=  $debit;
                    $total_cre  +=  $credit;
                }
                 $table .= '<tr class="bg-success"><td colspan="5" class="text-right">Total</td><td>'.number_format($total_deb, 2, '.', '').'</td><td>'.number_format($total_cre, 2, '.', '').'</td><td></td></tr>';
        }else{
              $table .= '<tr>';
                      $table .= '<td colspan="8" class="text-center">No Data</td>';
              $table .= '</tr>';
        }

            $table .= '</table>';
        
        
        echo $table;
        
    }
    
    public function actionUpdatereconciliation(){
        if(is_array($_POST['Row'])){
            foreach ($_POST['Row'] as $each){
                if($each['id'] > 0){
                    $model = BankReconciliation::model()->findBypk($each['id']);
                    $model->bank_date = date("Y-m-d", strtotime(str_replace('/', '-', $each['date'])));
                    $model->cleared = "Y";
                    $model->save(false);
                }
            }
            echo 'success';
        }else{
           echo 'fail';
        }
        
    }
    
     public function actionBankreconciliationhistory(){
       
         Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
         $this->renderPartial('bankreconciliation_history', array(), false, true);
    }
     public function actionSearchreconciliationhistory(){
         $date_from  =  date("Y-m-d", strtotime(str_replace('/', '-', $_POST['reconciliation_date_from'])));
        $date_to    =  date("Y-m-d", strtotime(str_replace('/', '-', $_POST['reconciliation_date_to'])));
        $bank    =  $_POST['fin_account_id_new'];
        $type =  $_POST['type'];
        $con = 'cleared="Y" AND apply_date BETWEEN  "'.$date_from.'" AND "'.$date_to.'"';
        if($type > 0)
            $con .= ' AND mode='.$type;  
        $bank_r=BankReconciliation::model()->findAll(array('condition'=>$con));
            $table = '<table class="table table-hover table-bordered personal-task">
     <tr>
        <th>Date</th>
        <th>Voucher No</th>
        <th>Type</th>
        <th>Cheque No./Ref</th>
        <th>Received/Paid From</th>
        <th>Deposit</th>
        <th>Withdrawal</th>
        <th>Reconcile Date</th>
    </tr>';
        $total_deb = $total_cre = 0;
        if(!empty($bank_r)){
                foreach ($bank_r as $i=>$row)
                {
                  
                    
                    $ledger = FinGeneralLedger::model()->find(array('condition' => 'voucher_no="'.$row->voucher_no.'"'));
                    $table .= '<tr>';
                        $table .= '<td>'.CHtml::hiddenfield('Row['.$i.'][id]',$row->id).date("d/m/Y",strtotime($row->apply_date)).'</td>';
                        $table .= '<td>'.$row->voucher_no.'</td>';
                        if($row->type == 1){
                            $type = 'Receipt';
                            $debit = $row->amount;
                            $credit = 0;
                        }else{
                            $type = 'Payment';
                            $debit = 0;
                            $credit = $row->amount;
                        }
                        $table .= '<td>'.$type.'</td>';
                        $table .= '<td>'.$ledger->chk_no.'</td>';
                        $table .= '<td>'.$ledger->bank_name.'</td>';
                        $table .= '<td>'.number_format($debit, 2, '.', '').'</td>';
                        $table .= '<td>'.number_format($credit, 2, '.', '').'</td>';
                        if($row['bank_date'] != '0000-00-00')
                            $date = date('d/m/Y', strtotime($row['bank_date'])); 
                        else 
                            $date = date('d/m/Y');
                        $table .= '<td>'.CHtml::textfield('Row['.$i.'][date]', $date,array('class' => 'datepicker form-control go')).'</td>';
                    $table .= '</tr>';
                    $total_deb  +=  $debit;
                    $total_cre  +=  $credit;
                }
                 $table .= '<tr class="bg-success"><td colspan="5" class="text-right">Total</td><td>'.number_format($total_deb, 2, '.', '').'</td><td>'.number_format($total_cre, 2, '.', '').'</td><td></td></tr>';
        }else{
              $table .= '<tr>';
                      $table .= '<td colspan="8" class="text-center">No Data</td>';
              $table .= '</tr>';
        }

            $table .= '</table>';
        
        
        echo $table;
        
    
    }
     public function actionFetchparentfeatures()
    {
    	$parent = $_POST['parent_account'];
        $data = array();
        if($parent > 0){
            $FinAccount = FinAccounts::model()->findByPk($parent);
            $data['account_type']  = $FinAccount->account_type;
            $data['credit_type']  = $FinAccount->credit_type;
            $data['routes']  = $FinAccount->routes.','.$FinAccount->id;
            if($FinAccount->routes == '')
                $data['routes']  = $FinAccount->id;
            $data['status']  = 'success';
        }
    	echo CJSON::encode($data);
    	
    }
    
    public function actionPreYearClosing()
    {
        $model = new FinanceYearClose;
    	Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('pre_audit_closing_form', array('model' => $model), false, true);    
    }
     public function actionSavePreAuditClose()
    {
        if($_POST['FinanceYearClose']['year']==null)
        {
            $jsonData['status'] = 'Year cannot be blank.';
        }
        if(($_POST['FinanceYearClose']['year']!=null))
        {
            $year=$_POST['FinanceYearClose']['year'];
            $year_next=$year+1;
            if($year>0)
            {
                $fin_month = Yii::app()->user->fin_year; 
                if($fin_month == 1){
                    $from_date = $year.'-01-01';
                    $end_date = $year.'-12-31';
                }else{
                    $from_date = $year.'-04-01';
                    $end_date = $year_next.'-03-31';
                }
                
                $sql1="delete from crm_fin_general_ledger where (date between '$from_date' AND '$end_date') AND (account_id=".FinSettings::getAccount(44444)." OR account_id=".FinSettings::getAccount(44445).")";
                Yii::app()->db->createCommand($sql1)->execute();
                $SQL =  "SELECT SUM(L.credit-L.debit) FROM crm_fin_general_ledger AS L 
                        INNER JOIN  crm_fin_accounts AS A ON A.id=L.account_id where A.account_type='I' 
                        AND L.date between '$from_date' AND '$end_date' AND isAllocated='Y'";
                $income=Yii::app()->db->createCommand($SQL)->queryScalar();
                $SQL1 = "SELECT SUM(L.debit-L.credit) FROM crm_fin_general_ledger AS L 
                         INNER JOIN crm_fin_accounts AS A ON A.id=L.account_id where A.account_type='E' 
                         AND L.date between '$from_date' AND '$end_date' AND isAllocated='Y'";
                $exp=Yii::app()->db->createCommand($SQL1)->queryScalar();
                $bal=$income-$exp;
                $sql = "INSERT INTO crm_fin_general_ledger(isAllocated,account_id,voucher_no,date,narration,chk_description,chk_no,cheque_date,exchange_rate,credit) VALUES('Y','".FinSettings::getAccount(44444)."','YC/$year','$end_date','Current Year Profit & Loss $year','XXX','XXX','1111-11-11','1.00',$bal)";
                Yii::app()->db->createCommand($sql)->execute();  
                $sql = "INSERT INTO crm_fin_general_ledger(isAllocated,account_id,voucher_no,date,narration,chk_description,chk_no,cheque_date,exchange_rate,debit) VALUES('Y','".FinSettings::getAccount(44445)."','YC/$year','$end_date','Current Year Profit & Loss $year','XXX','XXX','1111-11-11','1.00',$bal)";
                Yii::app()->db->createCommand($sql)->execute();
                $jsonData['status'] = 'success';
            }
    
    }
    echo CJSON::encode($jsonData);
    }
    public function actionFinalYearClosing()
    {
    
        $this->render('final_year_closing_list');    
    }
    
    public function actionGetallclosedyears(){
        $model=new FinanceYearClose;
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
        // datatable column index  => database column name
            0 => 'id',
            1 => 'year',
            2 => 'id',
         
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
        $condition = '1=1';
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
            $searchString = $_POST['search']['value'];
            $condition.=" AND (year LIKE '%".$searchString."%')";
        }
        $count = $model->count(array('condition'=>$condition));
        $model = $model->findAll(array('condition'=>$condition ,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        foreach ($model as $i => $row)
        {
           // if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["fin_alloc_print"])){ 
                $div = '<a href ="#" class="btn btn-danger btn-xs" onclick="deleteyear('.$row['id'].')"><i class="fa fa-trash-o "></i></a>';
          //  }
            $rowData[]=array(($i+1),$row['year'],'<div class="btn-wrap text-center">'.$div.'</div>');
        }
        $data['data'] = $rowData;
        echo json_encode($data);   
    }
    public function actionFinalauditclose(){
        $model = new FinanceYearClose;
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('final_year_closing_form', array('model' => $model), false, true);
    }
    public function actionDeleteYear()
    {
     $id=Yii::app()->request->getParam('id');
     FinanceYearClose::model()->deleteByPk($id);
     $jsonData['status'] = 'success';
    }
    public function actionSaveFinalYearClosing()
    {
        if($_POST['FinanceYearClose']['year']==null)
        {
        $jsonData['status'] = 'Year cannot be blank.';
        }
        else {
            $fin_month = Yii::app()->user->fin_year; 
            if($fin_month == 1){
                $from_date = $year.'-01-01';
                $end_date = $year.'-12-31';
            }else{
                $from_date = $year.'-04-01';
                $end_date = $year_next.'-03-31';
            }
                
            $year=$_POST['FinanceYearClose']['year'];
            $last_year=$year-1;
            $next_year=$year+1;
            $model= new FinanceYearClose();
            $model1=FinanceYearClose::model()->find(array('condition'=>'year='.$year));
            if($model1->year>0)
            {
            $jsonData['status'] = 'Year already closed.';    
            }
            else {
                $model2=FinanceYearClose::model()->find(array('condition'=>'year='.$last_year));
                if($model2->id>0)
                {
                    $model3=FinGeneralLedger::model()->find(array('condition'=>'account_id='.FinSettings::getAccount(44444).' AND date between "'.$from_date.'" AND "'.$end_date.'"'));
                    if($model3->id>0)
                    {
                        $model->year=$_POST['FinanceYearClose']['year'];
                        $model->save();
                        $jsonData['status'] = 'success';     
                    }
                    else {
                        $jsonData['status'] = 'Pre Audit not closed';    
                    }   
                }
                else {
                    $jsonData['status'] = 'Previous year not closed.';
                }
            }
        }
         echo CJSON::encode($jsonData);
    }
    public function actionTrialBalSort()
    {
     Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('//finance/trial_bal_sort', array(), false, true);    
    }
    public function actionFetChchild() {
        $accounts = FinAccounts::model()->findAll(array('condition'=>'parent_account='.(int) $_POST['listname'],'order'=>'sort_order'));
        $jsondata['list']='<table><tr><th>Accounts</th><th>Sort Order</th></tr>';
        foreach ($accounts as $i=>$row)
        {
        $jsondata['list'].='<tr><td>'.$row->description.'</td><td>'.CHtml::textField('child_list['.$i.']',$row->sort_order).CHtml::hiddenField('child['.$i.']',$row->id).'</td></tr>';
        }
        $jsondata['list'].='</table>';
        $jsondata['list'].=CHtml::hiddenField('count',$i);
        $jsondata['status']='success';
        echo CJSON::encode($jsondata);
    }
     public function actionEditSortOrder()
    {
    if(isset($_POST['accounts']) && isset($_POST['level']))
    {
    $accounts = FinAccounts::model()->findAll(array('condition'=>'account_type="'.$_POST['accounts'].'" AND level='.(int)$_POST['level']));
    $accounts=CHtml::listData($accounts,'id','description');
        $jsondata['list']=CHtml::dropDownList('listname','', 
                        $accounts,  array('prompt'=>'select one','onChange'=>'getChildAccounts(2)','data-label' => 'Accounts'));
    $jsondata['status']='success';
    echo CJSON::encode($jsondata);
    }
else {
    $jsondata['status']='fail';
        echo CJSON::encode($jsondata);

}    
    }
     public function actionSaveSortOrder()
    {
    if(isset($_POST['child']))
    {
    $count=$_POST['count'];
    for($i=0;$i<=$count;$i++)
    {
    $account=FinAccounts::model()->findByPk($_POST['child'][$i]);
    $account->sort_order=$_POST['child_list'][$i];  
    $account->save(false);
    }
    $jsonData['status'] = 'success';
    echo CJSON::encode($jsonData);
    }
    else {
    $jsonData['status'] = 'fail';
    echo CJSON::encode($jsonData);
    }
    }

    /**Outstanding invoices */

    public function actionOutstandinginvoices()
    {
        $this->render('outstanging_invoices');
    }

    public function actionGetoutstandinginvoicelist(){
        $model=new FinOutstandingInvoices();
        $draw   = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
               
                // 0=> 'id',
                // 1 =>'customer_details.customer_name',
                // 2=> 'invoice_date',
                // 3=> 'posted',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy      = $filterColumn." ".$filterOrder;
        $condition = '1=1';
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
            $searchString = $_POST['search']['value'];
            $condition = " invoice_reference LIKE '%".$searchString."%' OR customer_details.customer_name LIKE '%".$searchString."%' OR vendor_details.vendor_name like '%".$searchString."%'";
        }
        $model = $model->with('customer_details')->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'t.id desc'));
        $count = count($model);
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        foreach ($model as $i=>$row)
        {                 
            $div = '';
            if($row['synced'] == 'N'){
                $div .='<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'finance/addoutstandinginvoice&type=create&id='.$row['id'].'\',\'Edit -'.$row['id']."/".$row['invoice_reference'].'\',\'xl\')" title="Edit"><i class="fa fa-edit"></i></button>'; 
            }else{
                $div .='<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'finance/addoutstandinginvoice&type=view&id='.$row['id'].'\',\'Edit -'.$row['id']."/".$row['invoice_reference'].'\',\'xl\')" title="View"><i class="fa fa-eye"></i></button>'; 
            }
            
            $rowData[]=array(($i+1),$row['invoice_reference'],date("d/m/Y",strtotime($row['invoice_date'])),FinOutstandingInvoices::getname($row),'<div class="text-right">'.$row['amount'].'</div>',$row['synced'],'<div class="btn-wrap text-center">'.$div.'</div>');
                        
                      }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionAddoutstandinginvoice() {
        $id = Yii::app()->request->getParam('id');
        $type = Yii::app()->request->getParam('type');
        $model = new FinOutstandingInvoices;
        if($id > 0){
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('outstanding_invoice_create',array('model' => $model,'type' =>  $type));
    }


    public function actionGetallcustomersandvendors(){
        
        $searchTerm = $_GET['term'];
        $allcustomers = Customer::model()->findAll(array('select' => 'customer_name,id','condition' => 'customer_name LIKE "%' . $searchTerm . '%"'));
        $data = array();
        $last = 0;
        foreach( $allcustomers as $i => $each){
            $data[$i]['value'] = $each->id;
            $data[$i]['label'] = $each->customer_name;
            $data[$i]['other'] = 1;
            $last = $i;
        }
        foreach( $allvendors as $i => $each){
            $data[($i+$last)]['value'] = $each->id;
            $data[($i+$last)]['label'] = $each->vendor_name;
            $data[($i+$last)]['other'] = 2;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
        
    }

    public function actionSaveoutstandingreceipt(){
        $model = new FinOutstandingInvoices;
        if(isset($_POST['FinOutstandingInvoices'])){
                if($_POST['FinOutstandingInvoices']['id'] > 0)
                    $model =  $model->findbypk($_POST['FinOutstandingInvoices']['id']);
                else{
                    $model->created_by = Yii::app()->user->id;
                    $model->created_date_time = date('Y-m-d H:i:s');
                }
                $model->attributes = $_POST['FinOutstandingInvoices'];
                $model->customer_vendor_type = $_POST['FinOutstandingInvoices']['customer_vendor_type'];
                if($_POST['FinOutstandingInvoices']['invoice_date'] != '')
                {   
                    $model->invoice_date = str_replace('/', '-',$_POST['FinOutstandingInvoices']['invoice_date']);
                    $model->invoice_date = date("Y-m-d", strtotime($model->invoice_date));
                }
                if( $model->validate() ){
                    $model->save();
                    $jsonData['status'] = 'success';   
                    echo CJSON::encode($jsonData);  

                }else{
                    $error = CActiveForm::validate($model, '', false);
                    if ($error != '[]')
                        echo $error;
                }
        }
    }

    public function actionSyncinvoices(){

            /**
             * Legeder Adding Function
             * 
             * */
            function addLedger($form_ref_no,$account_id,$subledger,$voucher_no,$narration,$debit = 0,$credit=0,$type){
                $Ledger = new FinGeneralLedger;
                $Ledger->date = date('Y-m-d');
                $Ledger->form_ref_no = $form_ref_no;
                $Ledger->account_id = $account_id; 
                if($subledger > 0){
                    $sub = Subledger::model()->find(array('condition' => 'respect_id='.$subledger.' AND type='.$type)); 
                    if(!empty($sub))
                        $Ledger->subledger = $sub->id; /*Customer|Vendor*/
                }
                $Ledger->voucher_no = $voucher_no;
                $Ledger->item_description = $narration;
                $Ledger->narration =  $narration;
                $Ledger->isAllocated =  "Y";
                $Ledger->currency = 1;
                $Ledger->exchange_rate = 1;
                if($credit > 0){
                    $Ledger->credit = $credit;
                    $Ledger->cr_entered = $credit;
                }
                if($debit > 0){
                    $Ledger->debit = $debit;
                    $Ledger->db_entered = $debit;
                }
                $Ledger->save(false);
            }
            
            /**All Unsynced invoices */
            $allinvoices = FinOutstandingInvoices::model()->findAll(array('condition' => 'synced = "N"'));
            
            /**Posting 'em all */
            if(!empty($allinvoices)){
                foreach( $allinvoices as $each ){
                    /**
                    * General Ledger Head Insertion
                    * Common Table
                    * 21211  -- OutStanding Invoices Account - sales
                    * 21212  -- OutStanding Invoices Account - Purchase
                    * 99998  -- Sundry debitor
                    * 99997  -- Sundry Creditor
                    */
                    $GeneralLedger = new FinGeneralLedgerHead;
                    $GeneralLedger->voucher_no = $each->id;
                    $GeneralLedger->voucher_date = $each->invoice_date;
                    ($each->customer_vendor_type == 1) ? $invoice_type = 'Sales' : $invoice_type = 'Purchase';
                    $GeneralLedger->comment  = 'Outstanding '.$invoice_type.' Invoice Reference - '.$each->invoice_reference.' for '.FinOutstandingInvoices::getname($each);
                    $GeneralLedger->comment2 = 'Outstanding '.$invoice_type.' Invoice Reference - '.$each->invoice_reference.' for '.FinOutstandingInvoices::getname($each);
                    $GeneralLedger->posted = "Y";
                    $GeneralLedger->dt_posted = date('Y-m-d');
                    $GeneralLedger->voucher_type = 'OI'; //Outstanding Invoices
                    $GeneralLedger->value = $each->amount;
                    $GeneralLedger->save(false);
                    if($each->customer_vendor_type == 1){
                        addLedger($GeneralLedger->id,FinSettings::getAccount(99998),$each->customer_vendor_id,$GeneralLedger->voucher_type.'/'.$GeneralLedger->voucher_no,$GeneralLedger->comment,$each->amount,0,1);
                        addLedger($GeneralLedger->id,FinSettings::getAccount(21211),0,$GeneralLedger->voucher_type.'/'.$GeneralLedger->voucher_no,$GeneralLedger->comment,0,$each->amount,1);
                    }else{
                        addLedger($GeneralLedger->id,FinSettings::getAccount(99997),$each->customer_vendor_id,$GeneralLedger->voucher_type.'/'.$GeneralLedger->voucher_no,$GeneralLedger->comment,0,$each->amount,2);
                        addLedger($GeneralLedger->id,FinSettings::getAccount(21212),0,$GeneralLedger->voucher_type.'/'.$GeneralLedger->voucher_no,$GeneralLedger->comment,$each->amount,0,2);
                    }
                    $each->synced = "Y";
                    $each->save(false);
                }
            }
            
            echo 'success';
    }

    /** */
}
