<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of ExcelController
 *
 * @author Manu-Cumulus
 */
class ExcelController extends Controller {

    //put your code here

    public function accessRules() {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('inventory', 'dailyentry', 'dailyexit', 'auditlog', 'AdminTransactionList', 'clearingTransactionList', 'TransactionList', 'RecieptofPayment', 'CustomerAdvancePayment', 'daybook'
                    , 'CustomerContact' , 'PrintInvoiceReport','PrintvatreportExcel', 'PrintGLStatementReportexcel','ExportDepositList','ExportRefundList'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionInventory() {

        $part_number = Yii::app()->request->getParam("id");
        $tax_code = Yii::app()->request->getParam("taxcode");
        $filename = 'inventory.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $param = array(
            'part_number' => $part_number,
            'tax_code' => $tax_code
        );
        $this->renderPartial('inventory', $param);
        Yii::app()->end();
        return;
    }

    public function actionDailyEntry() {

        $from_date = Yii::app()->request->getParam("from_date");
        $to_date = Yii::app()->request->getParam("to_date");
        $customer_id = Yii::app()->request->getParam("customer_id");
        $filename = 'dailyentry.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $param = array(
            'from_date' => $from_date,
            'to_date' => $to_date,
            'customer_id' => $customer_id
        );
        $this->renderPartial('//excel/dailyentry', $param);
        Yii::app()->end();
        return;
    }

    public function actionDailyExit() {

        $from_date = Yii::app()->request->getParam("from_date");
        $to_date = Yii::app()->request->getParam("to_date");
        $customer_id = Yii::app()->request->getParam("customer_id");
        $filename = 'dailyexit.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $param = array(
            'from_date' => date('Y-m-d', strtotime(str_replace('/', '-', $from_date))),
            'to_date' => date('Y-m-d', strtotime(str_replace('/', '-', $to_date))),
            'customer_id' => $customer_id
        );
        $this->renderPartial('//excel/dailyexit', $param);
        Yii::app()->end();
        return;
    }

    public function actionAuditLog() {

        $from_date = Yii::app()->request->getParam("from_date");
        $to_date = Yii::app()->request->getParam("to_date");
        $type = Yii::app()->request->getParam("type");
        $filename = 'auditlog.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $param = array(
            'from_date' => $from_date,
            'to_date' => $to_date,
            'type' => $type
        );
        $this->renderPartial('//excel/auditlog', $param);
        Yii::app()->end();
        return;
    }

    public function actionAdminTransactionList() {
        $from_date = Yii::app()->request->getParam("from_date");
        $to_date = Yii::app()->request->getParam("to_date");
        $customer_id = Yii::app()->request->getParam("customer_id");
        $shipper_id = Yii::app()->request->getParam("shipper_id");
        $user = Yii::app()->request->getParam("user");
        $type = Yii::app()->request->getParam("type");
        $payment = Yii::app()->request->getParam("payment");
        $salesman = Yii::app()->request->getParam("salesman");
        $item = Yii::app()->request->getParam("item");
        $filename = 'admintransactionlist.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $param = array(
            'from_date' => $from_date,
            'to_date' => $to_date,
            'customer_id' => $customer_id,
            'shipper_id' => $shipper_id,
            'user' => $user,
            'type' => $type,
            'payment' => $payment,
            'salesman' => $salesman,
            'item' => $item
        );
        $this->renderPartial('//excel/admin_transactionlist', $param);
        Yii::app()->end();
        return;
    }

    public function actionClearingTransactionList() {
        $from_date = Yii::app()->request->getParam("from_date");
        $to_date = Yii::app()->request->getParam("to_date");
        $type = Yii::app()->request->getParam("type");
        $customer_id = Yii::app()->request->getParam("customer_id");
        $shipper_id = Yii::app()->request->getParam("shipper_id");
        $payment = Yii::app()->request->getParam("payment");
        $filename = 'clearingtransactionlist.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $param = array(
            'from_date' => $from_date,
            'to_date' => $to_date,
            'customer_id' => $customer_id,
            'type' => $type,
            'shipper_id' => $shipper_id,
            'payment' => $payment
        );
        $this->renderPartial('//excel/clearing_transactionlist', $param);
        Yii::app()->end();
        return;
    }

    public function actionTransactionList() {
        $from_date = Yii::app()->request->getParam("from_date");
        $to_date = Yii::app()->request->getParam("to_date");
        $customer_id = Yii::app()->request->getParam("customer_id");
        $shipper_id = Yii::app()->request->getParam("shipper_id");
        $type = Yii::app()->request->getParam("type");
        $payment = Yii::app()->request->getParam("payment");
        $filename = 'transactionlist.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $param = array(
            'from_date' => $from_date,
            'to_date' => $to_date,
            'customer_id' => $customer_id,
            'shipper_id' => $shipper_id,
            'type' => $type,
            'payment' => $payment
        );
        $this->renderPartial('//excel/transactionlist', $param);
        Yii::app()->end();
        return;
    }

    public function actionRecieptofPayment() {
        $from_date = Yii::app()->request->getParam("from_date");
        $to_date = Yii::app()->request->getParam("to_date");
        $company = Yii::app()->request->getParam("company");
        $payment = Yii::app()->request->getParam("payment");
        $realisation_from_date = Yii::app()->request->getParam("realisation_from_date");
        $realisation_to_date = Yii::app()->request->getParam("realisation_to_date");
        $filename = 'recieptofpayment.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $param = array(
            'from_date' => $from_date,
            'to_date' => $to_date,
            'company' => $company,
            'payment' => $payment,
            'realisation_from_date' => $realisation_from_date,
            'realisation_to_date' => $realisation_to_date
        );
        $this->renderPartial('//excel/recieptof_payment', $param);
        Yii::app()->end();
        return;
    }

    public function actionCustomerAdvancePayment() {
        $from_date = Yii::app()->request->getParam("from_date");
        $to_date = Yii::app()->request->getParam("to_date");
        $customer_id = Yii::app()->request->getParam("customer_id");
        $filename = 'customeradvancepayment.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $param = array(
            'from_date' => $from_date,
            'to_date' => $to_date,
            'customer_id' => $customer_id
        );
        $this->renderPartial('//excel/customer_advance_payment', $param);
        Yii::app()->end();
        return;
    }

    public function actiondaybook() {
        $date = Yii::app()->request->getParam("date");
        // $to_date = Yii::app()->request->getParam("to_date");
        // $customer_id = Yii::app()->request->getParam("customer_id");
        $filename = 'daybook.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $param = array(
            'date' => $date,
            
        );
        $this->renderPartial('//excel/daybook', $param);
        Yii::app()->end();
        return;
    }

    public function actionCustomerContact() {
        $customer_id = Yii::app()->request->getParam("customer_name");
        $filename = 'customercontact.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $param = array(
            'customer_id' => $customer_id
        );
        $this->renderPartial('customercontact', $param);
        Yii::app()->end();
        return;
    }

    public function actionPrintInvoiceReport() {

        $type = Yii::app()->request->getParam('type');
        $from_date = Yii::app()->request->getParam('from_date');
        $to_date = Yii::app()->request->getParam('to_date');
        $customer_id = Yii::app()->request->getParam("customer_name");
        $filename = 'InvoiceReport.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_invoicereport', array('model' => $model, 'from_date' => $from_date, 'to_date' => $to_date, 'type' => $type, 'customer_id' => $customer_id), false, true);
        Yii::app()->end();
        return;
    }
	
	public function actionPrintvatreportExcel() {

        $from_date = date('Y-m-d', strtotime(str_replace('/', '-', $_GET['from_date'])));
        $to_date = date('Y-m-d', strtotime(str_replace('/', '-', $_GET['to_date'])));
        $filename = 'list_vat.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('print_VatReportExcel', array('from_date' => $from_date,'to_date' => $to_date), false, true);
        Yii::app()->end();
    }
    public function actionPrintGLStatementReportexcel() {
        $date = str_replace('/', '-', $_REQUEST['from_date']);
        $searchstartdate = date("Y-m-d", strtotime($date));
        // $searchstartdate='2015-01-01';
        $date1 = str_replace('/', '-', $_REQUEST['to_date']);
        $searchenddate = date("Y-m-d", strtotime($date1));
        $company_id = $_REQUEST['subledger_id'];
        $account_id=$_REQUEST['ledger_id'];
        if($searchstartdate==null)
        {
         $searchstartdate=date('Y').'-01-01';
        }
        if($searchenddate==null)
        {
         $searchenddate=date('Y').'-12-31';
        }
         if (!empty($company_id) && !empty($searchstartdate) && !empty($searchenddate) && !empty($account_id))
        {
            $filename = 'soa.xls';
            ini_set("memory_limit", "-1");
            header("Content-type: application/vnd.ms-excel");
            header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
            $this->renderPartial('soa_excel', array('subledger'=>$company_id,'date_to'=>$searchenddate,'date_from'=>$searchstartdate,'account'=>$account_id), false, true);
            Yii::app()->end();
        }
        else {
            echo "Please Select Account";
        }
    }
    
    public function actionExportDepositList() {
        $from_date = Yii::app()->request->getParam("from_date");
        $to_date = Yii::app()->request->getParam("to_date");
        $status = Yii::app()->request->getParam("status");
         $filename = 'deposit_list.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $param = array(
            'from_date' => $from_date,
            'to_date' => $to_date,
            'status' => $status
        );
        $this->renderPartial('//excel/export_deposit_list', $param);
        Yii::app()->end();
        return;
    }
    
    public function actionExportRefundList() {
        $from_date = Yii::app()->request->getParam("from_date");
        $to_date = Yii::app()->request->getParam("to_date");
        $status = Yii::app()->request->getParam("status");
         $filename = 'refund_list.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $param = array(
            'from_date' => $from_date,
            'to_date' => $to_date,
            'status' => $status
        );
        $this->renderPartial('//excel/export_refund_list', $param);
        Yii::app()->end();
        return;
    }
	

}
