<?php

class DashboardController extends Controller
{
        public function accessRules() {
            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                  'actions' => array('login', 'error', 'logout'),
                  'users' => array('*'),
                  ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                  'actions' => array('Index','Create','GetLeadGraphs','GetQuoteGraphs','GetOrderGraphs','GettestGraphs','GetGraph','LeadGraphDetails','GetLeadOwnerDetail','LeadGraphOwnerDetails','LeadGetMonthDetails',
                                        'GetLeadCountryDetail','LeadGraphCountryDetails','LeadGetLeadCountryMonthDetails','GetLeadSalesGroupDetail','LeadGraphSalesGroupDetails',
                                        'LeadSalesMonthDetails','quotes_graphdetails','GetQuoteOwnerDetail','GetQuoteCountryDetail','GetQuotesSalesGroupDetail',
                                        'QuotesGraphOwnerDetails','QuotesGraphCountryDetails','QuoteGraphSalesGroupDetails','QuoteGetMonthDetails','GetQuoteMonthDetails',
                                        'QuoteSalesMonthDetails','Quotation_items','order_graphdetails','OrderGraphOwnerDetails','GetOrderOwnerDetail',
                                        'GetOrderCountryDetail','GetOrderSalesGroupDetail','OrderGraphOwnerDetails','OrderCountryDetails','OrderSalesGroupDetails','OrderGetMonthDetails',
                                        'GetOrderMonthDetails','OrderSalesMonthDetails','Order_items','invoice_graphdetails','GetInvoiceOwnerDetail',
                                        'GetInvoiceCountryDetail','GetInvoiceSalesGroupDetail','invoiceGraphOwnerDetails','invoiceCountryDetails',
                                        'InvoiceSalesGroupDetails','InvoiceGetMonthDetails','GetInvoiceMonthDetails','InvoiceSalesMonthDetails','getInvoiceItems'),
                  'expression' => '$user->isMember()',
                  ),
                array('deny', // deny all users
                  'users' => array('*'),
                  ),
                );
        }
	public function actionIndex()
	{
		$this->render('index');
	}

	// Uncomment the following methods and override them if needed
	
	public function filters()
        {
            return array(
                'accessControl', // perform access control for CRUD operations
                );
        }
        public function actionGetLeadGraphs()
	{
            //print_r("HI");die();
		$this->renderPartial('lead_graphs'); 
	}
         public function actionGetQuoteGraphs()
	{
		$this->render('quotation_graphs');
	}
         public function actionGetOrderGraphs()
	{
		$this->render('order_graphs');
	}
         public function actionGettestGraphs()
	{
		$this->render('test_graphs');
	}
        
        public function actionGetGraph(){
        
        $page = Yii::app()->request->getparam("page");  
        $this->render($page);
     }
       
     public function actionLeadGraphDetails(){  
        $type = (int) Yii::app()->request->getParam('type');
        $currentYear  = date("Y");
        
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false,'jquery-2.1.4.min.js' => false);
        if($type==1){
            $graph_data_quantity = Yii::app()->db->createCommand('SELECT CONCAT(user.first_name," ",user.last_name) AS x_value,COUNT(*) AS y_value FROM crm_lead AS lead INNER JOIN blueskye_erp_boul_evard_main.crm_user AS user ON lead.lead_owner_id=user.id  WHERE YEAR(lead.enq_date) = "'.$currentYear.'" GROUP BY user.id')->queryAll();
            $plot = '[';
           foreach($graph_data_quantity as  $m=>$eachdata ){
                $color = substr(md5(rand()), 0, 6);
                $plot .= '{label:"'.$eachdata['x_value'].'", value:'.$eachdata['y_value'].', color: "#'.$color.'"},';
            }
            $plot .= ']';
            $this->render('lead_owner_view',array('plot'=>$plot));
        }else if($type==2){
            
            
            $graphdata = Yii::app()->db->createCommand('SELECT COUNT(*) AS y_value,country.country_name AS x_value FROM crm_lead AS lead 
                                                        INNER JOIN crm_customer AS customer ON lead.customer_id=customer.id 
                                                        INNER JOIN crm_mas_country AS country ON customer.customer_country=country.id 
                                                        WHERE YEAR(lead.enq_date) = "'.$currentYear.'" GROUP BY customer.customer_country')->queryAll();
            
            //$graph_data_quantity = Yii::app()->db->createCommand('SELECT CONCAT(user.first_name," ",user.last_name) AS x_value,COUNT(*) AS y_value FROM crm_lead AS lead INNER JOIN blueskye_erp_boul_evard_main.crm_user AS user ON lead.lead_owner_id=user.id INNER JOIN crm_master_file AS master_file ON lead.file_id = master_file.id WHERE master_file.current_process_status = "L"  GROUP BY user.id')->queryAll();
            
            
            $plot = '[';
           foreach($graphdata as  $m=>$eachdata ){
                $color = substr(md5(rand()), 0, 6);
                $plot .= '{label:"'.$eachdata['x_value'].'", value:'.$eachdata['y_value'].', color: "#'.$color.'"},';
            }
            $plot .= ']';
            
            $this->render('lead_country_view',array('plot'=>$plot));
        }
        else if($type==3){
            
            
            $graphdata = Yii::app()->db->createCommand('SELECT sales_group.group_name AS x_value,SUM(lead.value) AS y_value FROM crm_lead AS lead 
                                                        INNER JOIN crm_mas_sales_group AS sales_group ON lead.sales_group_id=sales_group.id
                                                        WHERE YEAR(lead.enq_date) = "'.$currentYear.'" GROUP BY sales_group.id')->queryAll();
            
            
            $plot = '[';
           foreach($graphdata as  $m=>$eachdata ){
                $color = substr(md5(rand()), 0, 6);
                $plot .= '{label:"'.$eachdata['x_value'].'", value:'.$eachdata['y_value'].', color: "#'.$color.'"},';
            }
            $plot .= ']';
            
            $this->render('lead_sales_group_view',array('plot'=>$plot));
        }
     }
     
/***********************   start - lead Owner *****************************************************/
     
      public function actionGetLeadOwnerDetail(){  
            $lead_graph_details=array();
            $currentYear  = date("Y");
            
            $graph_data_quantity = Yii::app()->db->createCommand('SELECT lead.lead_owner_id AS OWNERID,CONCAT(user.first_name," ",user.last_name) AS x_value,COUNT(*) AS y_value FROM crm_lead AS lead INNER JOIN blueskye_erp_boul_evard_main.crm_user AS user ON lead.lead_owner_id=user.id  WHERE YEAR(lead.enq_date) = "'.$currentYear.'" GROUP BY user.id')->queryAll();
            $plot = '[';
           foreach($graph_data_quantity as  $m=>$eachdata ){
                $color = substr(md5(rand()), 0, 6);
                $plot .= '{label:"'.$eachdata['x_value'].'", value:'.$eachdata['y_value'].', color: "#'.$color.'"},';
                $lead_graph_details[$m]['slno']=$m+1;
                $lead_graph_details[$m]['lead_owner']=$eachdata['x_value'];
                $lead_graph_details[$m]['lead_count']=$eachdata['y_value'];
                $lead_graph_details[$m]['lead_color']="#".$color;
                $lead_graph_details[$m]['lead_owner_id']=$eachdata['OWNERID'];
            }
            $plot .= ']';
            
            foreach ($lead_graph_details as $key => $value) {
                $rowData[]=array($value['slno'],$value['lead_owner'],$value['lead_count'],$value['lead_color'],$value['lead_owner_id']);
            }
           $data['data'] = $rowData;
           $data['plot'] = $plot;
           echo json_encode($data);
     }
     
     public function actionLeadGraphOwnerDetails(){
        
            $owner_id  = $_POST['user_id'];
            $currentYear  = date("Y");
        
            $graph_detail = Yii::app()->db->createCommand('SELECT YEAR(lead.enq_date) as y, MONTH(lead.enq_date) as m, COUNT(lead.id) as TOTAL_COUNT,SUM(lead.value) AS TOTAL_AMT FROM crm_lead AS lead                                         
                                        WHERE YEAR(lead.enq_date) = "'.$currentYear.'" AND lead.lead_owner_id="'.$owner_id.'" GROUP BY y, m ORDER BY y DESC, m ASC')->queryAll();
            
            $this->render('lead_owner_details', array('graph_detail' => $graph_detail,'owner_id'=>$owner_id));
     }
     
     public function actionLeadGetMonthDetails(){
        
            $owner_id  = $_POST['ownerid'];
            $month     = $_POST['month'];
            $year      = $_POST['year'];
            $currentYear  = date("Y");
        
            $graph_detail = Yii::app()->db->createCommand('SELECT lead.customer_id,lead.value,lead.enq_date,lead.closing_date FROM crm_lead AS lead                                                     
                                                WHERE YEAR(lead.enq_date) = "'.$year.'" AND MONTH(lead.enq_date) = "'.$month.'" AND lead.lead_owner_id="'.$owner_id.'"')->queryAll();
            
            
            $this->render('lead_owner_month_details', array('graph_detail' => $graph_detail,'month'=>$month,'year'=>$year));
     }
/***********************   End - lead Owner ************************************************************/        
/***********************   start - lead Country *****************************************************/   

 public function actionGetLeadCountryDetail(){  
            $lead_graph_details=array();
            $currentYear  = date("Y");
            
            $graph_data_quantity = Yii::app()->db->createCommand('SELECT country.id AS COUNTRY_ID,COUNT(*) AS y_value,country.country_name AS x_value FROM crm_lead AS lead 
                                                        INNER JOIN crm_customer AS customer ON lead.customer_id=customer.id 
                                                        INNER JOIN crm_mas_country AS country ON customer.customer_country=country.id 
                                                        WHERE YEAR(lead.enq_date) = "'.$currentYear.'" GROUP BY customer.customer_country')->queryAll();
            
            $plot = '[';
           foreach($graph_data_quantity as  $m=>$eachdata ){
                $color = substr(md5(rand()), 0, 6);
                $plot .= '{label:"'.$eachdata['x_value'].'", value:'.$eachdata['y_value'].', color: "#'.$color.'"},';
                $lead_graph_details[$m]['slno']=$m+1;
                $lead_graph_details[$m]['lead_country']=$eachdata['x_value'];
                $lead_graph_details[$m]['lead_count']=$eachdata['y_value'];
                $lead_graph_details[$m]['lead_color']="#".$color;
                $lead_graph_details[$m]['lead_country_id']=$eachdata['COUNTRY_ID'];
            }
            $plot .= ']';
            
            foreach ($lead_graph_details as $key => $value) {
                $rowData[]=array($value['slno'],$value['lead_country'],$value['lead_count'],$value['lead_color'],$value['lead_country_id']);
            }
           $data['data'] = $rowData;
           $data['plot'] = $plot;
           echo json_encode($data);
     }  
     
     public function actionLeadGraphCountryDetails(){
        
            $country_id   = $_POST['country_id'];
            $currentYear  = date("Y");
            
            $graph_detail = Yii::app()->db->createCommand('SELECT YEAR(lead.enq_date) as y, MONTH(lead.enq_date) as m, COUNT(lead.id) as TOTAL_COUNT,SUM(lead.value) AS TOTAL_AMT  FROM crm_lead AS lead 
                                                        INNER JOIN crm_customer AS customer ON lead.customer_id=customer.id 
                                                        INNER JOIN crm_mas_country AS country ON customer.customer_country=country.id 
                                                        WHERE YEAR(lead.enq_date) = "'.$currentYear.'" AND country.id="'.$country_id.'" GROUP BY y, m ORDER BY y DESC, m ASC')->queryAll();
            
            $this->render('lead_country_details', array('graph_detail' => $graph_detail,'country_id'=>$country_id,'action'=>'view_country_detail'));
     }
     
     public function actionLeadGetLeadCountryMonthDetails(){
        
            $country_id  = $_POST['country_id'];
            $month       = $_POST['month'];
            $year        = $_POST['year'];
            $currentYear = date("Y");
            
            $graph_detail = Yii::app()->db->createCommand('SELECT lead.customer_id,lead.value,lead.enq_date,lead.closing_date FROM crm_lead AS lead 
                                                        INNER JOIN crm_customer AS customer ON lead.customer_id=customer.id  
                                                        INNER JOIN crm_mas_country AS country ON customer.customer_country=country.id 
                                                        WHERE YEAR(lead.enq_date) = "'.$year.'" AND MONTH(lead.enq_date) = "'.$month.'" AND country.id="'.$country_id.'"')->queryAll();
        
            
            $this->render('lead_country_details', array('graph_detail' => $graph_detail,'action'=>'view_country_month_detail','month'=>$month,'year'=>$year));
     }
     
/***********************   End - lead Country ************************************************************/        
/***********************   start - lead sales group  *****************************************************/
     
     public function actionGetLeadSalesGroupDetail(){  
            $lead_graph_details=array();
            $currentYear  = date("Y");
            
                                                        
            $graph_data_quantity = Yii::app()->db->createCommand('SELECT sales_group.id AS SALES_GROUP_ID,sales_group.group_name AS x_value,SUM(lead.value) AS y_value FROM crm_lead AS lead 
                                                        INNER JOIN crm_mas_sales_group AS sales_group ON lead.sales_group_id=sales_group.id 
                                                        WHERE YEAR(lead.enq_date) = "'.$currentYear.'" GROUP BY sales_group.id')->queryAll();
            
            $plot = '[';
           foreach($graph_data_quantity as  $m=>$eachdata ){
                $color = substr(md5(rand()), 0, 6);
                $plot .= '{label:"'.$eachdata['x_value'].'", value:'.$eachdata['y_value'].', color: "#'.$color.'"},';
                $lead_graph_details[$m]['slno']=$m+1;
                $lead_graph_details[$m]['sales_group']=$eachdata['x_value'];
                $lead_graph_details[$m]['lead_count']=$eachdata['y_value'];
                $lead_graph_details[$m]['lead_color']="#".$color;
                $lead_graph_details[$m]['sales_group_id']=$eachdata['SALES_GROUP_ID'];
            }
            $plot .= ']';
            
            foreach ($lead_graph_details as $key => $value) {
                $rowData[]=array($value['slno'],$value['sales_group'],$value['lead_count'],$value['lead_color'],$value['sales_group_id']);
            }
           $data['data'] = $rowData;
           $data['plot'] = $plot;
           echo json_encode($data);
     }
     
     public function actionLeadGraphSalesGroupDetails(){
        
            $group_id   = $_POST['group_id'];
            $currentYear  = date("Y");
            
            
            $graph_detail = Yii::app()->db->createCommand('SELECT YEAR(lead.enq_date) as y, MONTH(lead.enq_date) as m, COUNT(lead.id) as TOTAL_COUNT,SUM(lead.value) AS TOTAL_AMT FROM crm_lead AS lead 
                                                        INNER JOIN crm_mas_sales_group AS sales_group ON lead.sales_group_id=sales_group.id 
                                                        WHERE YEAR(lead.enq_date) = "'.$currentYear.'" AND sales_group.id="'.$group_id.'" GROUP BY y, m ORDER BY y DESC, m ASC')->queryAll();
            
            $this->render('lead_sales_group_details', array('graph_detail' => $graph_detail,'group_id'=>$group_id,'action'=>'view_sales_group_detail'));
     }
     public function actionLeadSalesMonthDetails(){
        
            $group_id  = $_POST['group_id'];
            $month       = $_POST['month'];
            $year        = $_POST['year'];
            $currentYear = date("Y");
            
            
            $graph_detail = Yii::app()->db->createCommand('SELECT lead.customer_id,lead.value,lead.enq_date,lead.closing_date FROM crm_lead AS lead 
                                                        INNER JOIN crm_mas_sales_group AS sales_group ON lead.sales_group_id=sales_group.id
                                                        WHERE YEAR(lead.enq_date) = "'.$year.'" AND MONTH(lead.enq_date) = "'.$month.'" AND sales_group.id="'.$group_id.'"')->queryAll();
                                                        
            $this->render('lead_sales_group_details', array('graph_detail' => $graph_detail,'action'=>'view_sales_group_month_detail','month'=>$month,'year'=>$year));
     }
     
/***********************   End - lead sales group *****************************************************/     

/***********************   Start  - Quaotation Part *****************************************************/     
 
 
 //quotes_graphdetails  
 
 public function actionQuotes_graphdetails(){  
        $type = (int) Yii::app()->request->getParam('type');
        $currentYear  = date("Y");
        
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false,'jquery-2.1.4.min.js' => false);
        if($type==1){
            $graph_data_quantity = Yii::app()->db->createCommand('SELECT CONCAT(user.first_name," ",user.last_name) AS x_value,COUNT(*) AS y_value FROM crm_quotes AS quotes INNER JOIN blueskye_erp_boul_evard_main.crm_user AS user ON quotes.crm_user_id=user.id WHERE YEAR(quotes.qtn_start_date) = "'.$currentYear.'"  GROUP BY user.id')->queryAll();
            $plot = '[';
           foreach($graph_data_quantity as  $m=>$eachdata ){
                $color = substr(md5(rand()), 0, 6);
                $plot .= '{label:"'.$eachdata['x_value'].'", value:'.$eachdata['y_value'].', color: "#'.$color.'"},';
            }
            $plot .= ']';
            $this->render('quotes_owner_view',array('plot'=>$plot));
        }else if($type==2){
            
            
            $graphdata = Yii::app()->db->createCommand('SELECT COUNT(*) AS y_value,country.country_name AS x_value FROM crm_quotes AS quotes 
                                                        INNER JOIN crm_customer AS customer ON quotes.company_id=customer.id 
                                                        INNER JOIN crm_mas_country AS country ON customer.customer_country=country.id 
                                                        WHERE YEAR(quotes.qtn_start_date) = "'.$currentYear.'"  GROUP BY customer.customer_country')->queryAll();
            
            $plot = '[';
           foreach($graphdata as  $m=>$eachdata ){
                $color = substr(md5(rand()), 0, 6);
                $plot .= '{label:"'.$eachdata['x_value'].'", value:'.$eachdata['y_value'].', color: "#'.$color.'"},';
            }
            $plot .= ']';
            
            $this->render('quotes_country_view',array('plot'=>$plot));
        }
        else if($type==3){
            
            
            $graphdata = Yii::app()->db->createCommand('SELECT sales_group.group_name AS x_value,SUM(quotes.grand_total) AS y_value FROM crm_quotes AS quotes
                                                        INNER JOIN crm_mas_sales_group AS sales_group ON quotes.sales_group=sales_group.id  
                                                        WHERE YEAR(quotes.qtn_start_date) = "'.$currentYear.'"  GROUP BY sales_group.id')->queryAll();
            
            
            $plot = '[';
           foreach($graphdata as  $m=>$eachdata ){
                $color = substr(md5(rand()), 0, 6);
                $plot .= '{label:"'.$eachdata['x_value'].'", value:'.$eachdata['y_value'].', color: "#'.$color.'"},';
            }
            $plot .= ']';
            
            $this->render('quotes_sales_group_view',array('plot'=>$plot));
        }
     }  
     
/***********************   start - Quote Owner *****************************************************/

public function actionGetQuoteOwnerDetail(){  
            $lead_graph_details=array();
            $currentYear  = date("Y");
            $graph_data_quantity = Yii::app()->db->createCommand('SELECT quotes.crm_user_id AS OWNERID,CONCAT(user.first_name," ",user.last_name) AS x_value,COUNT(*) AS y_value FROM crm_quotes AS quotes INNER JOIN blueskye_erp_boul_evard_main.crm_user AS user ON quotes.crm_user_id=user.id WHERE YEAR(quotes.qtn_start_date) = "'.$currentYear.'" GROUP BY user.id')->queryAll();
            $plot = '[';
           foreach($graph_data_quantity as  $m=>$eachdata ){
                $color = substr(md5(rand()), 0, 6);
                $plot .= '{label:"'.$eachdata['x_value'].'", value:'.$eachdata['y_value'].', color: "#'.$color.'"},';
                $lead_graph_details[$m]['slno']=$m+1;
                $lead_graph_details[$m]['quote_owner']=$eachdata['x_value'];
                $lead_graph_details[$m]['quote_count']=$eachdata['y_value'];
                $lead_graph_details[$m]['quote_color']="#".$color;
                $lead_graph_details[$m]['quote_owner_id']=$eachdata['OWNERID'];
            }
            $plot .= ']';
            
            foreach ($lead_graph_details as $key => $value) {
                $rowData[]=array($value['slno'],$value['quote_owner'],$value['quote_count'],$value['quote_color'],$value['quote_owner_id']);
            }
           $data['data'] = $rowData;
           $data['plot'] = $plot;
           echo json_encode($data);
     }
     
     public function actionQuotesGraphOwnerDetails(){
        
            $owner_id  = $_POST['user_id'];
            $currentYear  = date("Y");
        
            $graph_detail = Yii::app()->db->createCommand('SELECT YEAR(quotes.qtn_start_date) as y, MONTH(quotes.qtn_start_date) as m, COUNT(quotes.id) as TOTAL_COUNT,SUM(quotes.grand_total) AS TOTAL_AMT FROM crm_quotes AS quotes                                         
                                        WHERE YEAR(quotes.qtn_start_date) = "'.$currentYear.'" AND quotes.crm_user_id="'.$owner_id.'" GROUP BY y, m ORDER BY y DESC, m ASC')->queryAll();
            
            $this->render('quotes_owner_details', array('graph_detail' => $graph_detail,'owner_id'=>$owner_id,'action'=>'view_quotes_detail'));
     }
     
     public function actionQuoteGetMonthDetails(){
        
            $owner_id  = $_POST['ownerid'];
            $month     = $_POST['month'];
            $year      = $_POST['year'];
            $currentYear  = date("Y");
        
            $graph_detail = Yii::app()->db->createCommand('SELECT quotes.id AS quotes_id,quotes.company_id,quotes.grand_total,quotes.qtn_start_date,quotes.qtn_close_date FROM crm_quotes AS quotes                                                     
                                                WHERE YEAR(quotes.qtn_start_date) = "'.$year.'" AND MONTH(quotes.qtn_start_date) = "'.$month.'" AND quotes.crm_user_id="'.$owner_id.'"')->queryAll();
            
            
            $this->render('quotes_owner_details', array('graph_detail' => $graph_detail,'month'=>$month,'year'=>$year,'action'=>'view_country_month_detail'));
     }
     
     public function actionQuotation_items(){
        
            $quotesid  = $_POST['quotesid'];
            $this->render('view_quotesItems', array('quotesid' => $quotesid));
     }

/***********************   End - Quote Owner ************************************************************/        
/***********************   start - Quote Country *****************************************************/ 

public function actionGetQuoteCountryDetail(){  
            $lead_graph_details=array();
            $currentYear  = date("Y");
            
            $graph_data_quantity = Yii::app()->db->createCommand('SELECT country.id AS COUNTRY_ID,COUNT(*) AS y_value,country.country_name AS x_value FROM crm_quotes AS quotes 
                                                        INNER JOIN crm_customer AS customer ON quotes.company_id=customer.id
                                                        INNER JOIN crm_mas_country AS country ON customer.customer_country=country.id 
                                                        WHERE YEAR(quotes.qtn_start_date) = "'.$currentYear.'" GROUP BY customer.customer_country')->queryAll();
            
            $plot = '[';
           foreach($graph_data_quantity as  $m=>$eachdata ){
                $color = substr(md5(rand()), 0, 6);
                $plot .= '{label:"'.$eachdata['x_value'].'", value:'.$eachdata['y_value'].', color: "#'.$color.'"},';
                $lead_graph_details[$m]['slno']=$m+1;
                $lead_graph_details[$m]['quotes_country']=$eachdata['x_value'];
                $lead_graph_details[$m]['quotes_count']=$eachdata['y_value'];
                $lead_graph_details[$m]['quotes_color']="#".$color;
                $lead_graph_details[$m]['quotes_country_id']=$eachdata['COUNTRY_ID'];
            }
            $plot .= ']';
            
            foreach ($lead_graph_details as $key => $value) {
                $rowData[]=array($value['slno'],$value['quotes_country'],$value['quotes_count'],$value['quotes_color'],$value['quotes_country_id']);
            }
           $data['data'] = $rowData;
           $data['plot'] = $plot;
           echo json_encode($data);
     }  
     
    public function actionQuotesGraphCountryDetails(){
        
            $country_id   = $_POST['country_id'];
            $currentYear  = date("Y");
            
            $graph_detail = Yii::app()->db->createCommand('SELECT YEAR(quotes.qtn_start_date) as y, MONTH(quotes.qtn_start_date) as m, COUNT(quotes.id) as TOTAL_COUNT,SUM(quotes.grand_total) AS TOTAL_AMT  FROM crm_quotes AS quotes 
                                                        INNER JOIN crm_customer AS customer ON quotes.company_id=customer.id
                                                        INNER JOIN crm_mas_country AS country ON customer.customer_country=country.id 
                                                        WHERE YEAR(quotes.qtn_start_date) = "'.$currentYear.'" AND country.id="'.$country_id.'" GROUP BY y, m ORDER BY y DESC, m ASC')->queryAll();
            
            $this->render('quotes_country_details', array('graph_detail' => $graph_detail,'country_id'=>$country_id,'action'=>'view_country_detail'));
     }
     
     public function actionGetQuoteMonthDetails(){
        
            $country_id  = $_POST['country_id'];
            $month       = $_POST['month'];
            $year        = $_POST['year'];
            $currentYear = date("Y");
            
            $graph_detail = Yii::app()->db->createCommand('SELECT quotes.id AS quotes_id,quotes.company_id,quotes.grand_total,quotes.qtn_start_date,quotes.qtn_close_date FROM crm_quotes AS quotes  
                                                        INNER JOIN crm_customer AS customer ON quotes.company_id=customer.id
                                                        INNER JOIN crm_mas_country AS country ON customer.customer_country=country.id 
                                                        WHERE YEAR(quotes.qtn_start_date) = "'.$year.'" AND MONTH(quotes.qtn_start_date) = "'.$month.'" AND country.id="'.$country_id.'"')->queryAll();
        
            
            $this->render('quotes_country_details', array('graph_detail' => $graph_detail,'action'=>'view_country_month_detail','month'=>$month,'year'=>$year));
     }

/***********************   End - Quote Country ************************************************************/        
/***********************   start - Quote sales group *****************************************************/   


public function actionGetQuotesSalesGroupDetail(){  
    
            $lead_graph_details=array();
            $currentYear = date("Y");
                                                        
            $graph_data_quantity = Yii::app()->db->createCommand('SELECT sales_group.id AS SALES_GROUP_ID,sales_group.group_name AS x_value,SUM(quotes.grand_total) AS y_value FROM crm_quotes AS quotes  
                                                        INNER JOIN crm_mas_sales_group AS sales_group ON quotes.sales_group=sales_group.id 
                                                        WHERE YEAR(quotes.qtn_start_date) = "'.$currentYear.'"  GROUP BY sales_group.id')->queryAll();
            
            $plot = '[';
           foreach($graph_data_quantity as  $m=>$eachdata ){
                $color = substr(md5(rand()), 0, 6);
                $plot .= '{label:"'.$eachdata['x_value'].'", value:'.$eachdata['y_value'].', color: "#'.$color.'"},';
                $lead_graph_details[$m]['slno']=$m+1;
                $lead_graph_details[$m]['sales_group']=$eachdata['x_value'];
                $lead_graph_details[$m]['quotes_count']=$eachdata['y_value'];
                $lead_graph_details[$m]['quotes_color']="#".$color;
                $lead_graph_details[$m]['sales_group_id']=$eachdata['SALES_GROUP_ID'];
            }
            $plot .= ']';
            
            foreach ($lead_graph_details as $key => $value) {
                $rowData[]=array($value['slno'],$value['sales_group'],$value['quotes_count'],$value['quotes_color'],$value['sales_group_id']);
            }
           $data['data'] = $rowData;
           $data['plot'] = $plot;
           echo json_encode($data);
     }
     
     public function actionQuoteGraphSalesGroupDetails(){
        
            $group_id   = $_POST['group_id'];
            $currentYear  = date("Y");
            
            
            $graph_detail = Yii::app()->db->createCommand('SELECT YEAR(quotes.qtn_start_date) as y, MONTH(quotes.qtn_start_date) as m, COUNT(quotes.id) as TOTAL_COUNT,SUM(quotes.grand_total) AS TOTAL_AMT FROM crm_quotes AS quotes
                                                        INNER JOIN crm_mas_sales_group AS sales_group ON quotes.sales_group=sales_group.id  
                                                        WHERE YEAR(quotes.qtn_start_date) = "'.$currentYear.'" AND sales_group.id="'.$group_id.'" GROUP BY y, m ORDER BY y DESC, m ASC')->queryAll();
            
            $this->render('quotes_sales_group_details', array('graph_detail' => $graph_detail,'group_id'=>$group_id,'action'=>'view_sales_group_detail'));
     }
     public function actionQuoteSalesMonthDetails(){
        
            $group_id  = $_POST['group_id'];
            $month       = $_POST['month'];
            $year        = $_POST['year'];
            $currentYear = date("Y");
            
            
            $graph_detail = Yii::app()->db->createCommand('SELECT quotes.id AS quotes_id,quotes.company_id,quotes.grand_total,quotes.qtn_start_date,quotes.qtn_close_date FROM crm_quotes AS quotes
                                                        INNER JOIN crm_mas_sales_group AS sales_group ON quotes.sales_group=sales_group.id
                                                        WHERE YEAR(quotes.qtn_start_date) = "'.$year.'" AND MONTH(quotes.qtn_start_date) = "'.$month.'" AND sales_group.id="'.$group_id.'"')->queryAll();
                                                        
            $this->render('quotes_sales_group_details', array('graph_detail' => $graph_detail,'action'=>'view_sales_group_month_detail','month'=>$month,'year'=>$year));
     }
     

/***********************   End - Quote sales group *****************************************************/       


/***********************   Start  - Order Part *****************************************************/     
 
 
 
 
 public function actionorder_graphdetails(){  
        $type = (int) Yii::app()->request->getParam('type');
        $currentYear  = date("Y");
        
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false,'jquery-2.1.4.min.js' => false);
        if($type==1){
            //$graph_data_quantity = Yii::app()->db->createCommand('SELECT CONCAT(user.first_name," ",user.last_name) AS x_value,COUNT(*) AS y_value FROM crm_quotes AS quotes INNER JOIN blueskye_erp_boul_evard_main.crm_user AS user ON quotes.crm_user_id=user.id INNER JOIN crm_master_file AS master_file ON quotes.file_id = master_file.id WHERE master_file.current_process_status = "Q"  GROUP BY user.id')->queryAll();
            $graph_data_quantity = Yii::app()->db->createCommand('SELECT CONCAT(user.first_name," ",user.last_name) AS x_value,COUNT(*) AS y_value FROM crm_order AS ord INNER JOIN blueskye_erp_boul_evard_main.crm_user AS user ON ord.crm_user_id=user.id  WHERE YEAR(ord.order_date) = "'.$currentYear.'" GROUP BY user.id')->queryAll();
            $plot = '[';
           foreach($graph_data_quantity as  $m=>$eachdata ){
                $color = substr(md5(rand()), 0, 6);
                $plot .= '{label:"'.$eachdata['x_value'].'", value:'.$eachdata['y_value'].', color: "#'.$color.'"},';
            }
            $plot .= ']';
            $this->render('order_owner_view',array('plot'=>$plot));
        }else if($type==2){
            
            
            /*$graphdata = Yii::app()->db->createCommand('SELECT COUNT(*) AS y_value,country.country_name AS x_value FROM crm_order AS ord 
                                                        INNER JOIN crm_customer AS customer ON ord.company_id=customer.id 
                                                        INNER JOIN crm_master_file AS master_file ON ord.file_id = master_file.id 
                                                        INNER JOIN crm_mas_country AS country ON customer.customer_country=country.id 
                                                        WHERE master_file.current_process_status = "O"  GROUP BY customer.customer_country')->queryAll();*/
            
            $graphdata = Yii::app()->db->createCommand('SELECT COUNT(*) AS y_value,country.country_name AS x_value FROM crm_order AS ord 
                                                        INNER JOIN crm_customer AS customer ON ord.company_id=customer.id 
                                                        INNER JOIN crm_mas_country AS country ON customer.customer_country=country.id 
                                                        WHERE YEAR(ord.order_date) = "'.$currentYear.'" GROUP BY customer.customer_country')->queryAll();
            
            $plot = '[';
           foreach($graphdata as  $m=>$eachdata ){
                $color = substr(md5(rand()), 0, 6);
                $plot .= '{label:"'.$eachdata['x_value'].'", value:'.$eachdata['y_value'].', color: "#'.$color.'"},';
            }
            $plot .= ']';
            
            $this->render('order_country_view',array('plot'=>$plot));
        }
        else if($type==3){
            
            
            /*$graphdata = Yii::app()->db->createCommand('SELECT sales_group.group_name AS x_value,SUM(ord.grand_total) AS y_value FROM crm_order AS ord
                                                        INNER JOIN crm_mas_sales_group AS sales_group ON ord.sales_group=sales_group.id 
                                                        INNER JOIN crm_master_file AS master_file ON ord.file_id = master_file.id 
                                                        WHERE master_file.current_process_status = "O"  GROUP BY sales_group.id')->queryAll();*/
            
            $graphdata = Yii::app()->db->createCommand('SELECT sales_group.group_name AS x_value,SUM(ord.grand_total) AS y_value FROM crm_order AS ord
                                                        INNER JOIN crm_mas_sales_group AS sales_group ON ord.sales_group=sales_group.id                                                         
                                                        WHERE YEAR(ord.order_date) = "'.$currentYear.'" GROUP BY sales_group.id')->queryAll();
            
            
            $plot = '[';
           foreach($graphdata as  $m=>$eachdata ){
                $color = substr(md5(rand()), 0, 6);
                $plot .= '{label:"'.$eachdata['x_value'].'", value:'.$eachdata['y_value'].', color: "#'.$color.'"},';
            }
            $plot .= ']';
            
            $this->render('order_sales_group_view',array('plot'=>$plot));
        }
     }  

/***********************   start - Order Owner *****************************************************/

public function actionGetOrderOwnerDetail(){  
            $lead_graph_details=array();
            $currentYear  = date("Y");
            $graph_data_quantity = Yii::app()->db->createCommand('SELECT ord.crm_user_id AS OWNERID,CONCAT(user.first_name," ",user.last_name) AS x_value,COUNT(*) AS y_value FROM crm_order AS ord INNER JOIN blueskye_erp_boul_evard_main.crm_user AS user ON ord.crm_user_id=user.id  WHERE YEAR(ord.order_date) = "'.$currentYear.'" GROUP BY user.id')->queryAll();
            
            //$graph_data_quantity = Yii::app()->db->createCommand('SELECT CONCAT(user.first_name," ",user.last_name) AS x_value,COUNT(*) AS y_value FROM crm_order AS ord INNER JOIN blueskye_erp_boul_evard_main.crm_user AS user ON ord.crm_user_id=user.id INNER JOIN crm_master_file AS master_file ON ord.file_id = master_file.id WHERE master_file.current_process_status = "O"  GROUP BY user.id')->queryAll();
            $plot = '[';
           foreach($graph_data_quantity as  $m=>$eachdata ){
                $color = substr(md5(rand()), 0, 6);
                $plot .= '{label:"'.$eachdata['x_value'].'", value:'.$eachdata['y_value'].', color: "#'.$color.'"},';
                $lead_graph_details[$m]['slno']=$m+1;
                $lead_graph_details[$m]['order_owner']=$eachdata['x_value'];
                $lead_graph_details[$m]['order_count']=$eachdata['y_value'];
                $lead_graph_details[$m]['order_color']="#".$color;
                $lead_graph_details[$m]['order_owner_id']=$eachdata['OWNERID'];
            }
            $plot .= ']';
            
            foreach ($lead_graph_details as $key => $value) {
                $rowData[]=array($value['slno'],$value['order_owner'],$value['order_count'],$value['order_color'],$value['order_owner_id']);
            }
           $data['data'] = $rowData;
           $data['plot'] = $plot;
           echo json_encode($data);
     }
     
     public function actionOrderGraphOwnerDetails(){
        
            $owner_id  = $_POST['user_id'];
            $currentYear  = date("Y");
        
            $graph_detail = Yii::app()->db->createCommand('SELECT YEAR(ord.order_date) as y, MONTH(ord.order_date) as m, COUNT(ord.id) as TOTAL_COUNT,SUM(ord.grand_total) AS TOTAL_AMT FROM crm_order AS ord
                                        WHERE YEAR(ord.order_date) = "'.$currentYear.'" AND ord.crm_user_id="'.$owner_id.'" GROUP BY y, m ORDER BY y DESC, m ASC')->queryAll();
            
            $this->render('order_owner_details', array('graph_detail' => $graph_detail,'owner_id'=>$owner_id,'action'=>'view_quotes_detail'));
     }
     
     public function actionOrderGetMonthDetails(){
        
            $owner_id  = $_POST['ownerid'];
            $month     = $_POST['month'];
            $year      = $_POST['year'];
            $currentYear  = date("Y");
        
            $graph_detail = Yii::app()->db->createCommand('SELECT ord.id AS order_id,ord.company_id,ord.grand_total,ord.order_date,ord.delivery_date FROM crm_order AS ord                                                     
                                                WHERE YEAR(ord.order_date) = "'.$year.'" AND MONTH(ord.order_date) = "'.$month.'" AND ord.crm_user_id="'.$owner_id.'"')->queryAll();
            
            
            $this->render('order_owner_details', array('graph_detail' => $graph_detail,'month'=>$month,'year'=>$year,'action'=>'view_country_month_detail'));
     }
     
    /* public function actionQuotation_items(){
        
            $quotesid  = $_POST['quotesid'];
            $this->render('view_quotesItems', array('quotesid' => $quotesid));
     }

/***********************   End - order Owner ************************************************************/        
/***********************   start - order Country *****************************************************/  


public function actionGetOrderCountryDetail(){  
            $lead_graph_details=array();
            $currentYear  = date("Y");
            
            /*$graph_data_quantity = Yii::app()->db->createCommand('SELECT country.id AS COUNTRY_ID,COUNT(*) AS y_value,country.country_name AS x_value FROM crm_order AS ord
                                                        INNER JOIN crm_customer AS customer ON ord.company_id=customer.id 
                                                        INNER JOIN crm_master_file AS master_file ON ord.file_id = master_file.id 
                                                        INNER JOIN crm_mas_country AS country ON customer.customer_country=country.id 
                                                        WHERE master_file.current_process_status = "O"  GROUP BY customer.customer_country')->queryAll();*/
                                                        
            $graph_data_quantity = Yii::app()->db->createCommand('SELECT country.id AS COUNTRY_ID,COUNT(*) AS y_value,country.country_name AS x_value FROM crm_order AS ord
                                                        INNER JOIN crm_customer AS customer ON ord.company_id=customer.id 
                                                        INNER JOIN crm_mas_country AS country ON customer.customer_country=country.id 
                                                        WHERE YEAR(ord.order_date) = "'.$currentYear.'" GROUP BY customer.customer_country')->queryAll();
                        
            $plot = '[';
           foreach($graph_data_quantity as  $m=>$eachdata ){
                $color = substr(md5(rand()), 0, 6);
                $plot .= '{label:"'.$eachdata['x_value'].'", value:'.$eachdata['y_value'].', color: "#'.$color.'"},';
                $lead_graph_details[$m]['slno']=$m+1;
                $lead_graph_details[$m]['order_country']=$eachdata['x_value'];
                $lead_graph_details[$m]['order_count']=$eachdata['y_value'];
                $lead_graph_details[$m]['order_color']="#".$color;
                $lead_graph_details[$m]['order_country_id']=$eachdata['COUNTRY_ID'];
            }
            $plot .= ']';
            
            foreach ($lead_graph_details as $key => $value) {
                $rowData[]=array($value['slno'],$value['order_country'],$value['order_count'],$value['order_color'],$value['order_country_id']);
            }
           $data['data'] = $rowData;
           $data['plot'] = $plot;
           echo json_encode($data);
     }  
     
    public function actionOrderCountryDetails(){
        
            $country_id   = $_POST['country_id'];
            $currentYear  = date("Y");
            
            $graph_detail = Yii::app()->db->createCommand('SELECT YEAR(ord.order_date) as y, MONTH(ord.order_date) as m, COUNT(ord.id) as TOTAL_COUNT,SUM(ord.grand_total) AS TOTAL_AMT  FROM crm_order AS ord 
                                                        INNER JOIN crm_customer AS customer ON ord.company_id=customer.id
                                                        INNER JOIN crm_mas_country AS country ON customer.customer_country=country.id 
                                                        WHERE YEAR(ord.order_date) = "'.$currentYear.'" AND country.id="'.$country_id.'" GROUP BY y, m ORDER BY y DESC, m ASC')->queryAll();
            
            $this->render('order_country_details', array('graph_detail' => $graph_detail,'country_id'=>$country_id,'action'=>'view_country_detail'));
     }
     
     public function actionGetOrderMonthDetails(){
        
            $country_id  = $_POST['country_id'];
            $month       = $_POST['month'];
            $year        = $_POST['year'];
            $currentYear = date("Y");
            
            $graph_detail = Yii::app()->db->createCommand('SELECT ord.id AS order_id,ord.company_id,ord.grand_total,ord.order_date,ord.delivery_date FROM crm_order AS ord   
                                                        INNER JOIN crm_customer AS customer ON ord.company_id=customer.id 
                                                        INNER JOIN crm_mas_country AS country ON customer.customer_country=country.id 
                                                        WHERE YEAR(ord.order_date) = "'.$year.'" AND MONTH(ord.order_date) = "'.$month.'" AND country.id="'.$country_id.'"')->queryAll();
        
            
            $this->render('order_country_details', array('graph_detail' => $graph_detail,'action'=>'view_country_month_detail','month'=>$month,'year'=>$year));
     }

/***********************   start - order sales group *****************************************************/   


public function actionGetOrderSalesGroupDetail(){  
    
            $lead_graph_details=array();
            $currentYear  = date("Y");
                                                        
            /*$graph_data_quantity = Yii::app()->db->createCommand('SELECT sales_group.id AS SALES_GROUP_ID,sales_group.group_name AS x_value,SUM(ord.grand_total) AS y_value FROM crm_order AS ord  
                                                        INNER JOIN crm_mas_sales_group AS sales_group ON ord.sales_group=sales_group.id 
                                                        INNER JOIN crm_master_file AS master_file ON ord.file_id = master_file.id 
                                                        WHERE master_file.current_process_status = "O"  GROUP BY sales_group.id')->queryAll();*/
                                                        
            $graph_data_quantity = Yii::app()->db->createCommand('SELECT sales_group.id AS SALES_GROUP_ID,sales_group.group_name AS x_value,SUM(ord.grand_total) AS y_value FROM crm_order AS ord  
                                                        INNER JOIN crm_mas_sales_group AS sales_group ON ord.sales_group=sales_group.id                                                         
                                                        WHERE YEAR(ord.order_date) = "'.$currentYear.'"  GROUP BY sales_group.id')->queryAll();                                            
            
            $plot = '[';
           foreach($graph_data_quantity as  $m=>$eachdata ){
                $color = substr(md5(rand()), 0, 6);
                $plot .= '{label:"'.$eachdata['x_value'].'", value:'.$eachdata['y_value'].', color: "#'.$color.'"},';
                $lead_graph_details[$m]['slno']=$m+1;
                $lead_graph_details[$m]['sales_group']=$eachdata['x_value'];
                $lead_graph_details[$m]['order_count']=$eachdata['y_value'];
                $lead_graph_details[$m]['order_color']="#".$color;
                $lead_graph_details[$m]['sales_group_id']=$eachdata['SALES_GROUP_ID'];
            }
            $plot .= ']';
            
            foreach ($lead_graph_details as $key => $value) {
                $rowData[]=array($value['slno'],$value['sales_group'],$value['order_count'],$value['order_color'],$value['sales_group_id']);
            }
           $data['data'] = $rowData;
           $data['plot'] = $plot;
           echo json_encode($data);
     }
     
    public function actionOrderSalesGroupDetails(){
        
            $group_id   = $_POST['group_id'];
            $currentYear  = date("Y");
            
            
            $graph_detail = Yii::app()->db->createCommand('SELECT YEAR(ord.order_date) as y, MONTH(ord.order_date) as m, COUNT(ord.id) as TOTAL_COUNT,SUM(ord.grand_total) AS TOTAL_AMT FROM crm_order AS ord
                                                        INNER JOIN crm_mas_sales_group AS sales_group ON ord.sales_group=sales_group.id 
                                                        WHERE YEAR(ord.order_date) = "'.$currentYear.'" AND sales_group.id="'.$group_id.'" GROUP BY y, m ORDER BY y DESC, m ASC')->queryAll();
            
            $this->render('order_sales_group_details', array('graph_detail' => $graph_detail,'group_id'=>$group_id,'action'=>'view_sales_group_detail'));
     }
      public function actionOrderSalesMonthDetails(){
        
            $group_id  = $_POST['group_id'];
            $month       = $_POST['month'];
            $year        = $_POST['year'];
            $currentYear = date("Y");
            
            
            $graph_detail = Yii::app()->db->createCommand('SELECT ord.id AS order_id,ord.company_id,ord.grand_total,ord.order_date,ord.delivery_date FROM crm_order AS ord
                                                        INNER JOIN crm_mas_sales_group AS sales_group ON ord.sales_group=sales_group.id 
                                                        WHERE YEAR(ord.order_date) = "'.$year.'" AND MONTH(ord.order_date) = "'.$month.'" AND sales_group.id="'.$group_id.'"')->queryAll();
                                                        
            $this->render('order_sales_group_details', array('graph_detail' => $graph_detail,'action'=>'view_sales_group_month_detail','month'=>$month,'year'=>$year));
     }
     

/***********************   End - order sales group *****************************************************/ 
/***********************   start - order Items *****************************************************/ 
public function actionOrder_items(){
        
            $orderid  = $_POST['orderid'];
            $this->render('view_OrderItems', array('orderid' => $orderid));
} 
/***********************   End - order Items *****************************************************/ 


/***********************   Start  - Invoice Part *****************************************************/     
 
 
 
 
 public function actioninvoice_graphdetails(){  
        $type = (int) Yii::app()->request->getParam('type');
        $currentYear  = date("Y");
        
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false,'jquery-2.1.4.min.js' => false);
        if($type==1){
            //$graph_data_quantity = Yii::app()->db->createCommand('SELECT CONCAT(user.first_name," ",user.last_name) AS x_value,COUNT(*) AS y_value FROM crm_quotes AS quotes INNER JOIN blueskye_erp_boul_evard_main.crm_user AS user ON quotes.crm_user_id=user.id INNER JOIN crm_master_file AS master_file ON quotes.file_id = master_file.id WHERE master_file.current_process_status = "Q"  GROUP BY user.id')->queryAll();
            $graph_data_quantity = Yii::app()->db->createCommand('SELECT CONCAT(user.first_name," ",user.last_name) AS x_value,COUNT(*) AS y_value FROM crm_invoice AS inv 
                                                                    INNER JOIN blueskye_erp_boul_evard_main.crm_user AS user ON inv.crm_user_id=user.id 
                                                                    WHERE YEAR(inv.invoice_date) = "'.$currentYear.'"  GROUP BY user.id')->queryAll();
            $plot = '[';
           foreach($graph_data_quantity as  $m=>$eachdata ){
                $color = substr(md5(rand()), 0, 6);
                $plot .= '{label:"'.$eachdata['x_value'].'", value:'.$eachdata['y_value'].', color: "#'.$color.'"},';
            }
            $plot .= ']';
            $this->render('invoice_owner_view',array('plot'=>$plot));
        }else if($type==2){
            
            
            $graphdata = Yii::app()->db->createCommand('SELECT COUNT(*) AS y_value,country.country_name AS x_value FROM crm_invoice AS inv 
                                                        INNER JOIN crm_customer AS customer ON inv.company_id=customer.id
                                                        INNER JOIN crm_mas_country AS country ON customer.customer_country=country.id 
                                                        WHERE YEAR(inv.invoice_date) = "'.$currentYear.'"  GROUP BY customer.customer_country')->queryAll();
            
            $plot = '[';
           foreach($graphdata as  $m=>$eachdata ){
                $color = substr(md5(rand()), 0, 6);
                $plot .= '{label:"'.$eachdata['x_value'].'", value:'.$eachdata['y_value'].', color: "#'.$color.'"},';
            }
            $plot .= ']';
            
            $this->render('invoice_country_view',array('plot'=>$plot));
        }
        else if($type==3){
            
            
            $graphdata = Yii::app()->db->createCommand('SELECT sales_group.group_name AS x_value,SUM(inv.grand_total) AS y_value FROM crm_invoice AS inv
                                                        INNER JOIN crm_mas_sales_group AS sales_group ON inv.sales_group=sales_group.id 
                                                        WHERE YEAR(inv.invoice_date) = "'.$currentYear.'"  GROUP BY sales_group.id')->queryAll();
            
            
            $plot = '[';
           foreach($graphdata as  $m=>$eachdata ){
                $color = substr(md5(rand()), 0, 6);
                $plot .= '{label:"'.$eachdata['x_value'].'", value:'.$eachdata['y_value'].', color: "#'.$color.'"},';
            }
            $plot .= ']';
            
            $this->render('invoice_sales_group_view',array('plot'=>$plot));
        }
     }  
     
     
/***********************   start - Invoice Owner *****************************************************/

public function actionGetInvoiceOwnerDetail(){  
            $lead_graph_details=array();
            $currentYear  = date("Y");
            
            $graph_data_quantity = Yii::app()->db->createCommand('SELECT inv.crm_user_id AS OWNERID,CONCAT(user.first_name," ",user.last_name) AS x_value,COUNT(*) AS y_value FROM crm_invoice AS inv INNER JOIN blueskye_erp_boul_evard_main.crm_user AS user ON inv.crm_user_id=user.id  WHERE YEAR(inv.invoice_date) = "'.$currentYear.'" GROUP BY user.id')->queryAll();
            
            //$graph_data_quantity = Yii::app()->db->createCommand('SELECT CONCAT(user.first_name," ",user.last_name) AS x_value,COUNT(*) AS y_value FROM crm_order AS ord INNER JOIN blueskye_erp_boul_evard_main.crm_user AS user ON ord.crm_user_id=user.id INNER JOIN crm_master_file AS master_file ON ord.file_id = master_file.id WHERE master_file.current_process_status = "O"  GROUP BY user.id')->queryAll();
            $plot = '[';
           foreach($graph_data_quantity as  $m=>$eachdata ){
                $color = substr(md5(rand()), 0, 6);
                $plot .= '{label:"'.$eachdata['x_value'].'", value:'.$eachdata['y_value'].', color: "#'.$color.'"},';
                $lead_graph_details[$m]['slno']=$m+1;
                $lead_graph_details[$m]['order_owner']=$eachdata['x_value'];
                $lead_graph_details[$m]['order_count']=$eachdata['y_value'];
                $lead_graph_details[$m]['order_color']="#".$color;
                $lead_graph_details[$m]['order_owner_id']=$eachdata['OWNERID'];
            }
            $plot .= ']';
            
            foreach ($lead_graph_details as $key => $value) {
                $rowData[]=array($value['slno'],$value['order_owner'],$value['order_count'],$value['order_color'],$value['order_owner_id']);
            }
           $data['data'] = $rowData;
           $data['plot'] = $plot;
           echo json_encode($data);
     }
     
     public function actioninvoiceGraphOwnerDetails(){
        
            $owner_id  = $_POST['user_id'];
            $currentYear  = date("Y");
        
            $graph_detail = Yii::app()->db->createCommand('SELECT YEAR(inv.invoice_date) as y, MONTH(inv.invoice_date) as m, COUNT(inv.id) as TOTAL_COUNT,SUM(inv.grand_total) AS TOTAL_AMT FROM crm_invoice AS inv
                                        INNER JOIN crm_master_file AS master_file ON inv.file_id = master_file.id
                                        WHERE YEAR(inv.invoice_date) = "'.$currentYear.'" AND inv.crm_user_id="'.$owner_id.'" GROUP BY y, m ORDER BY y DESC, m ASC')->queryAll();
            
            $this->render('invoice_owner_details', array('graph_detail' => $graph_detail,'owner_id'=>$owner_id,'action'=>'view_quotes_detail'));
     }
     
     public function actionInvoiceGetMonthDetails(){
        
            $owner_id  = $_POST['ownerid'];
            $month     = $_POST['month'];
            $year      = $_POST['year'];
            $currentYear  = date("Y");
        
            $graph_detail = Yii::app()->db->createCommand('SELECT inv.id AS invoice_id,inv.company_id,inv.grand_total,inv.invoice_date FROM crm_invoice AS inv
                                                    INNER JOIN crm_master_file AS master_file ON inv.file_id = master_file.id 
                                                WHERE YEAR(inv.invoice_date) = "'.$year.'" AND MONTH(inv.invoice_date) = "'.$month.'" AND inv.crm_user_id="'.$owner_id.'"')->queryAll();
            
            
            $this->render('invoice_owner_details', array('graph_detail' => $graph_detail,'month'=>$month,'year'=>$year,'action'=>'view_country_month_detail'));
     }

/***********************   End - Invoice Owner ************************************************************/       
     
/***********************   start - Invoice Country *****************************************************/  


public function actionGetInvoiceCountryDetail(){  
            $lead_graph_details=array();
            
            $currentYear  = date("Y");
            
            $graph_data_quantity = Yii::app()->db->createCommand('SELECT country.id AS COUNTRY_ID,COUNT(*) AS y_value,country.country_name AS x_value FROM crm_invoice AS inv
                                                        INNER JOIN crm_customer AS customer ON inv.company_id=customer.id 
                                                        INNER JOIN crm_mas_country AS country ON customer.customer_country=country.id 
                                                        WHERE YEAR(inv.invoice_date) = "'.$currentYear.'"   GROUP BY customer.customer_country')->queryAll();
            
            $plot = '[';
           foreach($graph_data_quantity as  $m=>$eachdata ){
                $color = substr(md5(rand()), 0, 6);
                $plot .= '{label:"'.$eachdata['x_value'].'", value:'.$eachdata['y_value'].', color: "#'.$color.'"},';
                $lead_graph_details[$m]['slno']=$m+1;
                $lead_graph_details[$m]['order_country']=$eachdata['x_value'];
                $lead_graph_details[$m]['order_count']=$eachdata['y_value'];
                $lead_graph_details[$m]['order_color']="#".$color;
                $lead_graph_details[$m]['order_country_id']=$eachdata['COUNTRY_ID'];
            }
            $plot .= ']';
            
            foreach ($lead_graph_details as $key => $value) {
                $rowData[]=array($value['slno'],$value['order_country'],$value['order_count'],$value['order_color'],$value['order_country_id']);
            }
           $data['data'] = $rowData;
           $data['plot'] = $plot;
           echo json_encode($data);
     }  
     
    public function actioninvoiceCountryDetails(){
        
            $country_id   = $_POST['country_id'];
            $currentYear  = date("Y");
            
            $graph_detail = Yii::app()->db->createCommand('SELECT YEAR(inv.invoice_date) as y, MONTH(inv.invoice_date) as m, COUNT(inv.id) as TOTAL_COUNT,SUM(inv.grand_total) AS TOTAL_AMT  FROM crm_invoice AS inv
                                                        INNER JOIN crm_customer AS customer ON inv.company_id=customer.id  
                                                        INNER JOIN crm_mas_country AS country ON customer.customer_country=country.id 
                                                        WHERE YEAR(inv.invoice_date) = "'.$currentYear.'" AND country.id="'.$country_id.'" GROUP BY y, m ORDER BY y DESC, m ASC')->queryAll();
            
            $this->render('invoice_country_details', array('graph_detail' => $graph_detail,'country_id'=>$country_id,'action'=>'view_country_detail'));
     }
     
     public function actionGetInvoiceMonthDetails(){
        
            $country_id  = $_POST['country_id'];
            $month       = $_POST['month'];
            $year        = $_POST['year'];
            $currentYear = date("Y");
            
            $graph_detail = Yii::app()->db->createCommand('SELECT inv.id AS invoice_id,inv.company_id,inv.grand_total,inv.invoice_date FROM crm_invoice AS inv  
                                                        INNER JOIN crm_customer AS customer ON inv.company_id=customer.id 
                                                        INNER JOIN crm_mas_country AS country ON customer.customer_country=country.id 
                                                        WHERE YEAR(inv.invoice_date) = "'.$year.'" AND MONTH(inv.invoice_date) = "'.$month.'" AND country.id="'.$country_id.'"')->queryAll();
        
            
            $this->render('invoice_country_details', array('graph_detail' => $graph_detail,'action'=>'view_country_month_detail','month'=>$month,'year'=>$year));
     }

/***********************   start - invoice sales group *****************************************************/   


public function actionGetInvoiceSalesGroupDetail(){  
    
            $lead_graph_details=array();
            $currentYear  = date("Y");
                                                        
            $graph_data_quantity = Yii::app()->db->createCommand('SELECT sales_group.id AS SALES_GROUP_ID,sales_group.group_name AS x_value,SUM(inv.grand_total) AS y_value FROM crm_invoice AS inv 
                                                        INNER JOIN crm_mas_sales_group AS sales_group ON inv.sales_group=sales_group.id                                                          
                                                        WHERE YEAR(inv.invoice_date) = "'.$currentYear.'"  GROUP BY sales_group.id')->queryAll();
            
            $plot = '[';
           foreach($graph_data_quantity as  $m=>$eachdata ){
                $color = substr(md5(rand()), 0, 6);
                $plot .= '{label:"'.$eachdata['x_value'].'", value:'.$eachdata['y_value'].', color: "#'.$color.'"},';
                $lead_graph_details[$m]['slno']=$m+1;
                $lead_graph_details[$m]['sales_group']=$eachdata['x_value'];
                $lead_graph_details[$m]['order_count']=$eachdata['y_value'];
                $lead_graph_details[$m]['order_color']="#".$color;
                $lead_graph_details[$m]['sales_group_id']=$eachdata['SALES_GROUP_ID'];
            }
            $plot .= ']';
            
            foreach ($lead_graph_details as $key => $value) {
                $rowData[]=array($value['slno'],$value['sales_group'],$value['order_count'],$value['order_color'],$value['sales_group_id']);
            }
           $data['data'] = $rowData;
           $data['plot'] = $plot;
           echo json_encode($data);
     }
     
    public function actionInvoiceSalesGroupDetails(){
        
            $group_id   = $_POST['group_id'];
            $currentYear  = date("Y");
            
            
            $graph_detail = Yii::app()->db->createCommand('SELECT YEAR(inv.invoice_date) as y, MONTH(inv.invoice_date) as m, COUNT(inv.id) as TOTAL_COUNT,SUM(inv.grand_total) AS TOTAL_AMT FROM crm_invoice AS inv
                                                        INNER JOIN crm_mas_sales_group AS sales_group ON inv.sales_group=sales_group.id                                                          
                                                        WHERE YEAR(inv.invoice_date) = "'.$currentYear.'" AND sales_group.id="'.$group_id.'" GROUP BY y, m ORDER BY y DESC, m ASC')->queryAll();
            
            $this->render('invoice_sales_group_details', array('graph_detail' => $graph_detail,'group_id'=>$group_id,'action'=>'view_sales_group_detail'));
     }
      public function actionInvoiceSalesMonthDetails(){
        
            $group_id  = $_POST['group_id'];
            $month       = $_POST['month'];
            $year        = $_POST['year'];
            $currentYear = date("Y");
            
            
            $graph_detail = Yii::app()->db->createCommand('SELECT inv.id AS invoice_id,inv.company_id,inv.grand_total,inv.invoice_date FROM crm_invoice AS inv
                                                        INNER JOIN crm_mas_sales_group AS sales_group ON inv.sales_group=sales_group.id  
                                                        WHERE YEAR(inv.invoice_date) = "'.$year.'" AND MONTH(inv.invoice_date) = "'.$month.'" AND sales_group.id="'.$group_id.'"')->queryAll();
                                                        
            $this->render('invoice_sales_group_details', array('graph_detail' => $graph_detail,'action'=>'view_sales_group_month_detail','month'=>$month,'year'=>$year));
     }
     

/***********************   End - invoice sales group *****************************************************/ 
/***********************   start - invoice Items *****************************************************/ 
public function actiongetInvoiceItems(){
        
            $invoice_id  = $_POST['invoice_id'];
            $this->render('view_InvoiceItems', array('invoice_id' => $invoice_id));
} 
/***********************   End - order Items *****************************************************/ 
      
     
}