<?php
class CustomercontactController extends Controller
{
    public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                  'actions' => array('login', 'error', 'logout'),
                  'users' => array('*'),
                  ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                  'actions' => array('Index','Create','GetCustomerContactList','SaveContact','DeleteContact','GetCustomerContactdetails'),
                  'expression' => '$user->isMember()',
                  ),
                array('deny', // deny all users
                  'users' => array('*'),
                  ),
                );
    }
    public function filters()
    {
        return array(
                'accessControl', // perform access control for CRUD operations
                );
    }
    public function actionIndex()
    {
        $models = CustomerContact::model()->findAll();
        $this->render('index',array('model' => $model), false, true);
    }
    public function actionGetCustomerContactList()
    {
        $model=new CustomerContact();
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
        // datatable column index  => database column name
           0 =>'person_name',
           1 => 'designation',
           2=> 'contact_phone_no',
           3=> 'customer.customer_name',
           
           );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
        $condition = 't.isActive="Y"';
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
          $searchString = $_POST['search']['value'];
          $condition.=" AND (person_name LIKE '%".$searchString."%' OR designation LIKE '%".$searchString."%' OR contact_phone_no LIKE '%".$searchString."%')";
      }
      $count = $model->count(array('condition'=>$condition));
      $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
      $recordsTotal = $count;
      $recordsFiltered = $count;
      $data['draw'] = $draw;
      $data['recordsTotal'] = $recordsTotal;
      $data['recordsFiltered'] = $recordsFiltered;
      $rowData=array();
      foreach ($model as $row)
      {
         
          $rowData[]=array($row['person_name'],$row['designation'],$row['contact_phone_no'],$row['customer']['customer_name'],
              '<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'customercontact/create&id='.$row['id'].'\',\'Edit Contact\',\'lg\')"><i class="fa fa-pencil"></i></button> '
             .'<a href ="#" class="btn btn-danger btn-xs" onclick="deleteContact('.$row['id'].')"><i class="fa fa-trash-o "></i></a></div>');
      }
      $data['data'] = $rowData;
      echo json_encode($data);
  }
    public function actionCreate()
    {
        $id = (int) Yii::app()->request->getParam('id');
        $model=new CustomerContact();
        if($id > 0)
        {
            $model=$model->findByPk($id);
        }
        $this->render('contact_form', array('model' => $model), false, true);
    }
  
    public function actionSaveContact()
    {
        $model=new CustomerContact();
    	/************ START Code for Save ***************/
    	if (isset($_POST['CustomerContact'])) {
    		
    		if ((int) @$_POST['CustomerContact']['id'] > 0) {
                        $model->id = (int) $_POST['CustomerContact']['id'];
                        $model = $model->findByPK($model->id);
    			$model->last_updated_by = Yii::app()->user->id;
    			$model->last_updated_date = date('y-m-d');
                        $model->updated_by = Yii::app()->user->id;
                        $model->updated_datetime =date('Y-m-d h:i:s');
                }else{
                        $model->crm_user_id = Yii::app()->user->id;
                        $model->created_by = Yii::app()->user->id;
    			$model->created_date = date('y-m-d');
                }
                
            $model->attributes=$_POST['CustomerContact'];
            $model->notes = $_POST['CustomerContact']['notes'];
//            $model->notes = $_POST['CustomerContact']['customer_id']
           if ($model->save())
	    {
                        $jsonData['status'] = 'success';
                        $jsonData['frm'] = $_POST['customer_form'];
                        $jsonData['id'] = $model->id;
	                echo CJSON::encode($jsonData);
            }
	    else
	    {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
            }
//             $this->render('contact_form', array('model' => $model), false, true);

        }
    }
     public function actionDeleteContact()
    {
		$id = $_POST['id'];
                $model=new CustomerContact();
                $model->deleteByPk($id);
                echo "success";
    }
    
    public function actionGetCustomerContactdetails()
    {
        $id                 =   (int) Yii::app()->request->getparam("id");  
        $model_name         =   Yii::app()->request->getparam("model_name");  
        
        $contact_field_id   =   Yii::app()->request->getparam("contact_field_id");
        
        $models             =   CustomerContact::getCustomerContacts($id); 
        /*echo '<pre>';
        print_r($models);
        exit;*/
        
        $model = new $model_name;
        $drop='<li class="col-sm-6">';
        $drop.=CHtml::activedropDownList($model,$contact_field_id , $models,  array('data-label'=>'Contact','data-search'=>true,'prompt'=>'--Select Contact--'));    
        $drop.='</li>';
        
        $status=array("dt" => $drop);      
        echo CJSON::encode($status);
    }
    
}
