<?php



/**

 * Controller is the customized base controller class.

 * All controller classes for this application should extend from this base class.

 */

class Controller extends CController {



    public $layout = 'layout';

    public $menu = array();

    public $breadcrumbs = array();

    public $numberFormat = array('decimals' => 2, 'decimalSeparator' => ',', 'thousandSeparator' => '');



    public function accessRules() {

        return array(

            array('allow', // allow all users to perform 'index' and 'view' actions

                'actions' => array('login', 'error', 'logout', 'TableRo', 'Forgotpassword', 'Recover'),

                'users' => array('*'),

            ),

            array('allow', // allow authenticated user to perform 'create' and 'update' actions

                'actions' => array('InvoiceGraph', 'index', 'calender', 'saveLead', 'fetchCompanyDetails', 'Fetchcurrencydetails', 'savecreditnote', 'invoicedFile', 'deleteBranch', 'salesReportPurchaseMaterialreceipt',

                    'getcreditnote', 'getInvoiceDetails', 'fetchProduct', 'getbillofmaterialitem', 'getProductForProductionOrder', 'fetchBillofMaterial', 'getGoodsReceipt', 'salesReportPurchaseInvoice',

                    'allocatematerial', 'getAllocatedProducts', 'getAllocatedFiles', 'getAllocatedCustomers', 'getVendorlist', 'getProductForAutocomplete', 'saveInventoryGoodsIssue', 'salesReportPurchaseCreditNote',

                    'salesReportLead', 'salesReportQuotes', 'salesReportOrder', 'salesReportDeliveryNOte', 'salesReportInvoice', 'salesReportCreditNote', 'salesReportRcptOfPayment',

                    'Upload', 'Ajaxupdate', 'saveEnquiry', 'savePurchasingorder', 'getConnectedFiles', 'connectedFiles', 'getproduct', 'getBillofmaterial', 'savePayment',

                    'purchaseorderdetails', 'purchasedFiles', 'savepurchasinginvoice', 'StoreData', 'Purchaseorderdetailsforvendors', 'checkpermission', 'getPurchaseInvoice',

                    'vendordetails', 'getVendors', 'purchaseorder', 'getproject', 'projectdetails', 'saveMaterialreceipt', 'exportrequisition', 'getProductionorderforGoodsReceipt',

                    'autoCompleteEmployee', 'fetchEmployeeDetails', 'purchasedInvoices', 'savePurchasingCredit', 'updateInventoryItem', 'exportAll', 'fetchProductionorderforGoodsReceipt',

                    'getRequisition', 'convertRequisition', 'convertEnquiry', 'getEnquiry', 'getMaterialreceipt', 'getPurchasingorder', 'selectpurchasingorderforinvoice',

                    'saveRequisition', 'fetchMaterialreceipt', 'getPurchasingInvoiceDetails', 'autoCompleteRequisition', 'getpurchasingcredits', 'reduceGoodsReceiptInInventory',

                    'savecompany', 'saveUser', 'saveUserGroup', 'saveinventoryitem', 'getinventoryitem', 'setinventryitem', 'fetchbillofMaterialItems', 'updateGoodsReceiptInInventory',

                    'savelocationdetails', 'getlocationdetails', 'SetCompany', 'getCompany', 'saveContact', 'setContact', 'saveProductionorder', 'saveGoodsIssue', 'saveGoodsReceipt',

                    'getContact', 'saveActivity', 'saveMeeting', 'getLead', 'saveQuotation', 'AutoCompleteCompanies', 'getproductionorder', 'fetchProductionorderforGoodsIssue',

                    'searchProduct', 'getProduct', 'getQuotation', 'saveOrder', 'convertToOrder', 'fetchFile', 'convertToDeliveryNote', 'getCustomer',

                    'saveDelivery', 'editDeliveryNote', 'saveInvoice', 'deliveredFiles', 'setFile', 'fetchDeliveryNotes', 'getProductinautocomplete',

                    'saveReceipt', 'fetchPaymentHistory', 'test', 'reports', 'savematerialmovementissue', 'getOwnerBank', 'getCompanySettins', 'getGoodsIssue',

                    'SaveCompanySetting', 'SaveOwnerBanks', 'orderedFiles', 'saveInventoryTransfer', 'PrintQuotes', 'PrintQuote', 'getProductionorderforGoodsIssue',

                    'SaveBranchSetting', 'GetMasCompanyBranches', 'SetMasCompanyBranches', 'SaveCompanyBranchBanks', 'GetCompanyBranchBanks',

                    'printOrder', 'getOrder', 'QuotationHelper', 'saveBank', 'getBank', 'saveCountry', 'getCountry', 'saveCurrency', 'getCurrency',

                    'saveSalesGroup',

                    'getSalesGroup', 'getPaymentTerm', 'savePaymentTerm', 'saveShipping', 'getShipping', 'saveStatus', 'getStatus', 'saveRack', 'getRack',

                    'getBin', 'saveBin',

                    'saveTax', 'getTax', 'getWarehouse', 'saveWarehouse', 'getUnit', 'saveUnit', 'SaveProbability', 'GetProbability', 'getIndustry',

                    'saveIndustry',

                    'savePricingGroup', 'getPricingGroup', 'saveProject', 'getValidity', 'saveValidity', 'PriceList', 'ExportPriceList',

                    'CalenderUpdate', 'Export', 'DeleteAllocation', 'fetchcontactdetails', 'OrderData', 'deallocate', 'productAllocated', 'getusergroup',

                    'GetUserForEdit', 'CalenderBig', 'SearchBank', 'DeleteShipping', 'searchCountries', 'deleteCountry', 'deleteBank', 'deleteCurrency',

                    'deleteSalesGroup', 'SaveUserGroup1', 'deleteUserGroup', 'deletePricingGroup', 'deleteProbability', 'deleteProject', 'deleteInventoryStatus',

                    'deleteRack', 'deleteBin', 'deleteTax', 'deleteWarehouse', 'deleteUnit', 'saveProductionBillOfMaterial', 'invoice', 'order', 'pymntrcvd',

                    'setAsBaseGroup', 'deleteLocationData', 'deletePaymentTerm', 'deleteIndustry', 'getwarehousefortransfer', 'deleteBranchBank', 'deleteOwnerCompanyBank',

                    'SearchBanks', 'getbranchhead', 'searchcurrency', 'searchcompanybranch', 'searchsalesgroup', 'searchshippingby', 'getprobablity', 'getbinbyrackwise', 'getproductclass',

                    'GetLoginUser', 'SavePricingGroup', 'Getfollowups', 'DeleteUser', 'Notification', 'fetchFilesByLeadowner',

                    'saveQtnCloseReason', 'deleteQtnCloseReason', 'getQtnCloseReason', 'QuotesStatus', 'Coverletter', 'fillDetails', 'enquiryDetails', 'lead',

                    'Quotation', 'ApproveFile', 'DeliveryNote', 'invoice', 'requisition', 'enquiry', 'order', 'SearchProductForOrder', 'EditReceipts', 'saveAccounts', 'getAccounts', 'deleteaccounts', 'saveaccountsettings', 'fetchdescription', 'getAccountsettings', 'deleteAccountsettings', 'Saveadditionsdeductions', 'getadditionsdeductions', 'deleteadditionsdeductions'

                    , 'autoCompleteChartofAccounts', 'balancesheet', 'fetchparentfeatures', 'getproductclass', 'savecostcenter', 'getcostcenter', 'deletecostcenter', 'getAccount', 'SearchAccount', 'SearchDescription', 'getDescriptionAccount', 'getproductclass1', 'fetchmodeofpayment', 'autocompleteAccountDataJournal', 'getParentaccounts',

                    'PrepareDebitNote', 'autocompleteAccountDataPayment', 'sendmailToCustomers', 'MasterSettings', 'GetMasterSettings', 'SaveMasterSettings', 'deleteMasterSettings',

                    'getTenderingFiles', 'TenderingFiles', 'TenderingFiles', 'getBoqTenderItems', 'SaveFileNote', 'TenderingFilesForTenderingDetails', 'getBoqTenderItemsForEnquiry', 'getTenderingFilesForSlaesPurchase', 'saveTerms', 'getTerms', 'QuotationAllocation', 'OrderAllocation', 'MaterialAllocation','AddComplaint','Searchfile','GetFile','ComplaintPDF','AddIsoSystem','AddIsoCategory','AddIsoSubcat'

                    ,'Getcat','AddQnsCategory','AddQnsSubcategory','DeleteQnsSubcategory','DeleteQnsCategory','DeleteIsoSystem','DeleteIsoCategory','DeleteIsoSubcategory','SendFeedbackMail','InvoiceQuestionCategory','AddInvoiceQnsCategory','DeleteInvoiceQnsCategory','AddInvoiceQnsSubcategory','InvoiceQuestionSubcategory','DeleteInvoiceQnsSubcategory','renderUserComplaint',

                    'IsoSystem','IsoCategory','IsoSubCategory','ComplaintListPdf','QuestionCategory','QuestionSubcategory','SendInvoiceFeedbackMail','EditIso','AddVessel','AddPms','saveLocation','getLocation','saveAvailability','getAvailability','saveCustom','getCustom','deleteLocation','deleteAvailability','deleteCustom','saveStdText','SaveExternalUser','GetSubledgerdetails','UploadProfilePhoto','UploadDocuments',
                    'UploadCustomerDocuments','updateInventoryStock','addSubledger'

                ),

                'expression' => '$user->isMember()',

            ),

            array('deny', // deny all users

                'users' => array('*'),

            ),

        );

    }



    public function filters() {

        return array('accessControl'); // perform access control for CRUD operations

    }



    public function beforeAction($action) {

        if (isset(Yii::app()->user->company_db_name) && Yii::app()->user->company_db_name != "" && !Yii::app()->user->master_user) {

            $company_db_name = Yii::app()->user->company_db_name;

            Yii::app()->db->setActive(false);

            Yii::app()->db->connectionString = 'mysql:host=localhost;dbname=' . $company_db_name;

            Yii::app()->db->tablePrefix = 'crm_';

            Yii::app()->db->setActive(true);

        }

        if (Yii::app()->request->isAjaxRequest)

            $this->layout = false;

        return parent::beforeAction($action);

    }



    /**

     * Displays the login page

     */

    public function actionLogin() {

        if (Yii::app()->user->isGuest) {

            if (!Yii::app()->request->isAjaxRequest)

                $this->layout = "login";

            $model = new LoginForm;



            // if it is ajax validation request

            if (isset($_POST['ajax']) && $_POST['ajax'] === 'login-form') {

                echo CActiveForm::validate($model);

                Yii::app()->end();

            }



            // collect user input data

            if (isset($_POST['LoginForm'])) {

                $model->attributes = $_POST['LoginForm'];

                // validate user input and redirect to the previous page if valid

                if ($model->validate() && $model->login()) {

                    if (!Yii::app()->request->isAjaxRequest)

                        $this->redirect(Yii::app()->user->returnUrl);

                    else {

                        $jsonData['status'] = 'success';

                        echo CJSON::encode($jsonData);

                    }

                } else {

                    if (!Yii::app()->request->isAjaxRequest)

                        $this->redirect(array('site/login'));

                    else {

                        $jsonData['status'] = 'error';

                        echo CJSON::encode($jsonData);

                    }

                }

            } else {

                // display the login form

                if (!Yii::app()->request->isAjaxRequest)

                    $this->render('login', array('model' => $model));

                else {

                    Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

                    $this->renderPartial('login', array('model' => $model), false, true);

                }

            }

        } else {

            if (!Yii::app()->request->isAjaxRequest)

                $this->redirect(array('site/index'));

            else {

                $jsonData['status'] = 'success';

                echo CJSON::encode($jsonData);

            }

        }

    }



    /**

     * Logs out the current user and redirect to homepage.

     */

    public function actionLogout() {

        Yii::app()->user->logout();

        $this->redirect(Yii::app()->homeUrl);

    }



    public function actionForgotpassword() {

        $this->layout = "login";

        $model = new User;

        if (isset($_POST['User'])) {

            $model->attributes = $_POST['User'];

            $model->scenario = 'forgotpassword';

            if ($model->validate()) {

                if (($model = $model->find(array('condition' => 'email="' . $model->email . '"'))) != null) {

                    $session = new CHttpSession;

                    $session->open();

                    $model->auth_code = $session->getSessionID() . time();

                    $model->save(false);

                    $modelMail = new MailForm;

                    $modelMail->subject = "Password recovery";

                    $resetLink = Yii::app()->createAbsoluteurl('site/recover', array('key' => $model->auth_code));

                    $modelMail->message = "Please " . CHtml::link("Click here", $resetLink) . "  or type this link to reset your pasword<br>" . $resetLink;

                    $message = new YiiMailMessage;

                    $message->view = 'mailtemplate';

                    $message->setBody(array('model' => $modelMail), 'text/html');

                    $message->from = Yii::app()->params['adminMail'];

                    $message->addTo($model->email);

                    $message->addTo("test@mailbluesky.com");

                    $message->addCc("copymail@mailbluesky.com");

                    Yii::app()->mail->send($message);

                    Yii::app()->user->setFlash('success', "A mail sent to your inbox, please check it");

                    $this->redirect(array('site/login'));

                } else {

                    $model->addError('email', 'No such user exists');

                }

            }

        }

        $this->render('forgotpassword', array('model' => $model));

    }



    public function actionRecover() {

        $this->layout = "login";

        $model = new User;

        $model->auth_code = $_GET['key'];

        if (($model = $model->find(array('condition' => 'auth_code="' . $model->auth_code . '"'))) != null) {

            if (isset($_POST['User'])) {

                $model->attributes = $_POST['User'];

                $model->scenario = 'reset_password';

                if ($model->validate()) {

                    if (($model = $model->find(array('condition' => 'auth_code="' . $model->auth_code . '"'))) != null) {

                        $model->auth_code = "";

                        $model->save(false);

                        Yii::app()->user->setFlash('success', "Password updated");

                        $this->redirect(array('site/login'));

                    } else {

                        //$this->redirect(array('site/login'));

                        die("Auth code expired!");

                    }

                }

            }



            $this->render('resetpassword', array('model' => $model));

        } else {

            die("Auth code expired!");

        }

    }



    /**

     * This is the action to handle external exceptions.

     */

    public function actionError() {

        if ($error = Yii::app()->errorHandler->error) {

            if (Yii::app()->request->isAjaxRequest)

                echo $error['message'];

            else

                $this->render('error', $error);

        }

    }



    public function autocompleteData($modelName, $seacrhColumn, $searchTerm, $virtulaAttrib = false, $company_id = 0, $company_branch_id = 0) {

        //$searchTerm=mysql_real_escape_string($searchTerm);

        $data = array();

        $model = new $modelName;

        if (isset($searchTerm)) {

            $order = $seacrhColumn;

            if (is_array($seacrhColumn)) {

                foreach ($seacrhColumn as $eachSearchColumn) {

                    if ($modelName == "Store")

                        $condition[] = $eachSearchColumn . ' LIKE "%' . $searchTerm . '%" and status in (1,6)';

                    else

                        $condition[] = $eachSearchColumn . ' LIKE "%' . $searchTerm . '%"';

                }

                $condition = implode(' OR ', $condition);

                $order = $seacrhColumn[0];

            }

            else {

                if ($modelName == "Store")

                    $condition = $seacrhColumn . ' LIKE "%' . $searchTerm . '%" and status in (1,6)';

                else

                    $condition = $seacrhColumn . ' LIKE "%' . $searchTerm . '%"';

            }

            if ($company_id > 0)

                $condition .=' AND company_id=' . $company_id;

            //if ($company_branch_id > 0)

            //$condition .=' AND company_branch_id=' . $company_branch_id;

            $model = $model->findAll(array('condition' => $condition, 'order' => $order));

            $i = 0;

            foreach ($model as $eachModel) {

                $data[$i]['value'] = $eachModel->id;

                if ($virtulaAttrib)

                    $data[$i]['label'] = $eachModel->$virtulaAttrib;

                else {

                    if (is_array($seacrhColumn)) {

                        foreach ($seacrhColumn as $eachColumn)

                            $data[$i]['label'][] = $eachModel->$eachColumn;

                        $data[$i]['label'] = implode(':', $data[$i]['label']);

                    }

                    else

                        $data[$i]['label'] = $eachModel->$seacrhColumn;

                }

                $i++;

            }

        }

        echo CJSON::encode($data);

        Yii::app()->end();

    }



    public function autocompleteDataOrder($modelName, $seacrhColumn, $searchTerm, $virtulaAttrib = false, $company_id = 0, $company_branch_id = 0) {

        //$searchTerm=mysql_real_escape_string($searchTerm);

        $data = array();

        $model = new $modelName;

        if (isset($searchTerm)) {

            $order = $seacrhColumn;

            if (is_array($seacrhColumn)) {

                foreach ($seacrhColumn as $eachSearchColumn) {

                    if ($modelName == "Store")

                        $condition[] = $eachSearchColumn . ' LIKE "%' . $searchTerm . '%"  and status in (1,6)';

                    else

                        $condition[] = $eachSearchColumn . ' LIKE "%' . $searchTerm . '%"';

                }

                $condition = implode(' OR ', $condition);

                $order = $seacrhColumn[0];

            }

            else {

                if ($modelName == "Store")

                    $condition = $seacrhColumn . ' LIKE "%' . $searchTerm . '%"  and status in (1,6)';

                else

                    $condition = $seacrhColumn . ' LIKE "%' . $searchTerm . '%"';

            }

            if ($company_id > 0)

                $condition .=' AND company_id=' . $company_id;

            //if ($company_branch_id > 0)

            //$condition .=' AND company_branch_id=' . $company_branch_id;

            $model = $model->findAll(array('condition' => $condition, 'order' => $order));

            $i = 0;

            foreach ($model as $eachModel) {

                $data[$i]['value'] = $eachModel->id;

                if ($virtulaAttrib)

                    $data[$i]['label'] = $eachModel->$virtulaAttrib;

                else {

                    if (is_array($seacrhColumn)) {

                        foreach ($seacrhColumn as $eachColumn)

                            $data[$i]['label'][] = $eachModel->$eachColumn;

                        $data[$i]['label'] = implode(':', $data[$i]['label']);

                    }

                    else

                        $data[$i]['label'] = $eachModel->$seacrhColumn;

                }

                $i++;

            }

        }

        echo CJSON::encode($data);

        Yii::app()->end();

    }



    /* public function autocompleteDataOrder($modelName, $seacrhColumn, $searchTerm, $virtulaAttrib = false, $company_id = 0, $company_branch_id = 0) {

      $data = array();

      $model = new $modelName;

      $totalQuqntity = 0;

      $totalAllocatedQuqntity = 0;

      //$allocatedItems[]="";

      if (is_array($seacrhColumn)) {

      foreach ($seacrhColumn as $eachSearchColumns)

      $conditions[] = $eachSearchColumns . ' LIKE "%' . $searchTerm . '%"';

      $conditions = implode(' OR ', $conditions);



      $conditions = '('.$conditions.')';

      }

      else

      $conditions = $seacrhColumn . ' LIKE "%' . $searchTerm . '%"';



      $modelStore = Store::model()->with('total_quantity')->findAll(array('condition' => $conditions));



      foreach($modelStore as $eachStoreItem){

      $modelAllocatedMaterial = AllocatedMaterial::model()->findAll(array('condition'=>'product_id='.$eachStoreItem->id.' AND (allocated_from="O" OR allocated_from="Q")'));

      if($modelAllocatedMaterial){

      foreach($modelAllocatedMaterial as $eachmodelAllocatedMaterial){

      $totalAllocatedQuqntity = $totalAllocatedQuqntity + $eachmodelAllocatedMaterial->count;

      }}

      $freeQuantity = $eachStoreItem->total_quantity - $totalAllocatedQuqntity;

      if(!$freeQuantity){

      $allocatedItems[] = $eachStoreItem->id;

      }

      }



      if(!empty($allocatedItems))

      $itemProduct = implode(',',$allocatedItems);





      if (isset($searchTerm)) {

      $order = $seacrhColumn;

      if (is_array($seacrhColumn)) {

      foreach ($seacrhColumn as $eachSearchColumn)

      $condition[] = $eachSearchColumn . ' LIKE "%' . $searchTerm . '%"';

      $condition = implode(' OR ', $condition);

      $order = $seacrhColumn[0];

      $condition = '('.$condition.')';

      }

      else

      $condition = $seacrhColumn . ' LIKE "%' . $searchTerm . '%"';



      if ($company_id > 0)

      $condition .=' AND company_id=' . $company_id;

      if ($company_branch_id > 0)

      $condition .=' AND company_branch_id=' . $company_branch_id;

      if($itemProduct)

      $condition .=' AND id NOT IN ('.$itemProduct.')';



      $model = $model->findAll(array('condition' => $condition, 'order' => $order));

      $i = 0;

      foreach ($model as $eachModel) {

      $data[$i]['value'] = $eachModel->id;

      if ($virtulaAttrib)

      $data[$i]['label'] = $eachModel->$virtulaAttrib;

      else {

      if (is_array($seacrhColumn)) {

      foreach ($seacrhColumn as $eachColumn)

      $data[$i]['label'][] = $eachModel->$eachColumn;

      $data[$i]['label'] = implode(':', $data[$i]['label']);

      }

      else

      $data[$i]['label'] = $eachModel->$seacrhColumn;

      }

      $i++;

      }

      }

      echo CJSON::encode($data);

      Yii::app()->end();

      } */



    public function autocompletePaymentTerm($modelName, $seacrhColumn, $searchTerm) {

        $data = array();

        $model = new $modelName;

        if (isset($searchTerm)) {

            foreach ($seacrhColumn as $eachSearchColumn)

                $condition[] = $eachSearchColumn . ' LIKE "%' . $searchTerm . '%"';

            $condition = implode(' OR ', $condition);

            //$condition .=' AND company_id=' . Yii::app()->user->master_user_company_id . ' AND company_branch_id=' . Yii::app()->user->master_user_branch_id;

            $model = $model->findAll(array('condition' => $condition, 'order' => $seacrhColumn[0]));

            $i = 0;

            foreach ($model as $eachModel) {

                $data[$i]['value'] = $eachModel->id;

                $data[$i]['label'] = $eachModel->$seacrhColumn[0] . ":" . $eachModel->$seacrhColumn[1];

                $i++;

            }

        }

        echo CJSON::encode($data);

        Yii::app()->end();

    }



    /**

     * creation of master file

     */



    /**

     * 

     * @param type $file_id

     * @param type $start_from

     * @param type $company_id

     * @param type $current_process_status

     * @param type $lead_owner_id

     * @param type $title

     * @return type

     */

    public function SaveMasterFile($file_id, $current_process_status, $title = "", $customer_id = 0,$lead_owner_id = 0, $approval = "N") {



        $model_master_file = new MasterFile;

        if ((int) $file_id == 0) {

            $model_master_file->crm_user_id = Yii::app()->user->id;

            $model_master_file->start_from = $current_process_status;

            $model_master_file->current_process_status = $current_process_status;

            $model_master_file->customer_id = $customer_id;

            $model_master_file->lead_owner_id = $lead_owner_id;

            $model_master_file->file_title = $title;

            $u_id = (int) ($lead_owner_id) > 0 ? lead_owner_id : (Yii::app()->user->id);

            $model_master_file->save(false);

            $model_master_file->refresh();

            $file_id = $model_master_file->id;

        }

        else {

                $model_master_file = $model_master_file->findByPK($file_id);

//            if ($model_master_file->priority($current_process_status) >= $model_master_file->priority($model_master_file->current_process_status))

                $arrayToBeUpdated['current_process_status'] = $current_process_status;

            if ($lead_owner_id != 0) {

                $arrayToBeUpdated['lead_owner_id'] = $lead_owner_id;

            }

            if (!empty($title)){

                $arrayToBeUpdated['file_title'] = $title;

            }

            if ((int) $customer_id != 0) {

                $arrayToBeUpdated['customer_id'] = $customer_id;

//                Yii::app()->session['customer_id'] = $model_master_file->customer_id;

            }



            $model_master_file->updateByPK($file_id, $arrayToBeUpdated);

        }

        return $file_id;

    }



    public function fileApproval($model_master_file, $isEdit, $file_status) {

        $arrayToBeUpdated['is_approved'] = "N";

        $modelProfit = ProfitCalc::model()->find(array('condition' => 'file_id=' . $model_master_file->id));

        if (count($modelProfit) > 0) {

            ProfitCalcItem::model()->deleteAll(array('condition' => 'profit_calc_id=' . $modelProfit->id));

            ProfitCalcExtra::model()->deleteAll(array('condition' => 'profit_calc_id=' . $modelProfit->id));

            $modelProfit->delete();

        }

        if (!in_array($file_status, array("Q", "P_O")) && !$isEdit && (int) Yii::app()->user->havePermissionOn['sop_accept_approval_from_previous_state']) {

            $arrayToBeUpdated['is_approved'] = "Y";

        } else {

            switch ($file_status) {

                case "Q":

                    if (Yii::app()->user->havePermissionOn['approval_type_quote'] == "sop_quote_appr_by_val") {

                        if ((number_format(floatval($model_master_file->quote->grand_total_bc), 0, '', '')) <= number_format(floatval(Yii::app()->user->havePermissionOn['approval_limit_or_min_profit_quote']), 0, '', '')) {

                            $arrayToBeUpdated['is_approved'] = "Y";

                            if ($model_master_file->is_approved == "N")

                                $this->actionNotification($model_master_file->quote, "Quotes", false);

                        }

                        else

                            $arrayToBeUpdated['is_approved'] = "N";

                    }

                    break;

                case "O":

                    if (Yii::app()->user->havePermissionOn['approval_type_order'] == "sop_order_appr_by_val") {

                        if ((number_format(floatval($model_master_file->order->grand_total_bc), 0, '', '')) <= (int) Yii::app()->user->havePermissionOn['approval_limit_or_min_profit_order']) {

                            $arrayToBeUpdated['is_approved'] = "Y";

                            if ($model_master_file->is_approved == "N")

                                $this->actionNotification($model_master_file->order, "Order", false);

                        }

                        else

                            $arrayToBeUpdated['is_approved'] = "N";

                    }

                    break;

                case "P_O":

                    if ((number_format(floatval($model_master_file->purchaseorder->grand_total_bc), 0, '', '')) <= (int) Yii::app()->user->havePermissionOn['approval_limit_or_min_profit_purchase_order'])

                        $arrayToBeUpdated['is_approved'] = "Y";

                    else

                        $arrayToBeUpdated['is_approved'] = "N";

                    break;

            }

        }



        if (isset($arrayToBeUpdated['is_approved']) && $arrayToBeUpdated['is_approved'] == "Y") {

            $arrayToBeUpdated['approved_by'] = Yii::app()->user->id;

            $arrayToBeUpdated['date_of_approval'] = date('Y-m-d');

        }

        $model_master_file->updateByPK($model_master_file->id, $arrayToBeUpdated);

    }



    /**

     * 

     * @param array $status

     */

    public function getFiles($status = array(), $options = array()) {

        $data_array = array();

        if (isset($_GET['term'])) {

            $condition = 'isActive="Y" AND current_process_status in ("' . implode('","', $status) . '") AND (	file_title like "%' . $_GET['term'] . '%" or id like "%' . $_GET['term'] . '%")';

            if (!empty($options)) {

                foreach ($options as $column => $column_val) {

                    $condition .= ' AND ' . $column . '="' . $column_val . '"';

                }

            }

            $model = MasterFile::model()->findAll(array('condition' => $condition, 'order' => 'id DESC'));

            $i = 0;

            foreach ($model as $eachModel) {

                $data_array[$i]['value'] = $eachModel->id;

                $data_array[$i]['label'] = $eachModel->id . ':' . $eachModel->file_title;

                $i++;

            }

        }

        echo CJSON::encode($data_array);

        Yii::app()->end();

    }



    /**

     * 

     * @param array $status

     */

    /* public function getOrders($status = array()) {

      $data_array = array();

      if (isset($_GET['term'])) {

      $condition = 'isActive="Y" AND file.current_process_status in ("' . implode('","', $status) . '")';

      $model = Order::model()->with('file')->findAll(array('condition' => $condition));

      $i = 0;

      foreach ($model as $eachModel) {

      $data_array[$i]['value'] = $eachModel->id;

      $data_array[$i]['label'] = $eachModel->id . ':' . $eachModel->file->file_title;

      $i++;

      }

      }

      echo CJSON::encode($data_array);

      Yii::app()->end();

      } */



    /**

     * 

     * @param type $file_id

     * @param type $upoaded_from

     * save uploaded doucuments

     */

    public function documents($file_id, $uploaded_from) {

        if (isset($_POST['Document'])) {

            $documents = explode(',', $_POST['Document']['document_name']);

            /* if ((int) $file_id != 0) {

              Document::model()->deleteAll('file_id=:file_id AND uploaded_from=:uploaded_from', array(':file_id' => $file_id, ':uploaded_from' => $uploaded_from));

              } */

            foreach ($documents as $eachDocument) {

                if (trim($eachDocument) != "") {

                    $model = new Document;

                    $model->file_id = $file_id;

                    $model->document_name = $eachDocument;

                    $model->uploaded_from = $uploaded_from;

                    $model->save(false);

                }

            }

        }

    }



    /**

     * save quotation/order/delivery note details

     */



    /**

     * 

     * @param type $modelName

     * @param type $from

     */

    function saveSopPurchase($modelName, $from) {

        $model = new $modelName;

        $attributes_main = $_POST[$modelName];



        $attributes_items = isset($_POST[$modelName . 'Item']) ? $_POST[$modelName . 'Item'] : array(0);



        if (in_array($modelName, array("Quotes", "Order", "Invoice"))) { // extra additions and deductions only in these section thts y

            $attributes_additions = @$_POST[$modelName . 'Addition'];

            $attributes_deductions = @$_POST[$modelName . 'Deduction'];

        }

        $model->scenario = 'add';

        if ((int) @$attributes_main['id'] > 0)

            $model->scenario = 'update';

        $model->attributes = $attributes_main;

        $model->crm_user_id = Yii::app()->user->id;

        //$valid = true;

        $itemModel = $modelName . 'Item';

        $other_errors = array();

        $total_quatity_picked = 0;

        $valid1 = true;

        $valid = true;

        foreach ($attributes_items as $i => $item) {

            if (!empty($item['product_id'])) {

                $modelItem[$i] = new $itemModel;

                $modelItem[$i]->attributes = $attributes_items[$i];

                $valid = $modelItem[$i]->validate() && $valid;

                $thisProduct = Store::model()->findByPk($attributes_items[$i]['product_id']);

                if ($modelName == "DeliveryNote") {

                    $total_quatity_picked+=$modelItem[$i]->picked_qty;

                    if ($thisProduct->non_stock_item == "N") {

                        if ((int) $_POST['DeliveryNote']['id'] != 0) { //if going to edit delivery note,then replace quantity in warehose first

                            $warehouse = ProductLocation::model()->find('stock_id=:stock_id', array(

                                ':stock_id' => $thisProduct->id,

                            ));

                            $savedItem = $itemModel::model()->findAll(array('condition' => 'product_id=' . $thisProduct->id . ' AND delivery_note_id=' . $_POST['DeliveryNote']['id'], 'order' => 't.id ASC'));

                            $warehouse->quantity += $savedItem[$i]->picked_qty;

                            $thisProduct->total_quantity +=$savedItem[$i]->picked_qty;

                            $thisProduct->total_quantity_in_default_ware_house+=$savedItem[$i]->picked_qty;

                        }

                        if ($thisProduct->total_quantity_in_default_ware_house < $attributes_items[$i]['picked_qty']) {

                            $other_errors[] = "Item " . $thisProduct->part_number . " - only " . $thisProduct->total_quantity_in_default_ware_house . " is available in default warehouse. A total of " . $thisProduct->total_quantity . " Quantity available in the branch";

                            $valid = $valid && false;

                        }

                        $allocatedQuantityForThis = @AllocatedMaterial::model()->find('file_id=:file_id AND product_id=:product_id', array(':file_id' => $model->file_id, ':product_id' => $thisProduct->id))->count;

                        $availableQty = ($thisProduct->total_quantity + floatval($allocatedQuantityForThis)) - $thisProduct->total_allocated_quantity;

                        if ($availableQty < $attributes_items[$i]['picked_qty']) {

                            $other_errors[] = "Item " . $thisProduct->part_number . " available only " . $availableQty . ' Nos. in all warehouses';

                            $valid = $valid && false;

                        }

                        if ((int) $_POST['DeliveryNote']['id'] != 0 && $valid) {

                            //$warehouse->quantity -= $attributes_items[$i]['picked_qty'];

                            $warehouse->save();

                        }

                    }

                }

                if (in_array($modelName, array("PurchasingRequisition", "PurchasingEnquiry"))) {

                    if ($thisProduct->non_stock_item == "Y") {

                        $other_errors[] = "There is a Non Stock Item in the purchase order(Item:" . $thisProduct->part_number . " line number:" . ($i + 1) . ").Please Avoid Purchasing Non Stock Item";

                        $valid1 = $valid1 && false;

                    }

                }

            }

        }

        if ($modelName == "DeliveryNote" && $total_quatity_picked <= 0) {

            $valid = $valid && false;

            $modelItem = "";

        }

        //$valid = is_array($modelItem);

        $valid = $valid && is_array($modelItem) && $valid1;

        if (in_array($modelName, array("Quotes", "Order", "Invoice"))) { // extra additions and deductions only in these section thts y

            $itemAdditionModel = $modelName . 'Addition';

            $itemDeductionModel = $modelName . 'Deduction';

            if (is_array($attributes_additions))

                foreach ($attributes_additions as $i => $item) {

                    $modelAdditionItem[$i] = new $itemAdditionModel;

                    $modelAdditionItem[$i]->attributes = $attributes_additions[$i];

                    $valid = $modelAdditionItem[$i]->validate() && $valid;

                }

            //validationg deductions 

            if (is_array($attributes_deductions))

                foreach ($attributes_deductions as $i => $item) {

                    $modelDeductionItem[$i] = new $itemDeductionModel;

                    $modelDeductionItem[$i]->attributes = $attributes_deductions[$i];

                    $valid = $modelDeductionItem[$i]->validate() && $valid;

                }

        }

        if ($model->validate() && $valid) { // after validation saving the whole data 

            $company_id = 0;

            if ((int) $model->file_id > 0) {

                if ($model->hasAttribute('company_id') && (int) $model->company_id > 0)

                    $company_id = $model->company_id;

                else if ($model->hasAttribute('vendor_id') && (int) $model->vendor_id > 0)

                    $company_id = $model->vendor_id;

                else

                    $company_id = $model->file->company_id;

            }

            else if ($model->hasAttribute('company_id'))

                $company_id = $model->company_id;

            else if ($model->hasAttribute('vendor_id'))

                $company_id = $model->vendor_id;

            $model->file_id = $this->masterFile($model->file_id, $from, $model->title, $company_id, isset($model->lead_owner_id) ? (int) $model->lead_owner_id : 0);

            $refer_id = strtolower(preg_replace('/\B([A-Z])/', '_$1', $modelName)) . '_id'; //quotes_id,order_id,delivery_note_id etc.,

            $this->documents($model->file_id, $from);

            if ($modelName == "DeliveryNote") { // edit delivery section

                if ((int) $_POST['DeliveryNote']['id'] == 0)

                    $model->order_id = Order::model()->find(array('condition' => 'file_id=' . $model->file_id))->id;

                else

                    $model->id = $_POST['DeliveryNote']['id'];

            }

            else if ($modelName == "Invoice") {//there are more than one invoices

                if ((int) $_POST['Invoice']['id'] != 0)

                    $model->id = $_POST['Invoice']['id'];

            }

            else

                $model->id = @$modelName::model()->find(array('condition' => 'file_id=' . $model->file_id))->id;

            $notification = false;

            if ((int) $model->id == 0) {// if id 0 means its a new record, otherwise needs to update the existing one

                $notification = ($model->file->is_approved == "N");

                $model->save();

            } else {

                $model->updateByPK($model->id, $model->attributes);

                if (in_array($modelName, array("Quotes", "Order"))) { // extra additions and deductions only in these section and before updating needs to remove all other refernces

                    $itemModel::model()->deleteAll($refer_id . '=:refer_id', array(':refer_id' => $model->id));

                    $itemAdditionModel::model()->deleteAll($refer_id . '=:refer_id', array(':refer_id' => $model->id));

                    $itemDeductionModel::model()->deleteAll($refer_id . '=:refer_id', array(':refer_id' => $model->id));

                    AllocatedMaterial::model()->deleteAll('file_id=:file_id', array(':file_id' => $model->file_id));

                } else if (in_array($modelName, array("DeliveryNote", "PurchasingRequisition", "PurchasingEnquiry", "PurchasingOrder"))) {

                    $itemModel::model()->deleteAll($refer_id . '=:id', array(':id' => $model->id));

                }

            }

            if ($modelName == "Invoice") {

                DeliveryNote::model()->updateAll(array('invoiced' => 'Y'), 'id in (' . $model->delivery_ids . ')');

            }



            $model->refresh();

            $grand_total = $picked_qty = $actual_qty = $invoiced_qty = 0;

            $jsonData['shoratage'] = "";

            foreach ($modelItem as $eachItem) {

                $eachItem->{$refer_id} = $model->id;

                if (in_array($modelName, array("Invoice")))

                    $eachItem->cost_rate = Store::model()->findByPk($eachItem->product_id)->rate;

                $eachItem->save(false);

                if (!in_array($modelName, array("DeliveryNote", "PurchasingRequisition", "PurchasingEnquiry", "PurchasingOrder")))

                    $grand_total += $eachItem->net_amount;

                if (in_array($modelName, array("Order", "Quotes"))) {



                    if (isset($_POST['allocate_materials']) && $_POST['allocate_materials'] == "Y") {

                        $model->updateByPk($model->id, array('materials_allocated' => 'Y'));

                        $storeModel = Store::model()->findByPK($eachItem->product_id);

                        if ($storeModel->non_stock_item == "N") {

                            $shoratge = $storeModel->total_quantity - $storeModel->total_allocated_quantity - $eachItem->quantity;

                            if ($shoratge <= 0) {

                                $jsonData['shoratage'] .= "Item " . $eachItem->product->part_number . " need extra " . abs($shoratge) . "No.s<br/>";

                            }

                            else

                                $shoratge = 0;

                            $modelAllocatedMaterial = new AllocatedMaterial;

                            if (($t = AllocatedMaterial::model()->find('file_id=' . $model->file_id . ' AND product_id=' . $eachItem->product_id)) != null) {

                                $modelAllocatedMaterial = $t;

                            }

                            $modelAllocatedMaterial->product_id = $eachItem->product_id;

                            $modelAllocatedMaterial->file_id = $model->file_id;

                            $modelAllocatedMaterial->count = ($eachItem->quantity + $shoratge);

                            $modelAllocatedMaterial->allocation_date = date('Y-m-d');

                            //$modelAllocatedMaterial->allocation_end_date = $modelName == "Order" ? $model->delivery_date : $model->qtn_validity;

                            $modelCustom = CustomChanges::model()->find();

                            $custom_changes = CJSON::decode($modelCustom->changes);

                            if ((int) $custom_changes['custom_material_allocation_end_date']) {

                                $end_date = date('Y-m-d', mktime(0, 0, 0, date("m"), date("d") + 14, date("Y")));

                                if ($modelName == "Order")

                                    $modelAllocatedMaterial->allocation_end_date = $end_date;

                                else if ($modelName == "Quotes") {

                                    if ($model->qtn_validity > $end_date)

                                        $modelAllocatedMaterial->allocation_end_date = $end_date;

                                    else

                                        $modelAllocatedMaterial->allocation_end_date = $model->qtn_validity;

                                }

                                $modelAllocatedMaterial->allocated_from = $modelName == "Order" ? "O" : "Q";

                                $modelAllocatedMaterial->save(false);

                            }

                            else

                                $modelAllocatedMaterial->allocation_end_date = $modelName == "Order" ? $model->delivery_date : $model->qtn_validity;

                            $modelAllocatedMaterial->allocated_from = $modelName == "Order" ? "O" : "Q";

                            $modelAllocatedMaterial->save(false);

                        }

                    }

                } else if ($modelName == "DeliveryNote" && $eachItem->product->non_stock_item == "N") {

                    $warehouses = ProductLocation::model()->findAll('stock_id=:stock_id', array(':stock_id' => $eachItem->product_id));

                    foreach ($warehouses as $eachWareHouse) {

                        if ($eachItem->picked_qty <= $eachWareHouse->quantity) {

                            $eachWareHouse->quantity -= $eachItem->picked_qty;

                            $eachItem->picked_qty = 0;

                            $eachWareHouse->save(false);

                            break;

                        } else {

                            $eachItem->picked_qty-=$eachWareHouse->quantity;

                            $eachWareHouse->quantity = 0;

                            $eachWareHouse->save(false);

                        }

                    }

                    AllocatedMaterial::model()->deleteAll('file_id=:file_id AND product_id=:product_id', array(':file_id' => $model->file_id, ':product_id' => $eachItem->product_id));

                    //deduct items from product location

                } else if ($modelName == "Invoice") {

                    $invoiced_qty+=$eachItem->quantity;

                }

            }

            if (in_array($modelName, array("Quotes", "Order", "Invoice"))) {

                if (is_array($modelAdditionItem))

                    foreach ($modelAdditionItem as $eachItem) {

                        $eachItem->{$refer_id} = $model->id;

                        $eachItem->save(false);

                        $grand_total += $eachItem->calculated_value;

                    }

                if (is_array($modelDeductionItem))

                    foreach ($modelDeductionItem as $eachItem) {

                        $eachItem->{$refer_id} = $model->id;

                        $eachItem->save(false);

                        $grand_total -= $eachItem->calculated_value;

                    }

                if ($modelName == "Invoice") {

                    $orderedQuantity = $model->file->order->netQuantity;

                    $invoices = $model->file->invoices;

                    $inoicedQantity = 0;

                    foreach ($invoices as $eachInvoice)

                        $inoicedQantity+=$eachInvoice->netQuantity;

                    if ($orderedQuantity == $inoicedQantity)

                        $this->masterFile($model->file_id, "I");

                    //* here we decides whether the file is i status I or something else *//

                }

                $model->updateByPk($model->id, array('grand_total' => $grand_total));



                if (in_array($modelName, array("Quotes", "Order", "PurchasingOrder")))

                    $this->masterFile($model->file_id, $model->file->current_process_status, $model->file->file_title, $model->file->company_id, $model->file->lead_owner_id, "Y");

            } else if ($modelName == "DeliveryNote" && $model->file->deliveredQuantity >= $model->file->order->netQuantity) {



                $this->masterFile($model->file_id, "D"); ///need to check full delivey,status is not updating correctly 

            }

            $jsonData['file'] = $model->file;

            $jsonData['model'] = $model;

            $jsonData['status'] = 'success';

            if (in_array($modelName, array("Quotes", "Order"))) {

                $files = MasterFile::model()->findAll(array('condition' => 'company_id=' . $company_id . ' AND(current_process_status="D" OR current_process_status="PD" OR current_process_status="I" OR current_process_status="PI") '));

                $amount_pending = 0;

                foreach ($files as $eachFile) {

                    $amount_pending += $eachFile->order->grand_total;

                    foreach ($eachFile->invoices as $eachInvoice)

                        $amount_pending += ($eachInvoice->grand_total - $eachInvoice->receivedAmount);

                }

                if ($amount_pending > $eachFile->company->credit_limit) {

                    $jsonData['creditlimit'] .= "A pending of " . $amount_pending . " need to collect from " . $eachFile->company->company_name;

                    //send a mail to branch head here

                }

            }

            if (!in_array($modelName, array("PurchasingRequisition", "PurchasingEnquiry", "PurchasingOrder")))

                Yii::app()->session['company_id'] = $model->company_id;

            if ($notification) {

                $model->refresh();

                switch ($from) {

                    case 'Q':

                        $this->actionNotification($model, "Quotes");

                        break;

                    case 'O':

                        $this->actionNotification($model, "Order");

                        break;

                    default:

                        break;

                }

            }

            echo CJSON::encode($jsonData);

            //Yii::app()->end();

        } else {

            $error1 = json_decode(CActiveForm::validate($model, '', false), true);

            if (is_array($modelItem))

                $error2 = json_decode(CActiveForm::validateTabular($modelItem, '', false), true);

            else

                $error2[] = "Please add atleast one line item";

            $error3 = array();

            $error4 = array();

            if (in_array($modelName, array("Quotes", "Order"))) {

                $error3 = json_decode(CActiveForm::validateTabular($modelAdditionItem, '', false), true);

                $error4 = json_decode(CActiveForm::validateTabular($modelDeductionItem, '', false), true);

            }

            $error = CJSON::encode(array_merge_recursive($error1, $error2, $error3, $error4, $other_errors));

            if ($error != '[]')

                echo $error;

        }

    }



    public function actionTest() {

        $this->render('//test/test');

    }



    public function actionSaveUserGroup1() {

        echo CJSON::encode(array_fill_keys($_POST['MasUserGroup']['permissions'], '1'));

        die();

    }



    /**

     * 

     * @param type $modelName

     * general save method for all models

     */

    public function saveMaster($modelName) {

        $this->commonSave($modelName);

        /* $model = new $modelName;

          if (isset($_POST[$modelName])) {

          $model->attributes = $_POST[$modelName];

          $model->id = (int) @$_POST[$modelName]['id'];

          if (!in_array($modelName, array("User")))

          $model->company_branch_id = Yii::app()->user->master_user_branch_id;

          $model->company_id = Yii::app()->user->master_user_company_id;

          $model->scenario = ($model->id == 0) ? 'add' : 'update';

          if ($model->validate()) {

          ($model->id == 0) ? $model->save() : $model->updateByPK($model->id, $model->attributes);

          $jsonData['status'] = 'success';

          $jsonData['model'] = $model;

          echo CJSON::encode($jsonData);

          } else {

          $error = CActiveForm::validate($model, '', false);

          if ($error != '[]')

          echo $error;

          }

          }

          Yii::app()->end(); */

    }



    public function commonSave($modelName, $need_model_return = false) {

        $model = new $modelName;

        if (isset($_POST[$modelName])) {

            if ((int) @$_POST[$modelName]['id'] > 0) {

                $model->id = (int) $_POST[$modelName]['id'];

                $model->scenario = 'update';

                $model = $model->findByPK($model->id);

            } else {

                unset($_POST[$modelName]['id']);

                $model->scenario = 'add';

            }

            $model->attributes = $_POST[$modelName];

            //if ($model->hasAttribute('company_id') && empty($model->company_id) && $modelName != "CompanyContact")

            //$model->company_id = Yii::app()->user->master_user_company_id;

            //if ($model->hasAttribute('company_branch_id'))

            //$model->company_branch_id = Yii::app()->user->master_user_branch_id;

            if ($model->hasAttribute('crm_user_id'))

                $model->crm_user_id = Yii::app()->user->id;

            if ($model->validate()) {

                $model->save();

                $model->refresh();

                if($modelName=='Company')

                {

//                echo $model->id;    

                $model->account_no=$model->id;

                $model->save();

                }

                if (!$need_model_return) {

                    $jsonData['model'] = $model;

                    $jsonData['status'] = 'success';

                    echo CJSON::encode($jsonData);

                }

                else

                    return $model;

            } else {

                $error = CActiveForm::validate($model, '', false);

                if ($error != '[]')

                    echo $error;

            }

        }

        Yii::app()->end();

    }



    /* public function commonSave($modelName) {

      $model = new $modelName;

      if (isset($_POST[$modelName])) {

      $model->attributes = $_POST[$modelName];

      $model->crm_user_id = Yii::app()->user->id;

      $model->id = (int) @$_POST[$modelName]['id'];

      $model->scenario = ($model->id == 0) ? 'add' : 'update';

      if ($model->validate()) {

      ($model->id == 0) ? $model->save() : $model->updateByPK($model->id, $model->attributes);

      $model->refresh();

      $jsonData['model'] = $model;

      $jsonData['status'] = 'success';

      echo CJSON::encode($jsonData);

      } else {

      $error = CActiveForm::validate($model, '', false);

      if ($error != '[]')

      echo $error;

      }

      }

      Yii::app()->end();

      } */



    public function getCompanyNameIfSessionSet() {

        $returnvar = '<span class="company_name">';

        if ((int) Yii::app()->session['company_id'] > 0)

            $returnvar.= ' - ' . Company::model()->findByPK(Yii::app()->session['company_id'])->company_name;

        $returnvar.='</span>';

        return $returnvar;

    }



    /**

     *  get company details, contacts, retuning json 

     */

    public function actionfetchCompanyDetails() {

        if ((int) $_POST['company_id'] != 0 || (int) Yii::app()->session['company_id'] != 0) {

            $company_id = (int) $_POST['company_id'] == 0 ? Yii::app()->session['company_id'] : (int) $_POST['company_id'];

            $jsonArrray['company'] = Company::model()->findByPK((int) $company_id);

            $jsonArrray['paymentterm'] = MasPaymentTerm::model()->findByPk($jsonArrray['company']->genral_payment_term);

            $jsonArrray['paymenttermdetails'] = $jsonArrray['paymentterm']->payment_code . ':' . $jsonArrray['paymentterm']->payment_terms;

            //Yii::app()->session['company_id'] = $jsonArrray['company']->id;

            $data = CHtml::listData($jsonArrray['company']->companyContacts, 'id', 'fullname');

            $jsonArrray['company_conatct'] = CHtml::tag('option', array('value' => ""), CHtml::encode("-select-"), true);

            foreach ($data as $value => $name)

                $jsonArrray['company_conatct'] .= CHtml::tag('option', array('value' => $value), CHtml::encode($name), true);

            /* if ($jsonArrray['company']->billingcountry->country_code == 'AE')

              $jsonArrray['currency'] = MasCurrency::model()->find(array('condition' => 'currency_code="AED"'));

              else

              $jsonArrray['currency'] = MasCurrency::model()->find(array('condition' => 'currency_code="USD"')); */

            if ($jsonArrray['company']->currency != 0)

                $jsonArrray['currency'] = MasCurrency::model()->findByPk($jsonArrray['company']->currency);

            else

                $jsonArrray['currency'] = '';

            $jsonArrray['company']['billing_address'] = str_replace("<br/>", "\n", $jsonArrray['company']->billingAddress);

            $jsonArrray['company']['shipping_address'] = str_replace("<br/>", "\n", $jsonArrray['company']->shippingAddress);

            $condition = 'isActive =  "Y" ';

            $currencylist1 = MasCurrency::model()->findAll(array('condition' => $condition, 'order' => 'currency'));

            $currencylist1 = CHtml::listData($currencylist1, 'id', 'currency');

            foreach ($currencylist1 as $value => $name)

                $jsonArrray['currencylist'][] = CHtml::tag('option', array('value' => $value), CHtml::encode($name), true);

            if (is_array($jsonArrray['currencylist']))

                $jsonArrray['currencylist'] = implode('', $jsonArrray['currencylist']);

            echo CJSON::encode($jsonArrray);

        }

        Yii::app()->end();

    }



    public function actionFetchcurrencydetails() {

        echo CJSON::encode(MasCurrency::model()->findByPK((int) $_POST['currency_id']));

    }



    function CropIfImage($folder, $fileName, $width = 100, $height = 100) {

        $imageCropParams = array(array(50, 50), array(100, 100), array(100, 150), array(200, 150), array(200, 200), array(260, 125), array(800, 500), array(150, 128));



        $imagefile = getimagesize($folder . $fileName);

        if (is_array($imagefile)) {

            foreach ($imageCropParams as $eachImageCropParam) {

                $width = $eachImageCropParam[0];

                $height = $eachImageCropParam[1];

                $thumb = Yii::app()->phpThumb->create($folder . '/' . $fileName);

                $thumb->resize($width, $height);

                $thumb->save($folder . '/' . $width . $height . '_' . $fileName);

            }

        }

    }



    public function actionUpload($folder = null) {

        Yii::import("ext.EAjaxUpload.qqFileUploader");



        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';

// make the directory to store the pic:

        if (!is_dir($folder)) {

            mkdir($folder, 0777, TRUE);

//chmod($folder, 0755);

        }

        $allowedExtensions = array();

        $sizeLimit = 1 * 1024 * 1024; // maximum file size in bytes

        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);

        $result = $uploader->handleUpload($folder);

        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);

        $return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);



        $fileName = $result['filename']; //GETTING FILE NAME

        $this->CropIfImage($folder, $fileName, 100, 100);

        echo $return; // it's array

    }



    public function downloadFile($file, $folder) {

//die("here");

        $filename = Yii::app()->getBaseUrl(true) . $folder . $file;

//$file_url = 'http://www.myremoteserver.com/' . $file_name;

        header('Content-Type: application/octet-stream');

        header("Content-Transfer-Encoding: Binary");

        header("Content-disposition: attachment; filename=\"" . $file . "\"");

        readfile($filename);

    }



    function blowfishSalt($cost = 13) {

        if (!is_numeric($cost) || $cost < 4 || $cost > 31) {

            throw new Exception("cost parameter must be between 4 and 31");

        }

        $rand = array();

        for ($i = 0; $i < 8; $i += 1) {

            $rand[] = pack('S', mt_rand(0, 0xffff));

        }

        $rand[] = substr(microtime(), 2, 6);

        $rand = sha1(implode('', $rand), true);

        $salt = '$2a$' . sprintf('%02d', $cost) . '$';

        $salt .= strtr(substr(base64_encode($rand), 0, 22), array('+' => '.'));

        return $salt;

    }



    public function actionAjaxupdate() {

        $act = $_GET['act'];



        if ($act == 'doChangeStatus') {

            $model = $this->loadModel($_POST['autoId']);

            $model->isActive = ($model->isActive == 'Y') ? 'N' : 'Y';

            $model->save(false);

            $img = ($model->isActive == 'Y') ? 'active.png' : 'inactive.png';

            echo CHtml::image("images/admin/" . $img, "");

        } else if ($act == 'doSortOrder') {

            $sortOrderAll = $_POST['sortOrder'];

            if (count($sortOrderAll) > 0) {

                foreach ($sortOrderAll as $menuId => $sortOrder) {

                    $model = $this->loadModel($menuId);

                    $model->sortOrder = $sortOrder;

                    $model->save(false);

                }

            }

        } else {

            $autoIdAll = $_POST['autoId'];

            if (count($autoIdAll) > 0) {

                foreach ($autoIdAll as $autoId) {

                    $model = $this->loadModel($autoId);

                    if ($act == 'doDelete')

                        $model->is_delete = 'Y';

                    if ($act == 'doActive')

                        $model->is_active = 'Y';

                    if ($act == 'doInactive')

                        $model->is_active = 'N';

                    if ($model->save(false))

                        echo 'ok';

                    else

                        throw new Exception("Sorry", 500);

                }

            }

        }

    }



    public function readCSV($csvFile) {

        $file_handle = fopen($csvFile, 'r');

        while (!feof($file_handle)) {

            $contents = fgetcsv($file_handle, 1024, ',');

            if ($contents[1] == "")

                $contents = explode(';', $contents[0]);

            $line_of_text[] = $contents;

            //print_r($line_of_text);

            //die();

        }

        fclose($file_handle);

        return $line_of_text;

    }



    public function createCsv($dataarray, $filename) {

        $filename = $filename . '.csv';

        header('Content-Type: application/excel');

        header('Content-Disposition: attachment; filename="' . $filename . '"');

        $fp = fopen('php://output', 'w');

        foreach ($dataarray as $line) {

            $val = explode(",", $line);

            fputcsv($fp, $val);

        }

        fclose($fp);

        //$this->downloadFile($filename);

    }



    function array_to_csv_download($array, $filename = "export.csv", $delimiter = ",") {

        // open raw memory as file so no temp files needed, you might run out of memory though

        $f = fopen('php://memory', 'w');

        // loop over the input array

        foreach ($array as $line) {

            // generate csv lines from the inner arrays

            fputcsv($f, $line, $delimiter);

        }

        // rewrind the "file" with the csv lines

        fseek($f, 0);

        // tell the browser it's going to be a csv file

        header('Content-Type: application/csv');

        // tell the browser we want to save it instead of displaying it

        header('Content-Disposition: attachement; filename="' . $filename . '"');

        // make php send the generated csv lines to the browser

        fpassthru($f);

    }



    public function actionNotification($model = null, $modelName = null, $approval_needed = true, $subject = false) {

        if ($model == null) {

            $modelName = Yii::app()->request->getPost('model');

            $model = $modelName::model()->findByPK(Yii::app()->request->getPost('id'));

        }



        $leadowner = User::model()->findByPK($model->file->leadowner->id);

        $superiors = $leadowner->getSuperios();

        $message = new YiiMailMessage();

        $message->view = strtolower($modelName);

        $regex = '/^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,3})$/';

        if (!empty($model->file->leadowner->email) && preg_match($regex, $model->file->leadowner->email))

            $message->addTo($model->file->leadowner->email);

        else

            $message->addTo("admin@cumuluscrm.us");

        /* $branchhead = MasCompanyBranch::model()->findByPk(Yii::app()->user->master_user_branch_id)->branchhead;

          if (!empty($branchhead->email) && preg_match($regex, $branchhead->email))

          $message->addCc($branchhead->email); */

        if (is_array($superiors))

            foreach ($superiors as $eachOne) {

                if (!empty($eachOne->email) && preg_match($regex, $eachOne->email))

                    $message->addCc($eachOne->email);

            }

        //$message->addTo("test@mailbluesky.com");

        //$message->addTo("copymail@mailbluesky.com");

        $message->from = 'noreply@cumuluscrm.us';

        if (!$subject) {

            if ($approval_needed)

                $subject = $modelName . " - " . $model->file->id . '/' . $model->id . ' - ' . $model->file->leadowner->fullname . ' - Approval required';

            else

                $subject = $modelName . " - " . $model->file->id . '/' . $model->id . ' - ' . $model->file->leadowner->fullname . ' - Approval Done';

        }



        //$subject.= $modelName . " - " . $model->file->id . '/' . $model->id;

        $message->setSubject($subject);

        $message->setBody(array('model' => $model), 'text/html');

        Yii::app()->mail->send($message);

    }



    function getFileDetails($file_id, $needed_model) {

        $masterFile = MasterFile::model()->with($needed_model)->findByPK($file_id/* , array('order' => $needed_model->items->id) */);

        $jsonData['file'] = $masterFile;

        $jsonData['companyname'] = Company::model()->findByPK($jsonData['file']->customer_id);

        $jsonData[$needed_model] = $masterFile->{$needed_model};

        $jsonData['salesgroup'] = MasSalesGroup::model()->findByPK($jsonData[$needed_model]->sales_group);

        $jsonData['currency'] = MasCurrency::model()->findByPK($jsonData[$needed_model]->currency);

        $jsonData['paymenttermdetails'] = MasPaymentTerm::model()->findByPK($jsonData[$needed_model]->payment_terms);

        $jsonData['payemntterm'] = $jsonData['paymenttermdetails']->payment_code . ':' . $jsonData['paymenttermdetails']->payment_terms;

        $jsonData['contactname'] = CompanyContact::model()->findByPK($jsonData[$needed_model]->contact_id);

        return $jsonData;

    }



    public function getARandomColor() {

        $modelDashboard = new Dashboard;

        return $modelDashboard->getRandomColor();

    }



    public function getstatus($id) {

        $model = new CompanyTemp;

        $count = $model->count(array('condition' => 'company_id=' . $id . ' AND status=1'));

        if ($count)

            return 1;

        else

            return 0;

    }



    public function actionApproveFile() {

        $file_id = (int) Yii::app()->request->getParam('file_id');

        $modelFile = MasterFile::model()->findByPK($file_id);

        $modelFile->is_approved = ($modelFile->is_approved == "N") ? "Y" : "N";

        $modelFile->approved_by = Yii::app()->user->id;

        $modelFile->date_of_approval = date('Y-m-d');

        $modelFile->save(false);

        $jsonData['status'] = 'success';

        $jsonData['msg'] = $modelFile->is_approved == "Y" ? 'File has been approved' : 'File has been un approved';

        echo CJSON::encode($jsonData);

    }



    public function autocompleteAccountData($modelName, $seacrhColumn, $searchTerm, $form, $selectedType) {

        $data = array();

        $model = new $modelName;

        if (isset($searchTerm)) {

            $order = $seacrhColumn;

            if (is_array($seacrhColumn)) {

                foreach ($seacrhColumn as $eachSearchColumn)

                    if ($form == "contra") {

                        $condition[] = $eachSearchColumn . ' LIKE "%' . $searchTerm . '%" AND id!=70 AND id!=71 AND (parent_account=70 OR parent_account=71)';

                    } else if ($form == "receipts" && $selectedType == 2) {

                        $condition[] = $eachSearchColumn . ' LIKE "%' . $searchTerm . '%" AND id!=70 AND id!=71 AND (parent_account=70 OR parent_account=71)';

                    } else if ($form == "receipts" && $selectedType == 1) {

                        $condition[] = $eachSearchColumn . ' LIKE "%' . $searchTerm . '%" AND id!=70 AND id!=71 AND id!=75 AND id!=64 AND id!=62  AND ( parent_account=75 OR parent_account=64 OR parent_account=62)';

                    }

                $condition = implode(' OR ', $condition);

                $order = $seacrhColumn[0];

            } else {

                if ($form == "contra")

                    $condition = $seacrhColumn . ' LIKE "%' . $searchTerm . '%" AND id!=70 AND id!=71 AND (parent_account=70 OR parent_account=71)';

                else if ($form == "receipts" && $selectedType == 2)

                    $condition[] = $eachSearchColumn . ' LIKE "%' . $searchTerm . '%" AND id!=70 AND id!=71 AND (parent_account=70 OR parent_account=71)';

                else if ($form == "receipts" && $selectedType == 1)

                    $condition[] = $eachSearchColumn . ' LIKE "%' . $searchTerm . '%" AND id!=70 AND id!=71 AND id!=75 AND id!=64 AND id!=62  AND ( parent_account=75 OR parent_account=64 OR parent_account=62)';

            }

            $model = $model->findAll(array('condition' => $condition, 'order' => $order));

            $i = 0;

            foreach ($model as $eachModel) {

                $data[$i]['value'] = $eachModel->id;

                $data[$i]['companyid'] = 0;

                if ($virtulaAttrib)

                    $data[$i]['label'] = $eachModel->$virtulaAttrib;

                else {

                    if (is_array($seacrhColumn)) {

                        foreach ($seacrhColumn as $eachColumn)

                            $data[$i]['label'][] = $eachModel->$eachColumn;

                        $data[$i]['label'] = implode(':', $data[$i]['label']);

                    }

                    else

                        $data[$i]['label'] = $eachModel->$seacrhColumn;

                }

                $i++;

            }

        }

        echo CJSON::encode($data);

        Yii::app()->end();

    }



    public function autocompleteAccountDataJournal($modelName, $seacrhColumn, $searchTerm, $form, $selectedType) {

        $data = array();

        $model = new $modelName;

        if (isset($searchTerm)) {

            $order = $seacrhColumn;

            if (is_array($seacrhColumn)) {

                foreach ($seacrhColumn as $eachSearchColumn)

                    $condition[] = $eachSearchColumn . ' LIKE "%' . $searchTerm . '%" and parent_account !=0  and id not in (50,51,52,53,70,71) and parent_account not in (50,51,52,53,70,71)';

                $condition = implode(' OR ', $condition);

                $order = $seacrhColumn[0];



                $condition1[] = ' company.id LIKE "%' . $searchTerm . '%" or company.company_name like "%' . $searchTerm . '%" and company.isActive =  "Y" and companyType.type in ("C")';

                $condition1 = implode(' OR ', $condition1);

                $order1 = $seacrhColumn[0];



                $condition2[] = ' company.id LIKE "%' . $searchTerm . '%" or company.company_name like "%' . $searchTerm . '%" and company.isActive =  "Y" and companyType.type in ("V")';

                $condition2 = implode(' OR ', $condition2);

                $order2 = $seacrhColumn[0];

            } else {



                $condition = $seacrhColumn . ' LIKE "%' . $searchTerm . '%" and parent_account !=0 ';

                $condition1 = 'company.id LIKE "%' . $searchTerm . '%" or company.company_name like "%' . $searchTerm . '%" and company.isActive =  "Y" and companyType.type in ("C")';

                $condition2 = 'company.id LIKE "%' . $searchTerm . '%" or company.company_name like "%' . $searchTerm . '%" and company.isActive =  "Y" and companyType.type in ("V")';

            }



            $model = $model->findAll(array('condition' => $condition, 'order' => $order));

            $model1 = CompanyTypeRelation::model()->with(array('companyType', 'company'))->findAll(array('condition' => $condition1));

            $model2 = CompanyTypeRelation::model()->with(array('companyType', 'company'))->findAll(array('condition' => $condition2));

            $i = 0;

            foreach ($model as $eachModel) {

                $data[$i]['value'] = "a" . $eachModel->id;

                $data[$i]['companyid'] = 0;

                if ($virtulaAttrib)

                    $data[$i]['label'] = $eachModel->$virtulaAttrib;

                else {

                    if (is_array($seacrhColumn)) {

                        foreach ($seacrhColumn as $eachColumn)

                            $data[$i]['label'][] = $eachModel->$eachColumn;

                        $data[$i]['label'] = implode(':', $data[$i]['label']);

                    }

                    else

                        $data[$i]['label'] = $eachModel->$seacrhColumn;

                }

                $i++;

            }

            foreach ($model1 as $eachModel1) {

                $data[$i]['value'] = 75;

                $data[$i]['companyid'] = "c" . $eachModel1->company->id;

                if (is_array($seacrhColumn)) {

                    foreach ($seacrhColumn as $eachColumn) {

                        $data[$i]['label'] = $eachModel1->company->id . ':' . $eachModel1->company->company_name;

                    }

                }

                else

                    $data[$i]['label'] = $eachModel1->company->id . '' . $eachModel1->company->company_name;



                $i++;

            }

            foreach ($model2 as $eachModel2) {

                $data[$i]['value'] = 78;

                $data[$i]['companyid'] = "v" . $eachModel2->company->id;

                if (is_array($seacrhColumn)) {

                    foreach ($seacrhColumn as $eachColumn) {

                        $data[$i]['label'] = $eachModel2->company->id . ':' . $eachModel2->company->company_name;

                    }

                }

                else

                    $data[$i]['label'] = $eachModel2->company->id . '' . $eachModel2->company->company_name;



                $i++;

            }

        }

        //  print_r($data);die();

        echo CJSON::encode($data);

        Yii::app()->end();

    }



    public function autocompleteAccountDataReceipt($modelName, $seacrhColumn, $searchTerm, $form, $selectedType) {

        $data = array();

        $model = new $modelName;

        if (isset($searchTerm)) {

            $order = $seacrhColumn;

            if (is_array($seacrhColumn)) {

                foreach ($seacrhColumn as $eachSearchColumn) {

                    if ($selectedType == 2) {

                        $condition[] = $eachSearchColumn . ' LIKE "%' . $searchTerm . '%" and  id not in(70,71) AND parent_account in (70,71) ';

                    } else if ($selectedType == 1) {

                        $condition[] = $eachSearchColumn . ' LIKE "%' . $searchTerm . '%" and parent_account in (64,62)';

                    }

                }

                $condition1[] = ' company.id LIKE "%' . $searchTerm . '%" or company.company_name like "%' . $searchTerm . '%" and company.isActive =  "Y" and companyType.type in ("C")';

                $condition = implode(' OR ', $condition);

                $condition1 = implode(' OR ', $condition1);

                $order = $seacrhColumn[0];

                $order1 = $seacrhColumn[0];

            }

        } else {

            if ($selectedType == 2)

                $condition = $seacrhColumn . ' LIKE "%' . $searchTerm . '%" and  id not in(70,71) AND parent_account in (70,71) ';

            if ($selectedType == 1) {

                $condition = $seacrhColumn . ' LIKE "%' . $searchTerm . '%"  and parent_account in (64,62)';

                $condition1 = 'company.id LIKE "%' . $searchTerm . '%" or company.company_name like "%' . $searchTerm . '%" and company.isActive =  "Y" and companyType.type in ("C")';

            }

        }



        $model = $model->findAll(array('condition' => $condition));

        $model1 = CompanyTypeRelation::model()->with(array('companyType', 'company'))->findAll(array('condition' => $condition1));



        $i = 0;

        if ($selectedType == 2) {

            foreach ($model as $eachModel) {

                $data[$i]['value'] = "a" . $eachModel->id;

                $data[$i]['companyid'] = 0;

                if ($virtulaAttrib)

                    $data[$i]['label'] = $eachModel->$virtulaAttrib;

                else {

                    if (is_array($seacrhColumn)) {

                        foreach ($seacrhColumn as $eachColumn)

                            $data[$i]['label'][] = $eachModel->$eachColumn;

                        $data[$i]['label'] = implode(':', $data[$i]['label']);

                    }

                    else

                        $data[$i]['label'] = $eachModel->$seacrhColumn;

                }

                $i++;

            }

        }

        else if ($selectedType == 1) {

            foreach ($model as $eachModel) {

                $data[$i]['value'] = "a" . $eachModel->id;

                $data[$i]['companyid'] = 0;

                if ($virtulaAttrib)

                    $data[$i]['label'] = $eachModel->$virtulaAttrib;

                else {

                    if (is_array($seacrhColumn)) {

                        foreach ($seacrhColumn as $eachColumn)

                            $data[$i]['label'][] = $eachModel->$eachColumn;

                        $data[$i]['label'] = implode(':', $data[$i]['label']);

                    }

                    else

                        $data[$i]['label'] = $eachModel->$seacrhColumn;

                }

                $i++;

            }

            foreach ($model1 as $eachModel1) {

                $data[$i]['value'] = 75;

                $data[$i]['companyid'] = "c" . $eachModel1->company->id;

                if (is_array($seacrhColumn)) {

                    foreach ($seacrhColumn as $eachColumn) {

                        $data[$i]['label'] = $eachModel1->company->id . ':' . $eachModel1->company->company_name;

                    }

                }

                else

                    $data[$i]['label'] = $eachModel1->company->id . '' . $eachModel1->company->company_name;



                $i++;

            }

        }

        //  print_r($data);die();

        echo CJSON::encode($data);

        Yii::app()->end();

    }



    public function autocompleteAccountDataPayment($modelName, $seacrhColumn, $searchTerm, $form, $selectedType) {

        $data = array();

        $model = new $modelName;

        if (isset($searchTerm)) {

            $order = $seacrhColumn;

            if (is_array($seacrhColumn)) {

                foreach ($seacrhColumn as $eachSearchColumn) {

                    if ($selectedType == 1) {

                        $condition[] = $eachSearchColumn . ' LIKE "%' . $searchTerm . '%" and  id not in(70,71) AND parent_account in (70,71) ';

                    } else if ($selectedType == 2) {

                        $condition[] = $eachSearchColumn . ' LIKE "%' . $searchTerm . '%" and parent_account in (66,60,58)';

                    }

                }

                $condition1[] = ' company.id LIKE "%' . $searchTerm . '%" or company.company_name like "%' . $searchTerm . '%" and company.isActive =  "Y" and companyType.type in ("V")';

                $condition = implode(' OR ', $condition);

                $condition1 = implode(' OR ', $condition1);

                $order = $seacrhColumn[0];

                $order1 = $seacrhColumn[0];

            }

        } else {

            if ($selectedType == 1)

                $condition = $seacrhColumn . ' LIKE "%' . $searchTerm . '%" and  id not in(70,71) AND parent_account in (70,71) ';

            if ($selectedType == 2) {

                $condition = $seacrhColumn . ' LIKE "%' . $searchTerm . '%"  and parent_account in (66,60,58)';

                $condition1 = 'company.id LIKE "%' . $searchTerm . '%" or company.company_name like "%' . $searchTerm . '%" and company.isActive =  "Y" and companyType.type in ("V")';

            }

        }



        $model = $model->findAll(array('condition' => $condition));

        $model1 = CompanyTypeRelation::model()->with(array('companyType', 'company'))->findAll(array('condition' => $condition1));



        $i = 0;

        if ($selectedType == 1) {

            foreach ($model as $eachModel) {

                $data[$i]['value'] = "a" . $eachModel->id;

                $data[$i]['companyid'] = 0;

                if ($virtulaAttrib)

                    $data[$i]['label'] = $eachModel->$virtulaAttrib;

                else {

                    if (is_array($seacrhColumn)) {

                        foreach ($seacrhColumn as $eachColumn)

                            $data[$i]['label'][] = $eachModel->$eachColumn;

                        $data[$i]['label'] = implode(':', $data[$i]['label']);

                    }

                    else

                        $data[$i]['label'] = $eachModel->$seacrhColumn;

                }

                $i++;

            }

        }

        else if ($selectedType == 2) {

            foreach ($model as $eachModel) {

                $data[$i]['value'] = "a" . $eachModel->id;

                $data[$i]['companyid'] = 0;

                if ($virtulaAttrib)

                    $data[$i]['label'] = $eachModel->$virtulaAttrib;

                else {

                    if (is_array($seacrhColumn)) {

                        foreach ($seacrhColumn as $eachColumn)

                            $data[$i]['label'][] = $eachModel->$eachColumn;

                        $data[$i]['label'] = implode(':', $data[$i]['label']);

                    }

                    else

                        $data[$i]['label'] = $eachModel->$seacrhColumn;

                }

                $i++;

            }

            foreach ($model1 as $eachModel1) {

                $data[$i]['value'] = 75;

                $data[$i]['companyid'] = "v" . $eachModel1->company->id;

                if (is_array($seacrhColumn)) {

                    foreach ($seacrhColumn as $eachColumn) {

                        $data[$i]['label'] = $eachModel1->company->id . ':' . $eachModel1->company->company_name;

                    }

                }

                else

                    $data[$i]['label'] = $eachModel1->company->id . '' . $eachModel1->company->company_name;



                $i++;

            }

        }

        //  print_r($data);die();

        echo CJSON::encode($data);

        Yii::app()->end();

    }



    public function getDebitnotes() {

        $model = new Purchasingcredit;

        $count = $model->count();

        if ($count)

            return 1;

        else

            return 0;

    }

     public function actionUploadProfilePhoto($folder = null) {

    	

    	Yii::import("ext.EAjaxUpload.qqFileUploader");

    

    	$field_id = "";

    	if(isset($_GET['field_id']))

    	{

    		$field_id = Yii::app()->request->getParam('field_id');

    	}

    

    

    	$folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';

    	// make the directory to store the pic:

    	if (!is_dir($folder)) {

    		mkdir($folder, 0777, TRUE);

    	}

    	$allowedExtensions = array("jpg", "jpeg", "gif","png"); //array("jpg","jpeg","gif","exe","mov" and etc...

    	$sizeLimit = 8 * 1024 * 1024; // maximum file size in bytes

    	$uploader = new qqFileUploader($allowedExtensions, $sizeLimit);

    	$result = $uploader->handleUpload($folder);

    	$result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);

    	$result['field_id'] = $field_id;

    	$return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);

    

    	$fileName = $result['filename']; //GETTING FILE NAME

    	 

    

    	$imagename	=	Yii::app()->basePath.'/../uploads/profilephotos/'.$fileName;

    

    	$imagename_thumb	=	Yii::app()->basePath.'/../uploads/profilephotos/thumbs/'.$fileName;

    	Yii::import("ext.EPhpThumb.EPhpThumb");

    

    	$thumb=new EPhpThumb();

    	$thumb->init(); //this is needed

    	//chain functions

    	$thumb->create($imagename)->resize(100,100)->save($imagename_thumb);

    

    	echo $return; // it's array

    }

    public function actionUploadDocuments($folder = null) {

    	

    	Yii::import("ext.EAjaxUpload.qqFileUploader");

    

    	$field_id = "";

    	if(isset($_GET['field_id']))

    	{

    		$field_id = Yii::app()->request->getParam('field_id');

    	}

        //echo $field_id.'<br>';   

         

                 // echo $folder;

                 

    	$folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';

        

        

    	// make the directory to store the pic:

    	if (!is_dir($folder)) {

    		mkdir($folder, 0777, TRUE);

    	}

    	$allowedExtensions = array("png", "jpg", "jpeg", "gif", "pdf","doc", "docx", "txt"); //array("jpg","jpeg","gif","exe","mov" and etc...

    	$sizeLimit = 8 * 1024 * 1024; // maximum file size in bytes

    	$uploader = new qqFileUploader($allowedExtensions, $sizeLimit);

    	$result = $uploader->handleUpload($folder);

    	$result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);

    	$result['field_id'] = $field_id;

    	$return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);

    

    	$fileName = $result['filename']; //GETTING FILE NAME

    	

    	$imagename	=	Yii::app()->basePath.'/../uploads/documents/'.$fileName;

    

    	//$imagename_thumb	=	Yii::app()->basePath.'/../uploads/documents/thumbs/'.$fileName;

    	//Yii::import("ext.EPhpThumb.EPhpThumb");

    

    	// $thumb=new EPhpThumb();

    	// $thumb->init(); //this is needed

    	//chain functions

    //	$thumb->create($imagename)->resize(100,100)->save($fileName);

    

    	echo $return; // it's array

    }

    public function actionUploadCustomerDocuments($folder = null) {
         Yii::import("ext.EAjaxUpload.qqFileUploader");
         $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';
        // make the directory to store the pic:
        if (!is_dir($folder)) {
            mkdir($folder, 0777, TRUE);
        //chmod($folder, 0755);
        }
        $allowedExtensions = array("jpg","png","doc","docx","xls","xlsx","pdf","bmp","jpeg");
    	$sizeLimit = 8 * 1024 * 1024; // maximum file size in bytes

    	$uploader = new qqFileUploader($allowedExtensions, $sizeLimit);

    	$result = $uploader->handleUpload($folder);

    	$result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);

    	$return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);
        $fileName = $result['filename']; //GETTING FILE NAME
        $this->CropIfImage($folder, $fileName, 100, 100);
        echo $return; // it's array

    
    }
//    public function updateInventoryStock($product_id, $ware_house_id, $no_of_items_in_take,$frm) { //calling from actionSaveMaterialreceipt
//        if ($product_id != 0) {
//            $productlocation = ProductLocation::model()->find(array(
//              'condition' => 'stock_id=:stockID AND warehouse_id=:warehouseID',
//              'params' => array(':stockID' => $product_id, ':warehouseID' => $ware_house_id)));
//            if (empty($productlocation)) {
//                $productlocation = new ProductLocation;
//                $productlocation->stock_id = $product_id;
//                $productlocation->warehouse_id = $ware_house_id; // need to check if warehouse is blank or not, if blank assign the default warehouse
//                $productlocation->quantity = 0;
//                $productlocation->save(false);
//            }
//
//            $qty = 0;
//            if($frm=='add')
//            {
//                $qty = $productlocation->quantity + $no_of_items_in_take;
//            }
//            elseif($frm=='deduct')
//            {
//                $qty = $productlocation->quantity - $no_of_items_in_take;
//            }
//
//            $arrayToBeUpdated['quantity'] = $qty;
//            $productlocation->updateByPk($productlocation->id, $arrayToBeUpdated);
//        }
//    }
      public function updateInventoryStock($product_id=0, $ware_house_id=0, $no_of_items=0,$cur_total=0,$op) { //calling from MR,QC or PI
                   
              if ($product_id > 0) {
                    $productlocation = ProductLocation::model()->find(array('condition' => 'stock_id=:stockID AND warehouse_id=:warehouseID','params' => array(':stockID' => $product_id, ':warehouseID' => $ware_house_id)));
                    $product = Store::model()->findbyPk($product_id);
                    $old_total_qty = Yii::app()->db->createCommand('SELECT SUM(quantity) FROM  crm_product_location WHERE stock_id='.$product_id.' ')->queryScalar();
                    $old_net_amount = $product->rate * $old_total_qty;
                    if(!empty($productlocation)){
                        $existing_warehouse_qty =  $productlocation->quantity;
                    }else{
                        $existing_warehouse_qty = 0;
                    }
                    if($op == 'add'){
                        $total_qty = $old_total_qty + $no_of_items;
                        $warehouse_qty = $existing_warehouse_qty + $no_of_items;
                        $new_amount = ($old_net_amount + $cur_total)/$total_qty;
                   
                    }else if($op == 'transferded'){
                          $total_qty = $old_total_qty - $no_of_items;
                          $warehouse_qty = $existing_warehouse_qty - $no_of_items;
                          $new_amount = $product->rate;
                          
                    }else if($op == 'transferadd'){
                          $total_qty = $old_total_qty + $no_of_items;
                          $warehouse_qty = $existing_warehouse_qty + $no_of_items;
                          $new_amount = $product->rate;
                          
                    }else{
                         $total_qty = $old_total_qty - $no_of_items;
                         $warehouse_qty = $existing_warehouse_qty - $no_of_items;
                         $new_amount = ($old_net_amount - $cur_total)/$total_qty;
                    }
                    if($warehouse_qty < 0){
                         $warehouse_qty = 0;
                    }
                    $arrayToBeUpdated['quantity'] = $warehouse_qty;
                    $product->updateByPk($product->id, array('total_quantity' => $total_qty,'rate' => $new_amount));
                    if($productlocation->id > 0){
                         $productlocation->updateByPk($productlocation->id, $arrayToBeUpdated);
                    }else if($ware_house_id > 0){
                        $newloc = new ProductLocation;
                        $newloc->stock_id = $product_id;
                        $newloc->warehouse_id = $ware_house_id;
                        $newloc->quantity = $warehouse_qty;
                        $newloc->save(false);
                    }
                   
                    
              }
    }
    public function updateInventoryItem($product_id, $ware_house_id, $no_of_items,$op) {
    
                         $productlocation = ProductLocation::model()->find(array('condition' => 'stock_id=:stockID AND warehouse_id=:warehouseID','params' => array(':stockID' => $product_id, ':warehouseID' => $ware_house_id)));
                         $product = Store::model()->findbyPk($product_id);
                         if(!empty($product))
                                $total_qty = $product->total_quantity;
                             else
                                $total_qty = 0;
                         if($op == 'add'){
                             
                             if(!empty($productlocation)){
                                 $loc = ProductLocation::model()->findByPk($productlocation->id);
                                 $old = $loc->quantity;
                                 $loc->quantity = $old+$no_of_items;
                                 $loc->save(false);
                                 $qty = $loc->quantity;
                                 Store::model()->updateByPk($product_id, array('total_quantity' => $total_qty+$no_of_items));
                             }else{
                                    $newloc = new ProductLocation;
                                    $newloc->stock_id = $product_id;
                                    $newloc->warehouse_id = $ware_house_id;
                                    $newloc->quantity = $no_of_items;
                                    $newloc->save(false);
                                    $qty=$no_of_items;
                                    Store::model()->updateByPk($product_id, array('total_quantity' => $total_qty+$no_of_items));
                             }
                         }else if($op == 'sub'){
                             if(!empty($productlocation)){
                                 if($productlocation->quantity > $no_of_items){
                                    $loc = ProductLocation::model()->findByPk($productlocation->id);
                                    $old = $loc->quantity;
                                    $loc->quantity = $old-$no_of_items;
                                    $loc->save(false);
                                    $qty = $loc->quantity;
                                    Store::model()->updateByPk($product_id, array('total_quantity' => abs($total_qty-$no_of_items)));
                                   
                                 }
                                 
                             }
                         }
                         
            
    }
    public function addSubledger($type,$id,$des){
                $subledger = new Subledger;
                $max = Yii::app()->db->createCommand('SELECT MAX(account_no) FROM crm_fin_subledger')->queryScalar();
                $subledger->account_no = $max+1;
                $subledger->type = $type;   
                $subledger->respect_id = $id; 
                $subledger->description = $des;
                $subledger->created_by = Yii::app()->user->id;
                $subledger->created_date_time = date('Y-m-d h:i:s');
                $subledger->save(false);
    }

    



}