<?php

/**
 * This is the model class for table "{{outbound_invoice}}".
 *
 * The followings are the available columns in table '{{outbound_invoice}}':
 * @property string $id
 * @property integer $outbound_id
 * @property integer $customer_id
 * @property string $invoice_no
 * @property string $invoice_date
 * @property string $invoice_note
 * @property integer $created_by
 * @property string $created_date_time
 */
class OutboundInvoice extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	 
	public $customer_name;
	public function tableName()
	{
		return '{{outbound_invoice}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('outbound_id, customer_id, invoice_no, invoice_date ,unit_label', 'required'),
			array('outbound_id, customer_id, created_by', 'numerical', 'integerOnly'=>true),
			array('invoice_no, destination, freight_charge', 'length', 'max'=>255),
			array('brands_used', 'length', 'max'=>400),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, outbound_id, customer_id, invoice_no, invoice_date, bank_details, invoice_note, created_by, created_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    'items' => array(self::HAS_MANY, 'OutboundInvoiceItems', 'invoice_id', 'order' => 'items.id ASC'),
			'customer' => array(self::BELONGS_TO, 'Customers', 'customer_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'outbound_id' => 'Outbound',
			'customer_id' => 'Customer',
			'invoice_no' => 'Invoice No',
			'invoice_date' => 'Invoice Date',
			'invoice_note' => 'Invoice Note',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		$criteria->compare('outbound_id',$this->outbound_id);
		$criteria->compare('customer_id',$this->customer_id);
		$criteria->compare('invoice_no',$this->invoice_no,true);
		$criteria->compare('invoice_date',$this->invoice_date,true);
		$criteria->compare('invoice_note',$this->invoice_note,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return OutboundInvoice the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	public function currency(){
		return OutboundInvoiceItems::model()->find(array('condition'=>'invoice_id='.$this->id))->outb_currency_code;
	}
}
