(function () {

    if (this.StartCheckout) {
        return;
    }

    this.StartCheckout = {};

    function getScriptTagInSyncMode() {
        var scripts = document.getElementsByTagName('script');
        var script = scripts[scripts.length - 1];
        if (script.src.indexOf('checkout.js') == -1) {
            return false;
        } else {
            return script;
        }
        return false;
    };

    function getScriptTagInDeferMode() {
        return document.querySelector("script[src*='//beautiful.']");
    };

    var scriptTag = document.currentScript || getScriptTagInSyncMode() || getScriptTagInDeferMode();

    function host(url) {
        // works in IE < 8
        // https://gist.github.com/jlong/2428561
        var div = document.createElement('div'), anchor;
        div.innerHTML = "<a></a>";
        div.firstChild.href = url;
        div.innerHTML = div.innerHTML; // Run the current innerHTML back through the parser

        anchor = div.firstChild;

        return "" + anchor.protocol + "//" + anchor.host;
    }

    this.StartCheckout.onCI = (scriptTag.src.indexOf('ci=true') !== -1);
    this.StartCheckout.onProd = (host(scriptTag.src).indexOf('start.payfort.com') !== -1);
    this.StartCheckout.onStaging = (host(scriptTag.src).indexOf('staging.start.payfort.com') !== -1)

    this.StartCheckout.host = 'http://beautiful.start.dev'

    if (StartCheckout.onStaging) {
        this.StartCheckout.host = 'https://beautiful.staging.start.payfort.com'
    } else if (StartCheckout.onProd) {
        this.StartCheckout.host = 'https://beautiful.start.payfort.com'
    } else if (this.StartCheckout.onCI) {
        this.StartCheckout.host = '';
    }

    this.StartCheckout.scriptTag = scriptTag;
}).call(this);
(function(document) {
    if (this.StartCheckout.utils) {
        return;
    }

    this.StartCheckout.utils = {
        bind: function(el, name, callback) {
            if (el.addEventListener) {
                return el.addEventListener(name, callback, false)
            } else if (el.attachEvent)  {
                return el.attachEvent("on" + name, callback)
            }
        },
        bindFn: function(fn, obj) {
            return function() {
                return fn.apply(obj, arguments)
            }
        },
        addJsLink: function(link) {
            var js = document.createElement('script');
            js.src = link;
            js.type = 'text/javascript';
            document.getElementsByTagName('head')[0].appendChild(js);
        },
        addCssLink: function(link) {
            var style = document.createElement('link');
            style.type = 'text/css';
            style.rel = 'stylesheet';
            style.href = link;
            document.getElementsByTagName('head')[0].appendChild(style);
        }
    };
}).call(this, document);

(function() {
    if (this.StartCheckout.ua) {
        return;
    }

    this.StartCheckout.ua = {
        userAgent: window.navigator.userAgent,
        isiPhone: function() {
            return /(iPhone|iPod)/i.test(this.userAgent);
        },
        isiOSWebView: function() {
            return /(iPhone|iPod).*AppleWebKit(?!.*Safari)/i.test(this.userAgent);
        },
        isTouchCapable: function() {
            return 'ontouchstart' in window;
        },
        isTabsSupported: function() {
            return !this.isiOSWebView();
        }
    }
}).call(this);
(function() {
    if (this.StartCheckout.Navigator) {
        return;
    }

    this.StartCheckout.Navigator = (function() {
        function Navigator() {}

        Navigator.isSupportTLS1_2 = function() {
            var isSupport = true;

            var browser = getBrowserInfo();
            var version = parseInt(browser.version);

            switch (browser.name.toLowerCase()) {
            case "ie":
            case "msie":
                if (version < 10) { isSupport = false; }
                break;
            case "safari":
                if (version < 7) { isSupport = false; }
                break;
            }

            return isSupport;
        };

        function getBrowserInfo() {
            var ua=navigator.userAgent,tem,M=ua.match(/(opera|chrome|safari|firefox|msie|trident(?=\/))\/?\s*(\d+)/i) || [];
            if(/trident/i.test(M[1])){
                tem=/\brv[ :]+(\d+)/g.exec(ua) || [];
                return {name:'IE',version:(tem[1]||'')};
            }
            if(M[1]==='Chrome'){
                tem=ua.match(/\bOPR\/(\d+)/)
                if(tem!=null)   {return {name:'Opera', version:tem[1]};}
            }
            M=M[2]? [M[1], M[2]]: [navigator.appName, navigator.appVersion, '-?'];
            if((tem=ua.match(/version\/(\d+)/i))!=null) {M.splice(1,1,tem[1]);}
            return {
                name: M[0],
                version: M[1]
            };
        }

        return Navigator;
    })();

}).call(this);
(function() {
    if (this.StartCheckout.RPC) {
        return;
    }

    var utils = this.StartCheckout.utils;

    this.StartCheckout.RPC = (function() {
        function RPC(params) {
            this.target = params.target;
            this.type = params.type || 'server';
            this.methods = {};
            this.messages = [];
            this.isReady = false;

            utils.bind(window, "message", function(self) {
                return function() {
                    return self.handleMessage.apply(self, arguments)
                }
            }(this));
        }

        RPC.prototype.sendMessage = function(message) {
            data = JSON.stringify(message);

            this.send(data);
        };

        RPC.prototype.send = function(data) {
            if (this.isReady === true) {
                this.target.postMessage(data, "*");
            } else {
                this.messages.push(data);
            }
        };

        RPC.prototype.handleMessage = function(event) {
            if (event.source == this.target) {
                this.processMessage(event.data)
            }
        };

        RPC.prototype.processMessage = function(data) {
            message = JSON.parse(data);


            // when client ready
            if (message.isReady === true && this.isReady === false) {
                this.ready();

                return;
            }

            if (this.methods[message.method] && typeof(this.methods[message.method] === "function")) {
                this.methods[message.method].apply(this.methods, message.args);
            }
        };

        RPC.prototype.whenReady = function(callback) {
            if (this.isReady) {
                return callback();
            } else {
                this.onReadyCallback = callback;
            }
        };

        // say that client is ready
        RPC.prototype.ready = function() {
            var message;

            this.isReady = true;

            this.onReadyCallback && this.onReadyCallback();

            this.sendMessage({ isReady: true, type: this.type });

            while( message = this.messages.shift() ) {
                this.send(message);
            }
        };

        RPC.prototype.invoke = function() {
            var method, args,
            slice = Array.prototype.slice;

            method = arguments[0];
            args = slice.call(arguments, 1);

            this.sendMessage({
                method: method,
                args: args
            });
        };

        return RPC;
    })();

}).call(this);
(function(document) {
    if (this.StartCheckout.Iframe) {
        return;
    }

    var RPC = this.StartCheckout.RPC,
        utils = this.StartCheckout.utils,
        StartCheckout = this.StartCheckout,
        ua = this.StartCheckout.ua;

    this.StartCheckout.Iframe = (function() {

        var documentHead,
            documentViewport,
            viewportInitialValue,
            $body = document.body,
            // overflowInitialValue,
            $html,
            $body,
            htmlInitialStyle,
            bodyInitialStyle,
            requiredStyle,
            bodyScrollPosition;


        function updateViewPort() {
            documentHead = document.getElementsByTagName('head')[0];
            documentViewport = document.querySelector('meta[name=viewport]');
            viewportInitialValue = '';
            $body = document.body;
            $html = document.documentElement;

            htmlInitialStyle = $html.style.cssText || '';
            bodyInitialStyle = $body.style.cssText || '';

            requiredStyle = 'position: relative; overflow: hidden; height: 100%';

            // overflowInitialValue = $body.style.overflow;

            if ( !documentViewport ) {
                // 1. create new meta tag
                var viewportMetaTag = document.createElement('meta');
                viewportMetaTag.name = 'viewport';
                viewportMetaTag.content = '';
                // 2. add new meta tag
                documentHead.appendChild(viewportMetaTag);
                // 3. init viewport
                documentViewport = viewportMetaTag;
            }

            // save init viewport value and scroll position
            viewportInitialValue = documentViewport.getAttribute('content');
            bodyScrollPosition = $body.scrollTop;

            // set required value
            documentViewport.setAttribute('content', 'width=device-width, user-scalable=no');
            $body.style.cssText = requiredStyle;
            $html.style.cssText = requiredStyle;
        }

        function restoreViewPort() {
            documentViewport.setAttribute('content', viewportInitialValue);

            $body.style.cssText = htmlInitialStyle;
            $html.style.cssText = bodyInitialStyle;
            $body.scrollTop = bodyScrollPosition;
        }

        function Iframe() {
            var src = StartCheckout.host + "/beautiful.html" + '?' + Math.random();

            if (StartCheckout.onCI) {
                src += "&ci=true";
            }

            this.opened = false;

            this.src = src;

            this.iframe = this.addIframe();
            this.rpc = new RPC({ target: this.iframe.contentWindow, type: 'server' });
            this.rpc.methods.cancel = utils.bindFn(this.cancel, this);
            this.rpc.methods.complete = utils.bindFn(this.complete, this);
        }

        Iframe.prototype.config  = function(options) {
            this.configuration = options || (options = {});
            this.rpc.invoke('config', this.configuration);
        };

        Iframe.prototype.open = function(params) {
            if (this.opened) {
                return;
            }

            this.opened = true;

            if (ua.isTouchCapable()) {
                updateViewPort();
            }

            this.iframe.style.display = 'block';
            this.rpc.invoke('open', params);

        };

        Iframe.prototype.complete = function(params) {
            this.close();
            this.configuration.complete(params);
        };

        Iframe.prototype.cancel = function() {
            this.close();

            if (this.configuration.cancel) { this.configuration.cancel(); }
        };

        Iframe.prototype.close = function() {
            this.opened = false;
            this.iframe.style.display = 'none';

            if (ua.isTouchCapable()) {
                restoreViewPort();
            }
        };

        Iframe.prototype.addIframe = function() {
            var iframe;

            iframe = document.createElement("iframe");
            iframe.name = "beautifulJs";
            iframe.setAttribute("frameBorder", "0");
            iframe.setAttribute("allowtransparency", "true");
            iframe.style.cssText = "z-index: 2147483646;\ndisplay: none;\nbackground: transparent;\nbackground: rgba(0,0,0,0.005);\nborder: 0px none transparent;\noverflow-x: hidden;\noverflow-y: auto;\nvisibility: hidden;\nmargin: 0;\npadding: 0;\n-webkit-tap-highlight-color: transparent;\n-webkit-touch-callout: none; position: fixed;\nleft: 0;\ntop: 0;\nwidth: 100%;\nheight: 100%;"

            iframe.src = this.src;

            document.body.appendChild(iframe);

            utils.bind(iframe, 'load', function() {
                iframe.style.visibility = "visible";
            });

            return iframe;
        };

        return Iframe;
    })();
}).call(this, document);
(function(document) {
    if (this.StartCheckout.Tab) {
        return;
    }

    var RPC = this.StartCheckout.RPC,
        utils = this.StartCheckout.utils,
        StartCheckout = this.StartCheckout;

    this.StartCheckout.Tab = (function() {

        function Tab() {
            var src = StartCheckout.host + "/beautiful.html" + '?' + Math.random();

            if (StartCheckout.onCI) {
                src += "&ci=true";
            }
            this.opened = false;
            this.src = src;
        }

        Tab.prototype.config  = function(options) {
            this.configuration = options || (options = {});
            this.configuration.inTab = true;
        };

        Tab.prototype.open = function(params) {
            if (this.opened) {
                return;
            }

            this.opened = true;

            this.createTab();

            this.rpc.invoke('config', this.configuration);
            this.rpc.invoke('open', params);
        };


        Tab.prototype.createTab = function() {
            var self = this;

            this.tab = window.open(this.src, 'btfljs');
            this.rpc = new RPC({ target: this.tab, type: 'server' });
            this.rpc.methods.cancel = utils.bindFn(this.cancel, this);
            this.rpc.methods.complete = utils.bindFn(this.complete, this);
            this.rpc.whenReady(function() {
                self.checkIfClosed();
            });
        };

        Tab.prototype.checkIfClosed = function() {
            var self = this;
            if (this.checkInterval) {
                clearInterval(this.checkInterval);
            }

            this.checkInterval = setInterval(function() {
                if (self.tab.closed) {
                    self.close();
                }
            }, 1000);
        };

        Tab.prototype.complete = function(params) {
            this.close();
            this.configuration.complete(params);
        };

        Tab.prototype.cancel = function() {
            this.close();

            if (this.configuration.cancel) { this.configuration.cancel(); }
        };

        Tab.prototype.close = function() {
            clearInterval(this.checkInterval);
            this.opened = false;

            if (!this.tab.closed) {
                this.tab.close();
            }
        };

        return Tab;
    })();
}).call(this, document);
(function(document) {
    if (this.StartCheckout.View) {
        return;
    }

    var ua = this.StartCheckout.ua, StartCheckout = this.StartCheckout;

    this.StartCheckout.getView = function(options) {
        var viewClass;

        if (ua.isiPhone() && ua.isTabsSupported() && options.tabOnMobile) {
            viewClass = StartCheckout.Tab;
        } else {
            viewClass = StartCheckout.Iframe;
        }

        return viewClass;
    };
}).call(this, document);
(function() {
    var oldBrowserMessage = "Sorry, but you can't make payment using this browser as its version is considered unsecure. Please, use latest version of your browser or download and install latest version of free Firefox / Chrome.";

    if (this.StartCheckout.Checkout) {
        return;
    }

    if(this.StartCheckout.Navigator.isSupportTLS1_2() === false) { alert(oldBrowserMessage); }

    this.StartCheckout.Checkout = (function() {
        var initialized = false;

        function Checkout() {}

        // just do nothing with old browser...
        if(StartCheckout.Navigator.isSupportTLS1_2() === false) {
            Checkout.config = function(options) {};
            Checkout.open = function(params) { alert(oldBrowserMessage); };

            return Checkout;
        }

        // for modern browsers we are gald to say hello
        var view;


        Checkout.config = function(options) {
            this.configuration = options;

            if (typeof(view) === 'undefined') {
                viewClass = StartCheckout.getView(options);
                view = new viewClass;
            }

            view.config(options);
        };

        Checkout.open = function(params) {
            view.open(params);
        };

        return Checkout;
    })();
}).call(this);
(function() {
    if (this.StartCheckout.Button) {
        return;
    }

    var utils = this.StartCheckout.utils,
    StartCheckout = this.StartCheckout,
    oldIE = window.attachEvent && !window.addEventListener;

    StartCheckout.Button = (function() {
        function addInput(name, value) {
            var input = document.createElement("input");

            input.type = "hidden";
            input.value = value;
            input.name = name;

            return input;
        }

        function Button(form, config) {
            this.form = form;
            this.complete = utils.bindFn(this.complete, this);
            this.open = utils.bindFn(this.open, this);

            this.config = config;
            this.config.complete = this.complete;
            this.config.tabOnMobile = true;

            this.params = {
                amount: config.amount,
                currency: config.currency,
                email: config.email
            };

            StartCheckout.config(this.config);

            this.render();
        }

        Button.prototype.render = function() {
            utils.addCssLink(StartCheckout.host + '/button.css');

            this.btn = document.createElement("button");
            this.btn.setAttribute("type", "submit");
            this.btn.className = "start-js-btn";

            this.btn.innerHTML = this.config.label || "Pay with Card";

            utils.bind(this.btn, 'click', this.open);
            this.form.appendChild(this.btn);
        };

        Button.prototype.open = function(e) {
            e.preventDefault ? e.preventDefault() : e.returnValue = false;

            if (oldIE) {
                alert("Due to security reasons please, use modern browser (IE11, FireFox, Chrome or Safari) to make payment!");
            } else {
                StartCheckout.open(this.params);
            }

            return false;
        };

        Button.prototype.complete = function(params) {
            this.form.appendChild(addInput('startToken', params.token.id));
            this.form.appendChild(addInput('startEmail', params.email));
            this.form.submit();
        };

        return Button;
    })();
}).call(this);
(function() {
    if (this.StartCheckout.open) {
        return;
    }

    this.StartCheckout.open = this.StartCheckout.Checkout.open;
    this.StartCheckout.config = this.StartCheckout.Checkout.config;
}).call(this);
(function() {
    if (this.StartCheckout.auto) {
        return;
    }

    this.StartCheckout.auto = true;

    var scriptTag = this.StartCheckout.scriptTag,
    formTag = scriptTag.parentElement,
    config = {};

    if (formTag.tagName != 'FORM') {
        return;
    }

    var attr, match;

    for (i = 0; i < scriptTag.attributes.length; i++) {
        attr = scriptTag.attributes[i];
        match = attr.name.match(/^data-(.+)$/);
        if (match != null) {
            paramName = camelize(match[1]);
            config[paramName] = attr.value
        }
    }

    if(!config.key || !config.amount || !config.currency) {
        alert('At a minimum, the data-key, data-amount and data-currency options' +
              ' have to be set');
        return false;
    }

    config.amount = parseFloat(config.amount);
    config.tabOnMobile = true;

    var btn = new this.StartCheckout.Button(formTag, config);

    function camelize(str) {
        function lowerToUpper(_, match) {
            return match.toUpperCase();
        }

        return str.replace(/(?:[-_])(\w)/g, lowerToUpper);
    }
}).call(this);



