<?php
$form = $this->beginWidget('CActiveForm', array(
            'id' => 'bill-form',
            'enableAjaxValidation' => false,
            'enableClientValidation' => false,
        ));
?>
<ul class="nav nav-tabs company-nav-tabs nav-tab-theme">
    <li class="active"><a href="#tab1" data-toggle="tab">General</a></li>
    <li><a href="#tab2" data-toggle="tab">Details</a></li>
</ul>
<div class="tab-content">
    <div class="tab-pane active" id="tab1">
        <ul class="clearfix form-ul material">
            <li class="col-sm-3">
                <?php echo $form->textField($model,'inb_doc_no',array('data-label'=>'DOC #', 'readonly' => true )); ?>
            </li>
            <li class="col-sm-3">
                <?php echo $form->textField($model,'inb_delivery_note_no',array('data-label'=>'Delivery Note #', 'readonly' => true)); ?>
            </li>
            <li class="col-sm-3">
                <?php echo $form->textField($model,'inb_bill_of_entry_no',array('data-label'=>'Bill of Entry #', 'data-mask' => '999-99999999-99', 'readonly' => true)); ?>
            </li>
            <li class="col-sm-3">
                <?php echo $form->textField($model,'inb_ta_number',array('data-label'=>'TA #')); ?>
            </li>
            <li class="col-sm-3">
                <?php  $model->inb_bill_of_entry_date = ($model->inb_bill_of_entry_date != '0000-00-00') ? date('d/m/Y',strtotime($model->inb_bill_of_entry_date)) : ''; ?>
                <?php echo $form->textField($model,'inb_bill_of_entry_date',array('data-label'=>'BOE Date', 'class' => 'datepicker', 'readonly' => true)); ?>
            </li>
        </ul>
    </div>
     <div class="tab-pane" id="tab2">
        <ul class="clearfix form-ul material">
            <div class="table-responsive">
                <table class="table table-hover table-bordered personal-task">        
                <tr>
                    <th style="width:1%">No</th>            
                    <th style="width:10%">Item</th>
                    <th style="width:13%">Description</th> 
                    <th style="width:8%">HS Code</th>
                    <th style="width:10%">Origin</th>      
                    <th style="width:7%">Qty</th>            
                    <th style="width:5%">UoM</th>   
                    <th style="width:11%">Pckg</th>          
                    <th style="width:7%">Net Wt</th> 
                    <th style="width:7%">Gross Wt</th> 
                    <th style="width:7%">CBM</th> 
                    <th style="width:7%">U.Price</th> 
                    <th style="width:7%">Net value</th>            
                    <th style="width:2%">Currency</th>
                       
                        
                </tr>
       <?php
        foreach( $items as $i => $each): ?>
            <tr>                
                <td><label><?php echo ($i+1); ?></label></td>
                <td><?php echo $form->hiddenField($each, "[".$i."]id"); echo $form->textField($each, "[".$i."]inb_part_number", array('class'=>'form-control go')); ?></td>
                <td><?php echo $form->textArea($each, "[".$i."]inb_description", array('class'=>'form-control go')); ?></td>
                <td><?php echo $form->textField($each, "[".$i."]inb_hs_code", array('class'=>'form-control go')); ?></td>
                <td><?php echo $form->textField($each, "[".$i."]inb_contry_of_origin", array('class'=>'form-control go')); ?></td>
                <td><?php echo $form->textField($each, "[".$i."]inb_quantity", array('class'=>'form-control go', 'readonly' => true)); ?></td>
                <td><?php echo $form->textField($each, "[".$i."]inb_quantity_unit", array('class'=>'form-control go')); ?></td>
                <td><?php echo $form->textField($each, "[".$i."]inb_remarks", array('class'=>'form-control go')); ?></td>
                <td><?php echo $form->textField($each, "[".$i."]inb_net_wt", array('class'=>'form-control go', 'onkeypress' => 'return isNumberKey(event)' )); ?></td>
                <td><?php echo CHtml::hiddenField("InboundItems[".$i."][old_gross_wt]",$each->inb_gross_wt); echo $form->textField($each, "[".$i."]inb_gross_wt", array('class'=>'form-control go', 'onkeypress' => 'return isNumberKey(event)' )); ?></td>
                <td><?php echo $form->textField($each, "[".$i."]inb_cbm", array('class'=>'form-control go')); ?></td>
                <td><?php echo $form->textField($each, "[".$i."]rate", array('class'=>'form-control go text-right', 'value' => Yii::app()->numberFormatter->formatCurrency(($each->inb_invoice_rate/$each->inb_quantity)," ") )); ?></td>
                <td><?php echo CHtml::hiddenField("InboundItems[".$i."][old_invoice_rate]",$each->inb_invoice_rate); echo $form->textField($each, "[".$i."]inb_invoice_rate", array('class'=>'form-control go text-right', 'onkeypress' => 'return isNumberKey(event)')); ?></td>
                <td><?php echo $form->textField($each, "[".$i."]inb_currency_code", array('class'=>'form-control go')); ?></td>
            </tr>      
        <?php endforeach; ?>    
         </table>
    </div>

        </ul>
    </div>
</div>

<div class="modal-footer">
    <button type="button" class="btn btn-default "  data-dismiss="modal">Close</button>
    <?php
    //         $url = Yii::app()->createUrl('inbound/updateidocdetails');
    //         echo CHtml::ajaxSubmitButton('Save', $url, array(
    //                 'dataType' => 'json',
    //                 'type' => 'post',
    //                 'success' => 'function(data) {
    //                                 $("#loader").hide();
    //                                 if(data.status=="success"){  
    //                                      t8.success("Done!");
    //                                      $(".x.close").click();
    //                                      reloadTable("#tbl_inbound_details");
    //                                 }else{ 
    //                                     $.each(data, function(key, val) {
    //                                         t8.error(""+val+"");
    //                                     }); 
    //                                 } 
    //                             }',

    //                 'beforeSend' => 'function(){
    //                     $("#loader").show();
    //                 }'
    //             ), array('id' => 'mybtn' . rand(), 'class' => 'bill-save-btn btn btn-theme'));
    // ?>
    </div>


<?php $this->endWidget(); ?>










