<?php

/**
 * This is the model class for table "{{outbound_items}}".
 *
 * The followings are the available columns in table '{{outbound_items}}':
 * @property integer $id
 * @property string $outb_delivery_note_no
 * @property string $outb_part_number
 * @property string $outb_description
 * @property string $outb_hs_code
 * @property string $outb_hs_code_ae
 * @property string $outb_contry_of_origin_code
 * @property string $outb_contry_of_origin
 * @property string $outb_currency_code
 * @property string $outb_exchange_rate
 * @property string $outb_invoice_rate
 * @property string $outb_no_of_pieces
 * @property string $outb_pieces_unit
 * @property string $outb_quantity
 * @property string $outb_quantity_unit
 * @property string $outb_current_qty
 * @property string $outb_net_amount
 * @property string $outb_net_amount_bc
 * @property string $outb_net_wt
 * @property string $outb_gross_wt
 * @property string $outb_posted
 * @property string $outb_added_date
 * @property string $outb_rate_updated
 * @property integer $outb_rate_last_updated_by
 * @property string $outb_rate_last_updated_date_time
 * @property string $outb_weight_updated
 * @property integer $outb_weight_last_updated_by
 * @property string $outb_weight_last_updated_date_time
 */
class OutboundItems extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{outbound_items}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('outb_delivery_note_no, outb_part_number, outb_description, outb_currency_code, outb_invoice_rate, outb_quantity, outb_quantity_unit, outb_gross_wt, brand_id, category_id', 'required'),
			array('outb_rate_last_updated_by, outb_weight_last_updated_by', 'numerical', 'integerOnly'=>true),
			array('outb_delivery_note_no, outb_hs_code_ae, outb_contry_of_origin_code', 'length', 'max'=>50),
			array('outb_part_number', 'length', 'max'=>1000),
			array('outb_hs_code, outb_delivery_note_no', 'length', 'max'=>250),
			array('outb_remarks', 'length', 'max'=>500),
			array('outb_contry_of_origin', 'length', 'max'=>100),
			array('outb_currency_code, outb_invoice_rate, outb_pieces_unit, outb_quantity_unit, outb_cbm,outb_unit_price', 'length', 'max'=>20),
			array('outb_exchange_rate, outb_no_of_pieces, outb_quantity, outb_current_qty, outb_net_amount, outb_net_amount_bc, outb_net_wt, outb_gross_wt', 'length', 'max'=>15),
			array('outb_posted, outb_rate_updated, outb_weight_updated', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, outb_delivery_note_no, outb_part_number, outb_description, outb_hs_code, outb_hs_code_ae, outb_contry_of_origin_code, outb_contry_of_origin, outb_currency_code, outb_exchange_rate, outb_invoice_rate, outb_no_of_pieces, outb_pieces_unit, outb_quantity, outb_quantity_unit, outb_current_qty, outb_net_amount, outb_net_amount_bc, outb_net_wt, outb_gross_wt, outb_posted, outb_added_date, outb_rate_updated, outb_rate_last_updated_by, outb_rate_last_updated_date_time, outb_weight_updated, outb_weight_last_updated_by, outb_weight_last_updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'parent' => array(self::BELONGS_TO, 'Outbound', 'outb_delivery_note_no'),
			'hsc' => array(self::BELONGS_TO, 'HSCode', 'outb_part_number'),
			'currentStock' => array(self::BELONGS_TO, 'Stock', 'outb_stock_id'),
			'brand' => array(self::BELONGS_TO, 'MasBrand', 'brand_id'),
		    'category' => array(self::BELONGS_TO, 'MasCategory', 'category_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'outb_delivery_note_no' => 'Delivery note no from outbound_delivery_note',
			'outb_part_number' => 'Outb Part Number',
			'outb_description' => 'Outb Description',
			'outb_hs_code' => 'Outb Hs Code',
			'outb_hs_code_ae' => 'Outb Hs Code Ae',
			'outb_contry_of_origin_code' => 'Outb Contry Of Origin Code',
			'outb_contry_of_origin' => 'Outb Contry Of Origin',
			'outb_currency_code' => 'Outb Currency Code',
			'outb_exchange_rate' => 'Outb Exchange Rate',
			'outb_invoice_rate' => 'Outb Invoice Rate',
			'outb_no_of_pieces' => 'Outb No Of Pieces',
			'outb_pieces_unit' => 'Outb Pieces Unit',
			'outb_quantity' => 'Outb Quantity',
			'outb_quantity_unit' => 'Outb Quantity Unit',
			'outb_unit_price' => 'Outb Unit Price',
			'outb_current_qty' => 'Outb Current Qty',
			'outb_net_amount' => 'Outb Net Amount',
			'outb_net_amount_bc' => 'Outb Net Amount Bc',
			'outb_net_wt' => 'Outb Net Wt',
			'outb_gross_wt' => 'Outb Gross Wt',
			'outb_posted' => 'Outb Posted',
			'outb_added_date' => 'Outb Added Date',
			'outb_rate_updated' => 'Outb Rate Updated',
			'outb_rate_last_updated_by' => 'Outb Rate Last Updated By',
			'outb_rate_last_updated_date_time' => 'Outb Rate Last Updated Date Time',
			'outb_weight_updated' => 'Outb Weight Updated',
			'outb_weight_last_updated_by' => 'Outb Weight Last Updated By',
			'outb_weight_last_updated_date_time' => 'Outb Weight Last Updated Date Time',
			'brand_id' => 'Brand',
			'category_id' => 'Category',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('outb_delivery_note_no',$this->outb_delivery_note_no,true);
		$criteria->compare('outb_part_number',$this->outb_part_number,true);
		$criteria->compare('outb_description',$this->outb_description,true);
		$criteria->compare('outb_hs_code',$this->outb_hs_code,true);
		$criteria->compare('outb_hs_code_ae',$this->outb_hs_code_ae,true);
		$criteria->compare('outb_contry_of_origin_code',$this->outb_contry_of_origin_code,true);
		$criteria->compare('outb_contry_of_origin',$this->outb_contry_of_origin,true);
		$criteria->compare('outb_currency_code',$this->outb_currency_code,true);
		$criteria->compare('outb_exchange_rate',$this->outb_exchange_rate,true);
		$criteria->compare('outb_invoice_rate',$this->outb_invoice_rate,true);
		$criteria->compare('outb_no_of_pieces',$this->outb_no_of_pieces,true);
		$criteria->compare('outb_pieces_unit',$this->outb_pieces_unit,true);
		$criteria->compare('outb_quantity',$this->outb_quantity,true);
		$criteria->compare('outb_quantity_unit',$this->outb_quantity_unit,true);
		$criteria->compare('outb_current_qty',$this->outb_current_qty,true);
		$criteria->compare('outb_net_amount',$this->outb_net_amount,true);
		$criteria->compare('outb_net_amount_bc',$this->outb_net_amount_bc,true);
		$criteria->compare('outb_net_wt',$this->outb_net_wt,true);
		$criteria->compare('outb_gross_wt',$this->outb_gross_wt,true);
		$criteria->compare('outb_posted',$this->outb_posted,true);
		$criteria->compare('outb_added_date',$this->outb_added_date,true);
		$criteria->compare('outb_rate_updated',$this->outb_rate_updated,true);
		$criteria->compare('outb_rate_last_updated_by',$this->outb_rate_last_updated_by);
		$criteria->compare('outb_rate_last_updated_date_time',$this->outb_rate_last_updated_date_time,true);
		$criteria->compare('outb_weight_updated',$this->outb_weight_updated,true);
		$criteria->compare('outb_weight_last_updated_by',$this->outb_weight_last_updated_by);
		$criteria->compare('outb_weight_last_updated_date_time',$this->outb_weight_last_updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return OutboundItems the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
