<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("load", '
        $(document).ready(function() {
            var table_id ="#tbl_outbound_details";
            var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
                data.from_date = $("#start_date").val();
                data.to_date = $("#end_date").val();
                return data;
            }).DataTable({
                scrollY         : "380px",
                pageLength      : 50,
                ajax: {
                    url: "' . Yii::app()->createUrl('outbound/getidocs') . '",
                    type: "POST",
                    cache : false,
                },
                serverSide:     true,
                fixedColumns:   true,
                processing: true,
                order: [[ 1, "desc" ]],
            
            });
            $(".dataTables_scrollFoot").hide();
    });', CClientScript::POS_HEAD);
$cs->registerScript('importOutdoc', 'function importOutdoc() {
    
    var r = confirm("Are you sure to import outbound idocs?"); 
    if(r){
         HoldOn.open();
        jQuery.ajax({
                "dataType":"json",       
                "type":"post",
                "url": "' . Yii::app()->createUrl('outbound/importidoc') . '&key='.Yii::app()->user->import_key.'",
                "cache": false,
                "success": function(data) {
                    if( data.status == "success" ){
                        HoldOn.close();
                        t8.success("Idocs imported!");
                        reloadTable("#tbl_outbound_details");
                    }else{
                        HoldOn.close();
                        t8.error("Someting went wrong at server end, Make sure the idoc server configured properly!", "Something went wrong!");
                    }
                }
            
        });
    }
   
};', CClientScript::POS_HEAD);
$cs->registerScript("deleteDoc",  "function deleteDoc(id){
    var r = confirm('Are you sure to delete this?');
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'data'  : 'id=' + id,
              'url'  : $('#liveSite').val()+'index.php?r=outbound/delete',
              'cache': false,
              'success':function(data){
                if(data=='fail'){
                   t8.error('Deletion failed!');
                }else {
                    reloadTable('#tbl_outbound_details');
                    t8.success('Deleted!');
                }
               }
            });
        }

   
};", CClientScript::POS_HEAD);
$cs->registerScript("calculateVariance",  "function calculateVariance(deliveryNote, taNumber){
    var r = confirm('Make sure all idocs for TA '+taNumber+' is loaded. Do you want to continue?');
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'data'  : {'deliveryNote' : deliveryNote, 'taNumber' : taNumber},
              'url'  : $('#liveSite').val()+'index.php?r=outbound/calculatevariance',
              'cache': false,
              'success':function(data){
                if(data=='fail'){
                   t8.error('failed!');
                }else {
                    reloadTable('#tbl_outbound_details');
                    t8.success('Variance updated!');
                }
               }
            });
        }

   
};", CClientScript::POS_HEAD);
?>

    <section class="panel">
        <header class="panel-heading clearfix panel-theame">
            <i class="fa fa-file"></i> Delivery Notes
            <div class="pull-right">
                <?php echo CHtml::textfield('start_date',date('01/m/Y'),array('class' => 'datepicker form-control')); ?>
                <?php echo CHtml::textfield('end_date',date('t/m/Y'),array('class' => 'datepicker form-control')); ?>
                <button class="btn btn-sm btn-theme" title="Search" onclick="reloadTable('#tbl_outbound_details');"><i class="fa fa-search"></i></button>
                <button class="btn btn-sm btn-theme" title="Add Delivery" onclick="loadPopupModal('outbound/create','New Delivery','xl')"><i class="fa fa-plus"></i></button>
                <!-- <button class="btn btn-sm btn-theme" title="fetch idocs from the server" onclick="importOutdoc();"><i class="fa fa-download"></i></button> -->
                <!-- <button class="btn btn-sm btn-theme" title="Update bill of Exit" onclick="loadPopupModal('outbound/billofexit','Update Bill of Exit','md')"><i class="fa fa-retweet"></i></button> -->
            </div>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_outbound_details">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>REF #</th>
                            <th>Transferee</th>
                            <th>Invoice No</th>
                            <th>Invoice Date</th>
                            <th>Date</th>
                            <th>Status</th>
                            <th>Logo</th>
                            <th>Destination</th>
                            <th>Print Type</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </section>
    
    <?php 
        $cs = Yii::app()->getClientScript();
        $cs->registerScript('print_pdf', 'function print_pdf(id, view) {
            var logo = $("#logo_id_"+id).val();
            var destination = $("#destination_id_"+id).val();
            var print_type = $("#print_type_id_"+id).val();
            window.open("index.php?r=outbound/print&id="+id+"&view="+view+"&logo="+logo+"&destination="+destination+"&print_type="+print_type);
        };', CClientScript::POS_HEAD); 
        
         //code added by mereena on 12/06/2023
        
        $cs->registerScript("deleteOutboundDeliveryNote",  "function deleteOutboundDeliveryNote(outb_delivery_note_no){
        var r = confirm('Are you sure to delete this?');
            if(r==true)
            {
                jQuery.ajax({
                  'type'  : 'post',
                  'data'  : 'outb_delivery_note_no=' + outb_delivery_note_no,
                  'url'  : $('#liveSite').val()+'index.php?r=outbound/DeleteDeliveryNote',
                  'cache': false,
                  'success':function(data){
                    if(data=='fail'){
                       t8.error('Deletion failed!');
                    }else {
                        reloadTable('#tbl_outbound_details');
                        t8.success('Deleted!');
                    }
                   }
                });
            }
    
       
    };", CClientScript::POS_HEAD);
    ?>
