<?php

/**
 * This is the model class for table "{{warehouses}}".
 *
 * The followings are the available columns in table '{{warehouses}}':
 * @property integer $id
 * @property string $name
 * @property string $isActive
 * @property string $isDefault
 */
class Warehouses extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{warehouses}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('name', 'required'),
			array('name', 'length', 'max'=>255),
			array('isActive, isDefault', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, name, isActive, isDefault', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'name' => 'Name',
			'isActive' => 'Is Active',
			'isDefault' => 'Is Default',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('name',$this->name,true);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('isDefault',$this->isDefault,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Warehouses the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	public function getDefault(){
		return self::model()->find( array( 'condition' => 'isDefault="Y" AND isActive="Y"' ) );
	}

	public function getWarehouses(){
		$model = self::model()->findAll( array('condition'=>'isActive="Y"', 'order'=>'isDefault, name') );
		return CHtml::listData($model, 'id', 'name');
	}

	public function getWarehouses_wo_dedicated(){
		$model = self::model()->findAll( array('condition'=>'isActive="Y" AND isDefault="Y"', 'order'=>'isDefault, name') );
		return CHtml::listData($model, 'id', 'name');
	}
	
    //code added by  mereena on 19/07/2024
	public function getToWarehouses($warehouse_id=0){
	    $condition ='isActive="Y"';
	    if($warehouse_id > 0){
	        $condition.=' AND id<>'.$warehouse_id;
	    }
		$model = self::model()->findAll( array('condition'=>$condition, 'order'=>'isDefault, name') );
		return CHtml::listData($model, 'id', 'name');
	}
}
