<?php

class SsoauthController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('issuetoken', 'sslogin'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('index'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIssuetoken() {
        $username = Yii::app()->request->getParam('username');
        $condition = "t.hr_connected_employee_id='" . $username . "'";
        $model = User::model()->find(["condition" => $condition]);
        $token = CPasswordHelper::hashPassword($username . time());
        User::model()->updateByPk($model->id, ["sso_token" => $token]);
        echo json_encode(["status" => "success", "token" => $token]);
    }

    public function actionSslogin() {
        $token = Yii::app()->request->getParam('token');
        $employee_id = Yii::app()->request->getParam('u');
        $condition = "t.hr_connected_employee_id='" . $employee_id . "'";
        $usermodel = User::model()->find(["condition" => $condition]);
//        echo $condition;
//        echo $usermodel->sso_token;
        if ($usermodel->sso_token == $token) {
            $model = new LoginForm();
            $model->isSSO = true;
            $model->username = $usermodel->username;
            $model->password = $usermodel->password;
//            $model->company_code = "BLUESKY";
            if ($model->validate() && $model->login()) {
                User::model()->updateByPk($usermodel->id, ["sso_token" => ""]);
                $this->redirect(["/site/index"]);
            } else {
                echo "Error in login";
                print_r($model->getErrors());
            }
        } else {
            echo "Error in $employee_id sign in $token ";
        }
    }

}
