<?php

/**
 * This is the model class for table "{{non_stock_items}}".
 *
 * The followings are the available columns in table '{{non_stock_items}}':
 * @property integer $id
 * @property string $part_number
 * @property string $current_stock
 * @property string $stock_required
 * @property string $outbound_deliverynote
 * @property integer $outbound_item_id
 * @property string $isActive
 * @property string $created_date_time
 */
class NonstockItems extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{non_stock_items}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('part_number, current_stock, stock_required, outbound_deliverynote, outbound_item_id, created_date_time', 'required'),
			array('outbound_item_id', 'numerical', 'integerOnly'=>true),
			array('part_number, outbound_deliverynote', 'length', 'max'=>255),
			array('current_stock, stock_required', 'length', 'max'=>15),
			array('isActive', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, part_number, current_stock, stock_required, outbound_deliverynote, outbound_item_id, isActive, created_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'part_number' => 'Part Number',
			'current_stock' => 'Current Stock',
			'stock_required' => 'Stock Required',
			'outbound_deliverynote' => 'Outbound Deliverynote',
			'outbound_item_id' => 'Outbound Item',
			'isActive' => 'Is Active',
			'created_date_time' => 'Created Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('part_number',$this->part_number,true);
		$criteria->compare('current_stock',$this->current_stock,true);
		$criteria->compare('stock_required',$this->stock_required,true);
		$criteria->compare('outbound_deliverynote',$this->outbound_deliverynote,true);
		$criteria->compare('outbound_item_id',$this->outbound_item_id);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('created_date_time',$this->created_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return NonstockItems the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
