<?php

/**
 * This is the model class for table "{{hscode_mapping}}".
 *
 * The followings are the available columns in table '{{hscode_mapping}}':
 * @property integer $part_no
 * @property integer $eu_hs_code
 * @property integer $eu_hs_8
 * @property integer $ae_hs_code
 */
class HSCode extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hscode_mapping}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('part_no, eu_hs_code, eu_hs_8, ae_hs_code', 'required'),
			array('part_no, eu_hs_code, eu_hs_8, ae_hs_code', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('part_no, eu_hs_code, eu_hs_8, ae_hs_code', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'part_no' => 'Part No',
			'eu_hs_code' => 'Eu Hs Code',
			'eu_hs_8' => 'Eu Hs 8',
			'ae_hs_code' => 'Ae Hs Code',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('part_no',$this->part_no);
		$criteria->compare('eu_hs_code',$this->eu_hs_code);
		$criteria->compare('eu_hs_8',$this->eu_hs_8);
		$criteria->compare('ae_hs_code',$this->ae_hs_code);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return HSCode the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
