<?php

class ReportsController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('inboundWR','outboundWR', 'downloadWR', 'customsIncoming', 'customsOutgoing', 'generateCustomsreport',
                                    'balanceQty', 'exportBalanceqty', 'viewBalanceqty', 'balanceview', 'closingStock', 'exportclosingstock', 
                                    'customsIncomingsummary', 'generateCustomssummaryreport','FreightReport','printfreightreport',
                                    'TransferHistory','exportTransferHistory'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array('accessControl'); // perform access control for CRUD operations
    }
    // public function beforeAction($action) {
        
    //    // code added Lidiya 18-09-2023
    //    $ModelShowExpiryModel= new ShowExpiryModel();
    //    $days=$ModelShowExpiryModel->ExpiryDateShow();
    //    if($days[0]<(-2)){
    //        throw new CHttpException(403, ' Reports Available Only After The Successful Payment');
    //        return false;
    //    } 
    //    else
    //        return true;
    //    //////////
    // }
    public function actioninboundWR(){
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.js' => false);
        $this->render('wr_modal', array( 'url' => 'reports/downloadWR&type=inbound' ));
    }
    
    public function actionoutboundWR(){
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.js' => false);
        $this->render('wr_modal', array( 'url' => 'reports/downloadWR&type=outbound' ));
    }

    public function actiondownloadWR(){
        
        $type = Yii::app()->request->getParam('type');
        $ta_number = Yii::app()->request->getParam('ta_number');
       
        $ta_numbers = explode(',',$ta_number);
        
        $filtered = array();
        foreach( $ta_numbers as $each)
             if((int) $each > 0 ) $filtered[] = $each ;
        
        $filename = ''.$type.'.xls';


        $data = '<html>
                    <head>
                        <style>
                            table{
                                width:100%;
                            }
                            .head{
                                background-color : yellow;
                                font-weight: bold;
                                font-size: 14px;
                            }
                            .total{
                                text-align: right;
                                font-weight: bold;
                                font-size: 14px;
                            }
                        </style>
                    </head>
                    <body>
                        <table border=1>
                            <thead>
                                <th class="head">HSC</th>
                                <th class="head">HSC (AE)</th>
                                <th class="head">Description (as per invoice)</th>
                                <th class="head">Qty</th>
                                <th class="head">Net Weight</th>
                                <th class="head">Gross weight</th>
                                <th class="head">Invoice Rate</th>
                                <th class="head">Country of Origin</th>
                                <th class="head">Part No</th>
                                <th class="head">Delivery Note</th>
                                <th class="head">TA No</th>
                                <th class="head">BOE</th>
                            </thead>
                            <tbody>';
        
        
        if( !empty($filtered)){
            $items = ( $type == 'inbound' ) ? new InboundItems : new OutboundItems ;
            $field = ( $type == 'inbound' ) ? 'inb_ta_number' : 'outb_ta_number' ;
            $result = $items->with('parent')->findAll( array( 'condition' => 'parent.'.$field.' IN ('.implode(',',$filtered).')') );
            if( !empty($result)){
                if( $type == 'inbound' ){
                    foreach( $result as $each ){
                        
                        $bill_of_e = ( $each->parent->inb_bill_of_entry_no == "" ) ? 'style = "background-color:red";' : "";
                        $hsc_eu = ( $each->hsc->eu_hs_code > 0  ) ?   "" : 'style = "background-color:red";';
                        $hsc_ae = ( $each->hsc->ae_hs_code > 0  ) ?   "" : 'style = "background-color:red";';
                        
                        $data .=    '<tr>
                                        <td '.$hsc_eu.' >'.$each->hsc->eu_hs_code.'</td>
                                        <td '.$hsc_ae.' >'.$each->hsc->ae_hs_code.'</td>
                                        <td>'.$each->inb_description.'</td>
                                        <td>'.$each->inb_quantity.'</td>
                                        <td>'.$each->inb_net_wt.'</td>
                                        <td>'.$each->inb_gross_wt.'</td>
                                        <td>'.$each->inb_invoice_rate.'</td>
                                        <td>'.$each->inb_contry_of_origin.'</td>
                                        <td>'.$each->inb_part_number.'</td>
                                        <td>'.$each->inb_delivery_note_no.'</td>
                                        <td>'.$each->parent->inb_ta_number.'</td>
                                        <td '.$bill_of_e.' >'.$each->parent->inb_bill_of_entry_no.'</td>
                                    </tr>';
                    }
                }else{
                    foreach( $result as $each ){

                        $bill_of_e = ( $each->parent->outb_bill_of_exit_no == "" ) ? 'style = "background-color:red";' : "";
                        $hsc_eu = ( $each->hsc->eu_hs_code > 0  ) ?   "" : 'style = "background-color:red";';
                        $hsc_ae = ( $each->hsc->ae_hs_code > 0  ) ?   "" : 'style = "background-color:red";';

                        $data .=    '<tr>
                                        <td '.$hsc_eu.' >'.$each->hsc->eu_hs_code.'</td>
                                        <td '.$hsc_ae.' >'.$each->hsc->ae_hs_code.'</td>
                                        <td>'.$each->outb_description.'</td>
                                        <td>'.$each->outb_quantity.'</td>
                                        <td>'.$each->outb_net_wt.'</td>
                                        <td>'.$each->outb_gross_wt.'</td>
                                        <td>'.$each->outb_invoice_rate.'</td>
                                        <td>'.$each->outb_contry_of_origin.'</td>
                                        <td>'.$each->outb_part_number.'</td>
                                        <td>'.$each->outb_delivery_note_no.'</td>
                                        <td>'.$each->parent->outb_ta_number.'</td>
                                        <td '.$bill_of_e.' >'.$each->parent->outb_bill_of_exit_no.'</td>
                                    </tr>';
                    } 
                }
            }
        }

        $data .= '      </tbody>
                    </table>
                </body>
            </html>';
        header ( "Content-type: application/vnd.ms-excel" );
        header ( "Content-Disposition: attachment; filename=\"".$filename."\"" );
        echo $data;
        Yii::app()->end();
        return;
    }

    public function actioncustomsIncoming(){
         $this->render('customs_filters', array( 'from' => 'incoming' ));
    }

    public function actioncustomsOutgoing(){
         $this->render('customs_filters', array( 'from' => 'outgoing' ));
    }
    
    
    public function actiongenerateCustomsreport(){
        
        $type = Yii::app()->request->getParam('type');
        
        $from_date = Yii::app()->request->getParam('from_date');
        $to_date = Yii::app()->request->getParam('to_date');
        $bill_of_entry = Yii::app()->request->getParam('bill_of_entry');
        $bill_from_date = Yii::app()->request->getParam('bill_from_date');
        $bill_to_date = Yii::app()->request->getParam('bill_to_date');

        $condition = ( $type == 'incoming' ) ? 'I.is_transfer_entry="N"' : '1=1';
        if( $from_date != ""){
            $field = ( $type == 'incoming' ) ? 'I.inb_added_date' : 'O.outb_added_date';
            $condition .= ' AND '.$field.' >= "'.date("Y-m-d", strtotime(str_replace('/', '-',trim($from_date)))).'"';
        }
        if( $to_date != "" ){
            $field = ( $type == 'incoming' ) ? 'I.inb_added_date' : 'O.outb_added_date';
            $condition .= ' AND '.$field.' <= "'.date("Y-m-d", strtotime(str_replace('/', '-',trim($to_date)))).'"';
        }
        if( $bill_of_entry != ""){
            $field = ( $type == 'incoming' ) ? 'I.inb_bill_of_entry_no' : 'O.outb_bill_of_exit_no';
            $condition .= ' AND '.$field.' = "'.trim($bill_of_entry).'"';
        }
        if( $bill_from_date != ""){
            $field = ( $type == 'incoming' ) ? 'I.inb_bill_of_entry_date' : 'O.outb_bill_of_exit_date';
            $condition .= ' AND '.$field.' >= "'.date("Y-m-d", strtotime(str_replace('/', '-',trim($bill_from_date)))).'"';
        }
        if( $bill_to_date != "" ){
             $field = ( $type == 'incoming' ) ? 'I.inb_bill_of_entry_date' : 'O.outb_bill_of_exit_date';
            $condition .= ' AND '.$field.' <= "'.date("Y-m-d", strtotime(str_replace('/', '-',trim($bill_to_date)))).'"';
        }
        
        $filename = $type.".xls";
        $file = fopen($filename, "w");

        fputcsv($file, explode('$','Date$BOE$Qty$Net Weight$Price'));
        $data = '<html>
                    <head>
                        <style>
                            table{
                                width:100%;
                            }
                            .head{
                                background-color : yellow;
                                font-weight: bold;
                                font-size: 14px;
                            }
                            .total{
                                text-align: right;
                                font-weight: bold;
                                font-size: 14px;
                            }
                        </style>
                    </head>
                    <body>
                        <table border=1>
                           
                            ';
        
        if( $type == 'incoming' ){
               /* $query = "SELECT 
                        I.inb_bill_of_entry_no AS boe,
                        GROUP_CONCAT(I.inb_delivery_note_no) AS invoices,
                        I.inb_bill_of_entry_date AS boe_date,
                        INB.inb_part_number AS part_number,
                        INB.inb_description AS description,
                        SUM(INB.inb_quantity) AS quantity,
                        SUM(INB.inb_gross_wt) as gross_wt,
                        SUM(INB.inb_net_wt) as net_wt,
                        SUM(INB.inb_invoice_rate) AS rate,
                        SUM(INB.inb_cbm) AS cbm,
                        INB.inb_hs_code AS hscode,
                        INB.inb_currency_code AS currency_code 
                    FROM nia_inbound_items AS INB INNER JOIN nia_inbound AS I ON INB.inb_delivery_note_no=I.inb_delivery_note_no 
                    WHERE ".$condition." AND I.inb_bill_of_entry_no != '' 
                    GROUP BY I.inb_bill_of_entry_no, INB.inb_part_number";*/
                    
                    $query="SELECT 
                    I.inb_bill_of_entry_no AS boe, 
                    GROUP_CONCAT(I.inb_delivery_note_no) AS invoices, 
                    I.inb_bill_of_entry_date AS boe_date, 
                    INB.inb_part_number AS part_number, 
                    INB.inb_description AS description, 
                    SUM(INB.inb_quantity) AS quantity, 
                    SUM(INB.inb_gross_wt) as gross_wt, 
                    SUM(INB.inb_net_wt) as net_wt, 
                    SUM(INB.inb_invoice_rate) AS rate, 
                    SUM(INB.inb_cbm) AS cbm, 
                    INB.inb_hs_code AS hscode, 
                    INB.inb_currency_code AS currency_code,
                    INB.inb_brand_name,inb_category_name,
                    SUM(inb_total_cif_value) AS cif_value,
                    INB.inb_contry_of_origin,
                    I.inb_grn_no,I.inb_frieght,
                    I.inb_frieght_currency,
                    I.inb_total_containers,
                    I.inb_container_type,
                    I.inb_department FROM nia_inbound_items AS INB 
                    INNER JOIN nia_inbound AS I ON INB.inb_delivery_note_no=I.inb_delivery_note_no 
                    WHERE ".$condition." AND I.inb_bill_of_entry_no != '' 
                    GROUP BY I.inb_bill_of_entry_no, INB.inb_part_number";
                    //echo $query;
                    //exit;
            
             $data.='<thead>
                                <th class="head">#</th>
                                <th class="head">Part Number</th>
                                <th class="head">Description</th>
                                <th class="head">Brand</th>
                                <th class="head">Category</th>
                                <th class="head">HSCode</th>
                                <th class="head">Country</th>
                                <th class="head">Invoice No</th>
                                <th class="head">GRN#</th>
                                <th class="head">Date</th>
                                <th class="head">BOE</th>
                                <th class="head">Qty</th>
                                <th class="head">Net Weight</th>
                                <th class="head">Gross Weight</th>
                                <th class="head">CBM</th>
                                <th class="head">Price</th>
                                <th class="head">Currency</th>
                                <th class="head">Total CIF Value</th>
                                <th class="head">Freight</th>
                                <th class="head">Freight Currency</th>
                                <th class="head">Total Containers</th>
                                <th class="head">Shipment Type</th>
                                <th class="head">Department</th>
                            </thead><tbody>';

        }else{
            $query = "SELECT 
                        O.outb_bill_of_exit_no AS boe,
                        GROUP_CONCAT(O.outb_delivery_note_no) AS invoices,
                        O.outb_bill_of_exit_date AS boe_date,
                        OI.outb_part_number AS part_number,
                        OI.outb_description AS description,
                        SUM(OI.outb_quantity) AS quantity,
                        SUM(OI.outb_gross_wt) as gross_wt,
                        SUM(OI.outb_net_wt) as net_wt,
                        SUM(OI.outb_invoice_rate) AS rate,
                        SUM(OI.outb_cbm) AS cbm,
                        OI.outb_hs_code AS hscode,
                        OI.outb_currency_code AS currency_code 
                    FROM nia_outbound_items AS OI INNER JOIN nia_outbound AS O ON OI.outb_delivery_note_no=O.outb_delivery_note_no 
                    WHERE ".$condition." AND O.outb_bill_of_exit_no != '' 
                    GROUP BY O.outb_bill_of_exit_no, OI.outb_part_number";
                    
                    $data.='<thead>
                                <th class="head">#</th>
                                <th class="head">Date</th>
                                <th class="head">BOE</th>
                                <th class="head">Part Number</th>
                                <th class="head">Description</th>
                                <th class="head">Qty</th>
                                <th class="head">Net Weight</th>
                                <th class="head">Gross Weight</th>
                                <th class="head">CBM</th>
                                <th class="head">Price</th>
                                <th class="head">Currency</th>
                                <th class="head">HSCode</th>
                                <th class="head">Invoice No</th>
                            </thead><tbody>';
                    
        }

        $result = Yii::app()->db->createCommand($query)->queryAll();
        
        foreach($result as $i=>$each){
            
            if( $type == 'incoming' ){

              $data .=     '<tr>
                                <td>'.($i+1). '</td>
                                <td>'.$each['part_number'].'</td>
                                <td>'.$each['description'].'</td>
                                <td>'.$each['inb_brand_name'].'</td>
                                <td>'.$each['inb_category_name'].'</td>
                                <td>'.$each['hscode'].'</td>
                                <td>'.$each['inb_contry_of_origin'].'</td>
                                <td>'.$each['invoices'].'</td>
                                <td>'.$each['inb_grn_no'].'</td>
                                <td>'.date('d/m/Y',strtotime($each['boe_date'])).'</td>
                                <td>'.$each['boe'].'</td>
                                <td>'.$each['quantity'].'</td>
                                <td>'.$each['net_wt'].'</td>
                                <td>'.$each['gross_wt'].'</td>
                                <td>'.$each['cbm'].'</td>
                                <td>'.$each['rate'].'</td>
                                <td>'.$each['currency_code'].'</td>
                                <td>'.$each['cif_value']. '</td>
                                <td>'.$each['inb_frieght']. '</td>
                                <td>'.$each['inb_frieght_currency']. '</td>
                                <td>'.$each['inb_total_containers'].'</td> 
                                <td>'.$each['inb_container_type'].'</td> 
                                <td>'.$each['inb_department'].'</td> 
                            </tr>';
            }
            else{
                  $data .=     '<tr>
                                <td>'.($i+1). '</td>
                                <td>'.date('d/m/Y',strtotime($each['boe_date'])).'</td>
                                <td>'.$each['boe'].'</td>
                                <td>'.$each['part_number'].'</td>
                                <td>'.$each['description'].'</td>
                                <td>'.$each['quantity'].'</td>
                                <td>'.$each['net_wt'].'</td>
                                <td>'.$each['gross_wt'].'</td>
                                <td>'.$each['cbm'].'</td>
                                <td>'.$each['rate'].'</td>
                                <td>'.$each['currency_code'].'</td>
                                <td>'.$each['hscode'].'</td>
                                <td>'.$each['invoices'].'</td>
                            </tr>';
            }
                            
                      
        }
        
        $data .= '      </tbody>
                    </table>
                </body>
            </html>';
        header ( "Content-type: application/vnd.ms-excel" );
        header ( "Content-Disposition: attachment; filename=\"".$filename."\"" );
        echo $data;
        Yii::app()->end();
        return;
    }

   /* public function actiongenerateCustomsreport(){
        
        $type = Yii::app()->request->getParam('type');
        
        $from_date = Yii::app()->request->getParam('from_date');
        $to_date = Yii::app()->request->getParam('to_date');
        $bill_of_entry = Yii::app()->request->getParam('bill_of_entry');
        $bill_from_date = Yii::app()->request->getParam('bill_from_date');
        $bill_to_date = Yii::app()->request->getParam('bill_to_date');

        $condition = ( $type == 'incoming' ) ? 'I.is_transfer_entry="N"' : '1=1';
        if( $from_date != ""){
            $field = ( $type == 'incoming' ) ? 'I.inb_added_date' : 'O.outb_added_date';
            $condition .= ' AND '.$field.' >= "'.date("Y-m-d", strtotime(str_replace('/', '-',trim($from_date)))).'"';
        }
        if( $to_date != "" ){
            $field = ( $type == 'incoming' ) ? 'I.inb_added_date' : 'O.outb_added_date';
            $condition .= ' AND '.$field.' <= "'.date("Y-m-d", strtotime(str_replace('/', '-',trim($to_date)))).'"';
        }
        if( $bill_of_entry != ""){
            $field = ( $type == 'incoming' ) ? 'I.inb_bill_of_entry_no' : 'O.outb_bill_of_exit_no';
            $condition .= ' AND '.$field.' = "'.trim($bill_of_entry).'"';
        }
        if( $bill_from_date != ""){
            $field = ( $type == 'incoming' ) ? 'I.inb_bill_of_entry_date' : 'O.outb_bill_of_exit_date';
            $condition .= ' AND '.$field.' >= "'.date("Y-m-d", strtotime(str_replace('/', '-',trim($bill_from_date)))).'"';
        }
        if( $bill_to_date != "" ){
             $field = ( $type == 'incoming' ) ? 'I.inb_bill_of_entry_date' : 'O.outb_bill_of_exit_date';
            $condition .= ' AND '.$field.' <= "'.date("Y-m-d", strtotime(str_replace('/', '-',trim($bill_to_date)))).'"';
        }
        
        $filename = $type.".xls";
        $file = fopen($filename, "w");

        fputcsv($file, explode('$','Date$BOE$Qty$Net Weight$Price'));
        $data = '<html>
                    <head>
                        <style>
                            table{
                                width:100%;
                            }
                            .head{
                                background-color : yellow;
                                font-weight: bold;
                                font-size: 14px;
                            }
                            .total{
                                text-align: right;
                                font-weight: bold;
                                font-size: 14px;
                            }
                        </style>
                    </head>
                    <body>
                        <table border=1>
                            <thead>
                                <th class="head">Date</th>
                                <th class="head">BOE</th>
                                <th class="head">Part Number</th>
                                <th class="head">Description</th>
                                <th class="head">Qty</th>
                                <th class="head">Net Weight</th>
                                <th class="head">Gross Weight</th>
                                <th class="head">CBM</th>
                                <th class="head">Price</th>
                                <th class="head">Currency</th>
                                <th class="head">HSCode</th>
                                <th class="head">Invoice No</th>
                            </thead>
                            <tbody>';
        
        if( $type == 'incoming' ){
            
            $query = "SELECT 
                        I.inb_bill_of_entry_no AS boe,
                        GROUP_CONCAT(I.inb_delivery_note_no) AS invoices,
                        I.inb_bill_of_entry_date AS boe_date,
                        INB.inb_part_number AS part_number,
                        INB.inb_description AS description,
                        SUM(INB.inb_quantity) AS quantity,
                        SUM(INB.inb_gross_wt) as gross_wt,
                        SUM(INB.inb_net_wt) as net_wt,
                        SUM(INB.inb_invoice_rate) AS rate,
                        SUM(INB.inb_cbm) AS cbm,
                        INB.inb_hs_code AS hscode,
                        INB.inb_currency_code AS currency_code 
                    FROM nia_inbound_items AS INB INNER JOIN nia_inbound AS I ON INB.inb_delivery_note_no=I.inb_delivery_note_no 
                    WHERE ".$condition." AND I.inb_bill_of_entry_no != '' 
                    GROUP BY I.inb_bill_of_entry_no, INB.inb_part_number";

        }else{
            $query = "SELECT 
                        O.outb_bill_of_exit_no AS boe,
                        GROUP_CONCAT(O.outb_delivery_note_no) AS invoices,
                        O.outb_bill_of_exit_date AS boe_date,
                        OI.outb_part_number AS part_number,
                        OI.outb_description AS description,
                        SUM(OI.outb_quantity) AS quantity,
                        SUM(OI.outb_gross_wt) as gross_wt,
                        SUM(OI.outb_net_wt) as net_wt,
                        SUM(OI.outb_invoice_rate) AS rate,
                        SUM(OI.outb_cbm) AS cbm,
                        OI.outb_hs_code AS hscode,
                        OI.outb_currency_code AS currency_code 
                    FROM nia_outbound_items AS OI INNER JOIN nia_outbound AS O ON OI.outb_delivery_note_no=O.outb_delivery_note_no 
                    WHERE ".$condition." AND O.outb_bill_of_exit_no != '' 
                    GROUP BY O.outb_bill_of_exit_no, OI.outb_part_number";
        }

        $result = Yii::app()->db->createCommand($query)->queryAll();
        
        foreach($result as $each){

              $data .=     '<tr>
                                <td>'.date('d/m/Y',strtotime($each['boe_date'])).'</td>
                                <td>'.$each['boe'].'</td>
                                <td>'.$each['part_number'].'</td>
                                <td>'.$each['description'].'</td>
                                <td>'.$each['quantity'].'</td>
                                <td>'.$each['net_wt'].'</td>
                                <td>'.$each['gross_wt'].'</td>
                                <td>'.$each['cbm'].'</td>
                                <td>'.$each['rate'].'</td>
                                <td>'.$each['currency_code'].'</td>
                                <td>'.$each['hscode'].'</td>
                                <td>'.$each['invoices'].'</td>
                            </tr>';

        }
        
        $data .= '      </tbody>
                    </table>
                </body>
            </html>';
        header ( "Content-type: application/vnd.ms-excel" );
        header ( "Content-Disposition: attachment; filename=\"".$filename."\"" );
        echo $data;
        Yii::app()->end();
        return;
    }*/

    public function actionbalanceQty(){
        $this->render('balance_qty_filters');
    }

    public function actionexportBalanceqty(){
        $part_number = trim(Yii::app()->request->getParam('part_number'));
        $boe = trim(Yii::app()->request->getParam('boe'));
        $warehouse = (int) Yii::app()->request->getParam('warehouse');

        $condition = '1=1';
        if( $part_number != "")
            $condition .= ' AND CS.part_number = "'.$part_number.'" ';
        if( trim($boe) != "" )
            $condition .= ' AND CS.bill_of_entry = "'.$boe.'" ';
        if( $warehouse > 0 )
            $condition .= ' AND CS.warehouse = "'.$warehouse.'" ';

        $query =    "SELECT * FROM ( SELECT SUM(CS.quantity) AS balance,
                        CS.part_number,
                        CS.description,
                        CS.bill_of_entry,
                        GROUP_CONCAT(deliverynote) AS invoices,
                        ( CS.net_wt * quantity ) AS net_wt,
                        ( CS.gross_wt * quantity ) AS gross_wt,
                        ( CS.cbm * quantity ) AS cbm,
                        WH.name AS warehouse
                    FROM nia_current_stock CS LEFT JOIN nia_warehouses WH ON WH.id = CS.warehouse WHERE ".$condition." GROUP BY CS.id, CS.bill_of_entry, CS.warehouse ) AS A WHERE A.balance > 0 ";

        $items = Yii::app()->db->createCommand($query)->queryAll();
        
        $filename = "balance_".date('d-m-Y').".xls";
        $data = '<html>
                    <head>
                        <style>
                            table{
                                width:100%;
                            }
                            .head{
                                background-color : yellow;
                                font-weight: bold;
                                font-size: 14px;
                            }
                            .total{
                                text-align: right;
                                font-weight: bold;
                                font-size: 14px;
                            }
                        </style>
                    </head>
                    <body>
                        <table border=1>
                            <thead>
                                <th class="head">Part No</th>
                                <th class="head">Description</th>
                                <th class="head">BOE</th>
                                <th class="head">Invoice No</th>
                                <th class="head">Warehouse</th>
                                <th class="head">Net Wt</th>
                                <th class="head">Gross Wt</th>
                                <th class="head">Cbm</th>
                                <th class="head">Balance</th>
                            </thead>
                            <tbody>';

        foreach ( $items as $each ){

              $data .=     '<tr>
                                <td>'.$each['part_number'].'</td>
                                <td>'.$each['description'].'</td>
                                <td>'.$each['bill_of_entry'].'</td>
                                <td>'.$each['invoices'].'</td>
                                <td>'.$each['warehouse'].'</td>
                                <td>'.$each['net_wt'].'</td>
                                <td>'.$each['gross_wt'].'</td>
                                <td>'.$each['cbm'].'</td>
                                <td>'.$each['balance'].'</td>
                            </tr>';
        }
        $data .= '      </tbody>
                    </table>
                </body>
            </html>';

        header ( "Content-type: application/vnd.ms-excel" );
        header ( "Content-Disposition: attachment; filename=\"".$filename."\"" );
        echo $data;
        Yii::app()->end();
        return;
    }

    public function actionviewBalanceqty(){
        
        $part_number = trim($_POST['part_number']);

        $condition = '1=1';
        if( $part_number != "")
            $condition .= ' AND part_number = "'.$part_number.'" ';

        $query =    "SELECT SUM(quantity) AS balance,
                        part_number,
                        description 
                    FROM nia_current_stock WHERE ".$condition." GROUP BY part_number";

        $items = Yii::app()->db->createCommand($query)->queryAll();
            
            $data .= '<thead><tr>';
                $data .= '<th>Part Number</th>';
                $data .= '<th>Description</th>';
                $data .= '<th>Balance Qty</th>';
                $data .= '<th><i class="fa fa-eye"></i></th>';
            $data .= '</tr></thead>';
        
            foreach ( $items as $each ){    
                $data .= '<tbody><tr>';
                $data .= '<td>'.$each['part_number'].'</td>';
                $data .= '<td>'.$each['description'].'</td>';
                $data .= '<td>'.$each['balance'].'</td>';
                $data .= '<td><button class="btn btn-primary btn-xs" title="Balance details" onclick="loadPopupModal(\'reports/balanceview&part_number='.$each['part_number'].'\',\''.$each['part_number'].'\',\'lg\')"><i class="fa fa-eye"></i></button></td>';
                $data .= '</tr></tbody>';
            }
            
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.js' => false);
            $this->renderPartial('table',array( 'data' => $data));
    }

     public function actionbalanceview(){
         $part_number = Yii::app()->request->getParam('part_number');
            $data .= '<thead><tr>';
                $data .= '<th>DN</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>BOE</th>';
                $data .= '<th>BOE Date</th>';
                $data .= '<th>HSC</th>';
                $data .= '<th>Qty</th>';
                $data .= '<th>Wt</th>';
            $data .= '</tr></thead>';
         if( $part_number != "" ){
            $items = Stock::model()->findAll(array( 'condition' => 'quantity > 0 AND part_number = "'.trim($part_number).'" '));
            if( !empty($items) ){
                foreach ( $items as $each ){
                    $data .= '<tbody><tr>';
                        $data .= '<td>'.$each->deliverynote.'</td>';
                        $data .= '<td>'.date('d/m/Y',strtotime($each->inboundRelation->inb_added_date)).'</td>';
                        $data .= '<td>'.$each->bill_of_entry.'</td>';
                        $data .= '<td>'.date('d/m/Y',strtotime($each->bill_of_entry_date)).'</td>';
                        $data .= '<td>'.$each->inboundRelation->inb_hs_code.'</td>';
                        $data .= '<td>'.$each->quantity.'</td>';
                        $data .= '<td>'.($each->quantity*$each->gross_wt).'</td>';
                    $data .= '</tr></tbody>';
                }
            }else{
                $data .= '<tr><td colspan="7" class="text-center">No Data</td></tr>';
            }   
         }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.js' => false);
        $this->renderPartial('table',array( 'data' => $data));
    }

    public function actionclosingStock(){
        $this->render('closing_stock_filters');
    }

    public function actionexportclosingstock(){
        
        $part_number = trim(Yii::app()->request->getParam('part_number'));
        $date_to = trim(Yii::app()->request->getParam('date_to'));
        $warehouse = (int) Yii::app()->request->getParam('warehouse');

        $condition = '1=1';
        if( $part_number != '')
            $condition .= ' AND nia_inbound_items.inb_part_number = "'. $part_number .'" ';
        if( $date_to != '')
            $condition .= ' AND shipment_date <= "'. date("Y-m-d", strtotime(str_replace('/', '-',trim($date_to)))) .'" ';
        if( $warehouse > 0 )
            $condition .= ' AND nia_ledger.warehouse_id = "'. $warehouse .'" ';

        $query = 'SELECT 
                    SUM(nia_ledger.in_quantity) - SUM(nia_ledger.out_quantity) AS balance,
                    nia_ledger.stock_id AS stock_id,
                    nia_current_stock.cost_rate AS cost_rate,
                    nia_current_stock.bill_of_entry_date AS bill_of_entry_date,
                    nia_current_stock.bill_of_entry AS bill_of_entry,
                    nia_current_stock.deliverynote AS deliverynote,
                    nia_current_stock.part_number AS part_number,
                    nia_current_stock.description AS description,
                    nia_inbound_items.inb_currency_code AS currency,
                    nia_hscode_mapping.ae_hs_code AS hs_code,
                    nia_current_stock.gross_wt AS gross_wt,
                    nia_current_stock.net_wt AS net_wt,
                    nia_current_stock.cbm AS cbm,
                    nia_warehouses.name AS warehouse
                    FROM nia_ledger LEFT JOIN nia_current_stock ON nia_ledger.stock_id = nia_current_stock.id 
                    LEFT JOIN nia_inbound_items ON nia_current_stock.deliverynote_item_id = nia_inbound_items.id
                    LEFT JOIN nia_hscode_mapping ON nia_current_stock.part_number = nia_hscode_mapping.part_no
                    LEFT JOIN nia_warehouses ON nia_warehouses.id = nia_ledger.warehouse_id
                    WHERE '.$condition.' GROUP BY nia_ledger.stock_id, nia_ledger.warehouse_id, nia_current_stock.bill_of_entry';
        
        $items = Yii::app()->db->createCommand($query)->queryAll();

        $end_date = ( $date_to != '') ? date("Y-m-d", strtotime(str_replace('/', '-',trim($date_to))))  : date('Y-m-d');

        $filename = "closing_stock_".$end_date.".xls";
       
        $data = '<html>
                    <head>
                        <style>
                            table{
                                width:100%;
                            }
                            .head{
                                background-color : yellow;
                                font-weight: bold;
                                font-size: 14px;
                            }
                            .total{
                                text-align: right;
                                font-weight: bold;
                                font-size: 14px;
                            }
                        </style>
                    </head>
                    <body>
                        <table border=1>
                            <thead>
                                <th class="head">Date</th>
                                <th class="head">Warehouse</th>
                                <th class="head">Bill of Entry</th>
                                <th class="head">Delivery Note</th>
                                <th class="head">HS Code</th>
                                <th class="head">Part No</th>
                                <th class="head">Description</th>
                                <th class="head">Qty</th>
                                <th class="head">Net wt</th>
                                <th class="head">Gross wt</th>
                                <th class="head">Cbm</th>
                                <th class="head">Value</th>
                                <th class="head">Currency</th>
                                <th class="head">Aging</th>
                            </thead>
                            <tbody>';
        $total = 0;
        foreach ( $items as $each ){

            $start_date = $each['bill_of_entry_date'];

            $aging = round( ( strtotime($end_date) - strtotime($start_date) ) / 86400);
            
            if( $each['balance'] > 0 ){
                        
                $gross_wt  = ($each['balance'] * $each['gross_wt']);
                $net_wt  = ($each['balance'] * $each['net_wt']);
                $cbm =  ($each['balance'] * $each['cbm']);

                $value = ($each['balance'] * $each['cost_rate']);
                
                $data .=    '<tr>
                                        <td>'.$each['bill_of_entry_date'].'</td>
                                        <td>'.$each['warehouse'].'</td>
                                        <td>'.$each['bill_of_entry'].'</td>
                                        <td>'.$each['deliverynote'].'</td>
                                        <td>'.$each['hs_code'].'</td>
                                        <td>'.$each['part_number'].'</td>
                                        <td>'.$each['description'].'</td>
                                        <td>'.$each['balance'].'</td>
                                        <td>'.$net_wt.'</td>
                                        <td>'.$gross_wt.'</td>
                                        <td>'.$cbm.'</td>
                                        <td>'.$value.'</td>
                                        <td>'.$each['currency'].'</td>
                                        <td>'. $aging.'</td>
                                    </tr>';

                                    $total += $value;
            }

                                  
        }
       // $data .= '<tr><td style="background-color : gray;" colspan="11" class="total">Total</td><td style="background-color : gray;">'.$total.'</td><td style="background-color : gray;"></td><td style="background-color : gray;"></td></tr>';
        $data .= '      </tbody>
                    </table>
                </body>
            </html>';
        header ( "Content-type: application/vnd.ms-excel" );
        header ( "Content-Disposition: attachment; filename=\"".$filename."\"" );
        echo $data;
        Yii::app()->end();
        return;
    }



    public function actioncustomsIncomingsummary(){
        $this->render('customs_summary_filters');
    }

    public function actiongenerateCustomssummaryreport(){
        
        $bill_of_entry = Yii::app()->request->getParam('bill_of_entry');
        $bill_from_date = Yii::app()->request->getParam('bill_from_date');
        $bill_to_date = Yii::app()->request->getParam('bill_to_date');

        $condition = 'L.type="IN"';
        if( $bill_of_entry != "")
            $condition .= ' AND I.inb_bill_of_entry_no = "'.trim($bill_of_entry).'"';
        if( $bill_from_date != "")
            $condition .= ' AND I.inb_bill_of_entry_date >= "'.date("Y-m-d", strtotime(str_replace('/', '-',trim($bill_from_date)))).'"';
        if( $bill_to_date != "" )
            $condition .= ' AND I.inb_bill_of_entry_date <= "'.date("Y-m-d", strtotime(str_replace('/', '-',trim($bill_to_date)))).'"';
        
        $query =    'SELECT 
                        GROUP_CONCAT(L.stock_id) AS inbound_item_ids,
                        L.part_number AS part_number,
                        L.description AS description,
                        GROUP_CONCAT(L.delivery_note) AS invoice_no,
                        SUM(L.in_quantity) - ( SELECT IFNULL(SUM(quantity),"0") AS value FROM nia_warehouse_transfer_history WHERE from_stock_id = L.stock_id ) AS inbound_qty,
                        SUM(L.in_gross_wt) - ( SELECT IFNULL(SUM(gross_wt),"0") AS value FROM nia_warehouse_transfer_history WHERE from_stock_id = L.stock_id ) AS inbound_gross_wt,
                        SUM(L.in_net_wt) - ( SELECT IFNULL(SUM(net_wt),"0") AS value FROM nia_warehouse_transfer_history WHERE from_stock_id = L.stock_id ) AS inbound_net_wt,
                        SUM(L.in_cbm) - ( SELECT IFNULL(SUM(cbm),"0") AS value FROM nia_warehouse_transfer_history WHERE from_stock_id = L.stock_id ) AS inbound_cbm,
                        SUM(L.in_invoice_rate) - ( SELECT SUM(value) AS value FROM nia_warehouse_transfer_history WHERE from_stock_id = L.stock_id ) AS invoice_rate,
                        GROUP_CONCAT(II.inb_hs_code  SEPARATOR "-") AS hscodes,
                        II.inb_currency_code AS currency,
                        I.inb_bill_of_entry_no AS boe,
                        I.inb_bill_of_entry_date AS boe_date
                    FROM nia_ledger L LEFT JOIN nia_inbound_items II ON L.master_id = II.id
                    LEFT JOIN nia_inbound I ON I.inb_delivery_note_no =II.inb_delivery_note_no
                    WHERE '.$condition.' GROUP BY L.shipment_reference, L.part_number
                    ';
        $items = Yii::app()->db->createCommand($query)->queryAll();
        $filename = "customs_incoming_summary.xls";

        $data = '<html>
                    <head>
                        <style>
                            table{
                                width:100%;
                            }
                            .head{
                                background-color : yellow;
                                font-weight: bold;
                                font-size: 14px;
                            }
                            .total{
                                text-align: right;
                                font-weight: bold;
                                font-size: 14px;
                            }
                            .in{
                                background-color: #d5d5d5;
                            }
                            .out{
                                background-color: #f5f4f5;
                            }
                            .footer{
                                text-align: right;
                                font-weight: bold;
                                font-size: 14px;
                                background-color: #a5b997 ;
                            }
                        </style>
                    </head>
                    <body>
                        <table border=1>
                            <thead>
                                <th class="head">Entry Date</th>
                                <th class="head">Bill of Entry</th>
                                <th class="head">Invoice No</th>
                                <th class="head">Part No</th>
                                <th class="head">Description</th>
                                <th class="head">Quantity</th>
                                <th class="head">Net Wt</th>
                                <th class="head">Gross Wt</th>
                                <th class="head">Cbm</th>
                                <th class="head">Price</th>
                                <th class="head">Currency</th>
                                <th class="head">Hscodes</th>
                                <th class="head">Exit date</th>
                                <th class="head">Bill of exit</th>
                                <th class="head">Invoice No</th>
                                <th class="head">Part No</th>
                                <th class="head">Description</th>
                                <th class="head">Quantity</th>
                                <th class="head">Net Wt</th>
                                <th class="head">Gross Wt</th>
                                <th class="head">Cbm</th>
                                <th class="head">Value</th>
                                <th class="head">Currency</th>
                                <th class="head">Hscodes</th>
                            </thead>
                            <tbody>';

        foreach ( $items as $each ){
                
                 $data .=   '<tr>
                                <td class="in">'.$each['boe_date'].'</td>
                                <td class="in">'.$each['boe'].'</td>
                                <td class="in">'.$each['invoice_no'].'</td>
                                <td class="in">'.$each['part_number'].'</td>
                                <td class="in">'.$each['description'].'</td>
                                <td class="in">'.$each['inbound_qty'].'</td>
                                <td class="in">'.$each['inbound_net_wt'].'</td>
                                <td class="in">'.$each['inbound_gross_wt'].'</td>
                                <td class="in">'.$each['inbound_cbm'].'</td>
                                <td class="in">'.$each['invoice_rate'].'</td>
                                <td class="in">'.$each['currency'].'</td>
                                <td class="in">'.$each['hscodes'].'</td>
                                <td class="in"></td><td class="in"></td><td class="in"></td><td class="in"></td><td class="in"></td><td class="in"></td>
                                <td class="in"></td><td class="in"></td><td class="in"></td><td class="in"></td><td class="in"></td><td class="in"></td>
                            </tr>';
                
                if( !empty($each['inbound_item_ids']) ){
                    
                    $filtered = array();
                    
                    $ids = explode(',',$each['inbound_item_ids']);
                    foreach ( $ids as $eachid) :
                        if( $eachid > 0 )
                            $filtered[] = $eachid;
                    endforeach;
                    
                    $query_connected = 'SELECT 
                                        L.shipment_reference AS boe,
                                        GROUP_CONCAT(L.delivery_note) AS invoice_no,
                                        L.part_number AS part_number,
                                        L.description AS description,
                                        L.shipment_date AS boe_date,
                                        SUM(L.out_quantity) AS quantity,
                                        SUM(L.out_net_wt) AS net_wt,
                                        SUM(L.out_gross_wt) AS gross_wt,
                                        SUM(L.out_cbm) AS cbm,
                                        SUM(L.out_invoice_rate) AS invoice_rate,
                                        O.outb_currency_code AS currency,
                                        O.outb_hs_code  AS hscodes
                                        FROM nia_ledger L
                                        LEFT JOIN nia_outbound_items O ON L.master_id = O.id
                                        WHERE L.stock_id IN ('.implode(',',$filtered).') AND L.type= "OUT"
                                        GROUP BY L.shipment_reference, L.part_number
                                        ';

                    $connected_data = Yii::app()->db->createCommand($query_connected)->queryAll();

                    $outQty = 0;
                    $netWt = 0;
                    $grossWt = 0;
                    $total_cbm = 0;
                    $total_price = 0;
                    foreach ( $connected_data as $eachOut ){
                        
                $data .=   '<tr>
                                <td class="out"></td><td class="out"></td><td class="out"></td><td class="out"></td><td class="out"></td><td class="out"></td>
                                <td class="out"></td><td class="out"></td><td class="out"></td><td class="out"></td><td class="out"></td><td class="out"></td>
                                <td class="out">'.$eachOut['boe_date'].'</td>
                                <td class="out">'.$eachOut['boe'].'</td>
                                <td class="out">'.$eachOut['invoice_no'].'</td>
                                <td class="out">'.$eachOut['part_number'].'</td>
                                <td class="out">'.$eachOut['description'].'</td>
                                <td class="out">'.$eachOut['quantity'].'</td>
                                <td class="out">'.$eachOut['net_wt'].'</td>
                                <td class="out">'.$eachOut['gross_wt'].'</td>
                                <td class="out">'.$eachOut['cbm'].'</td>
                                <td class="out">'.$eachOut['invoice_rate'].'</td>
                                <td class="out">'.$eachOut['currency'].'</td>
                                <td class="out">'.$eachOut['hscodes'].'</td>
                            </tr>';
                            
                        $outQty += $eachOut['quantity'];
                        $netWt += $eachOut['net_wt'];
                        $grossWt += $eachOut['gross_wt'];
                        $total_cbm += $eachOut['cbm'];
                        $total_price += $eachOut['invoice_rate'];
                    }
                    $data .=   '<tr><td class="footer"></td><td class="footer"></td><td class="footer"></td><td class="footer"></td><td class="footer"></td><td class="footer"></td><td class="footer"></td><td class="footer"></td><td class="footer"></td><td class="footer"></td><td class="footer"></td><td class="footer"></td><td class="footer"></td><td class="footer"></td><td class="footer"></td><td class="footer"></td><td class="footer">Total</td><td class="footer">'.$outQty.'</td><td class="footer">'.$netWt.'</td><td class="footer">'.$grossWt.'</td><td class="footer">'.$total_cbm.'</td><td class="footer">'/*.$total_price*/.'</td><td class="footer"></td><td class="footer"></td></tr>';
                     $data .=   '<tr><td class="footer"></td><td class="footer"></td><td class="footer"></td><td class="footer"></td><td class="footer"></td><td class="footer"></td><td class="footer"></td><td class="footer"></td><td class="footer"></td><td class="footer"></td><td class="footer"></td><td class="footer"></td><td class="footer"></td><td class="footer"></td><td class="footer"></td><td class="footer"></td><td class="footer">Balance</td><td class="footer">'.($each['inbound_qty'] - $outQty).'</td><td class="footer">'.($each['inbound_net_wt'] - $netWt).'</td><td class="footer">'.($each['inbound_gross_wt'] - $grossWt).'</td><td class="footer">'.($each['inbound_cbm'] - $total_cbm).'</td><td class="footer">'./*($each['invoice_rate'] - $total_price).*/'</td><td class="footer"></td><td class="footer"></td></tr>';
                }
        }
        
        $data .= '      </tbody>
                    </table>
                </body>
            </html>';
        header ( "Content-type: application/vnd.ms-excel" );
        header ( "Content-Disposition: attachment; filename=\"".$filename."\"" );
        echo $data;
        Yii::app()->end();
        return;
    }

    // Added by Smrithy
    public function actionFreightReport(){
        $this->render('frieght_filters');
   }
   public function actionprintfreightreport()
   {
       $bill_of_entry_date = $_GET['bill_of_entry_date'];
       $boe_no = $_GET['boe_no'];
       $inb_container_type = $_GET['inb_container_type'];
       $pol_details = $_GET['pol_details'];
       $pod_details = $_GET['pod_details'];
       $inb_department = $_GET['inb_department'];

       $filename = 'Freight Report.xls';

     header("Content-type: application/vnd.ms-excel");

     header("Content-Disposition: attachment; filename=\"" . $filename . "\"");

     $this->renderPartial('application.views.front.reports.freight_excel_report',array('bill_of_entry_date' => $bill_of_entry_date, 'boe_no' => $boe_no, 'inb_container_type' => $inb_container_type, 'pol_details' => $pol_details, 
     'pod_details' => $pod_details,'inb_department' => $inb_department), false, true);

     Yii::app()->end();
   }
   // Added by Smrithy

   
   public function actionTransferHistory(){
    $this->render('filter_transfer_history');
}
public function actionexportTransferHistory(){
    $part_number = trim(Yii::app()->request->getParam('part_number'));
     
    $condition = '1=1';
    if( $part_number != "")
        $condition .= ' AND t.part_number = "'.$part_number.'" ';
    
    // $query =    "SELECT * FROM ( SELECT SUM(CS.quantity) AS balance,
    //                 CS.part_number,
    //                 CS.description,
    //                 CS.bill_of_entry,
    //                 GROUP_CONCAT(deliverynote) AS invoices,
    //                 ( CS.net_wt * quantity ) AS net_wt,
    //                 ( CS.gross_wt * quantity ) AS gross_wt,
    //                 ( CS.cbm * quantity ) AS cbm,
    //                 WH.name AS warehouse
    //             FROM nia_current_stock CS LEFT JOIN nia_warehouses WH ON WH.id = CS.warehouse WHERE ".$condition." GROUP BY CS.id, CS.bill_of_entry, CS.warehouse ) AS A WHERE A.balance > 0 ";

    // $items = Yii::app()->db->createCommand($query)->queryAll();
    $items = WarehouseTransferHistory::model()->findAll(array('condition'=>$condition));
    $filename = "warehouse_transfer_history_".date('d-m-Y').".xls";
    $data = '<html>
                <head>
                    <style>
                        table{
                            width:100%;
                        }
                        .head{
                            background-color : yellow;
                            font-weight: bold;
                            font-size: 14px;
                        }
                        .total{
                            text-align: right;
                            font-weight: bold;
                            font-size: 14px;
                        }
                    </style>
                </head>
                <body>
                    <table border=1>
                        <thead>
                            <th class="head">#</th>
                            <th class="head">Date</th>
                            <th class="head">BOE</th>
                            <th class="head">Part No</th>
                            <th class="head">Description</th>
                            <th class="head">REF#</th>
                            <th class="head">From WareHouse</th>
                            <th class="head">To WareHouse</th>
                            <th class="head">Quantity</th>
                            <th class="head">Net Wt</th>
                            <th class="head">Gross Wt</th>
                            <th class="head">Cbm</th>
                            <th class="head">Value</th>
                            
                        </thead>
                        <tbody>';
                        $m=1;
    foreach ( $items as $each ){

          $data .=     '<tr>
                            <td>'.$each['id'].'</td>
                            <td>'.date('d/m/Y', strtotime($each['created_datetime'])).'</td>
                            <td>'.$each['bill_of_entry'].'</td>
                            <td>'.$each['part_number'].'</td>
                            <td>'.$each['description'].'</td>
                            <td>'.$each->inboundRelation->inb_delivery_note_no.'</td>
                            <td>'.$each->fromwarehouseDetails->name.'</td>
                            <td>'.$each->towarehouseDetails->name.'</td>
                            <td>'.$each['quantity'].'</td>
                            <td>'.$each['net_wt'].'</td>
                            <td>'.$each['gross_wt'].'</td>
                            <td>'.$each['cbm'].'</td>
                            <td>'.$each['value'].'</td>
                            
                             
                        </tr>';
    }
    $data .= '      </tbody>
                </table>
            </body>
        </html>';

    header ( "Content-type: application/vnd.ms-excel" );
    header ( "Content-Disposition: attachment; filename=\"".$filename."\"" );
    echo $data;
    Yii::app()->end();
    return;
}


}