
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("changeDelivery", "function changeDelivery(type){
    jQuery.ajax({
        'dataType' : 'json',
        'data' :{'type':type},
        'type':'post',
        'url': '" . Yii::app()->createUrl('transfer/getDeliverylist') . "',
        'success': function(data) {
            $('#delivery_li').html(data.delivery_drops);
            $('#deliverynotes_tree').jstree('destroy');
        }
    });
}", CClientScript::POS_HEAD);
$cs->registerScript("buildTree", "function buildTree(){
    var deliveryNotes = $('#Transfers_delivery_notes').val();
    $('#deliverynotes_tree').jstree('destroy');
    $('#deliverynotes_tree').jstree({
        'core' : {
            'data' : {
                'url' : 'index.php?r=transfer/preview&data='+deliveryNotes,
                'dataType' : 'json' // needed only if you do not supply JSON headers
            },
            'themes' : {
                'variant' : 'large'
              }
        }
    });
}", CClientScript::POS_HEAD);


$form = $this->beginWidget('CActiveForm', array(
            'id' => 'bill-form',
            'enableAjaxValidation' => false,
            'enableClientValidation' => false,
        ));
$model = new Transfers;
?>

<!-- <script>
 $(document).ready(function(){
    $('#deliverynotes_tree').on("changed.jstree", function (e, data) {
        console.log(data.selected);
        alert(1);
    });
});
</script> -->

<div class="tab-content">
    <div class="tab-pane active" id="tab1">
        <ul class="clearfix form-ul material">
            <li class="col-sm-3">
                <?php echo $form->dropdownlist($model,'isInernal', array('N' => 'No', 'Y' => 'Yes'),array('data-label'=> 'Internal Transfer?', 'onChange' => 'changeDelivery(this.value)')); ?>
            </li>
            <li class="col-sm-3">
                <?php echo $form->textField($model,'bill_of_exit',array('data-label'=>'Customer Reference' )); ?>
            </li>
            <li class="col-sm-6" id="delivery_li">
                <?php echo $form->dropdownlist($model,'delivery_notes', Outbound::getDeliverylist('third_party') ,array('data-label'=>'Delivery Notes', 'multiple' => true, 'onchange' => 'buildTree();')); ?>
            </li>
            <li class="col-sm-6">
                <div  id="deliverynotes_tree"></div>
            </li>
            <li class="col-sm-6">
                <div  id="stock_availability"></div>
            </li>
        </ul>
    </div>
</div>

<div class="modal-footer">
    <button type="button" class="btn btn-default "  data-dismiss="modal">Close</button>
    <?php
            $url = Yii::app()->createUrl('transfer/save');
            echo CHtml::ajaxSubmitButton('Save', $url, array(
                    'dataType' => 'json',
                    'type' => 'post',
                    'success' => 'function(data) {
                                    $("#loader").hide();
                                    if(data.status=="success"){  
                                         t8.success("Done!");
                                         $(".x.close").click();
                                         reloadTable("#tb_transfer_details");
                                         if( data.postFlag == "true" ){
                                            xhr = new XMLHttpRequest();
                                            var params = "post_data="+JSON.stringify(data.postData);
                                            xhr.open("POST", "https://blueskylogistics.me/flair/index.php?r=inbound/receiver")
                                            xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
                                            xhr.onreadystatechange = function () {
                                                if (xhr.readyState == 4 && xhr.status == 200) {
                                                    t8.success("Items transfered to Flair!");
                                                }
                                            }
                                            xhr.send(params);
                                         }
                                    }else{ 
                                        $.each(data, function(key, val) {
                                            t8.error(""+val+"");
                                        }); 
                                    } 
                                }',

                    'beforeSend' => 'function(){
                        $("#loader").show();
                        var boe = $("#Transfers_bill_of_exit").val();
                        if( boe.trim() == ""){
                            $("#loader").hide();
                            t8.error("Please enter bill of exit");
                            return false;
                        }
                    }'
                ), array('id' => 'mybtn' . rand(), 'class' => 'bill-save-btn btn btn-theme'));
    ?>
    </div>


<?php $this->endWidget(); ?>






