<?php 
    $items = array(new Stock);
    if( $boe != ""){
        $items = Stock::model()->with('warehouseDetails', 'deliverynote')->findAll( array( 'condition' => 'quantity > 0  AND deliverynote.isDelivered = "N" AND t.bill_of_entry="'.$boe.'" AND warehouseDetails.isDefault="N"' ) );
    }
?>
<table class="table table-hover table-bordered personal-task" id="delivery_item_table" >       
    <tr>
        <th style="width:1%">No</th>            
        <th style="width:12%">Item</th>
        <th style="width:13%">Description</th> 
        <th style="width:6%">Brand</th>         
        <th style="width:6%">Category</th>
        <th style="width:6%">HS Code</th>
        <th style="width:6%">Origin</th>      
        <th style="width:5%">Qty</th>            
        <th style="width:5%">UoM</th>   
        <th style="width:5%">Pckg</th>     
        <th style="width:5%">Unit Price</th>         
        <th style="width:5%">Net Wt</th> 
        <th style="width:5%">Gross Wt</th> 
        <th style="width:5%">CBM</th> 
        <th style="width:6%">Net</th>           
        <!-- <th style="width:2%">Currency</th> -->
    </tr>
    <?php foreach( $items as $i => $each ){ ?>
        <?php 
            $model = new OutboundItems;
            $model->outb_part_number = $each->part_number;
            $model->outb_description = $each->description;
            $model->outb_stock_id = $each->id;
            $model->outb_hs_code = $each->inboundRelation->inb_hs_code;
            $model->outb_contry_of_origin = $each->inboundRelation->inb_contry_of_origin;
            $model->outb_quantity =  $each->quantity;
            $model->outb_quantity_unit =  $each->inboundRelation->inb_quantity_unit;
            $model->outb_remarks =  $each->inboundRelation->inb_remarks;
            $model->outb_net_wt = $each->quantity * $each->net_wt;
            $model->outb_gross_wt = $each->quantity * $each->gross_wt;
            $model->outb_cbm =  $each->quantity * $each->cbm;
            $model->outb_invoice_rate = $each->quantity * $each->cost_rate;
            $model->outb_currency_code =  $each->inboundRelation->inb_currency_code;
            $model->outb_unit_price = number_format(round((($model->outb_invoice_rate / $model->outb_quantity)), 2), 2, '.', '');
            
            //code added by mereena on 06-08-2024
            if((int) $each->inboundRelation->inb_brand_id > 0){
                $model->brand_id = (int) $each->inboundRelation->inb_brand_id;
            }
            else{
                $model->brand_id = (int) $each->item_master->brand_id;
            }
            
            if((int) $each->inboundRelation->inb_category_id > 0){
                $model->category_id = (int) $each->inboundRelation->inb_category_id;
            }
            else{
                $model->category_id = (int) $each->item_master->category_id;
            }
        ?>
        <tr>                
            <td><label><?php echo ($i+1); ?></label></td>
            <td><?php echo CHtml::activetextField($model, "[".$i."]outb_part_number", array('class'=>'form-control go', 'readonly' => true )); ?></td>
            <td><?php echo CHtml::activehiddenField($model, "[".$i."]outb_stock_id"); echo CHtml::activetextArea($model, "[".$i."]outb_description", array('class'=>'form-control go', 'readonly' => true)); ?></td>
            <td><?php echo CHtml::activedropdownlist($model, "[".$i."]brand_id",MasBrand::getActiveBrands(), array('class'=>'form-control go','prompt'=>'--Brand--')); ?></td>
            <td><?php echo CHtml::activedropdownlist($model, "[".$i."]category_id",MasCategory::getActiveCategories(), array('class'=>'form-control go','prompt'=>'--Category--')); ?></td>
            <td><?php echo CHtml::activetextField($model, "[".$i."]outb_hs_code", array('class'=>'form-control go', 'readonly' => true)); ?></td>
            <td><?php echo CHtml::activetextField($model, "[".$i."]outb_contry_of_origin", array('class'=>'form-control go', 'readonly' => true)); ?></td>
            <td><?php echo CHtml::activetextField($model, "[".$i."]outb_quantity", array('class'=>'form-control go', 'readonly' => true)); ?></td>
            <td><?php echo CHtml::activetextField($model, "[".$i."]outb_quantity_unit", array('class'=>'form-control go', 'readonly' => true)); ?></td>
            <td><?php echo CHtml::activetextField($model, "[".$i."]outb_remarks", array('class'=>'form-control go')); ?></td>
            <td><?php echo CHtml::activetextField($model, "[".$i."]outb_unit_price", array('class'=>'form-control go', 'onkeypress' => 'return isNumberKey(event)', 'onkeyup' => 'calculateNetAmount(this.id, this.value);')); ?></td>
            <td><?php echo CHtml::activetextField($model, "[".$i."]outb_net_wt", array('class'=>'form-control go', 'readonly' => true)); ?></td>
            <td><?php echo CHtml::activetextField($model, "[".$i."]outb_gross_wt", array('class'=>'form-control go', 'readonly' => true)); ?></td>
            <td><?php echo CHtml::activetextField($model, "[".$i."]outb_cbm", array('class'=>'form-control go', 'readonly' => true)); ?></td>
            <td><?php echo CHtml::activetextField($model, "[".$i."]outb_invoice_rate", array('class'=>'form-control go text-right', 'readonly' => true)); echo CHtml::activehiddenField($model, "[".$i."]outb_currency_code"); ?></td>
        </tr>      
    <?php } ?>
</table>