<?php
$form = $this->beginWidget('CActiveForm', array(
            'id' => 'inbound-delivery-note',
            'enableAjaxValidation' => false,
            'enableClientValidation' => false,
        ));
?>
<ul class="nav nav-tabs company-nav-tabs nav-tab-theme">
    <li class="active"><a href="#tab1" data-toggle="tab">General</a></li>
    <?php 
    if((int) $model->id > 0){?>
    <li><a href="#tab2" data-toggle="tab">Containers</a></li>
    <?php } ?>
</ul>
<div class="tab-content">
    <div class="tab-pane active" id="tab1">
        <ul class="clearfix form-ul material">
            <li class="col-sm-3">
                <?php 
                if((int) $model->id == 0){
                    $sql = "SELECT MAX(id) AS max_id FROM nia_inbound";
                    $result = Yii::app()->db->createCommand($sql)->queryRow();
                    
                    // Execute the command and fetch the result
                    $maxId = (int) $result['max_id']  + 1;
                }
                else{
                    $maxId = (int) $model->id;
                }
                
                echo $form->hiddenField($model,'id');
                echo $form->textField($model,'inb_doc_no',array('data-label'=>'DOC # <span style="color:red">*</span>','value'=>$maxId,'readonly'=>true)); ?>
            </li>
            <li class="col-sm-3">
                <?php echo $form->textField($model,'inb_delivery_note_no',array('data-label'=>'Delivery Note # <span style="color:red">*</span>')); ?>
            </li>
            <li class="col-sm-3">
            <?php echo $form->textField($model,'inb_bill_of_entry_no',array('data-label'=>'Bill of Entry # <span style="color:red">*</span>' )); ?>
            <?php //echo $form->textField($model,'inb_bill_of_entry_no',array('data-label'=>'Bill of Entry # <span style="color:red">*</span>', 'data-mask' => '999-99999999-99')); ?>
            </li>
            <li class="col-sm-3">
                <?php echo $form->textField($model,'inb_ta_number',array('data-label'=>'TA #')); ?>
            </li>
            <li class="col-sm-3">
                <?php 
                if((int) $model->id > 0){
                    $model->inb_bill_of_entry_date = date('d/m/Y',strtotime($model->inb_bill_of_entry_date));
                }
                echo $form->textField($model,'inb_bill_of_entry_date',array('data-label'=>'BOE Date <span style="color:red">*</span>', 'class' => 'datepicker')); ?>
            </li> 
            <li class="col-sm-3">
                <?php 
                if((int) $model->id > 0){
                    $model->inb_added_date = date('d/m/Y',strtotime($model->inb_added_date));
                }
                echo $form->textField($model,'inb_added_date',array('data-label'=>'Added Date', 'class' => 'datepicker')); ?>
            </li>
            <li class="col-sm-3">
                <?php echo $form->textField($model,'inb_grn_no',array('data-label'=>'GRN #')); ?>
            </li>
            <?php /*<li class="col-sm-3">
                <?php echo $form->textField($model,'inb_frieght',array('data-label'=>'Frieght')); ?>
            </li>
            <li class="col-sm-3">
                <?php echo $form->textField($model,'inb_frieght_currency',array('data-label'=>'Frieght Currency')); ?>
            </li> */ ?>
            <li class="col-sm-3">
                <?php echo $form->textField($model,'inb_total_containers',array('data-label'=>'Total Containers')); ?>
            </li>
            <li class="col-sm-3">
                <?php echo $form->textField($model,'inb_container_type',array('data-label'=>'Container Type')); ?>
            </li>
            <li class="col-sm-3">
                <?php echo $form->textField($model,'inb_department',array('data-label'=>'Department')); ?>
            </li>
            <li class="col-sm-3">
                <?php echo CHtml::dropdownlist('warehouse',$model->inb_warehouse_id,Warehouses::getWarehouses(), array('class' => 'tooltipster', 'data-label' => 'Warehouse')); ?>
            </li>
            <li class="col-sm-3">
            </li>
            <?php if((int) $model->id == 0){?>
            <li class="col-sm-2">
            <?php
                $allowedExtensions = array("csv");
                $this->widget('ext.EAjaxUpload.EAjaxUpload', array(
                    'id' => rand(),
                    'config' => array(
                    'action' => Yii::app()->createUrl(Yii::app()->controller->id . '/Upload', array('folder' => 'upload/idoc_csv')),
                    'multiple' => false,
                    'allowedExtensions' => $allowedExtensions,
                    'sizeLimit' => 5 * 1024 * 1024,
                    'onStart' => "js:function(){}",
                    'onComplete' => "js:function(id, fileName, responseJSON){
                        $('#idoc_csv_file').val(responseJSON.filename);
                        $('#import_inbound_btn').show();
                        // $('#errorlog').hide();
                    }",
                )
                ));
            ?>
            <?php echo CHtml::hiddenField('idoc_csv_file', ''); ?>
            </li>
            <li class="col-sm-3">
                <a href="#" class="tooltipster text-center btn-xs btn btn-theme" onclick="window.open($('#liveSite').val()+'index.php?r=inbound/download&filename=sample_new.csv', '_blank');" title="Download sample"><i class="fa fa-download"> Sample</i></a>
            </li>
            <?php } ?>
        </ul>
    </div>
    <div class="tab-pane" id="tab2">
         <table class="table table-hover table-bordered personal-task" id="container_item_table" >        
                <tr>
                    <th style="width:1%">No</th>            
                    <th style="width:12%">Type</th>
                    <th style="width:13%">Quantity</th> 
                    <th style="width:6%">Frieght</th>         
                    <th style="width:6%">Currency</th>
                    <th style="width:6%">Total Freight</th>
                    <th style="width:6%">POL</th>      
                    <th style="width:5%">POD</th>            
                    <th style="width:1%" class="text-center"><a class="btn btn-xs btn-theme " href="javascript:void(0);" onclick="addTableRow($('#container_item_table'));"><i class="fa fa-plus"></i></a></th>     
                </tr>
            <?php
                foreach( $modelInboundContainerDetails as $i => $eachItem){ ?>
                    <tr>                
                        <td><label><?php echo ($i+1); ?></label></td>
                        <td><?php 
                        echo $form->hiddenField($eachItem, "[".$i."]id");
                        echo $form->textField($eachItem, "[".$i."]container_type", array('class'=>'form-control go')); ?></td>
                        <td><?php echo $form->textField($eachItem, "[".$i."]container_quantity", array('class'=>'form-control go', 'onkeypress' => 'return isNumberKey(event)','onkeyup' =>'CalculateFreightValue(this.id)','style'=>'text-align:right')); ?></td>
                        <td><?php echo $form->textField($eachItem, "[".$i."]frieght_per_container", array('class'=>'form-control go', 'onkeypress' => 'return isNumberKey(event)','onkeyup' =>'CalculateFreightValue(this.id)','style'=>'text-align:right')); ?></td>
                        <td><?php echo $form->textField($eachItem, "[".$i."]currency", array('class'=>'form-control go')); ?></td>
                        <td><?php echo $form->textField($eachItem, "[".$i."]total_frieght", array('class'=>'form-control go', 'onkeypress' => 'return isNumberKey(event)','readonly'=>true,'style'=>'text-align:right')); ?></td>
                        <td><?php echo $form->textField($eachItem, "[".$i."]container_pol", array('class'=>'form-control go')); ?></td>
                        <td><?php echo $form->textField($eachItem, "[".$i."]container_pod", array('class'=>'form-control go')); ?></td>
                        <td class="text-center nw" width="1%"><?php echo CHtml::link('<i class="fa fa-times"></i>', 'javascript:void(0);', array('class'=>'btn btn-xs btn-danger','onclick' => 'removeTableRow($("#container_item_table"),this,this.id)', 'title' => 'Remove this item')); ?></td>
                    </tr>      
                <?php } ?>    
                </table>
        </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-default "  data-dismiss="modal">Close</button>
    <?php if((int) $model->id == 0){?>
     <button id="import_inbound_btn" style="display:none;" onclick="importdata();return false;" class='plan-save-btn btn btn-theme' target="_blank"><i class="fa fa-download"></i> Import</button>
     <?php }else if($type!='view'){ ?>
     <button id="import_inbound_btn" onclick="updateContainerData();return false;" class='plan-save-btn btn btn-theme' target="_blank"><i class="fa fa-plus"></i> Save</button>
     <?php } ?>
    <?php
    $cs = Yii::app()->getClientScript();
    $cs->registerScript("importdata", "function importdata(){
    var file_name= $('#idoc_csv_file').val();
    var warehouse= $('#warehouse').val();
    var boe_date = $('#Inbound_inb_bill_of_entry_date').val();
    var inb_delivery_note_no = $('#Inbound_inb_delivery_note_no').val();
    var inb_bill_of_entry_no = $('#inb_bill_of_entry_no').val();
    if(file_name!='' && boe_date!='' && inb_delivery_note_no!='' && inb_bill_of_entry_no!='')
    {
        var url = '" . Yii::app()->createUrl('inbound/importidocsnew') . "';
        jQuery.ajax({
        'dataType':'json',
         'type': 'post',
         //'data': {'file_name':file_name, 'warehouse' : warehouse}  ,
         'data':$('#inbound-delivery-note').serialize()+'&file_name='+file_name+'&warehouse='+warehouse,
         'url': url,
         'cache': false,
         'success': function(data)
         {
            if(data.status=='success')
            {
                HoldOn.close();
                loadPopupModal('inbound/documentpreview','Review','md');          
            }else{
                HoldOn.close();
                t8.error('Uploaded files contains some error. Please refer the error log!');
                // $('#errorlog').show();
                $('#import_inbound_btn').hide();
            }
         },
         'beforeSend':function(){
            $('.x.close').click();
            HoldOn.open();
         },
       });
    }
    else if(boe_date==''){
        t8.error('Please select a BOE Date');
        return false;
    }
    else if(inb_delivery_note_no==''){
        t8.error('Please select a Delivery Note#');
        return false;
    }
    else if(inb_bill_of_entry_no==''){
        t8.error('Please select a Bill of Entry#');
        return false;
    }
    else{
        t8.error('Upload File');

    }
}", CClientScript::POS_HEAD);

$cs->registerScript("updateContainerData", "function updateContainerData(){
var url = '" . Yii::app()->createUrl('inbound/updateContainerData') . "';
        jQuery.ajax({
        'dataType':'json',
         'type': 'post',
         'data':$('#inbound-delivery-note').serialize(),
         'url': url,
         'cache': false,
         'success': function(data)
         {
            if(data.status=='success')
            {
                t8.success('Success');
                return false;
            }else{
                t8.error('error');
            }
         },
         'beforeSend':function(){
            $('.x.close').click();
         },
       });
}", CClientScript::POS_HEAD);

$cs->registerScript("removeTableRow", "function removeTableRow(jQtable,evt,field_id) {
    var arr_fields= field_id.split('_');
    var row_field=arr_fields[1];
    formIdStarter   =   jQtable.attr('id').split(/_(.+)?/)[0];
    var num_rows    =   jQtable.find('tr:gt(0)').length;
    if(num_rows>1){
        var tr  =   $(evt).parent().parent();
        if(isRowEmpty(tr)) {
           
                $(evt).parents('tr').remove();
                var i=0;
                jQtable.find('tr:gt(0)').each(function() {
                    $(this).find('input,textarea,.errorMessage,div,select,a').each(function()
                    {
                        old_id   =   $(this).attr('id');
                        if(old_id!==undefined) {
                            new_id   =   old_id.replace(/\d+/,i);
                            $(this).attr('id',new_id);
                        }
                        old_name =   $(this).attr('name');
                        if(old_name!==undefined) {
                            new_name =   old_name.replace(/\d+/,i);
                            $(this).attr('name',new_name);
                        }
                    });
                    $(this).find('td:first label').html(++i);
                });
            }
    }else {
        alert('Atleast one item needed here');
    }
};", CClientScript::POS_HEAD);
$cs->registerScript("CalculateFreightValue", "function CalculateFreightValue(field_id){
var arr_fields= field_id.split('_');
    var row_field=arr_fields[1];
   
    var qty = $('#InboundContainerDetails_'+row_field+'_container_quantity').val();
    var rate = $('#InboundContainerDetails_'+row_field+'_frieght_per_container').val();
    if(qty > 0 && rate > 0)
    {
      $('#InboundContainerDetails_'+row_field+'_total_frieght').val(qty*rate);
     }
    }", CClientScript::POS_HEAD);
?> 
    </div>


<?php $this->endWidget(); ?>

