
<?php
    $cs = Yii::app()->getClientScript();
    $cs->registerScript("autoCompleteBillofentry", "function autoCompleteBillofentry(field_id){
        var url = '" . Yii::app()->createUrl('inbound/availableboes') . "';
        $('#'+field_id).autocomplete({
            minLength   : 1,
            source      : function (request, response) { autoCompleteSource(request, response,url) },
            focus       : function( event, ui ) {},
            select          : function( event, ui ) {
                event.preventDefault();
                trigger_target_id  	=   $(event.target).attr('id');
                $('#boe').val(ui.item.value);
                if( ui.item.value != '' ){
                    jQuery.ajax({
                        'data' :{'boe':ui.item.value},
                        'type':'post',
                        'url': '" . Yii::app()->createUrl('inbound/renderDirecttransfer') . "',
                        'success': function(data) {
                            $('#tbl-items-render').html(data);
                        }
                    });
                }
            }
        })
    }", CClientScript::POS_HEAD); 
    $cs->registerScript("validateQuantity", "function validateQuantity(field_id, value){
        var arr_field_id = field_id.split('_');
        var i =  arr_field_id[1];    
        var maximunValue = parseFloat($('#WarehouseTransferHistory_'+i+'_available_quantity').val());
        if( value > maximunValue )
            $('#'+field_id).val('');
    }", CClientScript::POS_HEAD); 
    
    
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'bill-form',
        'enableAjaxValidation' => false,
        'enableClientValidation' => false,
    ));

?>

<div class="tab-content">
    <div class="tab-pane active" id="tab1">
        <ul class="clearfix form-ul material">
            <li class="col-sm-3">
               <?php echo CHtml::textField('boe', '',array('data-label'=>'Bill of Entry *', 'class' => 'tooltipster', 'placeholder' => 'Type & Select Bill of Entry Number', 'onkeypress' => 'js:autoCompleteBillofentry(this.id);')); ?>
            </li>
            <li class="col-sm-9">
               <?php echo CHtml::textField('notes', '',array('data-label'=>'Notes *', 'class' => 'tooltipster')); ?>
            </li>
        </ul>
        <ul class="clearfix form-ul material">
            <div class="table-responsive" id="tbl-items-render">
                <table class="table table-hover table-bordered personal-task" id="delivery_item_table" >        
                    <tr>
                        <th class="bg-info" style="width:1%">No</th>            
                        <th class="bg-info" style="width:10%">Item</th>
                        <th class="bg-info" style="width:15%">Description</th>     
                        <th class="bg-info" style="width:10%">Qty</th>            
                        <th class="bg-info" style="width:10%">UoM</th>      
                        <th class="bg-info" style="width:10%">Net Wt</th> 
                        <th class="bg-info" style="width:10%">Gross Wt</th> 
                        <th class="bg-info" style="width:10%">CBM</th>       
                        <th class="bg-success" style="width:15%">Warehouse</th>    
                        <th class="bg-success" style="width:10%">Quantity</th> 
                    </tr>
                    <tr>
                        <td colspan="10" class="text-center">No data</td>
                    </tr>
                </table>
            </div>
        </ul>
    </div>
</div>

<div class="modal-footer">
    <button type="button" class="btn btn-default "  data-dismiss="modal">Close</button>
    <?php

                echo CHtml::ajaxSubmitButton('Save',Yii::app()->createUrl('inbound/savetransfer'), array(
                    'dataType' => 'json',
                    'type' => 'post',
                    'success' => 'function(data) {
                                    $("#loader").hide();
                                    if(data.status=="success"){  
                                         t8.success("Done!");
                                         $(".x.close").click();
                                         reloadTable("#tbl_transfers");
                                    }else{ 
                                        $.each(data, function(key, val) {
                                            t8.error(""+val+"");
                                        }); 
                                    } 
                                }',

                    'beforeSend' => 'function(){
                        $("#loader").show();
                    }'
                ), array('id' => 'mybtn' . rand(), 'class' => 'bill-save-btn btn btn-theme'));
    ?>
    </div>


<?php $this->endWidget(); ?>






