<?php

/**
 * This is the model class for table "{{outbound_variance}}".
 *
 * The followings are the available columns in table '{{outbound_variance}}':
 * @property string $ta_number
 * @property string $overall_gross_wt
 * @property string $overall_price
 * @property string $isUpdated
 */
class OutboundVariance extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{outbound_variance}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('ta_number, overall_gross_wt, overall_price', 'required'),
			array('ta_number', 'length', 'max'=>255),
			array('overall_gross_wt, overall_price', 'length', 'max'=>15),
			array('isUpdated', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('ta_number, overall_gross_wt, overall_price, isUpdated', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'ta_number' => 'Ta Number',
			'overall_gross_wt' => 'Overall Gross Wt',
			'overall_price' => 'Overall Price',
			'isUpdated' => 'Is Updated',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('ta_number',$this->ta_number,true);
		$criteria->compare('overall_gross_wt',$this->overall_gross_wt,true);
		$criteria->compare('overall_price',$this->overall_price,true);
		$criteria->compare('isUpdated',$this->isUpdated,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return OutboundVariance the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
