<?php

/**
 * This is the model class for table "{{inbound_header}}".
 *
 * The followings are the available columns in table '{{inbound_header}}':
 * @property string $inb_delivery_note_no
 * @property string $inb_bill_of_entry_no
 * @property string $inb_ta_number
 * @property string $inb_bill_of_entry_date
 * @property string $inb_added_date
 * @property string $inb_doc_no
 * @property string $inb_delivery_note_posted
 */
class Inbound extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{inbound}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('inb_delivery_note_no, inb_bill_of_entry_no, inb_ta_number, inb_bill_of_entry_date, inb_added_date, inb_doc_no, inb_delivery_note_posted, inb_warehouse_id', 'required'),
			array('inb_delivery_note_no, inb_bill_of_entry_no, inb_ta_number', 'length', 'max'=>100),
			array('inb_doc_no,inb_frieght,inb_total_containers', 'length', 'max'=>50),
			array('inb_delivery_note_posted', 'length', 'max'=>1),
			array('inb_file_name,inb_grn_no,inb_frieght_currency,inb_container_type,inb_department', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('inb_delivery_note_no, inb_bill_of_entry_no, inb_ta_number, inb_bill_of_entry_date, inb_added_date, inb_doc_no, inb_delivery_note_posted', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'items' => array(self::HAS_MANY, 'InboundItems', 'inb_inbound_id', 'order' => 'items.id ASC'),
			'warehouseDetails' => array(self::BELONGS_TO, 'Warehouses', 'inb_warehouse_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'inb_delivery_note_no' => 'Inb Delivery Note No',
			'inb_bill_of_entry_no' => 'Inb Bill Of Entry No',
			'inb_ta_number' => 'Inb Ta Number',
			'inb_bill_of_entry_date' => 'Inb Bill Of Entry Date',
			'inb_added_date' => 'Inb Added Date',
			'inb_doc_no' => 'Inb Doc No',
			'inb_delivery_note_posted' => 'Inb Delivery Note Posted',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('inb_delivery_note_no',$this->inb_delivery_note_no,true);
		$criteria->compare('inb_bill_of_entry_no',$this->inb_bill_of_entry_no,true);
		$criteria->compare('inb_ta_number',$this->inb_ta_number,true);
		$criteria->compare('inb_bill_of_entry_date',$this->inb_bill_of_entry_date,true);
		$criteria->compare('inb_added_date',$this->inb_added_date,true);
		$criteria->compare('inb_doc_no',$this->inb_doc_no,true);
		$criteria->compare('inb_delivery_note_posted',$this->inb_delivery_note_posted,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Inbound the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	public static function getNewta(){
		$inbound = self::model()->findAll(array('condition' => 'inb_bill_of_entry_no=""'));
		return CHtml::listData($inbound,'inb_ta_number', 'inb_ta_number');
	}
	
	public static function get_delivery_wo_boe(){
		$inbound = self::model()->findAll(array('condition' => 'inb_bill_of_entry_no=""', 'limit' => 500));
		return CHtml::listData($inbound,'id', 'inb_delivery_note_no');
	}

}
