<?php



class UsersController extends Controller

{

        public function accessRules() {

            return array(

                array('allow', // allow all users to perform 'index' and 'view' actions

                  'actions' => array('login', 'error', 'logout'),

                  'users' => array('*'),

                  ),

                array('allow', // allow authenticated user to perform 'create' and 'update' actions

                  'actions' => array('Index','Create','GetList','SaveUsers','DeleteUsers'),

                  'expression' => '$user->isMember()',

                  ),

                array('deny', // deny all users

                  'users' => array('*'),

                  ),

                );

        }

	public function actionIndex()

	{

		$this->render('index');

	}



	

	

	public function filters()

        {

            return array(

                'accessControl', // perform access control for CRUD operations

                );

        }

        public function actionGetList()

        {

                $model=new User();

                $draw    = $_POST['draw'];

                $offset = $_POST['start'];

                $limit  = $_POST['length'];

                $columns = array(

                // datatable column index  => database column name

                   0 =>'username',

                   1 => 'first_name',

                    2 => 'designation',

                    3 => 'user_group_id',

                   

                   );

                $filterColumn = $columns[$_POST['order'][0]['column']];

                $filterOrder  = $_POST['order'][0]['dir'];

                $orderBy   = $filterColumn." ".$filterOrder;

                $condition = 't.isActive="Y" and level!=0';

                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")

                {

                  $searchString = $_POST['search']['value'];

                  $condition.=" and username LIKE '%".$searchString."%' OR first_name LIKE '%".$searchString."%' OR designation LIKE '%".$searchString."%' OR user_group_id LIKE '%".$searchString."%'";

                }

                $count = $model->count(array('condition'=>$condition));

                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));

                $recordsTotal = $count;

                $recordsFiltered = $count;

                $data['draw'] = $draw;

                $data['recordsTotal'] = $recordsTotal;

                $data['recordsFiltered'] = $recordsFiltered;

                $rowData=array();

                $m = 1;

               

                foreach ($model as $row)

                {

                    /*$rowData[]=array($m,$row['username'],$row['first_name']." ".$row['last_name'],$row['designation'],$row->userGroup->group_name,'<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'users/create&id='.$row['id'].'\',\'Users\',\'lg\')"><i class="fa fa-pencil"></i></button> '

             .'<a href ="#" class="btn btn-danger btn-xs" onclick="deleteUsers('.$row['id'].')"><i class="fa fa-trash-o "></i></a></div>');

                    $m++;*/
                    $rowData[]=array($m,$row['username'],$row['first_name']." ".$row['last_name'],$row['designation'],'<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'users/create&id='.$row['id'].'\',\'Users\',\'lg\')"><i class="fa fa-pencil"></i></button> '

             .'<a href ="#" class="btn btn-danger btn-xs" onclick="deleteUsers('.$row['id'].')"><i class="fa fa-trash-o "></i></a></div>');
                    $m++;

                }

                $data['data'] = $rowData;

                echo json_encode($data);

        }

         public function actionCreate()

        {

            $model=new User();

            $id = (int) Yii::app()->request->getParam('id');

            if($id>0){

                $model=$model->findByPk($id);

            }

                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

            $this->render('users_form', array('model' => $model), false, false);
            

        }

  

  

        public function actionSaveUsers()

        {

            $model = new User();

            if (isset($_POST['User']))

            {

    		$model->created_by = Yii::app()->user->id;

                $model->created_date_time =date('Y-m-d h:i:s');

    		if ((int) @$_POST['User']['id'] > 0)

                {   $model->updated_by = Yii::app()->user->id;

                    $model->updated_date_time =date('Y-m-d h:i:s');

                    $id= (int) @$_POST['User']['id'];

                    $model=$model->findByPk($id);  

                }

                $model->attributes=$_POST['User'];

                //$company=MasCompany::model()->find();

                //$model->company_id=$company->id;

                if ($model->save())

                {

                        $jsonData['status'] = 'success';

                        $jsonData['frm'] = $_POST['users_form'];

                        $jsonData['id'] = $model->id;

	                echo CJSON::encode($jsonData);

                }

                else

                {

                        $error = CActiveForm::validate($model, '', false);

                        if ($error != '[]')

		               echo $error;

                }

          

            }

        }

        public function actionDeleteUsers(){

		$id = $_POST['id'];

                $model=new User();

                $model->deleteByPk($id);

                echo "success";

    }

}