<?php
class SiteController extends Controller {
    /**
     * Declares class-based actions.
     */
    public function actions() {
        return array(
			// captcha action renders the CAPTCHA image displayed on the contact page
            'captcha' => array(
                'class' => 'CCaptchaAction',
                'backColor' => 0xFFFFFF,
            ),
            // page action renders "static" pages stored under 'protected/views/site/pages'
			// They can be accessed via: index.php?r=site/page&view=FileName
            'page' => array(
                'class' => 'CViewAction',
            ),
        );
    }
        public function accessRules() {

        return array(

                array('allow', // allow all users to perform 'index' and 'view' actions

                  'actions' => array('login', 'error', 'logout'),

                  'users' => array('*'),

                  ),

                array('allow', // allow authenticated user to perform 'create' and 'update' actions

                  'actions' => array('Index','ChangePassword','UpdatePassword','BrowserControl','SaveBrowserView', 'hscodeupload', 'ftp', 'Upload', 'Importidocs'),

                  'expression' => '$user->isMember()',

                  ),

                array('deny', // deny all users

                  'users' => array('*'),

                  ),

                );

    }


    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     */
    public function actionIndex() {
            $this->render('index');
    }
    public function actionChangePassword() {
        $this->render('changepassword');
    }
    public function actionUpdatePassword() {
        $curr_pwd      = $_POST['user_current_password'];
        $new_pwd       = $_POST['user_new_password'];
        $rep_pwd       = $_POST['user_reenter_password'];
        $login_user_id = Yii::app()->user->id;
        $arr_user_details= User::model()->findByPk($login_user_id);
        $salt       = '$2a$10$1qAz2wSx3eDc4rFv5tGb5t';
        $password   = crypt($_POST['user_current_password'], $salt);
        
        if($arr_user_details->password == $password){
            $new_password   = crypt($_POST['user_new_password'], $salt);
            
           
            
            $arr_user_details->password=$new_password;
            $arr_user_details->save(false);
            $json['status'] = "success";
        }
        else
        {  
            $json['status'] = "fail";
        }
        echo CJSON::encode($json);
    }

    public function actionBrowserControl() {
        $model = MasterSetting::model()->find();
        if($model->browser_view==''){
            $model=new MasterSetting();
        }
         Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('browser_control',array('model'=>$model));
    }
     public function actionSaveBrowserView() {
        $model = new MasterSetting;
        if (isset($_POST['MasterSetting'])) {
            if ((int) @$_POST['MasterSetting']['id'] > 0) {
                $model->id = (int) $_POST['MasterSetting']['id'];
                $model->scenario = 'update';
                $model = MasterSetting::model()->findByPK($_POST['MasterSetting']['id']);
            }
  
            $model->attributes = $_POST['MasterSetting'];
            if ($model->validate()) {           
                $model->save();
                $model->refresh();
                $jsonData['model'] = 'MasterSetting';
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
        Yii::app()->end();
    }
    public function actionError() {
        if ($error = Yii::app()->errorHandler->error) {
            // print_r($error);
            if (Yii::app()->request->isAjaxRequest)
                echo $error['message'];
            else
                $this->render('error', $error);
        }
    }

    public function actionHscodeupload(){
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('upload_hsc');
    }
    public function actionFtp(){
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('server');
    }

    public function actionImportidocs(){
        
        $doc= $_POST['file_name']; 
        $doc = str_replace(',', '', $doc); 
        $file = fopen("upload/hscodecsv/$doc", "r");      
        
        while ($line = fgets($file, 1000)) {   
            $part_no ="";
            $eu_hs_code ="";
            $eu_hs_8 ="";
            $ae_hs_code = "";
            $line = explode(",", $line);
            foreach ($line as $i => $row) {
                    switch ($i) {
                        case 0:
                            $part_no = trim($row);
                            break;
                        case 1:
                            $eu_hs_code = trim($row);
                            break;
                        case 2:
                            $eu_hs_8 = trim($row);
                            break;
                        case 3:
                            $ae_hs_code = trim($row);
                            break;

                    }
            }  
            //SAVE DATA   
            $hscode = new HSCode;
            if( $part_no > 0 )
                $hscode->findBypk($part_no);
            if( (int) $hscode->part_no == 0 )
                $hscode = new HSCode;
            $hscode->part_no =$part_no;
            $hscode->eu_hs_code =$eu_hs_code;
            $hscode->eu_hs_8 =$eu_hs_8;
            $hscode->ae_hs_code=$ae_hs_code;
            $hscode->save(FALSE);             
           
        }
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }
    
}
