

$(function() {
    var time = 7; // time in seconds
    var $progressBar,
        $bar,
        $elem,
        isPause,
        tick,
        percentTime;
    //Init the carousel
    $("#main-slider").owlCarousel({
        slideSpeed: 500,
        paginationSpeed: 500,
        singleItem: true,
        afterInit: progressBar,
        afterMove: moved,
        startDragging: pauseOnDragging
    });
    //Init progressBar where elem is $("#owl-demo")
    function progressBar(elem) {
        $elem = elem;
        //build progress bar elements
        buildProgressBar();
        //start counting
        start();
    }

    //create div#progressBar and div#bar then prepend to $("#owl-demo")
    function buildProgressBar() {
        $progressBar = $("<div>", {
            id: "progressBar"
        });
        $bar = $("<div>", {
            id: "bar"
        });
        $progressBar.append($bar).prependTo($elem);
    }

    function start() {
        //reset timer
        percentTime = 0;
        isPause = false;
        //run interval every 0.01 second
        tick = setInterval(interval, 10);
    };

    function interval() {
        if (isPause === false) {
            percentTime += 1 / time;
            $bar.css({
                width: percentTime + "%"
            });
            //if percentTime is equal or greater than 100
            if (percentTime >= 100) {
                //slide to next item
                $elem.trigger('owl.next')
            }
        }
    }

    //pause while dragging
    function pauseOnDragging() {
        isPause = true;
    }

    //moved callback
    function moved() {
        //clear interval
        clearTimeout(tick);
        //start again
        start();
    }

    // uncomment this to make pause on mouseover
    // $elem.on('mouseover',function(){
    //   isPause = true;
    // })
    // $elem.on('mouseout',function(){
    //   isPause = false;
    // })
    var getHash = window.location.hash.substr(1);
    if (getHash) {
        if (getHash == 'register') {
            $('#login').addClass('signup');
            $('#ls-info-text').html('Already Have an<br>Account ?')
            $('#toggleLogin').html('Log In');
        }
    }
    $(window).on('hashchange', function(e) {
        var getHash = window.location.hash.substr(1);
        if (getHash) {
            if (getHash == 'register') {
                $('#login').addClass('signup');
                $('#toggleLogin').html('Log In');
                $('#ls-info-text').html('').typeIt({
                    strings: 'Don\'t have an<br>Account ?',
                    speed: 60,
                    autoStart: false,
                    html: true,
                    cursor: false,
                    startDelay: 0,
                    breakDelay: 0,
                });
            } else if (getHash == 'login') {
                $('#login').removeClass('signup');
                $('#toggleLogin').html('Sign Up');
                $('#ls-info-text').html('').typeIt({
                    strings: 'Already Have an<br>Account ?',
                    speed: 60,
                    autoStart: false,
                    html: true,
                    cursor: false,
                    startDelay: 0,
                    breakDelay: 0,
                });
            }
        }
    });
    $('#toggleLogin').click(function() {
        $('#login').toggleClass('signup');
        var info_text = 'Don\'t have an<br>Account ?';
        var button_text = 'Sign Up';
        if ($('#login').hasClass('signup')) {
            info_text = 'Already Have an<br>Account ?'
            var button_text = 'Log In';
        }
        $(this).html(button_text);
        $('#ls-info-text').html('').typeIt({
            strings: info_text,
            speed: 60,
            autoStart: false,
            html: true,
            cursor: false,
            startDelay: 0,
            breakDelay: 0,
        });
    });

    if ($(".event-details-bar")[0]) {
        $(window).on('scroll', function(event) {
            var scrollValue = $(window).scrollTop();
            var $el = $('.event-banner');
            var $e_bar = $('.event-details-bar');
            var $e_dtls = $('.event-details');
            var scroll_height = $el.position().top + $el.outerHeight(true) - $('.mainMenu').outerHeight(true);
            var mtop =$('.mainMenu').outerHeight(true);
            if (scrollValue == scroll_height || scrollValue > scroll_height) {
                $e_bar.addClass('fixed').css('top','0');
                $e_dtls.css('margin-top', $e_bar.outerHeight(false));
            } else {
                $e_bar.removeClass('fixed');
                $e_dtls.css('margin-top', '');
            }
        });
    }
    $('.ticket-details').on('click','.tkt-plus',function(){
        dt =$(this).attr('data-target');
        var $t = $(dt);
        var max_v = $t.attr('max-value');
        var v = +$t.val()+1;
        if(v>max_v){
            $(this).prop('disabled', true);
            return false;
        }
        if (v==max_v) {
            $(this).prop('disabled', true);
        }
        $t.val(v);
        $('[data-target="'+dt+'"]').prop('disabled', false);
    });
    $('.ticket-details').on('click','.tkt-minus',function(){
        dt =$(this).attr('data-target');
        var $t = $(dt);
        var min_v = $t.attr('min-value');
        var v = +$t.val()-1;
        if(v<min_v){
            $(this).prop('disabled', true);
            return false;
        }
        if (v==min_v) {
            $(this).prop('disabled', true);
        }
        $t.val(v);
        $('[data-target="'+dt+'"]').prop('disabled', false);
    });

    $('.hamburger').click(function () {
        $(this).toggleClass('active');
        $('.mainMenu').toggleClass('open-menu');
        $('body').toggleClass('body-lock');
        if($(this).hasClass('active')){
            $('body').css('padding-right',getScrollBarWidth());
        } else {
            $('body').css('padding-right',0);
        }
    })
});
$(window).on('load', function() {})

function getScrollBarWidth() {
  var inner = document.createElement('p');
  inner.style.width = "100%";
  inner.style.height = "200px";

  var outer = document.createElement('div');
  outer.style.position = "absolute";
  outer.style.top = "0px";
  outer.style.left = "0px";
  outer.style.visibility = "hidden";
  outer.style.width = "200px";
  outer.style.height = "150px";
  outer.style.overflow = "hidden";
  outer.appendChild (inner);

  document.body.appendChild (outer);
  var w1 = inner.offsetWidth;
  outer.style.overflow = 'scroll';
  var w2 = inner.offsetWidth;
  if (w1 == w2) w2 = outer.clientWidth;

  document.body.removeChild (outer);

  return (w1 - w2);
};
$(document).ready(function() {
    datamask();
});
function datamask(){
  $('[data-mask]').each(function() {
        var dm = $(this).attr('data-mask');
        $(this).mask(dm),{placeholder:"dd/mm/yyyy"};
    });
};