<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("load", '
        $(document).ready(function() {
            var table_id ="#tbl_inbound_details";
            var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
                data.from_date = $("#start_date").val();
                data.to_date = $("#end_date").val();
                return data;
            }).DataTable({
                scrollY         : "380px",
                pageLength      : 50,
                ajax: {
                    url: "' . Yii::app()->createUrl('inbound/getidocs') . '",
                    type: "POST",
                    cache : false,
                },
                serverSide:     true,
                fixedColumns:   true,
                processing: true,
                order: [[ 4, "desc" ]],
            
            });
            $(".dataTables_scrollFoot").hide();
    });', CClientScript::POS_HEAD);
$cs->registerScript('importIndoc', 'function importIndoc() {
    
    var r = confirm("Are you sure to import inbound idocs?"); 
    if(r){
        HoldOn.open();
        jQuery.ajax({
                "dataType":"json",       
                "type":"post",
                "url": "' . Yii::app()->createUrl('inbound/importidoc') . '&key='.Yii::app()->user->import_key.'",
                "cache": false,
                "success": function(data) {
                    if( data.status == "success" ){
                        HoldOn.close();
                        t8.success("Idocs imported!");
                        reloadTable("#tbl_inbound_details");
                    }else{
                        HoldOn.close();
                        t8.error("Someting went wrong at server end, Make sure the idoc server configured properly!", "Something went wrong!");
                    }
                }
            
        });
    }
   
};', CClientScript::POS_HEAD); 
$cs->registerScript("deleteDoc",  "function deleteDoc(id){
    var r = confirm('Are you sure to delete this?');
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'data'  : 'id=' + id,
              'url'  : $('#liveSite').val()+'index.php?r=inbound/delete',
              'cache': false,
              'success':function(data){
                if(data=='fail'){
                   t8.error('Deletion failed!');
                }else {
                    reloadTable('#tbl_inbound_details');
                    t8.success('Deleted!');
                }
               }
            });
        }

   
};", CClientScript::POS_HEAD);
$cs->registerScript("calculateVariance",  "function calculateVariance(deliveryNote, taNumber){
    var r = confirm('Make sure all idocs for TA '+taNumber+' is loaded. Do you want to continue?');
        if(r==true)
        {
            jQuery.ajax({
              'type'  : 'post',
              'data'  : {'deliveryNote' : deliveryNote, 'taNumber' : taNumber},
              'url'  : $('#liveSite').val()+'index.php?r=inbound/calculatevariance',
              'cache': false,
              'success':function(data){
                if(data=='fail'){
                   t8.error('failed!');
                }else {
                    reloadTable('#tbl_inbound_details');
                    t8.success('Variance updated!');
                }
               }
            });
        }

   
};", CClientScript::POS_HEAD);


?>

    <section class="panel">
        <header class="panel-heading clearfix panel-theame">
            <i class="fa fa-file"></i> Delivery Notes
            <div class="pull-right">
                <?php echo CHtml::textfield('start_date',date('01/m/Y'),array('class' => 'datepicker form-control')); ?>
                <?php echo CHtml::textfield('end_date',date('t/m/Y'),array('class' => 'datepicker form-control')); ?>
                <button class="btn btn-sm btn-theme" title="Search" onclick="reloadTable('#tbl_inbound_details');"><i class="fa fa-search"></i></button>
                <button class="btn btn-sm btn-theme" title="Import inbound data" onclick="loadPopupModal('inbound/excelidoc','Import Inbound date','md')"><i class="fa fa-cloud-upload"></i></button>
                <!-- <button class="btn btn-sm btn-theme" title="Update bill of entry" onclick="loadPopupModal('inbound/billofentry','Update Bill of Entry','md')"><i class="fa fa-retweet"></i></button> -->
            </div>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="tbl_inbound_details">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>REF #</th>
                            <th>BOE</th>
                            <th>BOE Date</th>
                            <th>Date</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tfoot>
                        <tr>
                            <th>#</th>
                            <th>REF #</th>
                            <th>BOE</th>
                            <th>BOE Date</th>
                            <th>Date</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </section>
<!--<style>-->
    
<!--    table.dataTable {-->
<!--    min-height: 500px!important;-->
<!--    overflow: scroll!important;-->
<!--    clear: both!important;-->
<!--    margin-top: 3px !important;-->
<!--    margin-bottom: 6px !important;-->
<!--    max-width: none !important;-->
<!--}-->
<!--</style>-->