<?php

/**
 * This is the model class for table "{{item_master}}".
 *
 * The followings are the available columns in table '{{item_master}}':
 * @property string $part_number
 * @property string $base_code
 * @property integer $category_id
 * @property string $description
 * @property string $upc_code
 * @property string $country_of_origin
 * @property double $dis_depth
 * @property double $dis_width
 * @property double $dis_height
 * @property double $com_pkg_m3
 * @property double $com_pkg_wt
 * @property double $item_depth
 * @property double $item_width
 * @property double $item_height
 * @property double $item_m3
 * @property double $item_weight
 * @property string $hs_code
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 */
class ItemMaster extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public $category_name;
	
	public function tableName()
	{
		return '{{item_master}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('part_number', 'required'),
			array('category_id, created_by, updated_by, brand_id', 'numerical', 'integerOnly'=>true),
			array('dis_depth, dis_width, dis_height, com_pkg_m3, com_pkg_wt, item_depth, item_width, item_height, item_m3, item_weight, rate, rate2, rate3', 'numerical'),
			array('part_number, base_code, upc_code, hs_code', 'length', 'max'=>255),
			array('country_of_origin', 'length', 'max'=>45),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('part_number, base_code, category_id, description, upc_code, country_of_origin, dis_depth, dis_width, dis_height, com_pkg_m3, com_pkg_wt, item_depth, item_width, item_height, item_m3, item_weight, hs_code, created_by, created_date_time, updated_by, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'category' => array(self::BELONGS_TO, 'MasCategory', 'category_id'),
			'brand' => array(self::BELONGS_TO, 'MasBrand', 'brand_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'part_number' => 'Part Number',
			'base_code' => 'Base Code',
			'category_id' => 'Category',
			'description' => 'Description',
			'upc_code' => 'Upc Code',
			'country_of_origin' => 'Country Of Origin',
			'dis_depth' => 'Dis Depth',
			'dis_width' => 'Dis Width',
			'dis_height' => 'Dis Height',
			'com_pkg_m3' => 'Com Pkg M3',
			'com_pkg_wt' => 'Com Pkg Wt',
			'item_depth' => 'Item Depth',
			'item_width' => 'Item Width',
			'item_height' => 'Item Height',
			'item_m3' => 'Item M3',
			'item_weight' => 'Item Weight',
			'hs_code' => 'Hs Code',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
			'rate' => 'Price 1',
			'rate2' => 'Price 2',
			'rate3' => 'Price 3',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('part_number',$this->part_number,true);
		$criteria->compare('base_code',$this->base_code,true);
		$criteria->compare('category_id',$this->category_id);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('upc_code',$this->upc_code,true);
		$criteria->compare('country_of_origin',$this->country_of_origin,true);
		$criteria->compare('dis_depth',$this->dis_depth);
		$criteria->compare('dis_width',$this->dis_width);
		$criteria->compare('dis_height',$this->dis_height);
		$criteria->compare('com_pkg_m3',$this->com_pkg_m3);
		$criteria->compare('com_pkg_wt',$this->com_pkg_wt);
		$criteria->compare('item_depth',$this->item_depth);
		$criteria->compare('item_width',$this->item_width);
		$criteria->compare('item_height',$this->item_height);
		$criteria->compare('item_m3',$this->item_m3);
		$criteria->compare('item_weight',$this->item_weight);
		$criteria->compare('hs_code',$this->hs_code,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return ItemMaster the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
