<?php

/**
 * This is the model class for table "{{inbound_items}}".
 *
 * The followings are the available columns in table '{{inbound_items}}':
 * @property integer $id
 * @property string $inb_delivery_note_no
 * @property string $inb_part_number
 * @property string $inb_description
 * @property string $inb_hs_code
 * @property string $inb_hs_code_ae
 * @property string $inb_contry_of_origin_code
 * @property string $inb_contry_of_origin
 * @property string $inb_currency_code
 * @property string $inb_exchange_rate
 * @property string $inb_invoice_rate
 * @property string $inb_no_of_pieces
 * @property string $inb_pieces_unit
 * @property string $inb_quantity
 * @property string $inb_quantity_unit
 * @property string $inb_current_qty
 * @property string $inb_net_amount
 * @property string $inb_net_amount_bc
 * @property string $inb_net_wt
 * @property string $inb_gross_wt
 * @property string $inb_posted
 * @property string $inb_added_date
 * @property string $inb_rate_updated
 * @property integer $inb_rate_last_updated_by
 * @property string $inb_rate_last_updated_date_time
 * @property string $inb_weight_updated
 * @property integer $inb_weight_last_updated_by
 * @property string $inb_weight_last_updated_date_time
 */
class InboundItems extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{inbound_items}}'; 
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('inb_delivery_note_no, inb_part_number, inb_description, inb_hs_code, inb_hs_code_ae, inb_contry_of_origin_code, inb_contry_of_origin, inb_currency_code, inb_exchange_rate, inb_invoice_rate, inb_no_of_pieces, inb_pieces_unit, inb_quantity, inb_quantity_unit, inb_current_qty, inb_net_amount, inb_net_amount_bc, inb_net_wt, inb_gross_wt, inb_added_date, inb_rate_last_updated_by, inb_rate_last_updated_date_time, inb_weight_last_updated_by, inb_weight_last_updated_date_time', 'required'),
			array('inb_rate_last_updated_by, inb_weight_last_updated_by,inb_brand_id,inb_category_id', 'numerical', 'integerOnly'=>true),
			array('inb_delivery_note_no, inb_hs_code_ae, inb_contry_of_origin_code', 'length', 'max'=>50),
			array('inb_part_number', 'length', 'max'=>1000),
			array('inb_hs_code,inb_brand_name,inb_category_name,inb_total_cif_value', 'length', 'max'=>250),
			array('inb_remarks', 'length', 'max'=>500),
			array('inb_contry_of_origin', 'length', 'max'=>100),
			array('inb_currency_code, inb_invoice_rate, inb_pieces_unit, inb_quantity_unit, inb_cbm', 'length', 'max'=>20),
			array('inb_exchange_rate, inb_no_of_pieces, inb_quantity, inb_current_qty, inb_net_amount, inb_net_amount_bc, inb_net_wt, inb_gross_wt', 'length', 'max'=>15),
			array('inb_posted, inb_rate_updated, inb_weight_updated', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, inb_delivery_note_no, inb_part_number, inb_description, inb_hs_code, inb_hs_code_ae, inb_contry_of_origin_code, inb_contry_of_origin, inb_currency_code, inb_exchange_rate, inb_invoice_rate, inb_no_of_pieces, inb_pieces_unit, inb_quantity, inb_quantity_unit, inb_current_qty, inb_net_amount, inb_net_amount_bc, inb_net_wt, inb_gross_wt, inb_posted, inb_added_date, inb_rate_updated, inb_rate_last_updated_by, inb_rate_last_updated_date_time, inb_weight_updated, inb_weight_last_updated_by, inb_weight_last_updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'parent' => array(self::BELONGS_TO, 'Inbound', 'inb_inbound_id'),
			'hsc' => array(self::BELONGS_TO, 'HSCode', 'inb_part_number'),
			'brand' => array(self::BELONGS_TO, 'MasBrand', 'inb_brand_id'),
			'category' => array(self::BELONGS_TO, 'MasCategory', 'inb_category_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'inb_delivery_note_no' => 'Delivery note no from inbound_delivery_note',
			'inb_part_number' => 'Inb Part Number',
			'inb_description' => 'Inb Description',
			'inb_hs_code' => 'Inb Hs Code',
			'inb_hs_code_ae' => 'Inb Hs Code Ae',
			'inb_contry_of_origin_code' => 'Inb Contry Of Origin Code',
			'inb_contry_of_origin' => 'Inb Contry Of Origin',
			'inb_currency_code' => 'Inb Currency Code',
			'inb_exchange_rate' => 'Inb Exchange Rate',
			'inb_invoice_rate' => 'Inb Invoice Rate',
			'inb_no_of_pieces' => 'Inb No Of Pieces',
			'inb_pieces_unit' => 'Inb Pieces Unit',
			'inb_quantity' => 'Inb Quantity',
			'inb_quantity_unit' => 'Inb Quantity Unit',
			'inb_current_qty' => 'Inb Current Qty',
			'inb_net_amount' => 'Inb Net Amount',
			'inb_net_amount_bc' => 'Inb Net Amount Bc',
			'inb_net_wt' => 'Inb Net Wt',
			'inb_gross_wt' => 'Inb Gross Wt',
			'inb_posted' => 'Inb Posted',
			'inb_added_date' => 'Inb Added Date',
			'inb_rate_updated' => 'Inb Rate Updated',
			'inb_rate_last_updated_by' => 'Inb Rate Last Updated By',
			'inb_rate_last_updated_date_time' => 'Inb Rate Last Updated Date Time',
			'inb_weight_updated' => 'Inb Weight Updated',
			'inb_weight_last_updated_by' => 'Inb Weight Last Updated By',
			'inb_weight_last_updated_date_time' => 'Inb Weight Last Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('inb_delivery_note_no',$this->inb_delivery_note_no,true);
		$criteria->compare('inb_part_number',$this->inb_part_number,true);
		$criteria->compare('inb_description',$this->inb_description,true);
		$criteria->compare('inb_hs_code',$this->inb_hs_code,true);
		$criteria->compare('inb_hs_code_ae',$this->inb_hs_code_ae,true);
		$criteria->compare('inb_contry_of_origin_code',$this->inb_contry_of_origin_code,true);
		$criteria->compare('inb_contry_of_origin',$this->inb_contry_of_origin,true);
		$criteria->compare('inb_currency_code',$this->inb_currency_code,true);
		$criteria->compare('inb_exchange_rate',$this->inb_exchange_rate,true);
		$criteria->compare('inb_invoice_rate',$this->inb_invoice_rate,true);
		$criteria->compare('inb_no_of_pieces',$this->inb_no_of_pieces,true);
		$criteria->compare('inb_pieces_unit',$this->inb_pieces_unit,true);
		$criteria->compare('inb_quantity',$this->inb_quantity,true);
		$criteria->compare('inb_quantity_unit',$this->inb_quantity_unit,true);
		$criteria->compare('inb_current_qty',$this->inb_current_qty,true);
		$criteria->compare('inb_net_amount',$this->inb_net_amount,true);
		$criteria->compare('inb_net_amount_bc',$this->inb_net_amount_bc,true);
		$criteria->compare('inb_net_wt',$this->inb_net_wt,true);
		$criteria->compare('inb_gross_wt',$this->inb_gross_wt,true);
		$criteria->compare('inb_posted',$this->inb_posted,true);
		$criteria->compare('inb_added_date',$this->inb_added_date,true);
		$criteria->compare('inb_rate_updated',$this->inb_rate_updated,true);
		$criteria->compare('inb_rate_last_updated_by',$this->inb_rate_last_updated_by);
		$criteria->compare('inb_rate_last_updated_date_time',$this->inb_rate_last_updated_date_time,true);
		$criteria->compare('inb_weight_updated',$this->inb_weight_updated,true);
		$criteria->compare('inb_weight_last_updated_by',$this->inb_weight_last_updated_by);
		$criteria->compare('inb_weight_last_updated_date_time',$this->inb_weight_last_updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return InboundItems the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
