<?php

class OutboundController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout', 'Importidoc'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('index','Getidocs','Billofexit','Updatebillofexit','Create','Updateidocdetails','Downloadxml',
                                   'Downloadcsv','Delete','Downloadsaso','Downloadwr','RemoveItems','Deleteitems', 'Calculatevariance', 'Customerlist',
                                    'Productlist', 'Save', 'Print', 'Customers', 'Getcustomers', 'Createcustomer', 'Savecustomer',
                                    'Renderdirectdelivery', 'Rendercustomdelivery','Customers_original', 'Getcustomers_original', 'Createcustomer_original', 'Savecustomer_original'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array('accessControl'); // perform access control for CRUD operations
    }

    public function actionIndex() {
        $this->render('index');
    }

    public function actionGetidocs(){
        $model  = new Outbound();
        $draw   = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 't.outb_delivery_note_no',
            2 => 'cus.name', 
            3 => 't.outb_bill_of_exit_no', 
            4 => 't.outb_bill_of_exit_date', 
            5 => 't.outb_added_date', 
            6 => 't.outb_delivery_note_posted', 
            7 => 't.id', 
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir']; 
        $orderBy   = $filterColumn." ".$filterOrder;
        $from_date = ( count(explode('/',$_POST['from_date'])) == 3 ) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from_date'])))  : date('Y-m-01');
        $to_date = ( count(explode('/',$_POST['to_date'])) == 3 ) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to_date'])))  : date('Y-m-t');
        $condition = 't.outb_added_date BETWEEN "'.$from_date.'" AND "'.$to_date.'"';
        if(isset($_POST['search']['value']) && trim($_POST['search']['value']) !="")
        {
            $searchString = trim($_POST['search']['value']);
            $condition.=" AND (cus.name LIKE '%".$searchString."%' OR t.outb_doc_no LIKE '%".$searchString."%' OR t.outb_delivery_note_no LIKE '%".$searchString."%' OR t.outb_ta_number LIKE '%".$searchString."%' OR t.outb_bill_of_exit_no LIKE '%".$searchString."%')";
        }
        $count = $model->with('cus')->count(array('condition'=>$condition));
        $model=$model->with('cus')->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $eachItemData=array();
        $m=1;
        
        $arr_logos = array(
            1 => Yii::app()->user->footer_line_one_1,
            0 => 'None',
            2 => Yii::app()->user->footer_line_two_1,
            3 => Yii::app()->user->footer_line_three_1,
            // 4 => Yii::app()->user->footer_line_four_1
        );
        
        $arr_destinations = array(
            3 => 'JEBEL ALI FREE ZONE',
            2 => 'DUBAI',
        );
        
        $arr_print_type = array(
            3 => 'Commercial Invoice',
            1 => 'Tax Invoice',
            2 => 'Invoice',
            4 => 'Proforma invoice',
        );
        foreach ($model as $i => $eachItem)
        {
            $variance = OutboundVariance::model()->findByPk($eachItem['outb_ta_number']);
            $arr_invoice_details = OutboundInvoice::model()->find(array('condition'=>'outbound_id='.$eachItem['outb_delivery_note_no']));
            $invoice_date="";
            if(isset($arr_invoice_details) && $arr_invoice_details!="0000-00-00"){
                $invoice_date = date('d/m/Y',strtotime($arr_invoice_details['invoice_date']));
            }
            $div  = '<div class="btn-wrap text-center">';
            if($eachItem['outb_delivery_note_posted'] == "N"){
                $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'outbound/create&dn='.$eachItem['outb_delivery_note_no'].'\',\'REF : '.$eachItem['outb_delivery_note_no'].'\',\'xl\')", title="Edit"><i class="fa fa-pencil"></i></button>';
            }
            $div .=' <a class="btn btn-primary btn-xs" onclick="print_pdf('.$eachItem['outb_delivery_note_no'].',\'invoice\');" title="Invoice"><i class="fa fa-file-pdf-o"></i></a>';
            $div .=' <a class="btn btn-primary btn-xs" onclick="print_pdf('.$eachItem['outb_delivery_note_no'].',\'packing_list\');" title="Packing List"><i class="fa fa-file-pdf-o"></i></a>';
            $div .=' <a class="btn btn-primary btn-xs" onclick="print_pdf('.$eachItem['outb_delivery_note_no'].',\'transfer_ownership\');" title="Transfer of Ownership"><i class="fa fa-file-pdf-o"></i></a>';
            $div .=' <a class="btn btn-primary btn-xs" onclick="print_pdf('.$eachItem['outb_delivery_note_no'].',\'delivery_advise\');" title="Delivery Advice"><i class="fa fa-file-pdf-o"></i></a>';
            //$div .=' <a class="btn btn-primary btn-xs" onclick="print_pdf('.$eachItem['outb_delivery_note_no'].',\'invoice_cum_packing_list\');" title="Print PDF"><i class="fa fa-file-pdf-o"></i></a>';
            $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'outboundinvoice/create&id='.$eachItem['outb_delivery_note_no'].'\',\'REF : '.$eachItem['outb_delivery_note_no'].'\',\'xl\')", title="Final Docs"><i class="fa fa-retweet"></i></button>';
            $div .= '</div>';
            $eachItemData[]=array(($i+1), $eachItem['outb_delivery_note_no'], $eachItem['cus']['name'], $eachItem['outb_invoice_no'], $invoice_date, date('d/m/Y',strtotime($eachItem['outb_added_date'])),($eachItem['outb_delivery_note_posted'] == "Y") ? 'Yes' : 'No', CHtml::dropDownList('logo_id_'.$eachItem['outb_delivery_note_no'],'', $arr_logos,array('class' =>'','style' =>'width:80px')), CHtml::dropDownList('destination_id_'.$eachItem['outb_delivery_note_no'],'', $arr_destinations,array('class' =>'','style' =>'width:80px')), CHtml::dropDownList('print_type_id_'.$eachItem['outb_delivery_note_no'],'', $arr_print_type,array('class' =>'','style' =>'width:80px')), $div);
          
        }
        $data['data'] = $eachItemData;
        echo json_encode($data);
    }

    public function actionImportidoc(){
        
        /**
         * IDOC Import
         * Created on 24-03-2018 by Jo~
         */
        
        $_key = $_GET['key'];
        $_import_key = MasCompany::model()->find()->import_key;
        $security = ( $_key == $_import_key )  ? true : false;

        $serverConfig = Server::getServer();
        $server         =   $serverConfig->server;
        $username       =   $serverConfig->username;
        $password       =   $serverConfig->password;
        $file_path      =   $serverConfig->file_path;
        $archive_path   =   $serverConfig->archive_path;
        
        if( $serverConfig->id > 0 ){
            
            $connection = ftp_connect($server) or die("Can't connect");
            ftp_login($connection,$username,$password) or die("Can't login");
           
            ini_set('max_execution_time', -1);
            $all_files = ftp_nlist($connection,$file_path);
            if ( !empty($all_files) ){
                foreach ( $all_files as $file ){
                
                    $arr_files=explode("_",$file);
                    if( $arr_files[0] == $file_path.'msg' ){
                        $filename=str_replace($file_path, "",$file);
                        ftp_get($connection,'idocs/'.$filename, $file_path.$filename,FTP_BINARY);
                        $xml=simplexml_load_file("idocs/$filename"); 
                        if( $xml->IDOC[0]->EDI_DC40[0]->MESTYP == 'Z_SPP_DUBAI_DESADV_OUT' ){
                            $idoc_number = $xml->IDOC[0]->EDI_DC40[0]->DOCNUM;
                            $d_note = (int) $xml->IDOC[0]->E1EDL20[0]->VBELN;
                            if( $idoc_number != ''){
                                $existance = Outbound::model()->findbyPk($d_note);
                                if( $existance->outb_delivery_note_no > 0 ){
                                    //remove comment line if in production mode
                                    ftp_put($connection,$archive_path.$filename,'idocs/'.$filename, FTP_BINARY);
                                    ftp_delete($connection,$file_path.$filename);
                                }else{
                                    $OutboundHeader = new Outbound;
                                    $OutboundHeader->outb_doc_no = $idoc_number;
                                    $OutboundHeader->outb_file_name = $filename;
                                    $OutboundHeader->outb_added_date = date('Y-m-d', strtotime($xml->IDOC[0]->EDI_DC40[0]->CREDAT));
                                    
                                    if( $OutboundHeader->outb_added_date == ''){
                                        $OutboundHeader->outb_added_date = date('Y-m-d');
                                    }
                                    
                                    if( $xml->IDOC[0]->E1EDL20[0]->Z1EDL20_ADD_DATA[0]->QUALF == 'TKNUM' )
                                        $OutboundHeader->outb_ta_number = (int) $xml->IDOC[0]->E1EDL20[0]->Z1EDL20_ADD_DATA[0]->DATA;
                                    
                                    //Taxable Local Transport
                                    $shippingCountry = $xml->IDOC[0]->E1EDL20[0]->Z1EDL20_WM[0]->SHIPTO_COUNTRY_EN;
                                    $isTaxable = ( $shippingCountry == 'United Arab Emirates' ) ? true : false;

                                    $overallGrossweight = 0;
                                    $overallRate = 0;
                                    $unit = '';
                                
                                    if( $xml->IDOC[0]->E1EDL20[0]->Z1EDL20_ADD_DATA[1]->QUALF == 'BTGEW' )
                                        $overallGrossweight = (float) $xml->IDOC[0]->E1EDL20[0]->Z1EDL20_ADD_DATA[1]->DATA;
                                    if( $xml->IDOC[0]->E1EDL20[0]->Z1EDL20_ADD_DATA[2]->QUALF == 'GEWEI' )
                                        $unit = $xml->IDOC[0]->E1EDL20[0]->Z1EDL20_ADD_DATA[2]->DATA;
                                    if( $xml->IDOC[0]->E1EDL20[0]->Z1EDL20_ADD_DATA[3]->QUALF == 'NETWR_SHIP' )
                                        $overallRate = (float) $xml->IDOC[0]->E1EDL20[0]->Z1EDL20_ADD_DATA[3]->DATA;
                                    else if( $xml->IDOC[0]->E1EDL20[0]->Z1EDL20_ADD_DATA[4]->QUALF == 'NETWR_SHIP' )
                                        $overallRate = (float) $xml->IDOC[0]->E1EDL20[0]->Z1EDL20_ADD_DATA[4]->DATA;
                                    
                                    $OutboundHeader->outb_delivery_note_no = (int) $xml->IDOC[0]->E1EDL20[0]->VBELN;
                                    
                                    if( $OutboundHeader->save(false) ){
                                        
                                        $overallGrossweight = ( $unit == 'GRM' ) ? $overallGrossweight/1000 : $overallGrossweight;

                                        if( $OutboundHeader->outb_ta_number > 0 ){
                                            $OutboundVariance = OutboundVariance::model()->findBypk($OutboundHeader->outb_ta_number);
                                            if( $OutboundVariance->ta_number > 0 )
                                                OutboundVariance::model()->updatebypk($OutboundHeader->outb_ta_number, array('overall_gross_wt' => $overallGrossweight, 'overall_price' => $overallRate, 'last_updated_idoc' => $idoc_number));
                                            else{
                                                $OutboundVariance = new OutboundVariance;
                                                $OutboundVariance->ta_number = $OutboundHeader->outb_ta_number;
                                                $OutboundVariance->overall_gross_wt = $overallGrossweight;
                                                $OutboundVariance->overall_price = $overallRate;
                                                $OutboundVariance->last_updated_idoc = $idoc_number;
                                                $OutboundVariance->save(false);
                                            }
                                        }
                                    
                                        foreach ( $xml->IDOC[0]->E1EDL20[0]->E1EDL24 as $i=> $eachItem ){
                                                $OutboundItems = new OutboundItems;
                                                $OutboundItems->outb_delivery_note_no = $OutboundHeader->outb_delivery_note_no;
                                                $OutboundItems->outb_part_number = (int) $eachItem->MATNR;
                                                $OutboundItems->outb_description = str_replace("'","",$eachItem->ARKTX);
                                                $OutboundItems->outb_hs_code = $eachItem->E1EDL35->STAWN;
                                                $OutboundItems->outb_contry_of_origin_code = $eachItem->E1EDL35->HERKL;
                                                $OutboundItems->outb_contry_of_origin = $eachItem->E1EDL35->E1EDL36->HERKL_BEZ;
                                                //$OutboundItems->outb_invoice_rate = $eachItem->Z1EDL02->KBETR;
                                                $OutboundItems->outb_invoice_rate=round((((double)$eachItem->Z1EDL02->KBETR*(double)$eachItem->LFIMG)/(double)$eachItem->Z1EDL02->KPEIN), 2);
                                                
                                                //Taxable Local transport
                                                if( $isTaxable )
                                                    $OutboundItems->outb_invoice_rate +=  round(($OutboundItems->outb_invoice_rate*0.05), 2); // 5% VAT
                                                
                                                $OutboundItems->outb_currency_code = $eachItem->Z1EDL02->KONWA;
                                                $OutboundItems->outb_no_of_pieces = $eachItem->Z1EDL24_outb_INVOICE->PUNIT;
                                                $OutboundItems->outb_pieces_unit = $eachItem->Z1EDL24_outb_INVOICE->KUNIT;
                                                $OutboundItems->outb_quantity = $eachItem->LFIMG;
                                                $OutboundItems->outb_current_qty = $eachItem->LFIMG;
                                                $OutboundItems->outb_quantity_unit = $eachItem->VRKME;
                                                $gross_weight = $eachItem->BRGEW;
                                                $net_weight   = $eachItem->NTGEW;
                                                if( $eachItem->GEWEI == 'GRM' ){
                                                    $gross_weight = $gross_weight/1000;    
                                                    $net_weight = $net_weight/1000;
                                                }
                                                
                                                $OutboundItems->outb_net_wt = $net_weight;
                                                $OutboundItems->outb_gross_wt = $gross_weight;
                                                $OutboundItems->outb_added_date = $OutboundHeader->outb_added_date;
                                                $OutboundItems->save(false);
                                            }
                                        }
                                    //remove comment line if in production mode
                                    ftp_put($connection,$archive_path.$filename,'idocs/'.$filename, FTP_BINARY);
                                    ftp_delete($connection,$file_path.$filename);
                                }
                            }
                        }
                    }
                }
                $jsonData['status'] = 'success';
            }else
                $jsonData['status'] = 'fail';
        }else
            $jsonData['status'] = 'fail';
        
        ftp_close($connection);
        $this->Connect();
        echo CJSON::encode($jsonData);
    }

    public function actionBillofexit(){
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.js' => false);
        $this->render('bill_of_exit');
    } 

    // public function actionUpdatebillofexit(){
        
    //     $ta_number = $_POST['ta_number'];
    //     $bill_of_exit_no = $_POST['bill_of_exit_no'];
    //     $bill_of_exit_date = $_POST['bill_of_exit_date'];
    //     $status = array();
    //     if( $ta_number != '' && $bill_of_exit_no != '' && $bill_of_exit_date != ''){
    //         $outbound = Outbound::model()->find(array('condition' => 'outb_ta_number="'.$ta_number.'"'));
    //         if( $outbound->outb_delivery_note_no > 0 ){
    //             if(  (int) Ledger::model()->find(array( 'condition' => 'delivery_note="'.$outbound->outb_delivery_note_no.'" AND type="OUT"' ))->id == 0 ){
    //                 Outbound::model()->updateAll(array( 'outb_bill_of_exit_no' => $bill_of_exit_no, 'outb_bill_of_exit_date' => date("Y-m-d", strtotime(str_replace('/', '-', $bill_of_exit_date))) ), 'outb_ta_number = "'.$ta_number.'"' );
    //                 $variance = OutboundVariance::model()->findByPk($ta_number);
    //                 if( $variance->ta_number > 0 && $variance->isUpdated == 'N' ){
                        
    //                     $query = 'SELECT SUM(II.outb_gross_wt) AS gross, SUM(II.outb_invoice_rate) AS rate FROM ht_outbound_items II LEFT JOIN ht_outbound I ON II.outb_delivery_note_no = I.outb_delivery_note_no WHERE I.outb_ta_number = "'.$ta_number.'" ';
    //                     $data  = Yii::app()->db->createCommand($query)->queryAll();
    //                     if( $variance->overall_gross_wt > $data[0]['gross'] || $variance->overall_price > $data[0]['rate'] ){
    //                         if( $variance->overall_gross_wt > $data[0]['gross'] )
    //                             Yii::app()->db->createCommand('UPDATE ht_outbound_items SET outb_gross_wt=outb_gross_wt+'.($variance->overall_gross_wt - $data[0]['gross']).' WHERE outb_delivery_note_no="'.$outbound->outb_delivery_note_no.'" LIMIT 1')->execute();
    //                         if( $variance->overall_price > $data[0]['rate'] )
    //                             Yii::app()->db->createCommand('UPDATE ht_outbound_items SET outb_invoice_rate=outb_invoice_rate+'.($variance->overall_price - $data[0]['rate']).' WHERE outb_delivery_note_no="'.$outbound->outb_delivery_note_no.'" LIMIT 1')->execute();
    //                         $variance->isUpdated = 'Y';
    //                         $variance->save(false);
    //                     }
    //                 }
    //                 $status['status'] = 'success';
    //             }else{
    //                 $status['status'] = 'success';
    //                 Outbound::model()->updateAll(array( 'outb_bill_of_exit_no' => $bill_of_exit_no, 'outb_bill_of_exit_date' => date("Y-m-d", strtotime(str_replace('/', '-', $bill_of_exit_date))) ), 'outb_ta_number = "'.$ta_number.'"' );
    //             }
    //         }else{
    //             $status[] = 'TA No not found!';
    //         }
    //     }else{
    //         if( $ta_number == '')
    //             $status[] = 'TA No Cannot Blank';
    //         if( $bill_of_exit_no == '')
    //             $status[] = 'BOE No Cannot Blank';
    //         if( $bill_of_exit_date == '')
    //             $status[] = 'BOE Date Cannot Blank';
            
    //     }
    //     $this->Connect();
    //     echo CJSON::encode($status);
    // }

    public function actionUpdatebillofexit(){
        
        $ta_number = $_POST['ta_number'];
        $bill_of_exit_no = $_POST['bill_of_exit_no'];
        $bill_of_exit_date = $_POST['bill_of_exit_date'];
        $status = array();
        if( $ta_number != '' && $bill_of_exit_no != '' && $bill_of_exit_date != ''){
            $variance = OutboundVariance::model()->findByPk($ta_number);
            if( $variance->ta_number > 0 && $variance->isUpdated == 'N' ){
                $status[] = 'Please calculate variance!';
            }else{
                $outbound = Outbound::model()->find(array('condition' => 'outb_ta_number="'.$ta_number.'"'));
                if( $outbound->outb_delivery_note_no > 0 ){
                    $status['status'] = 'success';
                    Outbound::model()->updateAll(array( 'outb_bill_of_exit_no' => $bill_of_exit_no, 'outb_bill_of_exit_date' => date("Y-m-d", strtotime(str_replace('/', '-', $bill_of_exit_date))) ), 'outb_ta_number = "'.$ta_number.'"' );
                    $deliveryNoteQuery = 'SELECT GROUP_CONCAT(outb_delivery_note_no) AS dns FROM ht_outbound WHERE outb_ta_number="'.$ta_number.'"';
                    $deliveryIds = Yii::app()->db->createCommand($deliveryNoteQuery)->queryAll();
                    $updateQuery = 'UPDATE ht_ledger SET shipment_reference="'.$bill_of_exit_no.'", shipment_date="'.date("Y-m-d", strtotime(str_replace('/', '-', $bill_of_exit_date))).'" WHERE delivery_note IN('.$deliveryIds[0]['dns'].') AND type="OUT"';
                    Yii::app()->db->createCommand($updateQuery)->execute();
                }else{
                    $status[] = 'TA No not found!';
                }
            }
        }else{
            if( $ta_number == '')
                $status[] = 'TA No Cannot Blank';
            if( $bill_of_exit_no == '')
                $status[] = 'BOE No Cannot Blank';
            if( $bill_of_exit_date == '')
                $status[] = 'BOE Date Cannot Blank';
            
        }
        $this->Connect();
        echo CJSON::encode($status);
    }

    public function actionCreate(){
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.js' => false);
        $delivery = (int) Yii::app()->request->getParam('dn');
        $model = new Outbound;
        $items = array( new OutboundItems );
        if( $delivery > 0 ){
            $model  = Outbound::model()->findByPk($delivery);
            $items  = OutboundItems::model()->findAll(array('condition' => 'outb_delivery_note_no='.$delivery));
        }
        $this->render('outbound',array('model' => $model, 'items' => $items));
    }

    public function actionRemoveItems(){
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.js' => false);
        $items  = OutboundItems::model()->findAll(array('condition' => 'outb_delivery_note_no='.(int) Yii::app()->request->getParam('dn')));
        $this->render('removeitems',array('items' => $items, 'dn' => (int) Yii::app()->request->getParam('dn') ));
    }

    public function actionUpdateidocdetails(){
        if(isset($_POST['Outbound'])){
            if( $_POST['Outbound']['outb_delivery_note_no'] > 0 ){
                $outbound = Outbound::model()->findByPk( (int) $_POST['Outbound']['outb_delivery_note_no']);
                $outbound->outb_bill_of_exit_no = $_POST['Outbound']['outb_bill_of_exit_no'];
                $outbound->outb_ta_number = $_POST['Outbound']['outb_ta_number'];
                if( $_POST['Outbound']['outb_bill_of_exit_no'] != '' && $_POST['Outbound']['outb_bill_of_exit_date'] != ''){
                    $outbound->outb_bill_of_exit_no = $_POST['Outbound']['outb_bill_of_exit_no'];
                    $outbound->outb_bill_of_exit_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['Outbound']['outb_bill_of_exit_date'])));
                }else{
                    $outbound->outb_bill_of_exit_no = '';
                    $outbound->outb_bill_of_exit_date = '';
                }
                $outbound->save(false);
                if(is_array($_POST['OutboundItems'])){
                    foreach( $_POST['OutboundItems'] as $each ){
                        $OutboundItems = OutboundItems::model()->findByPk($each['id']);

                        $oldGrosswt = $OutboundItems->outb_gross_wt;
                        $oldPrice = $OutboundItems->outb_invoice_rate;

                        $OutboundItems->attributes = $each;
                        if( $oldGrosswt != $each['outb_gross_wt'] ){
                            $OutboundItems->outb_weight_updated = "Y";
                            $OutboundItems->outb_weight_last_updated_by = Yii::app()->user->id;
                            $OutboundItems->outb_weight_last_updated_date_time = date('Y-m-d h:i:s');
                            $this->Writelog("User ".Yii::app()->user->fullname." Changed weight of Item ".
                                            $OutboundItems->outb_part_number." to ".$each['outb_gross_wt']." from ".$each['old_gross_wt'].
                                            " of Delivery note ".$_POST['Outbound']['outb_delivery_note_no']." and TA no ".$_POST['Outbound']['outb_ta_number']);
                            $each_gross_wt = $each['outb_gross_wt'] / $each['outb_quantity'];
                            $query = 'UPDATE ht_ledger SET out_gross_wt=out_quantity*'.$each_gross_wt.' WHERE type="OUT" AND master_id='.$each['id'];
                            Yii::app()->db->createCommand($query)->execute();
                        }
                        if( $oldPrice != $each['outb_invoice_rate'] ){
                            $OutboundItems->outb_rate_updated = "Y";
                            $OutboundItems->outb_rate_last_updated_by = Yii::app()->user->id;
                            $OutboundItems->outb_rate_last_updated_date_time = date('Y-m-d h:i:s');
                            $this->Writelog("User ".Yii::app()->user->fullname." Changed rate of Item ".
                                            $OutboundItems->outb_part_number." to ".$each['outb_invoice_rate']." from ".$each['old_invoice_rate'].
                                            " of Delivery note ".$_POST['Outbound']['outb_delivery_note_no']." and TA no ".$_POST['Outbound']['outb_ta_number']);
                            $each_rate = $each['outb_invoice_rate'] / $each['outb_quantity'];
                            $query = 'UPDATE ht_ledger SET out_invoice_rate=out_quantity*'.$each_rate.' WHERE type="OUT" AND master_id='.$each['id'];
                            Yii::app()->db->createCommand($query)->execute();
                        }
                        $OutboundItems->save(false);
                    }
                }
            }
        }
        $status['status'] = 'success';
        echo CJSON::encode($status);
    }

    public function actionDownloadxml(){
        $deliverynote = (int) Yii::app()->request->getParam('dn');
        if( $deliverynote > 0 ){
            
            $path = Yii::getPathOfAlias('webroot') . "/idocs/" . Outbound::model()->findBypk($deliverynote)->outb_file_name;
            header("Content-type:application/octet-stream"); //for txt file
            header("Content-Type: application/download");
            header('Content-Disposition: attachment; filename="' . basename($path) . '"');
            header('Content-Length: ' . filesize($path));
            readfile($path);
            Yii::app()->end();
        }
    }

    public function actionDownloadcsv(){
        $deliverynote = (int) Yii::app()->request->getParam('dn');
        if( $deliverynote > 0 ){
            
            $outbound = Outbound::model()->findBypk($deliverynote);
            $OutboundItems = OutboundItems::model()->findAll(array('condition' => 'outb_delivery_note_no ='.$deliverynote));

            $file = fopen("csvs/".$outbound->outb_doc_no.".csv", "w");
            
            $list[] = 'Doc No$'.$outbound->outb_doc_no;
            $list[] = 'DN No$'.$outbound->outb_delivery_note_no;
            $list[] = 'BOE No$'.$outbound->outb_bill_of_exit_no ;
            $list[] = 'BOE Date$'.$outbound->outb_bill_of_exit_date  ;
            $list[] = 'TA No$'.$outbound->outb_ta_number  ;
            $list[] = 'Date$'.$outbound->outb_added_date ;
            $list[] = '$';

            $list[] = 'No$Part Number$Description$HS Code$country$currency$Rate$quantity$unit$weight';
            foreach ($OutboundItems as $i => $item) {
                 $list[] = ($i+1).'$'. 
                            $item->outb_part_number. '$'. 
                            $item->outb_description. '$'. 
                            $item->outb_hs_code. '$'. 
                            $item->outb_contry_of_origin . '$'. 
                            $item->outb_currency_code. '$'. 
                            $item->outb_invoice_rate. '$'. 
                            $item->outb_quantity. '$'. 
                            $item->outb_quantity_unit. '$'. 
                            $item->outb_net_wt;
            }

            foreach ($list as $line) {
                fputcsv($file, explode('$', $line));
            }
            fclose($file);
            $filename = 'csvs/'.$outbound->outb_doc_no.'.csv';
            $path = 'csvs';
            header('Content-Type: application/csv');
            header("Content-disposition: attachment; filename=\"".$outbound->outb_doc_no.".csv\"");
            readfile($filename);
            Yii::app()->end();
            return;
        }
    }

    public function actionDelete(){
        $dn =  $_POST['id'];
        if( $dn > 0 ){
            Outbound::model()->deletebypk($dn);
            OutboundItems::model()->deleteAll('outb_delivery_note_no =:refer_id', array( ':refer_id' => $dn ));
            $this->Writelog("User ".Yii::app()->user->fullname." Deleted Delivery Note ".$dn);
            echo 'success';
        }else{
            echo 'fail';
        }
    }

        public function actionDownloadsaso(){
        $deliverynote = (int) Yii::app()->request->getParam('dn');
        if( $deliverynote > 0 ){
            
            $outbound = Outbound::model()->findBypk($deliverynote);
            $OutboundItems = OutboundItems::model()->findAll(array('condition' => 'outb_delivery_note_no ='.$deliverynote));
            
            $file = fopen("csvs/saso_".$outbound->outb_doc_no.".csv", "w");
           
            $list[] = 'Part Number$Description$HS Code$country$Rate$quantity$weight';
            
            $total_qty = $total_wt = 0;
            foreach ($OutboundItems as $i => $item) {
                 $list[] =
                            $item->outb_part_number. '$'. 
                            $item->outb_description. '$'. 
                            $item->outb_hs_code. '$'. 
                            $item->outb_contry_of_origin . '$'. 
                            $item->outb_invoice_rate. '$'. 
                            $item->outb_quantity. '$'. 
                            $item->outb_gross_wt;

                            $total_qty += $item->outb_quantity;
                            $total_wt += $item->outb_gross_wt;
            }
            $list[] = '$$$$$'. $total_qty.'$'.$total_wt;

            foreach ($list as $line) {
                fputcsv($file, explode('$', $line));
            }
            fclose($file);
            $filename = 'csvs/saso_'.$outbound->outb_doc_no.'.csv';
            $path = 'csvs';
            header('Content-Type: application/csv');
            header("Content-disposition: attachment; filename=\"saso_".$outbound->outb_doc_no.".csv\"");
            readfile($filename);
            Yii::app()->end();
            return;
        }
    }

    public function actionDownloadwr(){
        $ta_no = (int) Yii::app()->request->getParam('ta');
        if( $ta_no > 0 ){
            $OutboundItems = OutboundItems::model()->with('parent')->findAll(array('condition' => 'parent.outb_ta_number ='.$ta_no));
            
            $file = fopen("csvs/wr_".$ta_no.".csv", "w");
            
            $list[] = 'Part Number$Description$HS Code$country$Rate$quantity$weight';
            
            foreach ($OutboundItems as $i => $item) {
                 $list[] =
                            $item->outb_part_number. '$'. 
                            $item->outb_description. '$'. 
                            $item->outb_hs_code. '$'. 
                            $item->outb_contry_of_origin . '$'. 
                            $item->outb_invoice_rate. '$'. 
                            $item->outb_quantity. '$'. 
                            $item->outb_gross_wt;

            }

            foreach ($list as $line) {
                fputcsv($file, explode('$', $line));
            }

            fclose($file);
            $filename = 'csvs/wr_'.$ta_no.'.csv';
            $path = 'csvs';
            header('Content-Type: application/csv');
            header("Content-disposition: attachment; filename=\"wr_".$ta_no.".csv\"");
            readfile($filename);
            Yii::app()->end();
            return;
        }
    }

    public function actionDeleteitems(){
        if(is_array($_POST['OutboundItems'])){
            foreach( $_POST['OutboundItems'] as $each ){
                if( isset($each['checked']) ){
                    OutboundItems::model()->deleteBypk( (int) $each['id']);
                    $this->Writelog("User ".Yii::app()->user->fullname." Deleted Item ".$each['outb_part_number']." of delivery note ".$_POST['deliveynote']);
                }
            }
        }
        $data['status'] = 'success';
        echo json_encode($data);
    }

     public function Connect(){
        
        ini_set('max_execution_time', -1);
        
        $outbound = OutboundItems::model()->with('parent')->findAll( array( 'condition' => 't.outb_posted ="N" AND parent.outb_bill_of_exit_no != ""', 'order' => 'parent.outb_bill_of_exit_date ASC', 'limit' => 10000) );
        
        NonstockItems::model()->deleteAll();
        date_default_timezone_set("Asia/Dubai");
        
        if( !empty($outbound) ){
            foreach( $outbound as $eachItem ){
                
                $total_qty = Yii::app()->db->createCommand("SELECT SUM(quantity) FROM ht_current_stock WHERE part_number = '".trim(strtolower($eachItem->outb_part_number))."'  ")->queryScalar();  //AND bill_of_entry_date <= '".$eachItem->parent->outb_bill_of_exit_date."'
                
                if($total_qty < $eachItem->outb_quantity){
                    $nonStock = new NonstockItems;
                    $nonStock->part_number = trim($eachItem->outb_part_number);
                    $nonStock->current_stock = $total_qty;
                    $nonStock->stock_required = $eachItem->outb_quantity;
                    $nonStock->outbound_deliverynote = $eachItem->outb_delivery_note_no;
                    $nonStock->outbound_item_id = $eachItem->id;
                    $nonStock->created_date_time = date('Y-m-d h:i:s');
                    $nonStock->save(false);
                }else{
                    $connected_inbound = Stock::model()->findAll( array( 'condition' => "part_number = '".trim(strtolower($eachItem->outb_part_number))."' AND quantity > 0  ", 'order' => 'bill_of_entry_date ASC' ) );   //AND bill_of_entry_date <= '".$eachItem->parent->outb_bill_of_exit_date."'
                    $required = $eachItem->outb_quantity;
                    foreach( $connected_inbound as $eachInbound ){
                        if( $required > 0 ){
                            if( $required >= $eachInbound->quantity ){
                                
                                $required -= $eachInbound->quantity;
                               
                                $ledger = new Ledger;
                                $ledger->stock_id = $eachInbound->id;
                                $ledger->master_id = $eachItem->id;  //outbound
                                $ledger->warehouse_id = $eachInbound->warehouse;
                                $ledger->part_number = trim(strtolower($eachItem->outb_part_number));
                                $ledger->description = $eachItem->outb_description;
                                $ledger->delivery_note =  $eachItem->outb_delivery_note_no;
                                $ledger->shipment_reference =  $eachItem->parent->outb_bill_of_exit_no;
                                $ledger->shipment_date = $eachItem->parent->outb_bill_of_exit_date;
                                $ledger->out_invoice_rate = $eachItem->outb_invoice_rate;
                                $ledger->out_gross_wt = $eachItem->outb_gross_wt;
                                $ledger->out_quantity  = $eachInbound->quantity;
                                $ledger->type  = 'OUT';
                                $ledger->created_date = date('Y-m-d h:i:s');
                                $ledger->save(false);
                                
                                $eachInbound->quantity = 0;
                                $eachInbound->save(false);
                            }else{
                                
                                $ledger = new Ledger;
                                $ledger->stock_id = $eachInbound->id;
                                $ledger->master_id = $eachItem->id;  //outbound
                                $ledger->warehouse_id = $eachInbound->warehouse;
                                $ledger->part_number = trim(strtolower($eachItem->outb_part_number));
                                $ledger->description = $eachItem->outb_description;
                                $ledger->delivery_note =  $eachItem->outb_delivery_note_no;
                                $ledger->shipment_reference =  $eachItem->parent->outb_bill_of_exit_no;
                                $ledger->shipment_date = $eachItem->parent->outb_bill_of_exit_date;
                                $ledger->out_invoice_rate = ($eachItem->outb_invoice_rate/$eachItem->outb_quantity)  * $required ;
                                $ledger->out_gross_wt = ($eachItem->outb_gross_wt/$eachItem->outb_quantity) * $required;
                                $ledger->out_quantity  = $required;
                                $ledger->type  = 'OUT';
                                $ledger->created_date = date('Y-m-d h:i:s');
                                $ledger->save(false);
                                
                                $eachInbound->quantity -= $required;
                                $eachInbound->save(false);
                                $required = 0;
                            }
                        }
                    }
                    Outbound::model()->updatebypk($eachItem->outb_delivery_note_no,array( 'outb_delivery_note_posted' => 'Y' ));
                    $eachItem->outb_posted = "Y";
                    $eachItem->save(false);
                }
            }
        }
    }


    public function actionCalculatevariance(){
        
        $ta_number = $_POST['taNumber'];
        $deliveryNote = $_POST['deliveryNote'];

        $variance = OutboundVariance::model()->findByPk($ta_number);
        if( $variance->ta_number > 0 && $variance->isUpdated == 'N' ){
            $query = 'SELECT SUM(II.outb_gross_wt) AS gross, SUM(II.outb_invoice_rate) AS rate FROM ht_outbound_items II LEFT JOIN ht_outbound I ON II.outb_delivery_note_no = I.outb_delivery_note_no WHERE I.outb_ta_number = "'.$ta_number.'" ';
            $data  = Yii::app()->db->createCommand($query)->queryAll();
            if( $variance->overall_gross_wt > $data[0]['gross'] || $variance->overall_price > $data[0]['rate'] ){
                if( $variance->overall_gross_wt > $data[0]['gross'] )
                    Yii::app()->db->createCommand('UPDATE ht_outbound_items SET outb_gross_wt=outb_gross_wt+'.($variance->overall_gross_wt - $data[0]['gross']).' WHERE outb_delivery_note_no="'.$deliveryNote.'" LIMIT 1')->execute();
                if( $variance->overall_price > $data[0]['rate'] )
                    Yii::app()->db->createCommand('UPDATE ht_outbound_items SET outb_invoice_rate=outb_invoice_rate+'.($variance->overall_price - $data[0]['rate']).' WHERE outb_delivery_note_no="'.$deliveryNote.'" LIMIT 1')->execute();
            }
            $variance->isUpdated = 'Y';
            $variance->save(false);
        }
        echo 'success';
     }

     public function actionCustomerlist(){
        $term = Yii::app()->request->getParam('term');
        $response = array();
        if( trim($term) != ""){
            $customerList = Customers::model()->findAll( array('condition'=>'name LIKE "%'.$term.'%"', 'limit' => 500) );
            foreach ( $customerList as $i => $each ){
                $response[$i]['label'] = $each->name;
                $response[$i]['value'] = $each->id;
                $response[$i]['billing_adds'] = $each->billing_adds;
                $response[$i]['shipping_adds'] = $each->shipping_adds;
            }
        }
        echo json_encode($response);
    }

    public function actionProductlist(){
        $term = Yii::app()->request->getParam('term');
        $response = array();
        if( trim($term) != ""){
            $productList = Stock::model()->with('warehouseDetails')->findAll( array( 'select' => 'quantity, deliverynote_item_id, part_number, deliverynote, id, description, net_wt, gross_wt, cbm', 'condition'=>'warehouseDetails.isDefault="Y" AND quantity > 0 AND ( description LIKE "%'.$term.'%" OR part_number LIKE "%'.$term.'%" )', 'limit' => 100) );
            foreach ( $productList as $i => $each ){
                $query = "SELECT SUM(balance) FROM ( SELECT SUM(CS.quantity) AS balance,
                        WH.name AS warehouse
                    FROM nia_current_stock CS LEFT JOIN nia_warehouses WH ON WH.id = CS.warehouse WHERE CS.part_number = '".$each->part_number."' AND deliverynote = '".$each->deliverynote."' GROUP BY CS.id, CS.bill_of_entry, CS.warehouse ) AS A WHERE A.balance > 0 ";
                $bal_qty = Yii::app()->db->createCommand($query)->queryScalar();
                $query1 = "SELECT SUM(outb_quantity) FROM nia_outbound O inner join `nia_outbound_items` OI ON O.outb_delivery_note_no = OI.outb_delivery_note_no where OI.outb_part_number = '".$each->part_number."' AND OI.outb_stock_id=".$each->id." AND O.outb_delivery_note_posted='N'";
                $bal_qty_not_connect = Yii::app()->db->createCommand($query1)->queryScalar();
                $items=ItemMaster::model()->findByPk($each->part_number);
                $response[$i]['label'] = $each->part_number.' | '.$each->deliverynote.' | Qty : '.($bal_qty-$bal_qty_not_connect);
                $response[$i]['value'] = $each->part_number;
                $response[$i]['stock_id'] = $each->id;
                $response[$i]['description'] = $each->description;
                $response[$i]['unit'] = $each->inboundRelation->inb_quantity_unit;
                $response[$i]['coo'] = $each->inboundRelation->inb_contry_of_origin;
                $response[$i]['hsc'] = $each->inboundRelation->inb_hs_code;
                $response[$i]['nt_weight'] = $each->net_wt;
                $response[$i]['gr_weight'] = $each->gross_wt;
                $response[$i]['cbm'] = $each->cbm;
                $response[$i]['quantity'] = $each->quantity;
                $response[$i]['rate'] = $items->rate;
                $response[$i]['brand_id'] = $items->brand_id;
                $response[$i]['category_id'] = $items->category_id;
                $response[$i]['rate2'] = $items->rate2;
                $response[$i]['rate3'] = $items->rate3;
            }
        }
        echo json_encode($response);
    }

    public function actionSave(){
        if( isset($_POST['Outbound']) ){
            $mainModel = new Outbound;
            $productsArray = array();
            
            function checkAvailablity($items){
                
                $validationResponse = array();
                $qtyErrors = array();
                $validationResponse['isValid'] = true;

                foreach( $items as  $eachStock ){
                    $currentStock = Stock::model()->findBypk((int) $eachStock['id'] );
                    $quantityAvailable = (float) $currentStock->quantity;
                    $validationResponse['isValid'] = ( $eachStock['quantity'] <= $quantityAvailable && $validationResponse['isValid'] ) ? true : false; 
                    if( $eachStock['quantity'] > $quantityAvailable )
                        $qtyErrors[] = 'Quantity available for item '.$eachStock['part_no'].' ( REF # : '.$currentStock->deliverynote.') is '.$quantityAvailable;
                }

                $validationResponse['errors'] = $qtyErrors;
                return $validationResponse;
            }
            
            if( (int) $_POST['Outbound']['outb_delivery_note_no'] > 0 )
                $mainModel = $mainModel->findbypk($_POST['Outbound']['outb_delivery_note_no']);
            $mainModel->attributes = $_POST['Outbound'];
            $mainModel->outb_doc_no = 'N/A';
            $mainModel->outb_file_name = 'N/A';
            $mainModel->outb_added_date = ( count(explode('/',  $_POST['Outbound']['outb_added_date'])) == 3 ) ? date('Y-m-d', strtotime(str_replace('/', '-', $_POST['Outbound']['outb_added_date']))) : date('Y-m-d');
            $mainModel->outb_shipping_address = $_POST['Outbound']['outb_shipping_address'];
            $mainModel->outb_billing_address = $_POST['Outbound']['outb_billing_address'];
            $mainModel->outb_shipping_condition = $_POST['Outbound']['outb_shipping_condition'];
            $mainModel->outb_terms_and_conditions = $_POST['Outbound']['outb_terms_and_conditions'];
            $mainModel->isDirectDelivery = $_POST['Outbound']['isDirectDelivery'];
            $valid = $mainModel->validate();
            $itemsModel = array();
            $i = 0;
            $total_wt = 0;
            foreach( $_POST['OutboundItems'] as $each ){
                if( $each['outb_stock_id'] > 0 ){
                    $itemsModel[$i] = new OutboundItems;
                    $itemsModel[$i]->attributes = $each;
                    $itemsModel[$i]->outb_quantity = ( (float) $itemsModel[$i]->outb_quantity > 0 ) ? $itemsModel[$i]->outb_quantity : '';
                    $itemsModel[$i]->outb_delivery_note_no = 0;
                    $itemsModel[$i]->outb_stock_id = $each['outb_stock_id'];
                    //Update 
                    $itemsModel[$i]->outb_net_wt = round(($each['outb_quantity'] *  $each['per_net_wt']), 3);
                    $itemsModel[$i]->outb_gross_wt =round(($each['outb_quantity'] * $each['per_gross_wt']), 3);
                    $itemsModel[$i]->outb_cbm = round(($each['outb_quantity'] * $each['per_cbm']), 3);
                    //Update end
                    $valid = $valid && $itemsModel[$i]->validate();
                    $total_wt += (float) $each['outb_gross_wt'];
                    
                    $productsArray[$each['outb_stock_id']]['id'] = $each['outb_stock_id'];
                    $productsArray[$each['outb_stock_id']]['part_no'] = $each['outb_part_number'];
                    $productsArray[$each['outb_stock_id']]['quantity'] = (float) $productsArray[$itemsModel[$i]->outb_stock_id]['quantity'] + (float) $each['outb_quantity'];
                    
                    $i++;
                }
            }
            $validQty = checkAvailablity($productsArray);
            if( $valid && count($itemsModel) > 0 && $validQty['isValid'] ){
                echo json_encode(array('status'=>'success'));
                $mainModel->outb_total_weight = $total_wt;
                $mainModel->save(false);
                if( $mainModel->isDirectDelivery == 'Y' )
                    Inbound::model()->updateAll(array( 'isDelivered' => 'Y'  ), 'inb_bill_of_entry_no = "'.$mainModel->outb_awb_no.'"' );
                OutboundItems::model()->deleteAll('outb_delivery_note_no=:refer_id', array(':refer_id' => $mainModel->outb_delivery_note_no));
                foreach( $itemsModel as $eachItem ){
                    $eachItem->outb_delivery_note_no = $mainModel->outb_delivery_note_no;
                    $eachItem->save(false);
                }
            }else{
                $error2 = array();
                $error1 = json_decode(CActiveForm::validate($mainModel, '', false), true);
                if ( count($itemsModel) > 0 )
                    $error2 = json_decode(CActiveForm::validateTabular($itemsModel, '', false), true);
                else
                    $error2[] = "Please add atleast one line item";
                echo CJSON::encode(array_merge_recursive($error1, $error2, $validQty['errors']));
            }
        }
    }
    public function actionPrint() {
        $id = Yii::app()->request->getParam('id');
        $view = Yii::app()->request->getParam('view');
        $logo = (int) Yii::app()->request->getParam('logo');
        $destination = (int) Yii::app()->request->getParam('destination');
        $print_type = (int) Yii::app()->request->getParam('print_type');
       
        $arr_logos = array(
            1 => 'pdf_nia_limited.png',
            2 => 'pdf_nia_general_llc.png',
            3 => 'pdf_magnum.png',
            4 => 'pdf_flair_global.png'
        );
        
        $arr_company_name = array(
            1 => Yii::app()->user->footer_line_one_1,
            2 => Yii::app()->user->footer_line_two_1,
            3 => Yii::app()->user->footer_line_three_1,
            4 => Yii::app()->user->footer_line_four_1
        );
        
        $arr_company_address = array(
            1 => Yii::app()->user->footer_line_one_2,
            2 => Yii::app()->user->footer_line_two_2,
            3 => Yii::app()->user->footer_line_three_2,
            4 => Yii::app()->user->footer_line_four_2
        );
        
        
        
        $arr_mirshal_2_code = array(
            1 => "AE-1044942",
            2 => "AE-1007911",
            3 => "AE-1025296",
            4 => "AE-1128013"
        );

        $arr_licence_no =  array(
            1 => "1956",
            2 => "",
            3 => "",
            4 => "164019"
        );
        
        $arr_trn_no = array(
            1 => Yii::app()->user->trn_1,
            2 => Yii::app()->user->trn_2,
            3 => Yii::app()->user->trn_3,
            4 => Yii::app()->user->trn_4
        );

        $arr_billing_address = array(
            1 => Yii::app()->user->address_1,
            2 => Yii::app()->user->address_2,
            3 => Yii::app()->user->address_3,
            4 => Yii::app()->user->address_4
        );

        $arr_formatted = array(
            
            1 => '<p>No.27, Street S112, JAFZA South, Dubai, UAE 
                    <br><br>PO Box 13616, P + 971-4-8807273, F + 971-4-8807089<br><br>
                    E info@nialimited.com</p><br><br><br>',
            
            2 => '<p>No. 24, Ground Floor, Masraf Tower, Dubai, UAE<br><br>
                PO Box 13616, P + 971-4-2952080, F + 971-4-2953080<br><br>
                E info@nialimited.com</p><br><br><br>',
            
            3 => '<p>Office No 17, Ground Floor, Masraf Tower, Dubai, UAE<br><br>
                P + 971-4-3240340<br><br>
                E info@supermagnumtech.com</p><br><br><br>',
            
            4 => '<p>Office No 17, Ground Floor, Masraf Tower, Dubai, UAE<br><br>
                P + 971-4-3240340<br><br>
                E info@supermagnumtech.com</p><br><br><br>',
        );

        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');
        $mpdf->WriteHTML(file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css'), 1);
       
        $mpdf->WriteHTML($this->renderPartial('application.views.front.pdf.'.$view, array('trn_no' => $arr_trn_no[$logo], 'address' => $arr_billing_address[$logo], 'id' => $id, 'logo' => $arr_logos[$logo], 'company_name' => $arr_company_name[$logo], 'company_address' => $arr_company_address[$logo],'logo_display'=>$logo,'mirshal_2_code'=>$arr_mirshal_2_code[$logo], 'licence_no' => $arr_licence_no[$logo], 'formatted_address' => $arr_formatted[$logo], 'destination'=>$destination, 'print_type'=>$print_type),true));
        $mpdf->Output($view.".pdf", 'I');
    }

    public function actionCustomers() {
        $this->render('customers');
    }

    public function actionGetcustomers(){
        $model  = new Customers();
        $draw   = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'name',
            2 => 'email', 
            3 => 'billing_adds', 
            4 => 'id'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir']; 
        $orderBy   = $filterColumn." ".$filterOrder;
        $condition = '1=1';
        if(isset($_POST['search']['value']) && trim($_POST['search']['value']) !="")
        {
            $searchString = trim($_POST['search']['value']);
            $condition.=" AND (name LIKE '%".$searchString."%' OR email LIKE '%".$searchString."%' OR billing_adds LIKE '%".$searchString."%')";
        }
        $count = $model->count(array('condition'=>$condition));
        $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $eachItemData=array();
        $m=1;
        foreach ($model as $eachItem)
        {
           
            $div  = '<div class="btn-wrap text-center">';
            $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'outbound/createcustomer&id='.$eachItem['id'].'\',\''.$eachItem['name'].'\',\'lg\')"><i class="fa fa-pencil"></i></button>';
            $div .= '</div>';
            $eachItemData[]=array($eachItem['id'],$eachItem['name'],$eachItem['email'],nl2br($eachItem['billing_adds']), $div);
          
        }
        $data['data'] = $eachItemData;
        echo json_encode($data);
    }
    public function actionCreatecustomer(){
        
        $id = (int) Yii::app()->request->getParam('id');
        $model = new Customers;
        if( $id > 0 )
            $model = $model->findbypk($id);
        
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.js' => false);
        $this->render('create_customer', array( 'model'=> $model ));
    }

    public function actionSavecustomer(){
        if(isset($_POST)){
            $model = new Customers;
            if( (int) $_POST['Customers']['id'] > 0 )
                $model = $model->findbypk($_POST['Customers']['id']);
                $model->attributes = $_POST['Customers'];
            if( $model->validate() ){
                $model->save();
                echo json_encode(array('status' => 'success'));
            }else{
                echo CActiveForm::validate($model, '', false);
            }
        }
    }

    public function actionRenderdirectdelivery(){
        $this->render('direct_delivery_items', array( 'boe' =>  trim($_POST['boe']) ));
    }
    public function actionRendercustomdelivery(){
        $this->render('custom_delivery_items');
    }

    public function actionCustomers_original() {
        $this->render('customers_original');
    }

    public function actionGetcustomers_original(){
        $model  = new CustomersOriginal();
        $draw   = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'name',
            2 => 'email', 
            3 => 'billing_adds', 
            4 => 'id'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir']; 
        $orderBy   = $filterColumn." ".$filterOrder;
        $condition = '1=1';
        if(isset($_POST['search']['value']) && trim($_POST['search']['value']) !="")
        {
            $searchString = trim($_POST['search']['value']);
            $condition.=" AND (name LIKE '%".$searchString."%' OR email LIKE '%".$searchString."%' OR billing_adds LIKE '%".$searchString."%')";
        }
        $count = $model->count(array('condition'=>$condition));
        $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $eachItemData=array();
        $m=1;
        foreach ($model as $eachItem)
        {
           
            $div  = '<div class="btn-wrap text-center">';
            $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'outbound/createcustomer_original&id='.$eachItem['id'].'\',\''.$eachItem['name'].'\',\'lg\')"><i class="fa fa-pencil"></i></button>';
            $div .= '</div>';
            $eachItemData[]=array($eachItem['id'],$eachItem['name'],$eachItem['email'],nl2br($eachItem['billing_adds']), $div);
          
        }
        $data['data'] = $eachItemData;
        echo json_encode($data);
    }
    public function actionCreatecustomer_original(){
        
        $id = (int) Yii::app()->request->getParam('id');
        $model = new CustomersOriginal;
        if( $id > 0 )
            $model = $model->findbypk($id);
        
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.js' => false);
        $this->render('create_customer_original', array( 'model'=> $model ));
    }

    public function actionSavecustomer_original(){
        if(isset($_POST)){
            $model = new CustomersOriginal;
            if( (int) $_POST['CustomersOriginal']['id'] > 0 )
                $model = $model->findbypk($_POST['CustomersOriginal']['id']);
                $model->attributes = $_POST['CustomersOriginal'];
            if( $model->validate() ){
                $model->save();
                echo json_encode(array('status' => 'success'));
            }else{
                echo CActiveForm::validate($model, '', false);
            }
        }
    }
}