<?php

class MigrationController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('importIndata','ImportOutdata', 'Setflags', 'Fixrate', 'initemSetflags', 'FixWt'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array('accessControl'); // perform access control for CRUD operations
    }

    public function actionImportIndata(){
        ini_set('max_execution_time', -1);
        $idocsIn = Idoc::model()->findAll();
        $list = array();
        if( !empty($idocsIn) ){
            $file = fopen("inbound_migration_log.csv", "w");
            foreach ( $idocsIn as $eachIdoc) {
                $msg = '';
                if($eachIdoc->delivery_note != ''){
                    $items = Stocks::model()->findAll(array('condition' => 'delivery_note="'.$eachIdoc->delivery_note.'"'));
                    if(!empty($items)){
                        
                        $inbound = Inbound::model()->findByPk($eachIdoc->delivery_note);
                        if( $inbound->inb_delivery_note_no > 0 ){
                             $msg .= $eachIdoc->doc_no.'$'.'Already Exist';
                        }else{
                            $inMain = new Inbound;
                            $inMain->inb_delivery_note_no = $eachIdoc->delivery_note;
                            $inMain->inb_bill_of_entry_no = $eachIdoc->bill_of_entry;
                            $deliverynoteRelation = DeliverynoteRelation::model()->findBypk($eachIdoc->delivery_note);
                            if( $deliverynoteRelation->delivery_note > 0 ){
                                $inMain->inb_ta_number = $deliverynoteRelation->ta_no;
                            }else{
                                $msg .= $eachIdoc->doc_no.'$'.'TA Number blank';
                            }
                            $inMain->inb_bill_of_entry_date = $eachIdoc->bill_date;
                            $inMain->inb_added_date = $eachIdoc->added_date;
                            $inMain->inb_doc_no = $eachIdoc->doc_no;
                            $inMain->inb_delivery_note_posted = "N";
                            if( $inMain->save(false) ){
                                foreach( $items as $eachItem ){
                                    $inDetails = new InboundItems;
                                    $inDetails->inb_delivery_note_no = $eachIdoc->delivery_note;
                                    $inDetails->inb_part_number = $eachItem->item_no;
                                    $inDetails->inb_description = $eachItem->description;
                                    $inDetails->inb_hs_code = $eachItem->hs_code;
                                    $inDetails->inb_contry_of_origin_code = $eachItem->contry_of_origin_code;
                                    $inDetails->inb_contry_of_origin = $eachItem->contry_of_origin;
                                    $inDetails->inb_currency_code = $eachItem->currency_code;
                                    $inDetails->inb_invoice_rate = $eachItem->invoice_rate;
                                    $inDetails->inb_no_of_pieces = $eachItem->no_of_pieces;
                                    $inDetails->inb_pieces_unit = $eachItem->pieces_unit;
                                    $inDetails->inb_quantity = $eachItem->quantity; 
                                    $inDetails->inb_quantity_unit  = $eachItem->quantity_unit; 
                                    $inDetails->inb_net_wt = $eachItem->net_wt; 
                                    $inDetails->inb_gross_wt = $eachItem->gross_wt; 
                                    $inDetails->inb_added_date = $eachIdoc->added_date;
                                    $inDetails->save(false);
                                }
                            }
                        }
                    
                    }else{
                        $msg .= $eachIdoc->doc_no.'$'.'Items Empty';
                    }
                }else{
                     $msg .= $eachIdoc->doc_no.'$'.'No Deliveynote';
                }
                if($msg != '')
                    $list[] = $msg;
            }
            foreach ($list as $line) {
                fputcsv($file, explode('$', $line));
            }
            fclose($file);
            $filename = 'inbound_migration_log.csv';
            header('Content-Type: application/csv');
            header("Content-disposition: attachment; filename=\"inbound_migration_log.csv\"");
            readfile($filename);
            Yii::app()->end();
            return;
        }
    }

    public function actionImportOutdata(){
        ini_set('max_execution_time', -1);
        $idocsout = IdocOut::model()->findAll(array('condition' => 'posted="N"','limit' => 2000));
        $list = array();
        if( !empty($idocsout) ){
            $filename = 'outbound_migration_log'.rand().'.csv';
            $file = fopen($filename, "w");
            foreach ( $idocsout as $eachIdoc) {
                $msg = '';
                if($eachIdoc->delivery_note != ''){
                    $items = StocksOutgoing::model()->findAll(array('condition' => 'delivery_note="'.$eachIdoc->delivery_note.'"'));
                    if(!empty($items)){
                        
                        $outbound = Outbound::model()->findByPk($eachIdoc->delivery_note);
                        if( $outbound->outb_delivery_note_no > 0 ){
                             $msg .= $eachIdoc->doc_no.'$'.'Already Exist';
                        }else{
                            $outMain = new Outbound;
                            $outMain->outb_delivery_note_no = $eachIdoc->delivery_note;
                            $outMain->outb_bill_of_exit_no = $eachIdoc->bill_of_entry;
                            $deliverynoteRelation = OutBoundDeliveryNoteRelation::model()->findBypk($eachIdoc->delivery_note);
                            if( $deliverynoteRelation->delivery_note > 0 ){
                                $outMain->outb_ta_number = $deliverynoteRelation->ta_no;
                            }else{
                                $msg .= $eachIdoc->doc_no.'$'.'TA Number blank';
                            }
                            $outMain->outb_bill_of_exit_date = $eachIdoc->bill_date;
                            $outMain->outb_added_date = $eachIdoc->added_date;
                            $outMain->outb_doc_no = $eachIdoc->doc_no;
                            $outMain->outb_delivery_note_posted = "N";
                            if( $outMain->save(false) ){
                                foreach( $items as $eachItem ){
                                    $outDetails = new OutboundItems;
                                    $outDetails->outb_delivery_note_no = $eachIdoc->delivery_note;
                                    $outDetails->outb_part_number = $eachItem->item_no;
                                    $outDetails->outb_description = $eachItem->description;
                                    $outDetails->outb_hs_code = $eachItem->hs_code;
                                    $outDetails->outb_contry_of_origin_code = $eachItem->contry_of_origin_code;
                                    $outDetails->outb_contry_of_origin = $eachItem->contry_of_origin;
                                    $outDetails->outb_currency_code = $eachItem->currency_code;
                                    $outDetails->outb_invoice_rate = $eachItem->invoice_rate;
                                    $outDetails->outb_no_of_pieces = $eachItem->no_of_pieces;
                                    $outDetails->outb_pieces_unit = $eachItem->pieces_unit;
                                    $outDetails->outb_quantity = $eachItem->quantity; 
                                    $outDetails->outb_quantity_unit  = $eachItem->quantity_unit; 
                                    $outDetails->outb_net_wt = $eachItem->net_wt; 
                                    $outDetails->outb_gross_wt = $eachItem->gross_wt; 
                                    $outDetails->outb_added_date = $eachIdoc->added_date;
                                    $outDetails->save(false);
                                }
                            }
                        }
                    
                    }else{
                        $msg .= $eachIdoc->doc_no.'$'.'Items Empty';
                    }
                }else{
                     $msg .= $eachIdoc->doc_no.'$'.'No Deliveynote';
                }
                if($msg != '')
                    $list[] = $msg;
                $eachIdoc->posted = "Y";
                $eachIdoc->save(false);
            }
            foreach ($list as $line) {
                fputcsv($file, explode('$', $line));
            }
            fclose($file);
            header('Content-Type: application/csv');
            header("Content-disposition: attachment; filename=\"".$filename."\"");
            readfile($filename);
            Yii::app()->end();
            return;
        }
    }

    public function actionSetflags(){
        $items = Connection::model()->findAll(array( 'select' => 'out_deliverynote', 'group' => 'out_deliverynote'));
        foreach( $items as $each ){
            Outbound::model()->updatebypk($each->out_deliverynote,array( 'outb_delivery_note_posted' => 'Y' ));
        }
    }

      public function actionFixrate(){
        $items = Connection::model()->findAll(array('condition' => 'each_item_rate = 0'));
        foreach( $items as $each){
            $each->each_item_rate = ($each->inboundItemRelation->inb_invoice_rate / $each->inboundItemRelation->inb_quantity);
            $each->save(false);
        }
    }

    public function actioninitemSetflags(){
        $items = Connection::model()->findAll(array( 'select' => 'inbound_item_id', 'group' => 'inbound_item_id'));
        foreach( $items as $each ){
            InboundItems::model()->updatebypk($each->inbound_item_id,array( 'inb_posted' => 'Y' ));
        }
    }

    public function actionFixWt(){
        $stock = Stock::model()->findAll();
        foreach ( $stock as $each ){
            $each->gross_wt = $each->inboundRelation->inb_gross_wt /  $each->inboundRelation->inb_quantity;
            $each->save(false);
        }
    }

   
}