<?php

class InboundController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout', 'Importidoc'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('index','Getidocs','Billofentry','Updatebillofentry','Edit','Updateidocdetails',
                                   'Delete', 'Upload', 'Importidocs', 'Documentpreview', 'Getpreviewdata', 'Importtomain', 
                                   'Print', 'excelidoc', 'Download', 'Warehouses', 'Getwarehouses', 'Newwarehouse', 'Savewarehouse',
                                   'Availableboes', 'Transfers', 'Gettransfers', 'Addtransfer', 'Renderdirecttransfer', 'Savetransfer',
                                   'Inventory','Getitems','Add_product','Saveitem','Print1','EditGeneral','AvailableModelno',
                                   'AddMultipleTransfer','RenderDirecttransferMultiple','AddInboundNew','ImportIdocsNew','UpdateContainerData','ImportToMainDirect'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array('accessControl'); // perform access control for CRUD operations
    }

    public function actionIndex() {
        $this->render('index');
    }

    public function actionGetidocs(){
        $model  = new Inbound();
        $draw   = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'inb_delivery_note_no',
            2 => 'inb_bill_of_entry_no', 
            3 => 'inb_bill_of_entry_date', 
            4 => 'inb_added_date', 
            5 => 'inb_delivery_note_posted', 
            6 => 'id', 
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
        $from_date = ( count(explode('/',$_POST['from_date'])) == 3 ) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from_date'])))  : date('Y-m-01');
        $to_date = ( count(explode('/',$_POST['to_date'])) == 3 ) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to_date'])))  : date('Y-m-t');
        $condition = 'inb_added_date BETWEEN "'.$from_date.'" AND "'.$to_date.'"';
        if(isset($_POST['search']['value']) && trim($_POST['search']['value']) !="")
        {
            $searchString = trim($_POST['search']['value']);
            $condition.=" AND (inb_doc_no LIKE '%".$searchString."%' OR inb_delivery_note_no LIKE '%".$searchString."%' OR inb_ta_number LIKE '%".$searchString."%' OR inb_bill_of_entry_no LIKE '%".$searchString."%')";
        }
        $count = $model->count(array('condition'=>$condition));
        $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $eachItemData=array();
        $m=1;
        function deletableDoc( $dNo, $id ){
            $returnValue = true;
            $query = 'SELECT GROUP_CONCAT(id) AS ids FROM nia_current_stock WHERE deliverynote="'.$dNo.'"';
            $deliveryNoteIds = Yii::app()->db->createCommand($query)->queryAll();
            if( $deliveryNoteIds[0]['ids'] != ''){
                $queryLedger = 'SELECT COUNT(id) FROM nia_ledger WHERE stock_id IN('.$deliveryNoteIds[0]['ids'].') AND type="OUT"';
                $countOf = (int) Yii::app()->db->createCommand($queryLedger)->queryScalar();
                if( $countOf > 0 )
                    $returnValue = false;
                $queryOut = 'SELECT GROUP_CONCAT(id) AS ids FROM nia_current_stock WHERE deliverynote_id="'.$id.'"';
                $all_stock_ids = Yii::app()->db->createCommand($queryOut)->queryAll();
                if( $all_stock_ids[0]['ids'] != '' ){
                    $queryOut = 'SELECT COUNT(id) AS ids FROM nia_outbound_items WHERE outb_stock_id IN('.$all_stock_ids[0]['ids'].')';
                    $countOf_outs = (int) Yii::app()->db->createCommand($queryOut)->queryScalar();
                    if( $countOf_outs > 0 )
                        $returnValue = false;
                }
            }
            return $returnValue;
        }
        foreach ( $model as $eachItem )
        {
            $isDeletable = deletableDoc($eachItem['inb_delivery_note_no'],$eachItem['id']);
            $variance = InboundVariance::model()->findByPk($eachItem['inb_ta_number']);
            $div  = '<div class="btn-wrap text-center">';
            //Added by Smrithy//
            //$div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'inbound/editGeneral&id='.$eachItem['id'].'\',\'REF : '.$eachItem['inb_delivery_note_no'].'\',\'xl\')"><i class="fa fa-pencil"></i></button>';
            if($eachItem['is_transfer_entry'] == 'N'){
                $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'inbound/AddInboundNew&id='.$eachItem['id'].'\',\'REF : '.$eachItem['inb_delivery_note_no'].'\',\'xl\')"><i class="fa fa-pencil"></i></button>';
            }
            else{
                $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'inbound/AddInboundNew&id='.$eachItem['id'].'&type=view\',\'REF : '.$eachItem['inb_delivery_note_no'].'\',\'xl\')"><i class="fa fa-pencil"></i></button>';
            }
            //Added by Smrithy//
            $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'inbound/edit&id='.$eachItem['id'].'\',\'REF : '.$eachItem['inb_delivery_note_no'].'\',\'xl\')"><i class="fa fa-eye"></i></button>';
            $div .=' <a class="btn btn-primary btn-xs" title="Print PDF" target="_blank" href="?r=inbound/print&id='.$eachItem['id'].'"><i class="fa fa-file-pdf-o"></i></a>';
            if( $isDeletable &&  $eachItem['is_transfer_entry'] == 'N' ) :
                $div .= ' <a href ="#" title="Delete IDOC" class="btn btn-primary btn-xs" onclick="deleteDoc('.$eachItem['id'].')"><i class="fa fa-trash-o "></i></a>';
            endif;
            $div .= '</div>';
            $eachItemData[]=array($eachItem['id'],$eachItem['inb_delivery_note_no'],$eachItem['inb_bill_of_entry_no'],date('d/m/Y', strtotime($eachItem['inb_bill_of_entry_date'])),date('d/m/Y',strtotime($eachItem['inb_added_date'])),($eachItem['inb_delivery_note_posted'] == "Y") ? 'Yes' : 'No',$div);
          
        }
        $data['data'] = $eachItemData;
        echo json_encode($data);
    }

    public function actionBillofentry(){
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.js' => false);
        $this->render('bill_of_entry');
    } 

    public function actionUpdatebillofentry(){
        
        $status = $deliveryIds =  array();
        
        $bill_of_entry_no = $_POST['bill_of_entry_no'];
        $bill_of_entry_date = $_POST['bill_of_entry_date'];

        if( is_array($_POST['delivery_id']) ){
            foreach( $_POST['delivery_id'] as $eachId ){
                if( (int) $eachId > 0 )
                    $deliveryIds[] = $eachId;
            }

            if( count($deliveryIds) > 0 && $bill_of_entry_no != '' && $bill_of_entry_date != '' ){
                $status['status'] = 'success';
                               
                $bill_of_entry_date = ( count( explode('/', $bill_of_entry_date) ) == 3 ) ?  date("Y-m-d", strtotime(str_replace('/', '-', $bill_of_entry_date))) : date('Y-m-d');
                
                $inboundUpdation = 'UPDATE nia_inbound SET inb_bill_of_entry_no="'.$bill_of_entry_no.'", inb_bill_of_entry_date="'.$bill_of_entry_date.'" WHERE id IN ('.implode(',', $deliveryIds).')';
                Yii::app()->db->createCommand($inboundUpdation)->execute();

                $currentStockids = 'SELECT GROUP_CONCAT(id) AS ids FROM nia_current_stock WHERE deliverynote_id IN ('.implode(',', $deliveryIds).')';
                $currentIds = Yii::app()->db->createCommand($currentStockids)->queryAll();
                
                if( $currentIds[0]['ids'] != "" ){
                    $currentStockupdation = 'UPDATE nia_current_stock SET bill_of_entry="'.$bill_of_entry_no.'", bill_of_entry_date="'.$bill_of_entry_date.'" WHERE deliverynote_id IN ('.implode(',', $deliveryIds).')';
                    Yii::app()->db->createCommand($currentStockupdation)->execute();
                   
                    $updateQuery = 'UPDATE nia_ledger SET shipment_reference="'.$bill_of_entry_no.'", shipment_date="'.$bill_of_entry_date.'" WHERE stock_id IN('.$currentIds[0]['ids'].') AND type="IN"';
                    Yii::app()->db->createCommand($updateQuery)->execute();
                }

            }else
                $status[] = 'Enter all fields!';
        }else{
            $status[] = 'Choose atleast one Deliverynote!';
        }
        
        $this->Connect();
        echo CJSON::encode($status);
    }

    public function actionEdit(){
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.js' => false);
        $model  = Inbound::model()->findByPk((int) Yii::app()->request->getParam('id'));
        $items  = InboundItems::model()->findAll(array('condition' => 'inb_inbound_id='.(int) Yii::app()->request->getParam('id')));
        $this->render('inbound',array('model' => $model, 'items' => $items));
    }

    public function actionUpdateidocdetails(){
        if(isset($_POST['Inbound'])){
            if( $_POST['Inbound']['inb_delivery_note_no'] > 0 ){
                $inbound = Inbound::model()->findByPk( (int) $_POST['Inbound']['inb_delivery_note_no']);
                $inbound->inb_bill_of_entry_no = $_POST['Inbound']['inb_bill_of_entry_no'];
                if( $_POST['Inbound']['inb_bill_of_entry_no'] != '' && $_POST['Inbound']['inb_bill_of_entry_date'] != ''){
                    $inbound->inb_bill_of_entry_no = $_POST['Inbound']['inb_bill_of_entry_no'];
                    $inbound->inb_bill_of_entry_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['Inbound']['inb_bill_of_entry_date'])));
                }else{
                    $inbound->inb_bill_of_entry_no = '';
                    $inbound->inb_bill_of_entry_date = '';
                }
                
                $inbound->inb_ta_number = $_POST['Inbound']['inb_ta_number'];
                $inbound->save(false);

                if(is_array($_POST['InboundItems'])){
                    foreach( $_POST['InboundItems'] as $each ){
                        $InboundItems = InboundItems::model()->findByPk($each['id']);
                        
                        $oldGrosswt = $InboundItems->inb_gross_wt;
                        $oldPrice = $InboundItems->inb_invoice_rate;
                        
                        $InboundItems->attributes = $each;
                        if( $oldGrosswt != $each['inb_gross_wt'] ){
                            $InboundItems->inb_weight_updated = "Y";
                            $InboundItems->inb_weight_last_updated_by = Yii::app()->user->id;
                            $InboundItems->inb_weight_last_updated_date_time = date('Y-m-d h:i:s');
                            $this->Writelog("User ".Yii::app()->user->fullname." Changed weight of Item ".
                                            $InboundItems->inb_part_number." to ".$each['inb_gross_wt']." from ".$each['old_gross_wt'].
                                            " of Delivery note ".$_POST['Inbound']['inb_delivery_note_no']." and TA no ".$_POST['Inbound']['inb_ta_number']);
                            Stock::model()->updateAll(array('gross_wt' => ($each['inb_gross_wt']/$each['inb_quantity']) ),'deliverynote_item_id ='.$each['id']);
                            Ledger::model()->updateAll(array('in_gross_wt' => $each['inb_gross_wt']),'type = "IN" AND master_id = '.$each['id']);
                        }
                        if( $oldPrice != $each['inb_invoice_rate'] ){
                            $InboundItems->inb_rate_updated = "Y";
                            $InboundItems->inb_rate_last_updated_by = Yii::app()->user->id;
                            $InboundItems->inb_rate_last_updated_date_time = date('Y-m-d h:i:s');
                            $this->Writelog("User ".Yii::app()->user->fullname." Changed rate of Item ".
                                            $InboundItems->inb_part_number." to ".$each['inb_invoice_rate']." from ".$each['old_invoice_rate'].
                                            " of Delivery note ".$_POST['Inbound']['inb_delivery_note_no']." and TA no ".$_POST['Inbound']['inb_ta_number']);
                            Stock::model()->updateAll(array('cost_rate' => ($each['inb_invoice_rate']/$each['inb_quantity']) ),'deliverynote_item_id ='.$each['id']);
                            Ledger::model()->updateAll(array('in_invoice_rate' => $each['inb_invoice_rate']),'type = "IN" AND master_id = '.$each['id']);
                        }
                        $InboundItems->save(false);
                    }
                }
            }
        }
        $status['status'] = 'success';
        echo CJSON::encode($status);
    }

    public function actionDelete(){
        $id =  $_POST['id'];
        if( $id > 0 ){
            Inbound::model()->deletebypk($id);
            InboundItems::model()->deleteAll('inb_inbound_id =:refer_id', array( ':refer_id' => $id ));
            
            $query = 'SELECT GROUP_CONCAT(id) AS ids FROM nia_current_stock WHERE deliverynote_id ="'.$id.'"';
            $deliveryNoteIds = Yii::app()->db->createCommand($query)->queryAll();
            
            if( $deliveryNoteIds[0]['ids'] != ''){
                Stock::model()->deleteAll('deliverynote_id =:refer_id', array( ':refer_id' => $id ));
                $deleteQuery = 'DELETE FROM nia_ledger WHERE stock_id IN('.$deliveryNoteIds[0]['ids'].')';
                Yii::app()->db->createCommand($deleteQuery)->execute();
            }
            
            $this->Writelog("User ".Yii::app()->user->fullname." Deleted Delivery Note ".$id);
            echo 'success';
        }else{
            echo 'fail';
        }
    }

    /**
     *  Stock In to Out connection
     */

     public function Connect(){
        ini_set('max_execution_time', -1);
        $inbound = Inbound::model()->findAll( array( 'condition' => 'inb_delivery_note_posted="N" AND inb_bill_of_entry_no != ""', 'limit' => 5000) );
        if(!empty($inbound)){
            date_default_timezone_set("Asia/Dubai");
            foreach ( $inbound as $each ){
                if(is_array($each->items)){
                    foreach( $each->items as $eachItem ){
                       
                        $stock = new Stock;
                        $stock->part_number = trim($eachItem->inb_part_number);
                        $stock->description = $eachItem->inb_description;
                        $stock->quantity= $eachItem->inb_quantity;
                        $stock->deliverynote = $eachItem->inb_delivery_note_no;
                        $stock->deliverynote_id = $each->id;
                        $stock->deliverynote_item_id = $eachItem->id;
                        //$stock->bill_of_entry = $eachItem->parent->inb_bill_of_entry_no;
                        $stock->bill_of_entry_date = $eachItem->parent->inb_bill_of_entry_date;
                        $stock->cost_rate = $eachItem->inb_invoice_rate / $eachItem->inb_quantity;
                        $stock->gross_wt = $eachItem->inb_gross_wt / $eachItem->inb_quantity;
                        $stock->net_wt = $eachItem->inb_net_wt / $eachItem->inb_quantity;
                        $stock->cbm = $eachItem->inb_cbm / $eachItem->inb_quantity;
                        //code added by mereena on 08/06/2024
                        
                        if(isset($eachItem->inb_to_warehouse_id) && $eachItem->inb_to_warehouse_id > 0){
                            $stock->warehouse = $eachItem->inb_to_warehouse_id; 
                        }
                        else{
                            $stock->warehouse = $each->inb_warehouse_id; 
                        }
                        
                        //code added by mereena on 10/10/2024
                        if(isset($eachItem->inb_bill_of_entry_no) && $eachItem->inb_bill_of_entry_no!=''){
                            $stock->bill_of_entry = $eachItem->inb_bill_of_entry_no; 
                        }
                        else{
                            $stock->bill_of_entry = $eachItem->parent->inb_bill_of_entry_no;
                        }
                        //end
                        
                        
                        $stock->save(false);
                        $stock_id = $stock->id;
                       
                        $ledger = new Ledger;
                        $ledger->stock_id = $stock_id;
                        $ledger->master_id = $eachItem->id;
                        //code added by mereena on 08/06/2024
                        $ledger->warehouse_id = $eachItem->inb_to_warehouse_id;
                        $ledger->part_number = trim($eachItem->inb_part_number);
                        $ledger->description = $eachItem->inb_description;
                        $ledger->delivery_note =  $eachItem->inb_delivery_note_no;
                        $ledger->shipment_reference =  $eachItem->parent->inb_bill_of_entry_no;
                        $ledger->shipment_date = $eachItem->parent->inb_bill_of_entry_date;
                        $ledger->in_invoice_rate = $eachItem->inb_invoice_rate;
                        $ledger->in_gross_wt = $eachItem->inb_gross_wt;
                        $ledger->in_net_wt = $eachItem->inb_net_wt;
                        $ledger->in_cbm = $eachItem->inb_cbm;
                        $ledger->in_quantity  = $eachItem->inb_quantity;
                        $ledger->type  = 'IN';
                        $ledger->created_date = date('Y-m-d h:i:s');
                        $ledger->save(false);
                    }
                }
                $each->inb_delivery_note_posted = "Y";
                $each->save(false);
            }
        }
     }

    public function actionExcelidoc(){
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.js' => false);
        $this->render('import_idoc');
    } 
    
    public function actionImportidocs(){
        
        Inboundtemp::model()->deleteAll();
        InboundItemstemp::model()->deleteAll();

        $doc= $_POST['file_name']; 
        $warehouse= $_POST['warehouse']; 
        $doc = str_replace(',', '', $doc); 
        $file = fopen("upload/idoc_csv/$doc", "r");  

        function validateDate($date){
            $returnValue = false;
            if( count(explode('-', $date)) == 3  )
                $returnValue = true;
            if( $returnValue )
                if( strtotime($date) >= strtotime('2010-01-01') && strtotime($date) <= strtotime('2050-01-01')  )
                    $returnValue = true;
                else
                    $returnValue = false;
            return $returnValue;
        }
        
        function clean($string){
            if($string != ''){
                $value =  trim(preg_replace('/[^0-9a-zA-Z_@\s-]/', '', $string));
                if( $value != "")
                    return $value;
                else
                    return '';
            }else
                return '';
        }
        function write_error_log( $msg){
            $file = file_put_contents('upload/error.log', $msg.PHP_EOL , FILE_APPEND | LOCK_EX);
        }
        
        unlink('upload/error.log');
        ini_set('max_execution_time', 0);

        $x  =  0;
        while ($line = fgets($file, 1000)) {   
            if( $x > 0 ){  
                $bill_of_entry ="";
                $bill_of_entry_date ="";
                $delivery_note ="";
                $part_no ="";
                $description ="";
                $hs_code ="";
                $hs_code_ae = "";
                $country_code = "";
                $country = "";
                $currency = "";
                $exchange_rate = "";
                $remarks = "";
                $net_value = "";
                $quantity = "";
                $unit = "";
                $net_weight = "";
                $gross_weight = "";
                $cbm = "";
                
                //code added by mereena on 14/06/2023
                $grn                =   "";
                $brand              =   "";
                $category           =   "";
                $total_cif_value    =   "";
                $frieght            =   "";
                $frieght_currency   =   "";
                $total_containers   =   "";
                $container_type     =   "";
                $department         =   "";
                
                //end

                $line = explode(",", $line);
                
                foreach ($line as $i => $row) {
                        switch ($i) {
                            case 0:
                                $delivery_note = clean($row);
                                break;
                            case 1:
                                $bill_of_entry = clean($row);
                                break;
                            case 2:
                                $bill_of_entry_date = trim($row);
                                break;
                            case 3:
                                $part_no = clean($row);
                                break;
                            case 4:
                                $description = clean($row);
                                break;
                            case 5:
                                $hs_code = trim($row);
                                break;
                            case 6:
                                $hs_code_ae = trim($row);
                                break;
                            case 7:
                                $country_code = clean($row);
                                break;
                            case 8:
                                $country = clean($row);
                                break;
                            case 9:
                                $currency = trim($row);
                                break;
                            case 10:
                                $exchange_rate = trim($row);
                                break;
                            case 11:
                                $remarks = clean($row);
                                break;
                            case 12:
                                $quantity = trim($row);
                                break;
                            case 13:
                                $unit = trim($row);
                                break;
                            case 14:
                                $net_weight = trim($row);
                                break;
                            case 15:
                                $gross_weight = trim($row);
                                break;
                            case 16:
                                $cbm = trim($row);
                                break;
                            case 17:
                                $net_value = trim($row);
                                break;
                            //code added by mereena on 14/06/2023
                            case 18:
                                $grn = trim($row);
                                break;
                            case 19:
                                $brand = trim($row);
                                break;
                            case 20:
                                $category = trim($row);
                                break;
                            case 21:
                                $total_cif_value = trim($row);
                                break;
                            case 22:
                                $frieght = trim($row);
                                break;
                            case 23:
                                $frieght_currency = trim($row);
                                break;
                            case 24:
                                $total_containers = trim($row);
                                break;
                            case 25:
                                $container_type = trim($row);
                                break;
                            case 26:
                                $department = trim($row);
                                break;
                            //end
                        }
                }  
                //SAVE DATA  
                $Item_error = false; 
                $headError = false;
                if( $delivery_note != "" ){
                    $existance_in_inbound = Inbound::model()->find( array( 'condition' => 'inb_delivery_note_no="'.$delivery_note.'"') );
                    if( $existance_in_inbound->inb_delivery_note_no != "" ) :
                        $headError = true;
                        write_error_log('Ref #'.$delivery_note.' Already Exists!');
                    endif;
                    $checkExistance = Inboundtemp::model()->find( array( 'condition' => 'inb_delivery_note_no="'.$delivery_note.'"') );
                    if( $checkExistance->inb_delivery_note_no != "" ){
                        $newItem = new InboundItemstemp;
                        $newItem->inb_inbound_id = $checkExistance->id;
                        $newItem->inb_delivery_note_no = $checkExistance->inb_delivery_note_no;
                        $newItem->inb_part_number = $part_no;
                        if( $part_no == '') :
                            $Item_error = true;
                            write_error_log($delivery_note.' - Part Number Cannot Blank');
                        endif;
                        $newItem->inb_description = $description;
                        if( $description == '') :
                            $Item_error = true;
                            write_error_log($delivery_note.' Item '.$part_no.' - Description Cannot Blank');
                        endif;
                        $newItem->inb_hs_code = $hs_code;
                        $newItem->inb_hs_code_ae = $hs_code_ae;
                        $newItem->inb_contry_of_origin_code = $country_code;
                        $newItem->inb_contry_of_origin = $country;
                        if( $country == '') :
                            $Item_error = true;
                            write_error_log($delivery_note.' Item '.$part_no.' - Country of Origin Cannot Blank');
                        endif;
                        $newItem->inb_currency_code = $currency;
                        if( $currency == '') :
                            $Item_error = true;
                            write_error_log($delivery_note.' Item '.$part_no.' - Currency Cannot Blank');
                        endif;
                        $newItem->inb_exchange_rate = $exchange_rate;
                        $newItem->inb_invoice_rate = $net_value;
                        if( $net_value == '') :
                            $Item_error = true;
                            write_error_log($delivery_note.' Item '.$part_no.' - Net value Cannot Blank');
                        endif;
                        $newItem->inb_quantity = $quantity;
                        if( $quantity == '') :
                            $Item_error = true;
                            write_error_log($delivery_note.' Item '.$part_no.' - Quantity Cannot Blank');
                        endif;
                        $newItem->inb_quantity_unit = $unit;
                        $newItem->inb_net_wt = $net_weight;
                        if( $net_weight == '') :
                            $Item_error = true;
                            write_error_log($delivery_note.' Item '.$part_no.' - Net Weight Cannot Blank');
                        endif;
                        $newItem->inb_gross_wt = $gross_weight;
                        if( $gross_weight == '') :
                            $Item_error = true;
                            write_error_log($delivery_note.' Item '.$part_no.' - Gross Weight Cannot Blank');
                        endif;
                        $newItem->inb_remarks = $remarks;
                        $newItem->inb_cbm = $cbm;
                        $newItem->inb_added_date = date('Y-m-d');
                        if( $Item_error )
                            $newItem->inb_is_updatable = 'N';
                            
                        //code added by mereena on 14/06/2023
                        $newItem->inb_brand_name            = $brand;
                        $newItem->inb_category_name         = $category;
                        $newItem->inb_total_cif_value       = $total_cif_value;
                        //end
                            
                        $newItem->save(false);
                    }else{
                        $mainModel = new Inboundtemp;
                        $mainModel->inb_delivery_note_no = $delivery_note;
                        $taNumber = MasCompany::getInbound_ta_with_bill($bill_of_entry, true);
                        $mainModel->inb_ta_number = $taNumber;
                        if( !validateDate($bill_of_entry_date) ){
                            $headError = true;
                            write_error_log($delivery_note.' - BOE Date Cannot Blank');
                        }else{
                            $mainModel->inb_bill_of_entry_date = $bill_of_entry_date;
                        }
                        $mainModel->inb_bill_of_entry_no = $bill_of_entry;
                        if( $bill_of_entry == '' )
                            $headError = true;
                        $mainModel->inb_added_date =  date('Y-m-d');
                        $mainModel->inb_warehouse_id =  $warehouse;
                        $mainModel->inb_doc_no =  'N/A';
                        $mainModel->inb_file_name =  'N/A';
                        
                        //code added by mereena on 14/06/2023
                        $mainModel->inb_grn_no            = $grn;
                        $mainModel->inb_frieght           = $frieght;
                        $mainModel->inb_frieght_currency  = $frieght_currency;
                        $mainModel->inb_total_containers  = $total_containers;
                        $mainModel->inb_container_type    = $container_type;
                        $mainModel->inb_department        = $department;
                        //end
                        
                        
                        if( $headError )
                            $mainModel->inb_is_updatable = 'N';
                        if( $mainModel->save(false) ){
                            $newItem = new InboundItemstemp;
                            $newItem->inb_inbound_id = $mainModel->id;
                            $newItem->inb_delivery_note_no = $mainModel->inb_delivery_note_no;
                            $newItem->inb_part_number = $part_no;
                            if( $part_no == '') :
                                $Item_error = true;
                                write_error_log($delivery_note.' - Part Number Cannot Blank');
                            endif;
                            $newItem->inb_description = $description;
                            if( $description == '') :
                                $Item_error = true;
                                write_error_log($delivery_note.' Item '.$part_no.' - Description Cannot Blank');
                            endif;
                            $newItem->inb_hs_code = $hs_code;
                            $newItem->inb_hs_code_ae = $hs_code_ae;
                            $newItem->inb_contry_of_origin_code = $country_code;
                            $newItem->inb_contry_of_origin = $country;
                            if( $country == '') :
                                $Item_error = true;
                                write_error_log($delivery_note.' Item '.$part_no.' - Country of Origin Cannot Blank');
                            endif;
                            $newItem->inb_currency_code = $currency;
                            if( $currency == '') :
                                $Item_error = true;
                                write_error_log($delivery_note.' Item '.$part_no.' - Currency Cannot Blank');
                            endif;
                            $newItem->inb_exchange_rate = $exchange_rate;
                            $newItem->inb_invoice_rate = $net_value;
                            if( $net_value == '') :
                                $Item_error = true;
                                write_error_log($delivery_note.' Item '.$part_no.' - Net value Cannot Blank');
                            endif;
                            $newItem->inb_quantity = $quantity;
                            if( $quantity == '') :
                                $Item_error = true;
                                write_error_log($delivery_note.' Item '.$part_no.' - Quantity Cannot Blank');
                            endif;
                            $newItem->inb_quantity_unit = $unit;
                            $newItem->inb_net_wt = $net_weight;
                            if( $net_weight == '') :
                                $Item_error = true;
                                write_error_log($delivery_note.' Item '.$part_no.' - Net Weight Cannot Blank');
                            endif;
                            $newItem->inb_gross_wt = $gross_weight;
                            if( $gross_weight == '') :
                                $Item_error = true;
                                write_error_log($delivery_note.' Item '.$part_no.' - Gross Weight Cannot Blank');
                            endif;
                            $newItem->inb_remarks = $remarks;
                            $newItem->inb_cbm = $cbm;
                            $newItem->inb_added_date = date('Y-m-d');
                            if( $Item_error )
                                $newItem->inb_is_updatable = 'N';
                                
                            //code added by mereena on 14/06/2023
                            $newItem->inb_brand_name            = $brand;
                            $newItem->inb_category_name         = $category;
                            $newItem->inb_total_cif_value       = $total_cif_value;
                            //end    
                                
                                
                           
                            
                            $newItem->save(false);
                        }
                    }
                    if( $Item_error || $headError ) :
                        $haveErrors = true;
                        fwrite($errorFile, implode(' , ', $errors));
                    endif;
                }
            }
            $x++;
        }
        fclose($errorFile);
        echo CJSON::encode( array(  'status' => 'success'  ) );
    }

   /* public function actionImportidocs(){
        
        Inboundtemp::model()->deleteAll();
        InboundItemstemp::model()->deleteAll();

        $doc= $_POST['file_name']; 
        $warehouse= $_POST['warehouse']; 
        $doc = str_replace(',', '', $doc); 
        $file = fopen("upload/idoc_csv/$doc", "r");  

        function validateDate($date){
            $returnValue = false;
            if( count(explode('-', $date)) == 3  )
                $returnValue = true;
            if( $returnValue )
                if( strtotime($date) >= strtotime('2010-01-01') && strtotime($date) <= strtotime('2050-01-01')  )
                    $returnValue = true;
                else
                    $returnValue = false;
            return $returnValue;
        }
        
        function clean($string){
            if($string != ''){
                $value =  trim(preg_replace('/[^0-9a-zA-Z_@\s-]/', '', $string));
                if( $value != "")
                    return $value;
                else
                    return '';
            }else
                return '';
        }
        function write_error_log( $msg){
            $file = file_put_contents('upload/error.log', $msg.PHP_EOL , FILE_APPEND | LOCK_EX);
        }
        
        unlink('upload/error.log');
        ini_set('max_execution_time', 0);

        $x  =  0;
        while ($line = fgets($file, 1000)) {   
            if( $x > 0 ){  
                $bill_of_entry ="";
                $bill_of_entry_date ="";
                $delivery_note ="";
                $part_no ="";
                $description ="";
                $hs_code ="";
                $hs_code_ae = "";
                $country_code = "";
                $country = "";
                $currency = "";
                $exchange_rate = "";
                $remarks = "";
                $net_value = "";
                $quantity = "";
                $unit = "";
                $net_weight = "";
                $gross_weight = "";
                $cbm = "";

                $line = explode(",", $line);
                
                foreach ($line as $i => $row) {
                        switch ($i) {
                            case 0:
                                $delivery_note = clean($row);
                                break;
                            case 1:
                                $bill_of_entry = clean($row);
                                break;
                            case 2:
                                $bill_of_entry_date = trim($row);
                                break;
                            case 3:
                                $part_no = clean($row);
                                break;
                            case 4:
                                $description = clean($row);
                                break;
                            case 5:
                                $hs_code = trim($row);
                                break;
                            case 6:
                                $hs_code_ae = trim($row);
                                break;
                            case 7:
                                $country_code = clean($row);
                                break;
                            case 8:
                                $country = clean($row);
                                break;
                            case 9:
                                $currency = trim($row);
                                break;
                            case 10:
                                $exchange_rate = trim($row);
                                break;
                            case 11:
                                $remarks = clean($row);
                                break;
                            case 12:
                                $quantity = trim($row);
                                break;
                            case 13:
                                $unit = trim($row);
                                break;
                            case 14:
                                $net_weight = trim($row);
                                break;
                            case 15:
                                $gross_weight = trim($row);
                                break;
                            case 16:
                                $cbm = trim($row);
                                break;
                            case 17:
                                $net_value = trim($row);
                                break;
                        }
                }  
                //SAVE DATA  
                $Item_error = false; 
                $headError = false;
                if( $delivery_note != "" ){
                    $existance_in_inbound = Inbound::model()->find( array( 'condition' => 'inb_delivery_note_no="'.$delivery_note.'"') );
                    if( $existance_in_inbound->inb_delivery_note_no != "" ) :
                        $headError = true;
                        write_error_log('Ref #'.$delivery_note.' Already Exists!');
                    endif;
                    $checkExistance = Inboundtemp::model()->find( array( 'condition' => 'inb_delivery_note_no="'.$delivery_note.'"') );
                    if( $checkExistance->inb_delivery_note_no != "" ){
                        $newItem = new InboundItemstemp;
                        $newItem->inb_inbound_id = $checkExistance->id;
                        $newItem->inb_delivery_note_no = $checkExistance->inb_delivery_note_no;
                        $newItem->inb_part_number = $part_no;
                        if( $part_no == '') :
                            $Item_error = true;
                            write_error_log($delivery_note.' - Part Number Cannot Blank');
                        endif;
                        $newItem->inb_description = $description;
                        if( $description == '') :
                            $Item_error = true;
                            write_error_log($delivery_note.' Item '.$part_no.' - Description Cannot Blank');
                        endif;
                        $newItem->inb_hs_code = $hs_code;
                        $newItem->inb_hs_code_ae = $hs_code_ae;
                        $newItem->inb_contry_of_origin_code = $country_code;
                        $newItem->inb_contry_of_origin = $country;
                        if( $country == '') :
                            $Item_error = true;
                            write_error_log($delivery_note.' Item '.$part_no.' - Country of Origin Cannot Blank');
                        endif;
                        $newItem->inb_currency_code = $currency;
                        if( $currency == '') :
                            $Item_error = true;
                            write_error_log($delivery_note.' Item '.$part_no.' - Currency Cannot Blank');
                        endif;
                        $newItem->inb_exchange_rate = $exchange_rate;
                        $newItem->inb_invoice_rate = $net_value;
                        if( $net_value == '') :
                            $Item_error = true;
                            write_error_log($delivery_note.' Item '.$part_no.' - Net value Cannot Blank');
                        endif;
                        $newItem->inb_quantity = $quantity;
                        if( $quantity == '') :
                            $Item_error = true;
                            write_error_log($delivery_note.' Item '.$part_no.' - Quantity Cannot Blank');
                        endif;
                        $newItem->inb_quantity_unit = $unit;
                        $newItem->inb_net_wt = $net_weight;
                        if( $net_weight == '') :
                            $Item_error = true;
                            write_error_log($delivery_note.' Item '.$part_no.' - Net Weight Cannot Blank');
                        endif;
                        $newItem->inb_gross_wt = $gross_weight;
                        if( $gross_weight == '') :
                            $Item_error = true;
                            write_error_log($delivery_note.' Item '.$part_no.' - Gross Weight Cannot Blank');
                        endif;
                        $newItem->inb_remarks = $remarks;
                        $newItem->inb_cbm = $cbm;
                        $newItem->inb_added_date = date('Y-m-d');
                        if( $Item_error )
                            $newItem->inb_is_updatable = 'N';
                        $newItem->save(false);
                    }else{
                        $mainModel = new Inboundtemp;
                        $mainModel->inb_delivery_note_no = $delivery_note;
                        $taNumber = MasCompany::getInbound_ta_with_bill($bill_of_entry, true);
                        $mainModel->inb_ta_number = $taNumber;
                        if( !validateDate($bill_of_entry_date) ){
                            $headError = true;
                            write_error_log($delivery_note.' - BOE Date Cannot Blank');
                        }else{
                            $mainModel->inb_bill_of_entry_date = $bill_of_entry_date;
                        }
                        $mainModel->inb_bill_of_entry_no = $bill_of_entry;
                        if( $bill_of_entry == '' )
                            $headError = true;
                        $mainModel->inb_added_date =  date('Y-m-d');
                        $mainModel->inb_warehouse_id =  $warehouse;
                        $mainModel->inb_doc_no =  'N/A';
                        $mainModel->inb_file_name =  'N/A';
                        if( $headError )
                            $mainModel->inb_is_updatable = 'N';
                        if( $mainModel->save(false) ){
                            $newItem = new InboundItemstemp;
                            $newItem->inb_inbound_id = $mainModel->id;
                            $newItem->inb_delivery_note_no = $mainModel->inb_delivery_note_no;
                            $newItem->inb_part_number = $part_no;
                            if( $part_no == '') :
                                $Item_error = true;
                                write_error_log($delivery_note.' - Part Number Cannot Blank');
                            endif;
                            $newItem->inb_description = $description;
                            if( $description == '') :
                                $Item_error = true;
                                write_error_log($delivery_note.' Item '.$part_no.' - Description Cannot Blank');
                            endif;
                            $newItem->inb_hs_code = $hs_code;
                            $newItem->inb_hs_code_ae = $hs_code_ae;
                            $newItem->inb_contry_of_origin_code = $country_code;
                            $newItem->inb_contry_of_origin = $country;
                            if( $country == '') :
                                $Item_error = true;
                                write_error_log($delivery_note.' Item '.$part_no.' - Country of Origin Cannot Blank');
                            endif;
                            $newItem->inb_currency_code = $currency;
                            if( $currency == '') :
                                $Item_error = true;
                                write_error_log($delivery_note.' Item '.$part_no.' - Currency Cannot Blank');
                            endif;
                            $newItem->inb_exchange_rate = $exchange_rate;
                            $newItem->inb_invoice_rate = $net_value;
                            if( $net_value == '') :
                                $Item_error = true;
                                write_error_log($delivery_note.' Item '.$part_no.' - Net value Cannot Blank');
                            endif;
                            $newItem->inb_quantity = $quantity;
                            if( $quantity == '') :
                                $Item_error = true;
                                write_error_log($delivery_note.' Item '.$part_no.' - Quantity Cannot Blank');
                            endif;
                            $newItem->inb_quantity_unit = $unit;
                            $newItem->inb_net_wt = $net_weight;
                            if( $net_weight == '') :
                                $Item_error = true;
                                write_error_log($delivery_note.' Item '.$part_no.' - Net Weight Cannot Blank');
                            endif;
                            $newItem->inb_gross_wt = $gross_weight;
                            if( $gross_weight == '') :
                                $Item_error = true;
                                write_error_log($delivery_note.' Item '.$part_no.' - Gross Weight Cannot Blank');
                            endif;
                            $newItem->inb_remarks = $remarks;
                            $newItem->inb_cbm = $cbm;
                            $newItem->inb_added_date = date('Y-m-d');
                            if( $Item_error )
                                $newItem->inb_is_updatable = 'N';
                            $newItem->save(false);
                        }
                    }
                    if( $Item_error || $headError ) :
                        $haveErrors = true;
                        fwrite($errorFile, implode(' , ', $errors));
                    endif;
                }
            }
            $x++;
        }
        fclose($errorFile);
        echo CJSON::encode( array(  'status' => 'success'  ) );
    }*/

    public function actionDocumentpreview(){
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.js' => false);
        $countOne = (int) Inboundtemp::model()->count( array( 'condition' => 'inb_is_updatable="N"') );
        $countTwo = (int) InboundItemstemp::model()->count( array( 'condition' => 'inb_is_updatable="N"') );
        $this->render('documents_preview', array( 'isUpdatable' => ( $countOne > 0 || $countTwo > 0 ) ? false : true ));
    }
    
    
     public  function actionGetpreviewdata(){
        
        $bill_of_entries = array();
        $deliveryNotes = array();
        $products = array();
        $eachItem = array();
        $fields = array( 'Descripion' => 'inb_description', 'HS Code' =>'inb_hs_code', 'Origin' => 'inb_contry_of_origin',  'Currency' => 'inb_currency_code',  'Net Wt' => 'inb_net_wt',  'Gross Wt' => 'inb_gross_wt', 'Value' => 'inb_invoice_rate', 'Cbm' => 'inb_cbm','Brand'=>'inb_brand_name','Category'=>'inb_category_name'/*,'GRN'=>'inb_grn_no','Frieght'=>'inb_frieght','Frieght Currency'=>'inb_frieght_currency','Total Containers'=>'inb_total_containers','Container Type'=>'inb_container_type','Department'=>'inb_department'*/);
        $icons = array(
            'inb_description' => 'glyphicon glyphicon-align-right',
            'inb_hs_code' => 'glyphicon glyphicon-barcode',
            'inb_contry_of_origin' => 'glyphicon glyphicon-home',
            'inb_currency_code' => 'glyphicon glyphicon-usd',
            'inb_net_wt' => 'glyphicon glyphicon-compressed',
            'inb_gross_wt' => 'glyphicon glyphicon-tower',
            'inb_invoice_rate' => 'glyphicon glyphicon-bitcoin',
            'inb_cbm' => 'glyphicon glyphicon-object-align-right',
            'inb_brand_name' => 'glyphicon glyphicon-tags',
            'inb_category_name' => 'glyphicon glyphicon-bookmark',
        );
        $allEntries = Inboundtemp::model()->findAll(array( 'select' => 'inb_bill_of_entry_no, inb_bill_of_entry_date', 'condition' => 'inb_bill_of_entry_no !=""', 'group' => 'inb_bill_of_entry_no'));
        //echo '<pre>';
        //print_r($allEntries);
        if( !empty($allEntries) ){
            foreach( $allEntries as $i => $eachEntry ){
                $count = Inboundtemp::model()->count( array( 'condition' => 'inb_is_updatable="N" AND inb_bill_of_entry_no="'.$eachEntry->inb_bill_of_entry_no.'"') );
                $totalColor = ( $eachEntry->inb_bill_of_entry_date == '0000-00-00' ) ? true : false;
                $spanColor = ( $eachEntry->inb_bill_of_entry_date == '0000-00-00' || $count > 0 ) ? 'color:red;' : 'color:green;';
                $class = ( $eachEntry->inb_bill_of_entry_date == '0000-00-00' || $count > 0 ) ? 'cl_red' : 'cl_green';
                $bill_of_entries[$i]['id'] = $eachEntry->inb_bill_of_entry_no;
                $bill_of_entries[$i]['text'] = '<span style="'.$spanColor.'">'.$eachEntry->inb_bill_of_entry_no.'</span>';
                $bill_of_entries[$i]['state'] = array(
                    'opened' => ($i == 0 ) ? true : false,
                    'disabled' => false,
                    'selected' => false,
                );
                $bill_of_entries[$i]['icon'] =  $class." glyphicon glyphicon-list";
                $allDeliverys =  Inboundtemp::model()->findAll( array( 'select' => 'inb_delivery_note_no, inb_is_updatable', 'condition' => 'inb_bill_of_entry_no="'.$eachEntry->inb_bill_of_entry_no.'"', 'group' => 'inb_delivery_note_no', 'order' => 'inb_delivery_note_no') );
                if( !empty($allDeliverys) ){
                    foreach( $allDeliverys as $j => $eachDelivery ){
                        $count = Inboundtemp::model()->count( array( 'condition' => 'inb_is_updatable="N" AND inb_delivery_note_no="'.$eachDelivery->inb_delivery_note_no.'"') );
                        $spanColor = ( $eachDelivery->inb_is_updatable == 'N' || $totalColor || $count > 0 ) ? 'color:red;' : 'color:green;';
                        $totalColor_delivery = ( $eachDelivery->inb_is_updatable == 'N' || $totalColor ) ? true : false;
                        $class = ( $eachDelivery->inb_is_updatable == 'N' || $totalColor || $count > 0 ) ? 'cl_red' : 'cl_green';
                        $deliveryNotes[$j]['id'] = $eachDelivery->inb_delivery_note_no;
                        $deliveryNotes[$j]['text'] = '<span style="'.$spanColor.'">'.$eachDelivery->inb_delivery_note_no.'</span>';
                        $deliveryNotes[$j]['state'] = array(
                            'opened' => ($j == 0 ) ? true : false,
                            'disabled' => true,
                            'selected' => false,
                        );
                        $deliveryNotes[$j]['icon'] =  $class." glyphicon glyphicon-paste";
                        $allProducts = InboundItemstemp::model()->findAll( array( 'select' => 'id, inb_part_number, inb_is_updatable', 'condition' => 'inb_delivery_note_no="'.$eachDelivery->inb_delivery_note_no.'"', 'order' => 'inb_part_number' ) );
                        if( !empty($allProducts) ){
                            foreach( $allProducts as $x => $eachProduct ){
                                $spanColor = ( $eachProduct->inb_is_updatable == 'N' || $totalColor || $totalColor_delivery ) ? 'color:red;' : 'color:green;';
                                $class = ( $eachProduct->inb_is_updatable == 'N' || $totalColor ) ? 'cl_red' : 'cl_green';
                                $products[$x]['id'] = $eachProduct->id;
                                $products[$x]['text'] = '<span style="'.$spanColor.'">'.$eachProduct->inb_part_number.'</span>';
                                $products[$x]['state'] = array(
                                    'opened' =>  ($x == 0 ) ? true : false,
                                    'disabled' => false,
                                    'selected' => false,
                                );
                                $products[$x]['icon'] = $class." glyphicon glyphicon-hdd";
                                $item = InboundItemstemp::model()->findBypk($eachProduct->id);
                                $m = 0;
                                foreach( $fields as $description => $eachField ){
                                    $spanColor = ( $item->$eachField == '' || $totalColor  ) ? 'color:red;' : '';
                                    $class = ( $item->$eachField == '' || $totalColor ) ? 'cl_red' : '';
                                    $eachItem[$m]['id'] = $eachField.$m.$x.$j.$i;
                                    $eachItem[$m]['text'] = '<span style="'.$spanColor.'">'.$description.' : '.$item->$eachField.'</span>';
                                    $eachItem[$m]['state'] = array(
                                        'opened' =>  ($m == 0 ) ? true : false,
                                        'disabled' => false,
                                        'selected' => false,
                                    );
                                    $eachItem[$m]['icon'] =  $class.' '.$icons[$eachField];
                                    $m++;
                                }
                                $products[$x]['children'] = $eachItem;
                            }
                        }
                        $deliveryNotes[$j]['children'] = $products;
                    }
                }
                $bill_of_entries[$i]['children'] = $deliveryNotes;
            }
        }

        echo json_encode($bill_of_entries);
    }

    public function actionImporttomain(){
        $docs = Inboundtemp::model()->findAll();
        foreach ( $docs as $i => $each ){
            $newDoc = new Inbound;
            $newDoc->attributes = $each->attributes;
            $newDoc->save(false);
            $docItems = InboundItemstemp::model()->findAll( array('condition' => 'inb_delivery_note_no="'.$each->inb_delivery_note_no.'"') );
            foreach ( $docItems as $x => $eachItem ){
                $newDocitem = new InboundItems;
                $newDocitem->attributes = $eachItem->attributes;
                $newDocitem->inb_inbound_id = $newDoc->id;
                
                //code added by mereena on 14/06/2023
                if(!empty($eachItem->inb_brand_name)){
                    $modelMasBrand = new MasBrand();
                    $arr_brand_exist =  $modelMasBrand->find(array('condition'=>'brand_name="'.trim($eachItem->inb_brand_name).'" AND isActive="Y"'));
                    if(empty($arr_brand_exist)){
                        $modelMasBrand = new MasBrand();
                        $modelMasBrand->brand_name=trim($eachItem->inb_brand_name);
                        $modelMasBrand->isActive="Y";
                        $modelMasBrand->save();
                        $brand_id = (int) $modelMasBrand->id;
                    }
                    else{
                        $brand_id = (int) $arr_brand_exist->id;
                    }
                }
                
                $newDocitem->inb_brand_id = $brand_id;
                
                
                 if(!empty($eachItem->inb_category_name)){
                    $modelMasCategory = new MasCategory();
                    $arr_category_exist =  $modelMasCategory->find(array('condition'=>'category_name="'.trim($eachItem->inb_category_name).'" AND isActive="Y"'));
                    if(empty($arr_category_exist)){
                        $modelMasCategory = new MasCategory();
                        $modelMasCategory->category_name=trim($eachItem->inb_category_name);
                        $modelMasCategory->isActive="Y";
                        $modelMasCategory->save();
                        $category_id = (int) $modelMasCategory->id;
                    }
                    else{
                        $category_id = (int) $arr_category_exist->id;
                    }
                }
                
                $newDocitem->inb_category_id = $category_id;
                
                //end
                
                $newDocitem->save(false);
                
                //code added by mereena on 09/06/2023
                //if part no not exist in item master -- added new one
                $part_number        = trim($eachItem->inb_part_number);
                $modelItemMaster    = new ItemMaster();
                $cnt_part_no        = (int) $modelItemMaster->count(array('condition' => 'UPPER(part_number)="'.strtoupper($part_number).'"'));
                if($cnt_part_no == 0){
                    $modelItemMaster                    = new ItemMaster();
                    $modelItemMaster->part_number       = $part_number;
                    $modelItemMaster->description       = trim($eachItem->inb_description);
                    $modelItemMaster->hs_code           = trim($eachItem->inb_hs_code);
                    $modelItemMaster->category_id       = $category_id;
                    $modelItemMaster->brand_id          = $brand_id;
                    //$modelItemMaster->warehouse          = $docs->inb_warehouse_id;
                    $modelItemMaster->save(false);
                }
                else{
                    $modelItemMaster    = new ItemMaster();
                    $arr_existing_item  = $modelItemMaster->find(array('condition' => 'UPPER(part_number)="'.strtoupper($part_number).'"'));
                    if($arr_existing_item->category_id==0 && $category_id > 0){
                        $modelBrandUpdateItemMaster = new ItemMaster();
                        $modelBrandUpdateItemMaster->updateAll(array('category_id' => $category_id),'UPPER(part_number)="'.strtoupper($part_number).'"');
                    }
                    
                     if($arr_existing_item->brand_id==0 && $brand_id > 0){
                        $modelBrandUpdateItemMaster = new ItemMaster();
                        $modelBrandUpdateItemMaster->updateAll(array('brand_id' => $brand_id),'UPPER(part_number)="'.strtoupper($part_number).'"');
                    }
                }
                //end
            }
        }

        Inboundtemp::model()->deleteAll();
        InboundItemstemp::model()->deleteAll();
        
        echo json_encode(array('status' => 'success'));
        $this->Connect();
    }

    // public function actionGetpreviewdata(){
    //     $response = array();
    //     $docs = Inboundtemp::model()->findAll();
    //     foreach ( $docs as $i => $each ){
    //         $childArray = array();
    //         $response[$i]['id'] = $each->inb_delivery_note_no;
    //         $response[$i]['text'] = 'DN : '.$each->inb_delivery_note_no.' | BOE : '.$each->inb_bill_of_entry_no;
    //         $response[$i]['icon'] = "//jstree.com/tree.png";
    //         $response[$i]['state'] = array(
    //             'opened' => ($i == 0 ) ? true : false,
    //             'disabled' => false,
    //             'selected' => false,
    //         );
    //         $docItems = InboundItemstemp::model()->findAll( array('condition' => 'inb_delivery_note_no="'.$each->inb_delivery_note_no.'"') );
    //         foreach ( $docItems as $x => $eachItem ){
    //             $childArray[$x]['id'] = $eachItem->id;
    //             $childArray[$x]['text'] = $eachItem->inb_part_number.' | '.$eachItem->inb_description.' | '.$eachItem->inb_quantity.' '.$eachItem->inb_quantity_unit.' | '.$eachItem->inb_invoice_rate.' '.$eachItem->inb_currency_code;
    //         }
    //         $response[$i]['children'] = $childArray;
    //     }
    //     echo json_encode($response);
    // }

    /*public  function actionGetpreviewdata(){
        
        $bill_of_entries = array();
        $deliveryNotes = array();
        $products = array();
        $eachItem = array();
        $fields = array( 'Descripion' => 'inb_description', 'HS Code' =>'inb_hs_code', 'Origin' => 'inb_contry_of_origin',  'Currency' => 'inb_currency_code',  'Net Wt' => 'inb_net_wt',  'Gross Wt' => 'inb_gross_wt', 'Value' => 'inb_invoice_rate', 'Cbm' => 'inb_cbm');
        $icons = array(
            'inb_description' => 'glyphicon glyphicon-align-right',
            'inb_hs_code' => 'glyphicon glyphicon-barcode',
            'inb_contry_of_origin' => 'glyphicon glyphicon-home',
            'inb_currency_code' => 'glyphicon glyphicon-usd',
            'inb_net_wt' => 'glyphicon glyphicon-compressed',
            'inb_gross_wt' => 'glyphicon glyphicon-tower',
            'inb_invoice_rate' => 'glyphicon glyphicon-bitcoin',
            'inb_cbm' => 'glyphicon glyphicon-object-align-right',
        );
        $allEntries = Inboundtemp::model()->findAll(array( 'select' => 'inb_bill_of_entry_no, inb_bill_of_entry_date', 'condition' => 'inb_bill_of_entry_no !=""', 'group' => 'inb_bill_of_entry_no'));
        if( !empty($allEntries) ){
            foreach( $allEntries as $i => $eachEntry ){
                $count = Inboundtemp::model()->count( array( 'condition' => 'inb_is_updatable="N" AND inb_bill_of_entry_no="'.$eachEntry->inb_bill_of_entry_no.'"') );
                $totalColor = ( $eachEntry->inb_bill_of_entry_date == '0000-00-00' ) ? true : false;
                $spanColor = ( $eachEntry->inb_bill_of_entry_date == '0000-00-00' || $count > 0 ) ? 'color:red;' : 'color:green;';
                $class = ( $eachEntry->inb_bill_of_entry_date == '0000-00-00' || $count > 0 ) ? 'cl_red' : 'cl_green';
                $bill_of_entries[$i]['id'] = $eachEntry->inb_bill_of_entry_no;
                $bill_of_entries[$i]['text'] = '<span style="'.$spanColor.'">'.$eachEntry->inb_bill_of_entry_no.'</span>';
                $bill_of_entries[$i]['state'] = array(
                    'opened' => ($i == 0 ) ? true : false,
                    'disabled' => false,
                    'selected' => false,
                );
                $bill_of_entries[$i]['icon'] =  $class." glyphicon glyphicon-list";
                $allDeliverys =  Inboundtemp::model()->findAll( array( 'select' => 'inb_delivery_note_no, inb_is_updatable', 'condition' => 'inb_bill_of_entry_no="'.$eachEntry->inb_bill_of_entry_no.'"', 'group' => 'inb_delivery_note_no', 'order' => 'inb_delivery_note_no') );
                if( !empty($allDeliverys) ){
                    foreach( $allDeliverys as $j => $eachDelivery ){
                        $count = Inboundtemp::model()->count( array( 'condition' => 'inb_is_updatable="N" AND inb_delivery_note_no="'.$eachDelivery->inb_delivery_note_no.'"') );
                        $spanColor = ( $eachDelivery->inb_is_updatable == 'N' || $totalColor || $count > 0 ) ? 'color:red;' : 'color:green;';
                        $totalColor_delivery = ( $eachDelivery->inb_is_updatable == 'N' || $totalColor ) ? true : false;
                        $class = ( $eachDelivery->inb_is_updatable == 'N' || $totalColor || $count > 0 ) ? 'cl_red' : 'cl_green';
                        $deliveryNotes[$j]['id'] = $eachDelivery->inb_delivery_note_no;
                        $deliveryNotes[$j]['text'] = '<span style="'.$spanColor.'">'.$eachDelivery->inb_delivery_note_no.'</span>';
                        $deliveryNotes[$j]['state'] = array(
                            'opened' => ($j == 0 ) ? true : false,
                            'disabled' => true,
                            'selected' => false,
                        );
                        $deliveryNotes[$j]['icon'] =  $class." glyphicon glyphicon-paste";
                        $allProducts = InboundItemstemp::model()->findAll( array( 'select' => 'id, inb_part_number, inb_is_updatable', 'condition' => 'inb_delivery_note_no="'.$eachDelivery->inb_delivery_note_no.'"', 'order' => 'inb_part_number' ) );
                        if( !empty($allProducts) ){
                            foreach( $allProducts as $x => $eachProduct ){
                                $spanColor = ( $eachProduct->inb_is_updatable == 'N' || $totalColor || $totalColor_delivery ) ? 'color:red;' : 'color:green;';
                                $class = ( $eachProduct->inb_is_updatable == 'N' || $totalColor ) ? 'cl_red' : 'cl_green';
                                $products[$x]['id'] = $eachProduct->id;
                                $products[$x]['text'] = '<span style="'.$spanColor.'">'.$eachProduct->inb_part_number.'</span>';
                                $products[$x]['state'] = array(
                                    'opened' =>  ($x == 0 ) ? true : false,
                                    'disabled' => false,
                                    'selected' => false,
                                );
                                $products[$x]['icon'] = $class." glyphicon glyphicon-hdd";
                                $item = InboundItemstemp::model()->findBypk($eachProduct->id);
                                $m = 0;
                                foreach( $fields as $description => $eachField ){
                                    $spanColor = ( $item->$eachField == '' || $totalColor  ) ? 'color:red;' : '';
                                    $class = ( $item->$eachField == '' || $totalColor ) ? 'cl_red' : '';
                                    $eachItem[$m]['id'] = $eachField.$m.$x.$j.$i;
                                    $eachItem[$m]['text'] = '<span style="'.$spanColor.'">'.$description.' : '.$item->$eachField.'</span>';
                                    $eachItem[$m]['state'] = array(
                                        'opened' =>  ($m == 0 ) ? true : false,
                                        'disabled' => false,
                                        'selected' => false,
                                    );
                                    $eachItem[$m]['icon'] =  $class.' '.$icons[$eachField];
                                    $m++;
                                }
                                $products[$x]['children'] = $eachItem;
                            }
                        }
                        $deliveryNotes[$j]['children'] = $products;
                    }
                }
                $bill_of_entries[$i]['children'] = $deliveryNotes;
            }
        }

        echo json_encode($bill_of_entries);
    }

    public function actionImporttomain(){
        $docs = Inboundtemp::model()->findAll();
        foreach ( $docs as $i => $each ){
            $newDoc = new Inbound;
            $newDoc->attributes = $each->attributes;
            $newDoc->save(false);
            $docItems = InboundItemstemp::model()->findAll( array('condition' => 'inb_delivery_note_no="'.$each->inb_delivery_note_no.'"') );
            foreach ( $docItems as $x => $eachItem ){
                $newDocitem = new InboundItems;
                $newDocitem->attributes = $eachItem->attributes;
                $newDocitem->inb_inbound_id = $newDoc->id;
                $newDocitem->save(false);
                
                //code added by mereena on 09/06/2023
                //if part no not exist in item master -- added new one
                $part_number        = trim($eachItem->inb_part_number);
                $modelItemMaster    = new ItemMaster();
                $cnt_part_no        = (int) $modelItemMaster->count(array('condition' => 'UPPER(part_number)="'.$part_number.'"'));
                if($cnt_part_no == 0){
                    $modelItemMaster                    = new ItemMaster();
                    $modelItemMaster->part_number       = $part_number;
                    $modelItemMaster->description       = trim($eachItem->inb_description);
                    $modelItemMaster->hs_code           = trim($eachItem->inb_hs_code);
                    $modelItemMaster->save(false);
                }
                //end
            }
        }

        Inboundtemp::model()->deleteAll();
        InboundItemstemp::model()->deleteAll();
        
        echo json_encode(array('status' => 'success'));
        $this->Connect();
    }*/
    public function actionPrint() {
        $id = Yii::app()->request->getParam('id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4-L');
       
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
       
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.inbound', array('id' => $id),true));
        $mPDF1->Output("inbound.pdf", 'I');
    }
    public function actionPrint1() {
        $id = Yii::app()->request->getParam('id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
       
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
       
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.inbound1', array('id' => $id),true));
        $mPDF1->Output("inbound.pdf", 'I');
    }
    
    public function actionDownload(){
        $filename= Yii::app()->request->getparam('filename'); 
        $path = Yii::getPathOfAlias('webroot')."/upload/".$filename;
        if(!empty($path)){ 
                header("Content-type:application/force-download"); //for txt file
                header('Content-Disposition: attachment; filename="'.basename($path).'"'); 
                header('Content-Length: ' . filesize($path));
                readfile($path);
                Yii::app()->end();
        }
    }

    public function actionWarehouses() {
        $this->render('warehouses');
    }

    public function actionGetwarehouses(){
        $model  = new Warehouses();
        $draw   = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'name',
            2 => 'id', 
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
        $condition = '1=1';
        if(isset($_POST['search']['value']) && trim($_POST['search']['value']) !="")
        {
            $searchString = trim($_POST['search']['value']);
            $condition.=" AND (name LIKE '%".$searchString."%' OR id LIKE '%".$searchString."%')";
        }
        $count = $model->count(array('condition'=>$condition));
        $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $eachItemData=array();
        $m=1;

        foreach ( $model as $eachItem )
        {

            $div  = '<div class="btn-wrap text-center">';
            $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'inbound/newwarehouse&id='.$eachItem['id'].'\',\''.$eachItem['name'].'\',\'md\')"><i class="fa fa-pencil"></i></button>';
            $div .= '</div>';
            $eachItemData[]=array($eachItem['id'],$eachItem['name'],$div);
          
        }
        $data['data'] = $eachItemData;
        echo json_encode($data);
    }
    
    public function actionNewwarehouse(){
        $id = (int) Yii::app()->request->getParam('id');
        $model = new Warehouses;
        if( $id > 0 )
            $model = $model->findBypk($id);
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.js' => false);
        $this->render('warehouse_form', array('model' => $model));
    }

    public function actionSavewarehouse(){
        $model = new Warehouses;
        if( (int) $_POST['Warehouses']['id'] > 0 )
            $model = $model->findBypk((int) $_POST['Warehouses']['id']);
        $model->attributes = $_POST['Warehouses'];
        if( $model->validate() ){
            $model->save();
            echo json_encode( array( 'status' => 'success' ) );
        }else
            echo CActiveForm::validate($model, '', false);
    }

    public function actionAvailableboes(){
        $term = trim($_GET['term']);
        $response = array();
        if( $term != '' ){
            $inboundEntries = Inbound::model()->with('warehouseDetails')->findAll( array( 'select' => 'inb_bill_of_entry_no', 'condition'=>'inb_bill_of_entry_no LIKE "%'.$term.'%" AND inb_delivery_note_posted="Y" AND warehouseDetails.isDefault="N" AND isDelivered="N" ', 'group' => 'inb_bill_of_entry_no') );
            foreach( $inboundEntries as $i => $eachEntry ){
                $response[$i]['label'] = $eachEntry->inb_bill_of_entry_no;
                $response[$i]['value'] = $eachEntry->inb_bill_of_entry_no;
            }
        }
        echo json_encode($response);
    }

    public function actionTransfers(){
        $this->render('transfer_index');
    }

    public function actionGettransfers(){
        $model  = new WarehouseTransferHistory();
        $draw   = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 't.created_datetime',
            2 => 't.bill_of_entry', 
            3 => 't.part_number', 
            4 => 't.quantity', 
            5 => 't.id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
        $condition = '1=1';
        if(isset($_POST['search']['value']) && trim($_POST['search']['value']) !="")
        {
            $searchString = trim($_POST['search']['value']);
            $condition.=" AND (t.id LIKE '%".$searchString."%' OR t.bill_of_entry LIKE '%".$searchString."%' OR t.part_number LIKE '%".$searchString."%')";
        }
        $count = $model->count(array('condition'=>$condition));
        $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $eachItemData=array();
        $m=1;
        foreach ( $model as $eachItem )
        {
            $div  = '<div class="btn-wrap text-center">';
            $div .=' <a class="btn btn-primary btn-xs" title="Print PDF" target="_blank" href="?r=inbound/print&id='.$eachItem['id'].'"><i class="fa fa-file-pdf-o"></i></a>';
            $div .= '</div>';
            $eachItemData[]=array($eachItem['id'], date('d/m/Y', strtotime($eachItem['created_datetime'])), $eachItem['bill_of_entry'], $eachItem['part_number'], $eachItem['quantity'], $eachItem->inboundRelation->inb_delivery_note_no,$eachItem['notes']);
        }
        $data['data'] = $eachItemData;
        echo json_encode($data);
    }

    public function actionAddtransfer(){
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.js' => false);
        $this->render('transfer_items');
    }

    public function actionRenderdirecttransfer(){
        //code changed by mereena on 23/07/2024
         $this->render('direct_transfer_items', array( 'search_type' =>  trim($_POST['search_type']),'type'=>trim($_POST['type'])));
    }

    public function actionSavetransfer(){
        
        function update_stock( $modelItems ){
            foreach( $modelItems as $i => $each ) :
                //Receipt
                $each->save();
                if( $i == 0 ) :
                    $model = new Inbound;
                    $model->inb_delivery_note_no = 'WA-TRA-'.strtotime(date('Y-m-d h:i:s'));
                    $model->inb_bill_of_entry_no = $each->fromStock->bill_of_entry;
                    $model->inb_ta_number = MasCompany::getInbound_ta_with_bill($model->inb_bill_of_entry_no, true);
                    $model->inb_bill_of_entry_date = $each->fromStock->bill_of_entry_date;
                    $model->inb_added_date = date('Y-m-d');
                    $model->inb_doc_no = 'N/A';
                    $model->inb_warehouse_id = $each->to_warehouse;
                    $model->is_transfer_entry = 'Y';
                    $model->save(false);
                endif;
                
                //Items
                $item = new InboundItems;
                $item->inb_inbound_id = $model->id;
                $item->inb_delivery_note_no = $model->inb_delivery_note_no;
                $item->inb_part_number = $each->part_number;
                $item->inb_description = $each->description;
                $item->inb_hs_code = $each->fromStock->inboundRelation->inb_hs_code;
                $item->inb_hs_code_ae = $each->fromStock->inboundRelation->inb_hs_code_ae;
                $item->inb_contry_of_origin_code  = $each->fromStock->inboundRelation->inb_contry_of_origin_code;
                $item->inb_contry_of_origin = $each->fromStock->inboundRelation->inb_contry_of_origin;
                $item->inb_currency_code = $each->fromStock->inboundRelation->inb_currency_code;
                $item->inb_invoice_rate = $each->fromStock->cost_rate * $each->quantity;
                $item->inb_quantity = $each->quantity;
                $item->inb_quantity_unit =  $each->fromStock->inboundRelation->inb_quantity_unit;  
                $item->inb_net_wt = $each->fromStock->net_wt * $each->quantity;
                $item->inb_gross_wt = $each->fromStock->gross_wt * $each->quantity;
                $item->inb_cbm = $each->fromStock->cbm * $each->quantity;
                $item->inb_remarks = $each->fromStock->inboundRelation->inb_remarks;  
                //code added by mereena on 06-08-2024
                $item->inb_from_warehouse_id = $each->from_warehouse;  
                $item->inb_to_warehouse_id = $each->to_warehouse; 
                
                //code added by mereena on 10/10/2024
                $item->inb_bill_of_entry_no = $each->bill_of_entry; 
                //end
                
                $item->inb_added_date = date('Y-m-d');
                $item->save(false);

                //Out Ledger
                $ledger = new Ledger;
                $ledger->stock_id = $each->from_stock_id;
                $ledger->master_id = $each->id;  //outbound
                $ledger->warehouse_id = $each->from_warehouse;
                $ledger->part_number = trim($each->part_number);
                $ledger->description = $each->description;
                $ledger->delivery_note =  0;
                $ledger->shipment_reference =  '000-00-000000-00';
                $ledger->shipment_date = date('Y-m-d');
                $ledger->out_invoice_rate = $item->inb_invoice_rate;
                $ledger->out_net_wt = $item->inb_net_wt;
                $ledger->out_cbm = $item->inb_cbm;
                $ledger->out_gross_wt = $item->inb_gross_wt;
                $ledger->out_quantity  = $each->quantity;
                $ledger->type  = 'OUT-TR';
                $ledger->created_date = date('Y-m-d h:i:s');
                $ledger->save(false);
                //Remove Qty
                $stockModel = Stock::model()->findBypk( $each->from_stock_id );
                $stockModel->quantity = (float) $stockModel->quantity - (float) $each->quantity;
                InboundItems::model()->updateBypk($stockModel->deliverynote_item_id, array( 'used_for_transfer_entry' => 'Y' ));
                $stockModel->update();
                
                //Updating entries
                $each->inbound_id = $model->id;
                $each->inbound_item_id = $item->id;
                $each->net_wt = $stockModel->net_wt * $each->quantity;
                $each->gross_wt = $stockModel->gross_wt * $each->quantity;
                $each->cbm = $stockModel->cbm * $each->quantity;
                $each->value = $stockModel->cost_rate * $each->quantity;
                $each->update();
            endforeach;
        }

        if( $_POST['boe'] != '' || $_POST['model_no'] != '' || $_POST['from_warehouse']!=''){
            $items = array();
            $i =0;
            $valid = true;
            foreach( $_POST['WarehouseTransferHistory'] as $each ) :
                if( $each['quantity'] > 0 ) :
                    $items[$i] = new WarehouseTransferHistory;
                    $items[$i]->attributes = $each;
                    $items[$i]->notes = ( $_POST['notes'] != '' ) ?  $_POST['notes'] : 'Created on '.date('d/m/Y');
                    $items[$i]->created_by = Yii::app()->user->id;
                    $items[$i]->created_datetime = date('Y-m-d h:i:s');
                    $items[$i]->fill_stock_details();
                    $valid = $valid && $items[$i]->validate();
                    $i++;
                endif;
            endforeach;
            if( count($items) > 0 && $valid ){
                echo json_encode( array( 'status' => 'success' ) );
                update_stock($items);
                $this->Connect();
            }else{
                $error1 = $error2 = array();
                if( !$valid )
                    $error1 = json_decode(CActiveForm::validateTabular($items, '', false), true);
                if( count($items) == 0 )
                    $error2[] = 'Choose atleast on item!';
                echo CJSON::encode(array_merge_recursive($error1, $error2));
            }
       }
       else if($_POST['from_warehouse']==''){
           echo json_encode( array('Please select from warehouse') );
       }
       else{
           echo json_encode( array('Please select either Bill of Entry or Model#') );
       }
    }
    public function actionInventory()
    {
        $_GET  = filter_input_array(INPUT_GET, FILTER_SANITIZE_STRING);
        if(count($_GET) > 0){
            $this->render('inventory', array('show_btn' => $_GET['opening'] == 'true' ? true : false));
        }
        else{
              throw new CHttpException(404, 'Page not found.');
        }  
    }

    public function actionGetitems()
    {
        $_POST  = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
        if(count($_POST) > 0){
            $model = new ItemMaster();
            $draw = $_POST['draw'];
            $offset = $_POST['start'];
            $limit = $_POST['length'];
            $columns = array(
                // datatable column index  => database column name
                0 => 't.part_number',
                1 => 't.base_code',
                2 => 'category.category_name',
                3 => 't.description',
                // 4 => 't.upc_code',
                4 => 't.hs_code',
                5 => 't.rate',
                6 => 't.part_number',
            );
            $filterColumn = $columns[$_POST['order'][0]['column']];
            $filterOrder = $_POST['order'][0]['dir'];
            $orderBy = $filterColumn . " " . $filterOrder;
    
            $condition = '1=1';
            if (isset($_POST['search']['value']) && trim($_POST['search']['value']) != "") {
                $searchString = trim($_POST['search']['value']);
                $condition .= " AND (t.part_number LIKE '%" . $searchString . "%' OR t.base_code LIKE '%" . $searchString . "%' OR t.description LIKE '%" . $searchString . "%' OR t.upc_code LIKE '%" . $searchString . "%')";
            }
            $count = $model->with('category')->count(array('condition' => $condition));
            $model = $model->with('category')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
            $recordsTotal = $count;
            $recordsFiltered = $count;
            $data['draw'] = $draw;
            $data['recordsTotal'] = $recordsTotal;
            $data['recordsFiltered'] = $recordsFiltered;
            $eachItemData = array();
    
            foreach ($model as $eachItem) {
                 $ModelBrand=new MasBrand();
               $ModelBrand=$ModelBrand->findbypk($eachItem['brand_id']);
                $div = '<div class="btn-wrap text-center">';
//                if (Yii::app()->user->authorised_user == 1 || isset(Yii::app()->user->havePermissionOn['inventory_view'])) {
                    $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'inbound/add_product&part_number=' . $eachItem['part_number'] . '\',\' ' . $eachItem['part_number'] . '\',\'lg\')"><i class="fa fa-pencil"></i></button>';
//                }
                $div .= '</div>';
                $eachItemData[] = array($eachItem['part_number'], $eachItem['base_code'], $eachItem['category']['category_name'], $eachItem['description'], $eachItem['hs_code'], $eachItem['rate'],$ModelBrand->brand_name,$div);
            }
            $data['data'] = $eachItemData;
            echo json_encode($data);
        }
        else{
              throw new CHttpException(404, 'Page not found.');
        }
    }

    public function actionAdd_product()
    {
        $_GET = filter_input_array(INPUT_GET, FILTER_SANITIZE_STRING);
        if(count($_GET) > 0){
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.js' => false);
            $model = new ItemMaster;
            $partNumber = trim($_GET['part_number']);
            if ($partNumber != "")
                $model = ItemMaster::model()->findBypk($partNumber);
            $this->render('add_item', array('model' => $model)); 
            
        }
        else{
              throw new CHttpException(404, 'Page not found.');
        }
    }

    public function actionSaveitem()
    {
        $_POST = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING);
        if(count($_POST) > 0){
            $count = 0;
            $partNumber = trim($_POST['ItemMaster']['part_number']);
    
            if ($partNumber != "")
                $count = ItemMaster::model()->count(array('condition' => 'UPPER(TRIM(part_number))="' . strtoupper(trim($partNumber)) . '"'));
    
            if ($count == 0)
                $model = new ItemMaster;
            else
                $model = ItemMaster::model()->findBypk($partNumber);
    
            $model->attributes = $_POST['ItemMaster'];
            $model->description = $_POST['ItemMaster']['description'];
    
            if ($model->validate()) {
                $model->save();
                
//            $sql1="update {{inbound_items}} SET inb_description='".$model->description."',inb_hs_code='".$model->hs_code."',inb_contry_of_origin_code='".$model->country_of_origin."',inb_contry_of_origin='".$model->country_of_origin."' where inb_part_number='".$model->part_number."'";   
//            Yii::app()->db->createCommand($sql1)->execute(); 
//            $sql2="update {{outbound_items}} SET outb_description='".$model->description."',outb_hs_code='".$model->hs_code."',outb_contry_of_origin_code='".$model->country_of_origin."',outb_contry_of_origin='".$model->country_of_origin."' where outb_part_number='".$model->part_number."'";   
//            Yii::app()->db->createCommand($sql2)->execute();
//            $sql3="update {{current_stock}} SET description='".$model->description."' where part_number='".$model->part_number."'";   
//            Yii::app()->db->createCommand($sql3)->execute();
//            $sql4="update {{ledger}} SET description='".$model->description."' where part_number='".$model->part_number."'";   
//            Yii::app()->db->createCommand($sql4)->execute();
//            $sql5="update {{outbound_invoice_items}} SET outb_description='".$model->description."',outb_hs_code='".$model->hs_code."',outb_contry_of_origin_code='".$model->country_of_origin."',outb_contry_of_origin='".$model->country_of_origin."' where outb_part_number='".$model->part_number."'";   
//            Yii::app()->db->createCommand($sql5)->execute();
            
                echo json_encode(array('status' => 'success'));
            } else {
                echo CActiveForm::validate($model, '', false);
            }
        }
        else{
              throw new CHttpException(404, 'Page not found.');
        }
    }
//Added by Smrithy
    public function actionEditGeneral(){
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.js' => false);
        $model  = Inbound::model()->findByPk((int) Yii::app()->request->getParam('id'));
        $items  = InboundItems::model()->findAll(array('condition' => 'inb_inbound_id='.(int) Yii::app()->request->getParam('id')));
        $this->render('inbound_edit_printdata',array('model' => $model, 'items' => $items));
    }
    //Added by Smrithy
    
    //code added by mereena on 23/07/2024
    public function actionAvailableModelno(){
        $term = trim($_GET['term']);
        $response = array();
        if( $term != '' ){
            $arr_stock_items = Stock::model()->with('deliverynote')->findAll( array( 'condition' => 'quantity > 0 AND deliverynote.isDelivered = "N" AND part_number LIKE "%'.$term.'%"','group' => 'part_number') );
            foreach( $arr_stock_items as $i => $eachItem ){
                $response[$i]['label'] = $eachItem->part_number;
                $response[$i]['value'] = $eachItem->part_number;
            }
        }
        echo json_encode($response);
    }
    
    //end 
    
    public function actionAddMultipleTransfer(){
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.js' => false);
        $this->render('transfer_items_multiple');
    }
    
     public function actionRenderDirecttransferMultiple(){
        //code changed by mereena on 23/07/2024
        $from_warehouse=0;
        if( (int) $_POST['from_warehouse'] > 0 ){
            $from_warehouse = (int) $_POST['from_warehouse'];
        }
        
        
        $next_id = (int) $_POST['next_id'];
        
        $exist_ids = $_POST['exist_ids'];
        
         $this->render('direct_transfer_items_multiple', array( 'search_type' =>  trim($_POST['search_type']),'type'=>trim($_POST['type']),'from_warehouse'=>$from_warehouse,'next_id'=>$next_id,'exist_ids'=>$exist_ids));
    }
    
    public function actionAddInboundNew(){
        $id     = (int) Yii::app()->request->getParam('id');
        $type   = Yii::app()->request->getParam('type');
        
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.js' => false);
        $model  = new Inbound();
        $modelInboundContainerDetails = array(new InboundContainerDetails());
        if($id > 0){
           $modelInboundContainerDetails =  InboundContainerDetails::model()->findAll(array('condition'=>'inbound_id='.$id,'order'=>'id ASC'));
           if(empty($modelInboundContainerDetails)){
               $modelInboundContainerDetails = array(new InboundContainerDetails());
           }
           
           $model = $model->findByPk($id);
           
           if(empty($model)){
               $model  = new Inbound();
           }
        }
        $this->render('add_inbound_new',array('model' => $model,'modelInboundContainerDetails'=>$modelInboundContainerDetails,'type'=>$type));
    }
    
   public function actionImportIdocsNew(){
        
        /*echo '<pre>';
        print_r($_POST);
        exit;*/
        
        Inboundtemp::model()->deleteAll();
        InboundItemstemp::model()->deleteAll();

        $doc= $_POST['file_name']; 
        $warehouse= $_POST['warehouse']; 
        $doc = str_replace(',', '', $doc); 
        $file = fopen("upload/idoc_csv/$doc", "r");  

        function validateDate($date){
            $returnValue = false;
            if( count(explode('-', $date)) == 3  )
                $returnValue = true;
            if( $returnValue )
                if( strtotime($date) >= strtotime('2010-01-01') && strtotime($date) <= strtotime('2050-01-01')  )
                    $returnValue = true;
                else
                    $returnValue = false;
            return $returnValue;
        }
        
        function clean($string){
            if($string != ''){
                $value =  trim(preg_replace('/[^0-9a-zA-Z_@\s-]/', '', $string));
                if( $value != "")
                    return $value;
                else
                    return '';
            }else
                return '';
        }
        function write_error_log( $msg){
            $file = file_put_contents('upload/error.log', $msg.PHP_EOL , FILE_APPEND | LOCK_EX);
        }
        
        //unlink('upload/error.log');
        //ini_set('max_execution_time', 0);
        
       // echo $file;exit;

        $x  =  0;
        $errors=[];
        $errorFile = fopen("upload/error.log", "w");
        while ($line = fgets($file, 1000)) {   
            if( $x > 0 ){  
                
                $bill_of_entry_date       = str_replace('/', '-', $_POST['Inbound']['inb_bill_of_entry_date']);
                $bill_of_entry_date       = date("Y-m-d", strtotime($bill_of_entry_date));
                
                
                $inb_added_date           = str_replace('/', '-', $_POST['Inbound']['inb_added_date']);
                $inb_added_date             = date("Y-m-d", strtotime($inb_added_date));         
                
                
                $bill_of_entry ="";
                $delivery_note =$_POST['Inbound']['inb_delivery_note_no'];
                $part_no ="";
                $description ="";
                $hs_code ="";
                $hs_code_ae = "";
                $country_code = "";
                $country = "";
                $currency = "";
                $exchange_rate = "";
                $remarks = "";
                $net_value = "";
                $quantity = "";
                $unit = "";
                $net_weight = "";
                $gross_weight = "";
                $cbm = "";
                
                //code added by mereena on 14/06/2023
                $brand              =   "";
                $category           =   "";
                $total_cif_value    =   "";
                
                $grn                =   $_POST['Inbound']['inb_grn_no'];
                $frieght            =   $_POST['Inbound']['inb_frieght'];
                $frieght_currency   =   $_POST['Inbound']['inb_frieght_currency'];
                $total_containers   =   $_POST['Inbound']['inb_total_containers'];
                $container_type     =   $_POST['Inbound']['inb_container_type'];
                $department         =   $_POST['Inbound']['inb_department'];
                $ta_number          =   $_POST['Inbound']['inb_ta_number'];
                $added_date         =   $_POST['Inbound']['inb_added_date'];
                $bill_of_entry      =   $_POST['Inbound']['inb_bill_of_entry_no'];
                
                //end

                $line = explode(",", $line);
                
                foreach ($line as $i => $row) {
                        switch ($i) {
                            case 0:
                                $part_no = clean($row);
                                break;
                            case 1:
                                $description = clean($row);
                                break;
                            case 2:
                                $hs_code = trim($row);
                                break;
                            case 3:
                                $hs_code_ae = trim($row);
                                break;
                            case 4:
                                $country_code = clean($row);
                                break;
                            case 5:
                                $country = clean($row);
                                break;
                            case 6:
                                $currency = trim($row);
                                break;
                            case 7:
                                $exchange_rate = trim($row);
                                break;
                            case 8:
                                $remarks = clean($row);
                                break;
                            case 9:
                                $quantity = trim($row);
                                break;
                            case 10:
                                $unit = trim($row);
                                break;
                            case 11:
                                $net_weight = trim($row);
                                break;
                            case 12:
                                $gross_weight = trim($row);
                                break;
                            case 13:
                                $cbm = trim($row);
                                break;
                            case 14:
                                $net_value = trim($row);
                                break;
                            //code added by mereena on 14/06/2023
                            case 15:
                                $brand = trim($row);
                                break;
                            case 16:
                                $category = trim($row);
                                break;
                            case 17:
                                $total_cif_value = trim($row);
                                break;
                            //end
                        }
                }  
                //SAVE DATA  
                $Item_error = false; 
                $headError = false;
                if( $delivery_note != "" ){
                    $existance_in_inbound = Inbound::model()->find( array( 'condition' => 'inb_delivery_note_no="'.$delivery_note.'"') );
                    if( $existance_in_inbound->inb_delivery_note_no != "" ) :
                        $headError = true;
                        write_error_log('Ref #'.$delivery_note.' Already Exists!');
                    endif;
                    $checkExistance = Inboundtemp::model()->find( array( 'condition' => 'inb_delivery_note_no="'.$delivery_note.'"') );
                    if( $checkExistance->inb_delivery_note_no != "" ){
                        $newItem = new InboundItemstemp;
                        $newItem->inb_inbound_id = $checkExistance->id;
                        $newItem->inb_delivery_note_no = $checkExistance->inb_delivery_note_no;
                        $newItem->inb_part_number = $part_no;
                        if( $part_no == '') :
                            $Item_error = true;
                            write_error_log($delivery_note.' - Part Number Cannot Blank');
                        endif;
                        $newItem->inb_description = $description;
                        if( $description == '') :
                            $Item_error = true;
                            write_error_log($delivery_note.' Item '.$part_no.' - Description Cannot Blank');
                        endif;
                        $newItem->inb_hs_code = $hs_code;
                        $newItem->inb_hs_code_ae = $hs_code_ae;
                        $newItem->inb_contry_of_origin_code = $country_code;
                        $newItem->inb_contry_of_origin = $country;
                        if( $country == '') :
                            $Item_error = true;
                            write_error_log($delivery_note.' Item '.$part_no.' - Country of Origin Cannot Blank');
                        endif;
                        $newItem->inb_currency_code = $currency;
                        if( $currency == '') :
                            $Item_error = true;
                            write_error_log($delivery_note.' Item '.$part_no.' - Currency Cannot Blank');
                        endif;
                        $newItem->inb_exchange_rate = $exchange_rate;
                        $newItem->inb_invoice_rate = $net_value;
                        if( $net_value == '') :
                            $Item_error = true;
                            write_error_log($delivery_note.' Item '.$part_no.' - Net value Cannot Blank');
                        endif;
                        $newItem->inb_quantity = $quantity;
                        if( $quantity == '') :
                            $Item_error = true;
                            write_error_log($delivery_note.' Item '.$part_no.' - Quantity Cannot Blank');
                        endif;
                        $newItem->inb_quantity_unit = $unit;
                        $newItem->inb_net_wt = $net_weight;
                        if( $net_weight == '') :
                            $Item_error = true;
                            write_error_log($delivery_note.' Item '.$part_no.' - Net Weight Cannot Blank');
                        endif;
                        $newItem->inb_gross_wt = $gross_weight;
                        if( $gross_weight == '') :
                            $Item_error = true;
                            write_error_log($delivery_note.' Item '.$part_no.' - Gross Weight Cannot Blank');
                        endif;
                        $newItem->inb_remarks = $remarks;
                        $newItem->inb_cbm = $cbm;
                        $newItem->inb_added_date = !empty($added_date)?$added_date:date('Y-m-d');
                        if( $Item_error )
                            $newItem->inb_is_updatable = 'N';
                            
                        //code added by mereena on 14/06/2023
                        $newItem->inb_brand_name            = $brand;
                        $newItem->inb_category_name         = $category;
                        $newItem->inb_total_cif_value       = $total_cif_value;
                        //end
                            
                        $newItem->save(false);
                    }else{
                        $mainModel = new Inboundtemp;
                        $mainModel->inb_delivery_note_no = $delivery_note;
                        //$taNumber = MasCompany::getInbound_ta_with_bill($bill_of_entry, true);
                        
                        $mainModel->inb_ta_number = $ta_number;
                        if( !validateDate($bill_of_entry_date) ){
                            $headError = true;
                            write_error_log($delivery_note.' - BOE Date Cannot Blank');
                        }else{
                            $mainModel->inb_bill_of_entry_date = $bill_of_entry_date;
                        }
                        $mainModel->inb_bill_of_entry_no = $bill_of_entry;
                        if( $bill_of_entry == '' )
                            $headError = true;
                        $mainModel->inb_added_date =  date('Y-m-d');
                        $mainModel->inb_warehouse_id =  $warehouse;
                        $mainModel->inb_doc_no =  $_POST['Inbound']['inb_doc_no'];
                        $mainModel->inb_file_name =  'N/A';
                        
                        //code added by mereena on 14/06/2023
                        $mainModel->inb_grn_no            = $grn;
                        //$mainModel->inb_frieght           = $frieght;
                        //$mainModel->inb_frieght_currency  = $frieght_currency;
                        $mainModel->inb_total_containers  = $total_containers;
                        $mainModel->inb_container_type    = $container_type;
                        $mainModel->inb_department        = $department;
                        //end
                        
                        
                        if( $headError )
                            $mainModel->inb_is_updatable = 'N';
                        if( $mainModel->save(false) ){
                            $newItem = new InboundItemstemp;
                            $newItem->inb_inbound_id = $mainModel->id;
                            $newItem->inb_delivery_note_no = $mainModel->inb_delivery_note_no;
                            $newItem->inb_part_number = $part_no;
                            if( $part_no == '') :
                                $Item_error = true;
                                write_error_log($delivery_note.' - Part Number Cannot Blank');
                            endif;
                            $newItem->inb_description = $description;
                            if( $description == '') :
                                $Item_error = true;
                                write_error_log($delivery_note.' Item '.$part_no.' - Description Cannot Blank');
                            endif;
                            $newItem->inb_hs_code = $hs_code;
                            $newItem->inb_hs_code_ae = $hs_code_ae;
                            $newItem->inb_contry_of_origin_code = $country_code;
                            $newItem->inb_contry_of_origin = $country;
                            if( $country == '') :
                                $Item_error = true;
                                write_error_log($delivery_note.' Item '.$part_no.' - Country of Origin Cannot Blank');
                            endif;
                            $newItem->inb_currency_code = $currency;
                            if( $currency == '') :
                                $Item_error = true;
                                write_error_log($delivery_note.' Item '.$part_no.' - Currency Cannot Blank');
                            endif;
                            $newItem->inb_exchange_rate = $exchange_rate;
                            $newItem->inb_invoice_rate = $net_value;
                            if( $net_value == '') :
                                $Item_error = true;
                                write_error_log($delivery_note.' Item '.$part_no.' - Net value Cannot Blank');
                            endif;
                            $newItem->inb_quantity = $quantity;
                            if( $quantity == '') :
                                $Item_error = true;
                                write_error_log($delivery_note.' Item '.$part_no.' - Quantity Cannot Blank');
                            endif;
                            $newItem->inb_quantity_unit = $unit;
                            $newItem->inb_net_wt = $net_weight;
                            if( $net_weight == '') :
                                $Item_error = true;
                                write_error_log($delivery_note.' Item '.$part_no.' - Net Weight Cannot Blank');
                            endif;
                            $newItem->inb_gross_wt = $gross_weight;
                            if( $gross_weight == '') :
                                $Item_error = true;
                                write_error_log($delivery_note.' Item '.$part_no.' - Gross Weight Cannot Blank');
                            endif;
                            $newItem->inb_remarks = $remarks;
                            $newItem->inb_cbm = $cbm;
                            $newItem->inb_added_date = date('Y-m-d');
                            if( $Item_error )
                                $newItem->inb_is_updatable = 'N';
                                
                            //code added by mereena on 14/06/2023
                            $newItem->inb_brand_name            = $brand;
                            $newItem->inb_category_name         = $category;
                            $newItem->inb_total_cif_value       = $total_cif_value;
                            //end    
                                
                                
                           
                            
                            $newItem->save(false);
                        }
                    }
                    if( $Item_error || $headError ) :
                        $haveErrors = true;
                        fwrite($errorFile, implode(' , ', $errors));
                    endif;
                }
            }
            $x++;
        }
        fclose($errorFile);
        
        
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.js' => false);
        $countOne = (int) Inboundtemp::model()->count( array( 'condition' => 'inb_is_updatable="N"') );
        $countTwo = (int) InboundItemstemp::model()->count( array( 'condition' => 'inb_is_updatable="N"') );
        $this->render('documents_preview_new', array( 'isUpdatable' => ( $countOne > 0 || $countTwo > 0 ) ? false : true ));
        
        //echo CJSON::encode( array(  'status' => 'success','content'=> $content));
        
        
    }
    
    public function actionUpdateContainerData(){
        $model = new Inbound();
        if((int) $_POST['Inbound']['id'] > 0){
            $model = $model->findByPk((int) $_POST['Inbound']['id']);
        }
        $model->attributes = $_POST['Inbound'];
        if($_POST['Inbound']['inb_bill_of_entry_date']!=''){
            $bill_of_entry_date             = str_replace('/', '-', $_POST['Inbound']['inb_bill_of_entry_date']);
            $bill_of_entry_date             = date("Y-m-d", strtotime($bill_of_entry_date));
            $model->inb_bill_of_entry_date  = $bill_of_entry_date;
        }
        if($_POST['Inbound']['inb_added_date']!=''){
            $inb_added_date                 = str_replace('/', '-', $_POST['Inbound']['inb_added_date']);
            $inb_added_date                 = date("Y-m-d", strtotime($inb_added_date));
            $model->inb_added_date          = $inb_added_date;
        }
        if($_POST['warehouse'] > 0){
            $model->inb_warehouse_id          = $_POST['warehouse'];
        }
         $model->save(false);
        
        if (is_array($_POST['InboundContainerDetails'])) {
            
            if((int) $_POST['Inbound']['id'] > 0){
                $modelInboundContainerDetails = new InboundContainerDetails();
                $modelInboundContainerDetails->deleteAll('inbound_id=:refer_id', array( ':refer_id' => (int) $_POST['Inbound']['id'] ));
            }
            
            foreach ($_POST['InboundContainerDetails'] as $i => $eachItem) {  
                if($eachItem['container_type']!='' && (int) $_POST['Inbound']['id'] > 0){
                    
                    /*if ((int) $eachItem['id'] > 0) {
                            $modelInboundContainerDetails = InboundContainerDetails::model()->findByPK((int) $eachItem['id']); 
                    } 
                    else {
                            $modelInboundContainerDetails = new InboundContainerDetails();
                    }*/
                    $modelInboundContainerDetails = new InboundContainerDetails();
                    $modelInboundContainerDetails->inbound_id               = (int) $_POST['Inbound']['id'];
                    $modelInboundContainerDetails->container_type           = $eachItem['container_type'];
                    $modelInboundContainerDetails->container_quantity       = $eachItem['container_quantity'];
                    $modelInboundContainerDetails->frieght_per_container    = $eachItem['frieght_per_container'];
                    $modelInboundContainerDetails->currency                 = $eachItem['currency'];
                    $modelInboundContainerDetails->total_frieght            = $eachItem['total_frieght'];
                    $modelInboundContainerDetails->container_pol            = $eachItem['container_pol'];
                    $modelInboundContainerDetails->container_pod            = $eachItem['container_pod'];
                    $modelInboundContainerDetails->shipping_agent           = $eachItem['shipping_agent'];
                    if($eachItem['eta_arrival_date']!=''){
                        $modelInboundContainerDetails->eta_arrival_date = date("Y-m-d", strtotime(str_replace('/', '-', $eachItem['eta_arrival_date'])));
                    }
                    else{
                        $modelInboundContainerDetails->eta_arrival_date = '0000-00-00'; 
                    }
                    $modelInboundContainerDetails->save(false);
                }
            }
            
             $status='success';
        }
        else{
            $status='error';
        }
        
        echo CJSON::encode( array('status' => $status) );
    }
    
    
     public function actionImportToMainDirect(){
        $docs = Inboundtemp::model()->findAll();
        foreach ( $docs as $i => $each ){
            $newDoc = new Inbound;
            $newDoc->attributes = $each->attributes;
            $newDoc->inb_ta_number = $_POST['Inbound']['inb_ta_number'];
            if($_POST['Inbound']['inb_added_date']!=''){
                $newDoc->inb_added_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['Inbound']['inb_added_date'])));
            }
            else{
               $newDoc->inb_added_date = date("Y-m-d"); 
            }
            $newDoc->inb_grn_no = $_POST['Inbound']['inb_grn_no'];
            $newDoc->inb_total_containers = $_POST['Inbound']['inb_total_containers'];
            $newDoc->inb_container_type = $_POST['Inbound']['inb_container_type'];
            $newDoc->inb_department = $_POST['Inbound']['inb_department'];
            $newDoc->inb_container_type = $_POST['Inbound']['inb_container_type'];
            $newDoc->inb_department = $_POST['Inbound']['inb_department'];
            $newDoc->inb_brand_name = $_POST['Inbound']['inb_brand_name'];
            $newDoc->inb_warehouse_id = $_POST['warehouse'];
            $newDoc->save(false);
            $docItems = InboundItemstemp::model()->findAll( array('condition' => 'inb_delivery_note_no="'.$each->inb_delivery_note_no.'"') );
            foreach ( $docItems as $x => $eachItem ){
                $newDocitem = new InboundItems;
                $newDocitem->attributes = $eachItem->attributes;
                $newDocitem->inb_inbound_id = $newDoc->id;
                
                //code added by mereena on 14/06/2023
                if(!empty($eachItem->inb_brand_name)){
                    $modelMasBrand = new MasBrand();
                    $arr_brand_exist =  $modelMasBrand->find(array('condition'=>'brand_name="'.trim($eachItem->inb_brand_name).'" AND isActive="Y"'));
                    if(empty($arr_brand_exist)){
                        $modelMasBrand = new MasBrand();
                        $modelMasBrand->brand_name=trim($eachItem->inb_brand_name);
                        $modelMasBrand->isActive="Y";
                        $modelMasBrand->save();
                        $brand_id = (int) $modelMasBrand->id;
                    }
                    else{
                        $brand_id = (int) $arr_brand_exist->id;
                    }
                }
                
                $newDocitem->inb_brand_id = $brand_id;
                
                
                 if(!empty($eachItem->inb_category_name)){
                    $modelMasCategory = new MasCategory();
                    $arr_category_exist =  $modelMasCategory->find(array('condition'=>'category_name="'.trim($eachItem->inb_category_name).'" AND isActive="Y"'));
                    if(empty($arr_category_exist)){
                        $modelMasCategory = new MasCategory();
                        $modelMasCategory->category_name=trim($eachItem->inb_category_name);
                        $modelMasCategory->isActive="Y";
                        $modelMasCategory->save();
                        $category_id = (int) $modelMasCategory->id;
                    }
                    else{
                        $category_id = (int) $arr_category_exist->id;
                    }
                }
                
                $newDocitem->inb_category_id = $category_id;
                
                //end
                
                $newDocitem->save(false);
                
                //code added by mereena on 09/06/2023
                //if part no not exist in item master -- added new one
                $part_number        = trim($eachItem->inb_part_number);
                $modelItemMaster    = new ItemMaster();
                $cnt_part_no        = (int) $modelItemMaster->count(array('condition' => 'UPPER(part_number)="'.strtoupper($part_number).'"'));
                if($cnt_part_no == 0){
                    $modelItemMaster                    = new ItemMaster();
                    $modelItemMaster->part_number       = $part_number;
                    $modelItemMaster->description       = trim($eachItem->inb_description);
                    $modelItemMaster->hs_code           = trim($eachItem->inb_hs_code);
                    $modelItemMaster->category_id       = $category_id;
                    $modelItemMaster->brand_id          = $brand_id;
                    //$modelItemMaster->warehouse          = $docs->inb_warehouse_id;
                    $modelItemMaster->save(false);
                }
                else{
                    $modelItemMaster    = new ItemMaster();
                    $arr_existing_item  = $modelItemMaster->find(array('condition' => 'UPPER(part_number)="'.strtoupper($part_number).'"'));
                    if($arr_existing_item->category_id==0 && $category_id > 0){
                        $modelBrandUpdateItemMaster = new ItemMaster();
                        $modelBrandUpdateItemMaster->updateAll(array('category_id' => $category_id),'UPPER(part_number)="'.strtoupper($part_number).'"');
                    }
                    
                     if($arr_existing_item->brand_id==0 && $brand_id > 0){
                        $modelBrandUpdateItemMaster = new ItemMaster();
                        $modelBrandUpdateItemMaster->updateAll(array('brand_id' => $brand_id),'UPPER(part_number)="'.strtoupper($part_number).'"');
                    }
                }
                //end
            }
        }

        Inboundtemp::model()->deleteAll();
        InboundItemstemp::model()->deleteAll();
        
        $inbound_id = (int) $newDoc->id;
         if (is_array($_POST['InboundContainerDetails'])) {
            foreach ($_POST['InboundContainerDetails'] as $i => $eachItem) {  
                if($inbound_id > 0){
                    
                    $modelInboundContainerDetails = new InboundContainerDetails();
                    
                    $modelInboundContainerDetails->inbound_id               = $inbound_id;
                    $modelInboundContainerDetails->container_type           = $eachItem['container_type'];
                    $modelInboundContainerDetails->container_quantity       = $eachItem['container_quantity'];
                    $modelInboundContainerDetails->frieght_per_container    = $eachItem['frieght_per_container'];
                    $modelInboundContainerDetails->currency                 = $eachItem['currency'];
                    $modelInboundContainerDetails->total_frieght            = $eachItem['total_frieght'];
                    $modelInboundContainerDetails->container_pol            = $eachItem['container_pol'];
                    $modelInboundContainerDetails->container_pod            = $eachItem['container_pod'];
                    $modelInboundContainerDetails->shipping_agent           = $eachItem['shipping_agent'];
                    if($eachItem['eta_arrival_date']!=''){
                        $modelInboundContainerDetails->eta_arrival_date = date("Y-m-d", strtotime(str_replace('/', '-', $eachItem['eta_arrival_date'])));
                    }
                    else{
                       $modelInboundContainerDetails->eta_arrival_date = '0000-00-00'; 
                    }
                    $modelInboundContainerDetails->save(false);
                }
            }
            
        }
        
        echo json_encode(array('status' => 'success'));
        $this->Connect();
    }

    
    
}