<div class="panel">
    <div class="panel-heading panel-theme">
        <p>Warehouse Stock Report - Vertical </p>
    </div>
    <div class="panel-body"> 
        <div class="table-responsive"> 
            <input type="hidden" id="type" name="type" value="<?php echo $type; ?>">
            <input type="hidden" id="part_number" name="part_number" value="<?php echo $part_no; ?>">
            <input type="hidden" id="generic_name" name="generic_name" value="<?php echo $generic_name; ?>">

            <table id="tbl_inventory_table" class="table table-fixed table-bordered table-primary dataTable">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Warehouse</th>
                        <th>Quantity</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $condition = '1=1';
                    ;
                    if ($part_no>0) {
                        $condition .= ' AND t.id=' . $part_no . '';
                    }
                    $model_inventory = Inventory::model()->findAll(array('condition' => $condition, 'order' => 'part_number asc'));
                    foreach ($model_inventory as $eachItem) {
                        ?>
                        <tr>
                            <td class="bg-part"><b><?php echo $eachItem->part_number; ?></b></td>
                            <td class="bg-part" colspan="2"> <b><?php echo $eachItem->description; ?></b></td>
                        </tr>
                        <?php
                        $model_warehouse = new MasInventoryWarehouse();
                        $model_warehouse = $model_warehouse->findAll(array('condition' => 't.isActive="Y"', 'order' => 'warehouse_name asc'));
                        $total = 0;
                        foreach ($model_warehouse as $k => $each) {
                            $warehouse_id = $each->id;

                            $location_qty = Yii::app()->db->createCommand('SELECT IFNULL(SUM(quantity),0)  as quantity FROM erp_stock_ledger WHERE warehouse_id = ' . $warehouse_id . ' AND  product_id=' . $eachItem->id . ' AND stock_updated="Y" GROUP BY warehouse_id')->queryScalar();
                            /* $location_qty = Yii::app()->db->createCommand('SELECT IFNULL(SUM(quantity),0) FROM erp_product_location_details 
                              WHERE warehouse_id = ' . $warehouse_id . ' AND
                              product_id = ' . $eachItem->id.'
                              AND isActive="Y"')->queryScalar(); */
                            $total+=$location_qty;
                            ?>
                            <tr>
                                <td><?php echo $k + 1; ?></td>
                                <td><?php echo $each->warehouse_name; ?></td>
                                <td class="text-right"><?php echo number_format($location_qty,2); ?></td>
                            </tr>
                        <?php } ?>
                        <tr>
                            <td colspan="2" class="text-right bg-total"><b>Total</b></td>
                            <td class="text-right bg-total"><b><?php echo number_format($total, 2); ?></b></td>
                        </tr>
                    <?php } ?>
                </tbody>
            </table>
            <br>
            <div class="btn-wrap text-center">   
                <a title="Export Pdf" class="btn btn-theme" onclick="loadWarehouseVerticalPDF();"><i class="fa fa-file-pdf-o"></i> &nbsp;PDF</a> 
                <?php //echo CHtml::link('Export PDF',array('Invreports/PrintWarehouseVerticalReportPDF','part_no' => $part_no,'brand_id' => $brand_id), array('title'=>'Warehouse Stock Report - Horizontal','target'=>'_blank','class' =>  'btn btn-theme'));  ?>    

                <!--<button type="button" class="btn btn-theme" onclick="excelLeadList();">Export Excel</button>--> 
            </div>    

        </div>
    </div>
</div>
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadWarehouseVerticalPDF", "function loadWarehouseVerticalPDF(){
                           
            var part_no = $('#warehouse_part_no').val(); 
            var brand_id = $('#inv_warehouse_brand_name').val();
            var page_size =$('#pagesize').val();
            var page_no =$('#pagecount').val();
            var loc = $('#inv_warehouse_warehouse').val();
            window.open($('#liveSite').val()+'index.php?r=invreports/PrintWarehouseVerticalReportPDF&part_no='+part_no+'&brand_id='+brand_id+'&loc='+loc, '_blank'); 
            return false;
                
    }", CClientScript::POS_HEAD);
?>    
