<!DOCTYPE html>
<html>
    <head>
        <title>Warehouse Stock Report - Horizontal</title>
    </head>
    <body>
        <div class="heading">
            <div class="header" style="width:100%;float: left;padding-bottom:10px;">
                <img src="<?php echo  'images/logo/'.Yii::app()->user->pdf_company_logo; ?>"/>
            </div>
            <div class="col-12 text-center" style="margin: 0 auto;">
                <h1><u>Warehouse Stock Report - Horizontal</u></h1>
            </div>    
            <div class="col-12">
                <div class="details-box">

                    <table class="table" style="width:100%">
                        <?php
                        if ($part_no > 0) {
                            ?>
                            <tr>
                                <td><b>Part No</b></td>
                                <td>
                                    <?php
                                    $modelStroe = Inventory::model()->findByPk($part_no);
                                    echo $modelStroe->part_number;
                                    ?>
                                </td>
                            </tr>
                            <?php
                        }
                        ?>

                        <?php
                        if ($brand_id != '') {
                            $modelBrand = MasBrand::model()->findByPk($brand_id);
                            ?>
                            <tr>
                                <td><b>Brand /Class</b></td>
                                <td>
                                    <?php echo $modelBrand->brand_name; ?>
                                </td>
                            </tr>
                            <?php
                        }
                        ?>
                    </table>


                </div>
            </div>
        </div>

        <div class="clearfix"></div>

        <div class="panel">
            <div class="panel-body">

                <div class="table-responsive"> 
                    <input type="hidden" id="type" name="type" value="<?php echo $type; ?>">
                    <input type="hidden" id="part_number" name="part_number" value="<?php echo $part_no; ?>">
                    <input type="hidden" id="generic_name" name="generic_name" value="<?php echo $generic_name; ?>">

                    <table id="tbl_inventory_table" class="table table-fixed table-bordered table-primary dataTable">
                        <thead>
                            <tr>
                                <th>No</th>
                                <th>Customer</th>
                                <th>Part Number</th>
                                <th>Brand</th>
                                <?php
                                $total = array();
                                $model_warehouse = new MasInventoryWarehouse();
                                $model_warehouse_param = null;
                                if ($loc == '' || $loc == 'null') {
                                    $model_warehouse_param = array('condition' => 't.isActive="Y"', 'order' => 'warehouse_name asc');
                                } else {
                                    $model_warehouse_param = array('condition' => ' t.id in (' . $loc . ')', 'order' => 'warehouse_name asc');
                                }

                                $model_warehouse = $model_warehouse->findAll($model_warehouse_param);
                                if (!empty($model_warehouse)) {
                                    foreach ($model_warehouse as $k => $each) {
                                        $total[$k] = 0;
                                        ?>
                                        <th><?php echo $each->warehouse_name; ?></th>
                                        <th>Rack</th>
                                        <th>Bin</th>
                                        <?php
                                    }
                                }
                                ?>
                                <th>Total</th>        
                            </tr>
                        </thead>
                        <tbody>       
                            <?php
                            $toalval = 0;
                            $offset = ($page_no - 1) * $page_size;
                            $condition = '1=1';
                            ;
                            if ($part_no != '') {
                                $condition .= ' AND t.id="' . $part_no . '"';
                            }
                            if ($brand_id != '') {
                                $condition .= ' AND t.brand="' . $brand_id . '"';
                            }
                            if ($customer_id != '') {
                             $condition .= ' AND t.customer_id="' . $customer_id . '"';
                             }
                            $condition .= ' AND t.type="I"';
                            $criteria = new CDbCriteria();
                            $criteria->condition = $condition;
                            $criteria->order = 'part_number asc';

                            $model_inventory = Inventory::model()->findAll($criteria);

                            foreach ($model_inventory as $i => $model) {
                                ?>

                                <tr>      
                                    <td><?php echo $offset + $i + 1; ?></td>
                                    <td><?php echo $model->customer->customer_name; ?></td>
                                    <td><?php echo $model->part_number; ?></td>
                                    <td><?php echo $model->brands->brand_name; ?></td> 
                                    <?php
                                    if (!empty($model_warehouse)) {
                                        $toalval = 0;
                                        foreach ($model_warehouse as $n => $each) {
                                            $warehouse_id = $each->id;

                                            //$location_qty = Yii::app()->db->createCommand('SELECT IFNULL(SUM(quantity),0)  as quantity FROM erp_stock_ledger WHERE warehouse_id = ' . $warehouse_id . ' AND  product_id=' . $model->id . ' AND stock_updated="Y" GROUP BY warehouse_id')->queryScalar();
                                            /* $location_qty = Yii::app()->db->createCommand('SELECT IFNULL(SUM(quantity),0) FROM erp_product_location_details 
                                              WHERE warehouse_id = ' . $warehouse_id . ' AND
                                              product_id = ' . $model->id.'
                                              AND isActive="Y"')->queryScalar(); */
                                            $location_qty = Yii::app()->db->createCommand('SELECT IFNULL(SUM(quantity),0)  as quantity FROM view_stock_ledger_details WHERE warehouse_id = ' . $warehouse_id . ' AND  product_id='.$model->id.' AND stock_updated="Y" GROUP BY warehouse_id')->queryScalar();       
                                               
                                            $total[$n]+=$location_qty;
                                            $toalval+=$location_qty;
                                            ?>
                                            <td class="text-right"><?php echo number_format($location_qty, 2); ?></td>
                                            <?php
                                       $SQL = 'SELECT CONCAT(rack_name," : ",ROUND(SUM(quantity))) AS rack_name FROM `view_stock_ledger_details` AS ST 
                                                WHERE product_id='.$model->id.' AND ST.warehouse_id=' . $warehouse_id . ' GROUP By ST.rack_id';
                                        $arr_rack_name = Yii::app()->db->createCommand($SQL)->queryAll();
                                        $arr_rack_name = Yii::app()->db->createCommand($SQL)->queryAll();
                                        $str_rack_name='';
                                        foreach($arr_rack_name as $eachRack){
                                            $str_rack_name.=$eachRack['rack_name'].'<br>';
                                        }
                                        
                                        $SQL1 = 'SELECT CONCAT(bin_name," : ",ROUND(SUM(quantity))) AS bin_name FROM `view_stock_ledger_details` AS ST 
                                                WHERE product_id='.$model->id.' AND ST.warehouse_id=' . $warehouse_id . ' GROUP By ST.bin_id';
                                        
                                        $arr_bin_name = Yii::app()->db->createCommand($SQL1)->queryAll();
                                        
                                        $str_bin_name='';
                                        foreach($arr_bin_name as $eachBin){
                                            $str_bin_name.=$eachBin['bin_name'].'<br>';
                                        }
                                        
                                        
                                       /* $SQL = 'SELECT CONCAT(RA.name," : ",SUM(quantity)) AS rack_name,CONCAT(BIN.name," : ",SUM(quantity)) AS bin_name FROM `erp_stock_ledger` AS ST 
                                                INNER JOIN erp_mas_inv_rack AS RA ON ST.rack_id=RA.id  
                                                INNER JOIN erp_mas_inv_bin AS BIN ON bin_id=BIN.id 
                                                WHERE product_id='.$model->id.' AND ST.warehouse_id=' . $warehouse_id . ' GROUP By ST.rack_id,ST.bin_id';*/
                                        
                                        
                                        
                                        ?>
                                    
                                    <td><?php echo $str_rack_name;?></td>
                                    <td><?php echo $str_bin_name;?></td>
                                    <?php
                                }
                            }
                            ?>
                                    <td class="text-right"><?php echo number_format($toalval, 2); ?></td>        
                                </tr>
                            <?php } ?>   

                        </tbody>
                    </table>


                </div>
            </div>
        </div>        
    <htmlpagefooter name="myfooter">

        <div style="text-align:center;width:100%;font-size:10px"><?= Yii::app()->user->footer_autogenerated; ?>
            <?php
            date_default_timezone_set("Asia/Dubai");
            echo date('d/m/Y') . " " . date("h:i:sa");
            ?>
        </div>
        <div style="border-top: 1px dotted #000000; font-size: 12px; text-align: center; padding-top: 10px; background-color: #d7faeb;">
            <div style="text-align:center;width:100%">
                <b><?= Yii::app()->user->footer_line_1 ?></b><br>
                <?= Yii::app()->user->footer_line_2 ?>
            </div>
            <div style="text-align:center;width:100%">Page {PAGENO} of {nb} </div>
        </div>
    </htmlpagefooter>
</body>
</html>
