<!DOCTYPE html>
<html>
    <head>
        <title>Quote List</title>
    </head>
    <body>
        <div class="heading">
            <div class="header" style="width:100%;float: left;padding-bottom:10px;">
                <img src="<?php echo 'images/logo/' . Yii::app()->user->pdf_company_logo; ?>"/>
            </div>
            <div class="col-12 text-center" style="margin: 0 auto;">
                <h3><u>QUOTATION SUMMARY LIST</u></h3>
            </div>
            <div class="col-12">
                <div class="details-box">
                    <table class="table" style="width:100%">
                        <?php if ($qtn_start_from_date != '') { ?>
                        <tr>
                            <td style="width: 20%"><b>Quotation From </b></td>
                            <td>
                                <?php echo $qtn_start_from_date; ?>
                            </td>
                        </tr>
                        <?php } ?>
                        <?php if ($qtn_start_to_date != '') { ?>
                        <tr>
                            <td style="width: 20%"><b>Quotation To </b></td>
                            <td>
                                <?php echo $qtn_start_to_date; ?>
                            </td>
                        </tr>
                        <?php } ?>
                        <?php if ($customer_id != '') { ?>
                        <tr>
                            <td style="width: 20%"><b>Customer</b></td>
                            <td>
                                <?php
                                $c = Customer::model()->findByPK($customer_id);
                                echo $c->customer_name;
                                ?>
                            </td>
                        </tr>
                        <?php } ?>
                        <?php if ($leadowner_id > 0) { ?>
                        <tr>
                            <td style="width: 20%"><b>Lead Owner</b></td>
                            <td>
                                <?php
                                $l = User::model()->findByPK($leadowner_id);
                                echo $l->first_name . " " . $l->last_name;
                                ?>
                            </td>
                        </tr>
                        <?php } ?>
                        <?php if ($qtn_created_by > 0) { ?>
                        <tr>
                            <td style="width: 20%"><b>Created By</b></td>
                            <td>
                                <?php
                                $l = User::model()->findByPK($qtn_created_by);
                                echo $l->first_name . " " . $l->last_name;
                                ?>
                            </td>
                        </tr>
                        <?php } ?>
                        <?php if ($qtn_origin_id > 0) { ?>
                        <tr>
                            <td style="width: 20%"><b>Origin</b></td>
                            <td>
                                <?php
                                $country1 = MasCountry::model()->findByPK($qtn_origin_id);
                                echo $country1['country_name'];
                                ?>
                            </td>
                        </tr>
                        <?php } ?>
                        <?php if ($qtn_destination_id > 0) { ?>
                        <tr>
                            <td style="width: 20%"><b>Destination</b></td>
                            <td>
                                <?php
                                $country1 = MasCountry::model()->findByPK($qtn_destination_id);
                                echo $country1['country_name'];
                                ?>
                            </td>
                        </tr>
                        <?php } ?>
                        <?php if ($quotes_type != '') {
                        ?><tr>
                            <td style="width: 20%;font-size:11px;"><b>Type</b></td>
                            <td>
                                <?php echo ($quotes_type == 'sale') ? 'Sales' : 'Service'; ?>
                            </td>
                        </tr>
                        <?php }
                        ?>
                    </table>
                </div>
            </div>
        </div>
        <div class="clearfix"></div>
        <div class="table-body">

            <table id="tbl_qtn_table" class="table ">
                <thead>
                    <tr>
                        <th>SI#</th>
                        <th>Qtn #</th> 
                        <th>Qtn Date</th>  
                        <th>Customer</th>
                        <th>Contact Person</th>
                        <th>Lead Owner</th>
                        <th>Created By</th>
                        <th>Origin</th>
                        <th>Destination</th> 
                        <th>Consignee</th> 
                        <th>Ch.Wt</th>
                        <th>Status</th>
                        <th>Selling Price</th>
                        <th>Cost</th>
                        <th>Profit</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $condition = '1=1';

                    if ($qtn_start_from_date != '') {
                    $qtn_start_from_date = str_replace('/', '-', $qtn_start_from_date);
                    $qtn_start_from_date = date('Y-m-d', strtotime($qtn_start_from_date));
                    $condition .= ' AND t.quotation_date >="' . $qtn_start_from_date . '"';
                    }
                    if ($qtn_start_to_date != '') {
                    $qtn_start_to_date = str_replace('/', '-', $qtn_start_to_date);
                    $qtn_start_to_date = date('Y-m-d', strtotime($qtn_start_to_date));
                    $condition .= ' AND t.quotation_date <="' . $qtn_start_to_date . '"';
                    }

                    if ($customer_id != '') {
                    $condition .= ' AND t.customer_id ="' . $customer_id . '"';
                    }
                    if ($qtn_shipper_id != '') {
                    $condition .= ' AND t.shipper_id ="' . $qtn_shipper_id . '"';
                    }
                    if ($quotation_id != '') {
                    $condition .= ' AND t.id ="' . $quotation_id . '"';
                    }

                    if ($qtn_consignee_id != '') {
                    $condition .= ' AND t.consignee_id LIKE "%' . $qtn_consignee_id . '%"';
                    }
                    if ($qtn_origin_id != '') {
                    $condition .= ' AND t.origin_id ="' . $qtn_origin_id . '"';
                    }
                    if ($qtn_destination_id != '') {

                    $condition .= ' AND t.destination_id ="' . $qtn_destination_id . '"';
                    }
                    if ($qtn_status != '') {
                    $condition .= ' AND t.quotation_status ="' . $qtn_status . '"';
                    }
                    if($qtn_created_by != ""){
                    $condition .= ' AND t.created_by ="' . $qtn_created_by.'"';
                    }
                    if($qtn_leadowner_id != ""){
                    $condition .= ' AND t.lead_owner_id ="' . $qtn_leadowner_id.'"';
                    }
                    /**view added by jisha on 15/1/24*/
                    $total = 0;
                    $sql = "SELECT * FROM view_quotation_details t where ".$condition;
                    //echo $condition; exit;
                    $modelQuote = Yii::app()->db->createCommand($sql)->queryAll();
                    //print_r($condition);
                    foreach ($modelQuote as $i => $model) {

                    switch($model['quotation_status']){
                    case 'CL':
                    $row_quotation_status="Closed";
                    break;
                    case 'A':
                    $row_quotation_status="Awaiting";
                    break;
                    case 'CO':
                    $row_quotation_status="Confirmed";
                    break;
                    case 'CA':
                    $row_quotation_status="Cancel";
                    break;
                    default:
                    $row_quotation_status="Open";
                    break;
                    } 

                    ?>
                    <tr>
                        <td><?php echo $i + 1; ?></td>
                        <td><?php echo $model['id']; ?></td>
                        <?php if ($model['quotation_date'] != '0000-00-00') { ?>
                        <td><?php echo date("d/m/Y", strtotime($model['quotation_date'])); ?></td>
                        <?php } else { ?>
                        <td>&nbsp;</td>
                        <?php } ?>
                        <td><?php echo $model['customer_name']; ?></td>
                        <td width="20px;"><?php echo $model['contact_names'];?></td>
                        <td class="nw"><?php echo $model['leadowner']; ?></td>
                        <td class="nw"> <?php echo $model['created_user']; ?></td>
                        <td><?php echo $model['origin']; ?></td>
                        <td><?php echo $model['destination']; ?></td>
                        <td><?php echo $model['consignee_id']; ?></td>
                        <td class="text-right"><?php echo $row_quotation_status;?></td>
                        <td width="8%" class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($model['chargeable_weight'],""); ?></td>
                        <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($model['selling_price'],""); ?></td>
                        <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($model['cost_price'] ,""); ?></td>
                        <td class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($model['profit'],"");
                            $total_planned_cost += $model['cost_price'];
                            $total_selling_price += $model['selling_price'];
                            $total_planned_profit+=$model['profit'];
                            ?></td>
                    </tr>
                    <?php } ?>
                    <tr>
                        <td colspan="12"> </td>

                        <td class="text-right"><b> <?php echo Yii::app()->numberFormatter->formatCurrency($total_selling_price, " "); ?></b> </td>
                        <td class="text-right"><b> <?php echo Yii::app()->numberFormatter->formatCurrency($total_planned_cost, " "); ?></b> </td>
                        <td class="text-right"><b> <?php echo Yii::app()->numberFormatter->formatCurrency($total_planned_profit, " "); ?></b> </td>
                    </tr>

                </tbody>
            </table>

            <htmlpagefooter name="myfooter">
                <div style="text-align:center;width:100%;font-size:10px"><?= Yii::app()->user->footer_autogenerated; ?>
                    <?php
                    date_default_timezone_set("Asia/Dubai");
                    echo date('d/m/Y') . " " . date("h:i:sa");
                    ?>
                </div>
                <div style="border-top: 1px dotted #000000; font-size: 12px; text-align: center; padding-top: 10px; background-color: #d7faeb;">
                    <div style="text-align:center;width:100%">
                        <b><?= Yii::app()->user->footer_line_1 ?></b><br>
                        <?= Yii::app()->user->footer_line_2 ?>
                    </div>
                    <div style="text-align:center;width:100%">Page {PAGENO} of {nb} </div>
                </div>
            </htmlpagefooter>
            <sethtmlpagefooter name="myfooter" page="all" value="on" />
    </body>

</html>